/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.search;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.search.DMNGridHelper;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.util.GridHighlightHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DMNGridHelperTest {
    @Mock
    private DMNSession dmnSession;
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DefaultGridLayer defaultGridLayer;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private GridHighlightHelper highlightHelper;
    @Mock
    private GridWidget gridWidget1;
    @Mock
    private GridWidget gridWidget2;
    @Mock
    private GridWidget gridWidget3;
    @Mock
    private GridData model;
    private DMNGridHelper helper;

    @Before
    public void setup() {
        Mockito.when((Object)this.dmnSession.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.gridPanel.getDefaultGridLayer()).thenReturn((Object)this.defaultGridLayer);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnSession);
        this.helper = (DMNGridHelper)Mockito.spy((Object)new DMNGridHelper(this.sessionManager));
    }

    @Test
    public void testHighlightHelper() {
        boolean row = true;
        boolean column = true;
        GridColumn headerColumn = (GridColumn)Mockito.mock(GridColumn.class);
        GridColumn currentColumn = (GridColumn)Mockito.mock(GridColumn.class);
        GridRow headerRow = (GridRow)Mockito.mock(GridRow.class);
        GridRow currentRow = (GridRow)Mockito.mock(GridRow.class);
        double headerColumnWidth = 2.0;
        double currentColumnWidth = 4.0;
        double headerRowWidth = 8.0;
        double currentRowWidth = 16.0;
        ((DMNGridHelper)Mockito.doReturn((Object)this.highlightHelper).when((Object)this.helper)).highlightHelper(this.gridWidget1);
        Mockito.when((Object)this.gridWidget1.getModel()).thenReturn((Object)this.model);
        Mockito.when((Object)this.model.getColumns()).thenReturn(Arrays.asList(headerColumn, currentColumn));
        Mockito.when((Object)this.model.getRows()).thenReturn(Arrays.asList(headerRow, currentRow));
        Mockito.when((Object)headerColumn.getWidth()).thenReturn((Object)2.0);
        Mockito.when((Object)currentColumn.getWidth()).thenReturn((Object)4.0);
        Mockito.when((Object)headerRow.getHeight()).thenReturn((Object)8.0);
        Mockito.when((Object)currentRow.getHeight()).thenReturn((Object)16.0);
        Mockito.when((Object)this.highlightHelper.withPaddingX(6.0)).thenReturn((Object)this.highlightHelper);
        Mockito.when((Object)this.highlightHelper.withPaddingY(24.0)).thenReturn((Object)this.highlightHelper);
        Mockito.when((Object)this.highlightHelper.withPinnedGrid()).thenReturn((Object)this.highlightHelper);
        this.helper.highlightCell(1, 1, this.gridWidget1);
        ((GridHighlightHelper)Mockito.verify((Object)this.highlightHelper)).highlight(1, 1);
    }

    @Test
    public void clearSelections() {
        Mockito.when((Object)this.defaultGridLayer.getGridWidgets()).thenReturn(this.asSet(this.gridWidget1, null, this.gridWidget2, null, this.gridWidget3));
        ((DMNGridHelper)Mockito.doReturn((Object)this.highlightHelper).when((Object)this.helper)).highlightHelper(this.gridWidget1);
        ((DMNGridHelper)Mockito.doReturn((Object)this.highlightHelper).when((Object)this.helper)).highlightHelper(this.gridWidget2);
        ((DMNGridHelper)Mockito.doReturn((Object)this.highlightHelper).when((Object)this.helper)).highlightHelper(this.gridWidget3);
        this.helper.clearSelections();
        ((GridHighlightHelper)Mockito.verify((Object)this.highlightHelper, (VerificationMode)Mockito.times((int)3))).clearSelections();
    }

    @Test
    public void getGridWidgets() {
        Mockito.when((Object)this.defaultGridLayer.getGridWidgets()).thenReturn(this.asSet(this.gridWidget1, null, this.gridWidget2, null, this.gridWidget3));
        Set actualGridWidgets = this.helper.getGridWidgets();
        Set<GridWidget> expectedGridWidgets = this.asSet(this.gridWidget1, this.gridWidget2, this.gridWidget3);
        Assert.assertEquals(expectedGridWidgets, (Object)actualGridWidgets);
    }

    @Test
    public void testFocusGridPanel() {
        this.helper.focusGridPanel();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).setFocus(true);
    }

    private Set<GridWidget> asSet(GridWidget ... a) {
        return new HashSet<GridWidget>(Arrays.asList(a));
    }
}

