/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverViewImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPicker;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPickerEvent;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BootstrapSelectDropDownMonitorTest {
    private static final Optional<String> TITLE = Optional.of("title");
    @Mock
    private JQuerySelectPicker jQuerySelectPicker;
    @Mock
    private JQuerySelectPickerEvent event;
    @Mock
    private ParameterizedCommand<Optional<String>> showCommand;
    @Mock
    private Command hideCommand;
    @Mock
    private Element menuElement;
    @Mock
    private DOMTokenList menuElementClassList;
    @Captor
    private ArgumentCaptor<JQuerySelectPicker.CallbackFunction> hiddenCallbackHandlerCaptor;
    private ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor monitor;

    @Before
    public void setup() {
        this.monitor = (ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.spy((Object)new ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor(this.showCommand, this.hideCommand));
        Mockito.when((Object)this.monitor.kieDataTypeSelect()).thenReturn((Object)this.jQuerySelectPicker);
        ((ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)this.menuElement).when((Object)this.monitor)).getMenuElement();
        this.menuElement.classList = this.menuElementClassList;
    }

    @Test
    public void testShow() {
        this.monitor.show(TITLE);
        ((ParameterizedCommand)Mockito.verify(this.showCommand)).execute(ArgumentMatchers.eq(TITLE));
    }

    @Test
    public void testHideWhenDropDownIsShown() {
        ((ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)true).when((Object)this.monitor)).isDropDownVisible();
        this.monitor.hide();
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).off((String)ArgumentMatchers.eq((Object)"shown.bs.select"));
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).on((String)ArgumentMatchers.eq((Object)"hidden.bs.select"), (JQuerySelectPicker.CallbackFunction)this.hiddenCallbackHandlerCaptor.capture());
        ((Command)Mockito.verify((Object)this.hideCommand, (VerificationMode)Mockito.never())).execute();
        ((JQuerySelectPicker.CallbackFunction)this.hiddenCallbackHandlerCaptor.getValue()).call(this.event);
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).off((String)ArgumentMatchers.eq((Object)"hidden.bs.select"));
        ((Command)Mockito.verify((Object)this.hideCommand)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jQuerySelectPicker});
    }

    @Test
    public void testHideWhenDropDownIsNotShown() {
        ((ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)false).when((Object)this.monitor)).isDropDownVisible();
        this.monitor.hide();
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).off((String)ArgumentMatchers.eq((Object)"shown.bs.select"));
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).off((String)ArgumentMatchers.eq((Object)"hidden.bs.select"));
        ((Command)Mockito.verify((Object)this.hideCommand)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jQuerySelectPicker});
    }

    @Test
    public void testIsVisible() {
        Mockito.when((Object)this.menuElementClassList.contains("open")).thenReturn((Object)true);
        boolean actual = this.monitor.isDropDownVisible();
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsVisibleWhenIsNotVisible() {
        Mockito.when((Object)this.menuElementClassList.contains("open")).thenReturn((Object)false);
        boolean actual = this.monitor.isDropDownVisible();
        Assert.assertFalse((boolean)actual);
    }
}

