/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessages;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypesPage;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManagerStackStore;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.editors.types.common.events.RefreshDataTypesListEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeShortcuts;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={RootPanel.class})
public class DataTypesPageTest {
    @Mock
    private DataTypeList treeList;
    @Mock
    private ItemDefinitionUtils itemDefinitionUtils;
    @Mock
    private ItemDefinitionStore definitionStore;
    @Mock
    private DataTypeStore dataTypeStore;
    @Mock
    private DataTypeManager dataTypeManager;
    @Mock
    private DataTypeManagerStackStore stackIndex;
    @Mock
    private FlashMessages flashMessages;
    @Mock
    private DataTypeSearchBar searchBar;
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private TranslationService translationService;
    @Mock
    private HTMLDivElement pageView;
    @Mock
    private DataTypeShortcuts dataTypeShortcuts;
    @Captor
    private ArgumentCaptor<List<DataType>> dataTypesCaptor;
    private DataTypesPageFake page;

    @Before
    public void setup() {
        this.page = (DataTypesPageFake)((Object)Mockito.spy((Object)((Object)new DataTypesPageFake(this.treeList, this.itemDefinitionUtils, this.definitionStore, this.dataTypeStore, this.dataTypeManager, this.stackIndex, this.flashMessages, this.searchBar, this.dmnGraphUtils, this.translationService, this.dataTypeShortcuts, this.pageView){

            @Override
            protected void setupPageCSSClass(String cssClass) {
            }
        })));
    }

    @Test
    public void testInit() {
        this.page.init();
        ((DataTypeShortcuts)Mockito.verify((Object)this.dataTypeShortcuts)).init(this.treeList);
    }

    @Test
    public void testOnFocusWhenPageIsLoaded() {
        ((DataTypesPageFake)((Object)Mockito.doReturn((Object)true).when((Object)this.page))).isLoaded();
        this.page.onFocus();
        ((DataTypesPageFake)((Object)Mockito.verify((Object)((Object)this.page), (VerificationMode)Mockito.never()))).reload();
        ((DataTypesPageFake)((Object)Mockito.verify((Object)((Object)this.page)))).refreshPageView();
    }

    @Test
    public void testOnFocusWhenPageIsNotLoaded() {
        ((DataTypesPageFake)((Object)Mockito.doReturn((Object)false).when((Object)this.page))).isLoaded();
        this.page.onFocus();
        ((DataTypesPageFake)((Object)Mockito.verify((Object)((Object)this.page)))).reload();
        ((DataTypesPageFake)((Object)Mockito.verify((Object)((Object)this.page)))).refreshPageView();
    }

    @Test
    public void testOnLostFocus() {
        this.page.onLostFocus();
        ((FlashMessages)Mockito.verify((Object)this.flashMessages)).hideMessages();
    }

    @Test
    public void testReload() {
        String expected = "dmnModelNamespace";
        ((DataTypesPageFake)((Object)Mockito.doReturn((Object)"dmnModelNamespace").when((Object)this.page))).currentDMNModelNamespace();
        this.page.reload();
        String actual = this.page.getLoadedDMNModelNamespace();
        ((DataTypesPageFake)((Object)Mockito.verify((Object)((Object)this.page)))).cleanDataTypeStore();
        ((DataTypesPageFake)((Object)Mockito.verify((Object)((Object)this.page)))).loadDataTypes();
        Assert.assertEquals((Object)"dmnModelNamespace", (Object)actual);
    }

    @Test
    public void testRefreshPageView() {
        HTMLElement flashMessagesElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement treeListElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Element element = (Element)Mockito.mock(Element.class);
        this.pageView.firstChild = element;
        Mockito.when((Object)this.pageView.removeChild((Node)element)).then(a -> {
            this.pageView.firstChild = null;
            return element;
        });
        Mockito.when((Object)this.flashMessages.getElement()).thenReturn((Object)flashMessagesElement);
        Mockito.when((Object)this.treeList.getElement()).thenReturn((Object)treeListElement);
        this.page.refreshPageView();
        ((HTMLDivElement)Mockito.verify((Object)this.pageView)).removeChild((Node)element);
        ((HTMLDivElement)Mockito.verify((Object)this.pageView)).appendChild((Node)flashMessagesElement);
        ((HTMLDivElement)Mockito.verify((Object)this.pageView)).appendChild((Node)treeListElement);
    }

    @Test
    public void testIsLoadedWhenItIsNotLoaded() {
        ((DataTypesPageFake)((Object)Mockito.doReturn((Object)"dmnModelNamespace1").when((Object)this.page))).currentDMNModelNamespace();
        ((DataTypesPageFake)((Object)Mockito.doReturn((Object)"dmnModelNamespace2").when((Object)this.page))).getLoadedDMNModelNamespace();
        Assert.assertFalse((boolean)this.page.isLoaded());
    }

    @Test
    public void testIsLoadedWhenItIsLoaded() {
        ((DataTypesPageFake)((Object)Mockito.doReturn((Object)"dmnModelNamespace1").when((Object)this.page))).currentDMNModelNamespace();
        ((DataTypesPageFake)((Object)Mockito.doReturn((Object)"dmnModelNamespace1").when((Object)this.page))).getLoadedDMNModelNamespace();
        TestCase.assertTrue((boolean)this.page.isLoaded());
    }

    @Test
    public void testCurrentDMNModelNamespaceWhenDefinitionsIsNull() {
        Mockito.when((Object)this.dmnGraphUtils.getModelDefinitions()).thenReturn(null);
        String actual = this.page.currentDMNModelNamespace();
        String expected = "";
        Assert.assertEquals((Object)"", (Object)actual);
    }

    @Test
    public void testCurrentDMNModelNamespaceWhenNamespaceIsNull() {
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Mockito.when((Object)definitions.getNamespace()).thenReturn(null);
        Mockito.when((Object)this.dmnGraphUtils.getModelDefinitions()).thenReturn((Object)definitions);
        String actual = this.page.currentDMNModelNamespace();
        String expected = "";
        Assert.assertEquals((Object)"", (Object)actual);
    }

    @Test
    public void testCurrentDMNModelNamespace() {
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Text text = (Text)Mockito.mock(Text.class);
        String expected = "currentDMNModelNamespace";
        Mockito.when((Object)text.getValue()).thenReturn((Object)"currentDMNModelNamespace");
        Mockito.when((Object)definitions.getNamespace()).thenReturn((Object)text);
        Mockito.when((Object)this.dmnGraphUtils.getModelDefinitions()).thenReturn((Object)definitions);
        String actual = this.page.currentDMNModelNamespace();
        Assert.assertEquals((Object)"currentDMNModelNamespace", (Object)actual);
    }

    @Test
    public void testCleanDataTypeStore() {
        this.page.cleanDataTypeStore();
        ((ItemDefinitionStore)Mockito.verify((Object)this.definitionStore)).clear();
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore)).clear();
        ((DataTypeManagerStackStore)Mockito.verify((Object)this.stackIndex)).clear();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).reset();
    }

    @Test
    public void testLoadDataTypes() {
        ItemDefinition itemDefinition1 = this.makeItem("itemDefinition1");
        ItemDefinition itemDefinition2 = this.makeItem("itemDefinition2");
        ItemDefinition itemDefinition3 = this.makeItem("itemDefinition3");
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        List<ItemDefinition> itemDefinitions = Arrays.asList(itemDefinition1, itemDefinition2, itemDefinition3);
        Mockito.when((Object)this.itemDefinitionUtils.all()).thenReturn(itemDefinitions);
        ((DataTypesPageFake)((Object)Mockito.doReturn((Object)dataType1).when((Object)this.page))).makeDataType(itemDefinition1);
        ((DataTypesPageFake)((Object)Mockito.doReturn((Object)dataType2).when((Object)this.page))).makeDataType(itemDefinition2);
        ((DataTypesPageFake)((Object)Mockito.doReturn((Object)dataType3).when((Object)this.page))).makeDataType(itemDefinition3);
        this.page.loadDataTypes();
        ((DataTypeList)Mockito.verify((Object)this.treeList)).setupItems((List)this.dataTypesCaptor.capture());
        List dataTypes = (List)this.dataTypesCaptor.getValue();
        Assertions.assertThat((List)dataTypes).containsExactly((Object[])new DataType[]{dataType1, dataType2, dataType3});
    }

    @Test
    public void testMakeDataType() {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        DataType expectedDataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)this.dataTypeManager.from(itemDefinition)).thenReturn((Object)this.dataTypeManager);
        Mockito.when((Object)this.dataTypeManager.get()).thenReturn((Object)expectedDataType);
        DataType actualDataType = this.page.makeDataType(itemDefinition);
        Assert.assertEquals((Object)expectedDataType, (Object)actualDataType);
    }

    @Test
    public void testOnDataTypePageNavTabActiveEvent() {
        this.page.onDataTypePageNavTabActiveEvent((DataTypePageTabActiveEvent)Mockito.mock(DataTypePageTabActiveEvent.class));
        ((DataTypesPageFake)((Object)Mockito.verify((Object)((Object)this.page)))).onFocus();
    }

    @Test
    public void testEnableShortcuts() {
        this.page.enableShortcuts();
        ((DataTypeShortcuts)Mockito.verify((Object)this.dataTypeShortcuts)).setup();
    }

    @Test
    public void testOnRefreshDataTypesListWithNewItemDefinitionWhenPageIsNotLoaded() {
        RefreshDataTypesListEvent event = new RefreshDataTypesListEvent(Collections.emptyList());
        ((DataTypesPageFake)((Object)Mockito.doReturn((Object)false).when((Object)this.page))).isLoaded();
        this.page.onRefreshDataTypesListWithNewItemDefinitions(event);
        ((DataTypesPageFake)((Object)Mockito.verify((Object)((Object)this.page), (VerificationMode)Mockito.never()))).refreshItemDefinitions((List)ArgumentMatchers.any());
        ((DataTypesPageFake)((Object)Mockito.verify((Object)((Object)this.page), (VerificationMode)Mockito.never()))).reload();
    }

    @Test
    public void testOnRefreshDataTypesListWithNewItemDefinitionWhenPageIsLoaded() {
        ItemDefinition itemDefinition1 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition itemDefinition2 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<ItemDefinition> newItemDefinitions = Arrays.asList(itemDefinition1, itemDefinition2);
        RefreshDataTypesListEvent event = new RefreshDataTypesListEvent(newItemDefinitions);
        ((DataTypesPageFake)((Object)Mockito.doReturn((Object)true).when((Object)this.page))).isLoaded();
        this.page.onRefreshDataTypesListWithNewItemDefinitions(event);
        ((DataTypesPageFake)((Object)Mockito.verify((Object)((Object)this.page)))).refreshItemDefinitions(newItemDefinitions);
        ((DataTypesPageFake)((Object)Mockito.verify((Object)((Object)this.page)))).reload();
    }

    @Test
    public void testDisableShortcuts() {
        this.page.disableShortcuts();
        ((DataTypeShortcuts)Mockito.verify((Object)this.dataTypeShortcuts)).teardown();
    }

    private ItemDefinition makeItem(String itemName) {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Name name = (Name)Mockito.mock(Name.class);
        Mockito.when((Object)name.getValue()).thenReturn((Object)itemName);
        Mockito.when((Object)itemDefinition.getName()).thenReturn((Object)name);
        return itemDefinition;
    }

    private class DataTypesPageFake
    extends DataTypesPage {
        DataTypesPageFake(DataTypeList treeList, ItemDefinitionUtils itemDefinitionUtils, ItemDefinitionStore definitionStore, DataTypeStore dataTypeStore, DataTypeManager dataTypeManager, DataTypeManagerStackStore stackIndex, FlashMessages flashMessages, DataTypeSearchBar searchBar, DMNGraphUtils dmnGraphUtils, TranslationService translationService, DataTypeShortcuts dataTypeShortcuts, HTMLDivElement pageView) {
            super(treeList, itemDefinitionUtils, definitionStore, dataTypeStore, dataTypeManager, stackIndex, flashMessages, searchBar, dmnGraphUtils, translationService, dataTypeShortcuts, pageView);
        }

        protected void setupPageCSSClass(String cssClass) {
            super.setupPageCSSClass(cssClass);
        }
    }
}

