/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import java.util.Optional;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.HasValueAndTypeRef;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverImpl;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ValueAndDataTypePopoverImplTest {
    private static final String NAME = "name";
    private static final String NAME_LABEL = "label";
    @Mock
    private ValueAndDataTypePopoverView view;
    @Mock
    private HasValueAndTypeRef<Name> bound;
    @Mock
    private Decision decision;
    @Mock
    private QName typeRef;
    private ValueAndDataTypePopoverImpl editor;

    @Before
    public void setup() {
        this.editor = new ValueAndDataTypePopoverImpl(this.view);
        Mockito.when((Object)this.bound.asDMNModelInstrumentedBase()).thenReturn((Object)this.decision);
        Mockito.when((Object)this.bound.toWidgetValue(ArgumentMatchers.any(Name.class))).thenAnswer(i -> ((Name)i.getArguments()[0]).getValue());
        Mockito.when((Object)this.bound.toModelValue((String)Mockito.any())).thenAnswer(i -> new Name((String)i.getArguments()[0]));
        Mockito.when((Object)this.bound.normaliseValue((String)Mockito.any())).thenAnswer(i -> i.getArguments()[0]);
        Mockito.when((Object)this.bound.getValueLabel()).thenReturn((Object)NAME_LABEL);
        Mockito.when((Object)this.bound.getValue()).thenReturn((Object)new Name(NAME));
        Mockito.when((Object)this.bound.getTypeRef()).thenReturn((Object)this.typeRef);
    }

    @Test
    public void testInit() {
        ((ValueAndDataTypePopoverView)Mockito.verify((Object)this.view)).init(ArgumentMatchers.eq((Object)this.editor));
    }

    @Test
    public void testShow() {
        this.editor.bind(this.bound, 0, 0);
        this.editor.show();
        ((ValueAndDataTypePopoverView)Mockito.verify((Object)this.view)).show(Optional.empty());
    }

    @Test
    public void testHide() {
        this.editor.bind(this.bound, 0, 0);
        this.editor.hide();
        ((ValueAndDataTypePopoverView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testBind() {
        this.editor.bind(this.bound, 0, 0);
        ((ValueAndDataTypePopoverView)Mockito.verify((Object)this.view)).setDMNModel((DMNModelInstrumentedBase)ArgumentMatchers.eq((Object)this.decision));
        ((ValueAndDataTypePopoverView)Mockito.verify((Object)this.view)).initValue((String)ArgumentMatchers.eq((Object)NAME));
        ((ValueAndDataTypePopoverView)Mockito.verify((Object)this.view)).initSelectedTypeRef((QName)ArgumentMatchers.eq((Object)this.typeRef));
        this.editor.show();
        ((ValueAndDataTypePopoverView)Mockito.verify((Object)this.view)).show(Optional.empty());
    }

    @Test
    public void testSetDisplayName() {
        this.editor.bind(this.bound, 0, 0);
        this.editor.setValue(NAME);
        ((HasValueAndTypeRef)Mockito.verify(this.bound)).setValue(ArgumentMatchers.eq((Object)new Name(NAME)));
    }

    @Test
    public void testSetTypeRef() {
        this.editor.bind(this.bound, 0, 0);
        this.editor.setTypeRef(this.typeRef);
        ((HasValueAndTypeRef)Mockito.verify(this.bound)).setTypeRef((QName)ArgumentMatchers.eq((Object)this.typeRef));
    }

    @Test
    public void testSetOnClosedByKeyboardCallback_WhenBound() {
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        this.editor.bind(this.bound, 0, 0);
        this.editor.setOnClosedByKeyboardCallback(callback);
        ((ValueAndDataTypePopoverView)Mockito.verify((Object)this.view)).setOnClosedByKeyboardCallback(callback);
    }

    @Test
    public void testSetOnClosedByKeyboardCallback_WhenNotBound() {
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        this.editor.setOnClosedByKeyboardCallback(callback);
        ((ValueAndDataTypePopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setOnClosedByKeyboardCallback((Consumer)ArgumentMatchers.any(Consumer.class));
    }

    @Test
    public void testOnDataTypePageNavTabActiveEvent_WhenBound() {
        this.editor.bind(this.bound, 0, 0);
        this.editor.onDataTypePageNavTabActiveEvent((DataTypePageTabActiveEvent)Mockito.mock(DataTypePageTabActiveEvent.class));
        ((ValueAndDataTypePopoverView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testOnDataTypePageNavTabActiveEvent_WhenNotBound() {
        this.editor.onDataTypePageNavTabActiveEvent((DataTypePageTabActiveEvent)Mockito.mock(DataTypePageTabActiveEvent.class));
        ((ValueAndDataTypePopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
    }

    @Test
    public void testGetValueLabel_WhenBound() {
        this.editor.bind(this.bound, 0, 0);
        Assertions.assertThat((String)this.editor.getValueLabel()).isEqualTo(NAME_LABEL);
    }

    @Test
    public void testGetValueLabel_WhenNotBound() {
        Throwable thrown = Assertions.catchThrowable(() -> this.editor.getValueLabel());
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Popover has not been bound.");
    }

    @Test
    public void testNormaliseValue_WhenBound() {
        this.editor.bind(this.bound, 0, 0);
        Assertions.assertThat((String)this.editor.normaliseValue(NAME)).isEqualTo(NAME);
    }

    @Test
    public void testNormaliseValue_WhenNotBound() {
        Throwable thrown = Assertions.catchThrowable(() -> this.editor.normaliseValue(NAME));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Popover has not been bound.");
    }
}

