/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.KeyboardEvent;
import java.util.Optional;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePickerWidget;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverViewImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;

@RunWith(value=GwtMockitoTestRunner.class)
public class ValueAndDataTypePopoverViewImplTest {
    private static final String VALUE = "value";
    private static final String VALUE_LABEL = "label";
    @Mock
    private Input valueEditor;
    @Mock
    private DataTypePickerWidget dataTypeEditor;
    @Mock
    private Div popoverElement;
    @Mock
    private Div popoverContentElement;
    @Mock
    private Span valueLabel;
    @Mock
    private Span dataTypeLabel;
    @Mock
    private JQueryProducer.JQuery<Popover> jQueryProducer;
    @Mock
    private ValueAndDataTypePopoverView.Presenter presenter;
    @Mock
    private HTMLElement element;
    @Mock
    private Decision decision;
    @Mock
    private QName typeRef;
    @Mock
    private ValueChangeEvent<QName> valueChangeEvent;
    @Mock
    private BlurEvent blurEvent;
    @Mock
    private Popover popover;
    @Mock
    private TranslationService translationService;
    @Mock
    private Button manageButton;
    @Mock
    private Button typeSelectorButton;
    @Mock
    private EventListener keyDownCallback;
    @Mock
    private EventListener managerCallback;
    @Mock
    private EventListener eventListenerCallback;
    @Captor
    private ArgumentCaptor<ValueChangeHandler<QName>> valueChangeHandlerCaptor;
    private ValueAndDataTypePopoverViewImpl view;

    @Before
    public void setUp() {
        this.view = (ValueAndDataTypePopoverViewImpl)Mockito.spy((Object)new ValueAndDataTypePopoverViewImpl(this.valueEditor, this.dataTypeEditor, this.popoverElement, this.popoverContentElement, this.valueLabel, this.dataTypeLabel, this.jQueryProducer, this.translationService){

            public HTMLElement getElement() {
                return ValueAndDataTypePopoverViewImplTest.this.element;
            }

            protected EventListener getKeyDownEventListener() {
                return ValueAndDataTypePopoverViewImplTest.this.keyDownCallback;
            }

            EventListener getManageButtonKeyDownEventListener() {
                return ValueAndDataTypePopoverViewImplTest.this.managerCallback;
            }

            EventListener getTypeSelectorKeyDownEventListener() {
                return ValueAndDataTypePopoverViewImplTest.this.eventListenerCallback;
            }
        });
        Mockito.when((Object)this.element.querySelector("#typeButton")).thenReturn((Object)this.manageButton);
        Mockito.when((Object)this.element.querySelector("button.dropdown-toggle.btn-default")).thenReturn((Object)this.typeSelectorButton);
        Mockito.when((Object)this.presenter.getValueLabel()).thenReturn((Object)VALUE_LABEL);
        this.view.init(this.presenter);
        Mockito.when((Object)this.valueChangeEvent.getValue()).thenReturn((Object)this.typeRef);
        Mockito.when((Object)this.jQueryProducer.wrap((org.jboss.errai.common.client.dom.Element)this.element)).thenReturn((Object)this.popover);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0]).when((Object)this.translationService)).getTranslation((String)Mockito.any());
    }

    @Test
    public void testInit() {
        ((DataTypePickerWidget)Mockito.verify((Object)this.dataTypeEditor)).addValueChangeHandler((ValueChangeHandler)this.valueChangeHandlerCaptor.capture());
        ((ValueChangeHandler)this.valueChangeHandlerCaptor.getValue()).onValueChange(this.valueChangeEvent);
        Assert.assertEquals((Object)this.view.getCurrentTypeRef(), (Object)this.typeRef);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).setKeyDownListeners();
    }

    @Test
    public void testSetKeyDownListeners() {
        Mockito.reset((Object[])new Button[]{this.manageButton, this.typeSelectorButton});
        this.view.setKeyDownListeners();
        ((Div)Mockito.verify((Object)this.popoverElement)).addEventListener("keydown", this.keyDownCallback, false);
        ((Button)Mockito.verify((Object)this.manageButton)).addEventListener("keydown", this.managerCallback, false);
        ((Button)Mockito.verify((Object)this.typeSelectorButton)).addEventListener("keydown", this.eventListenerCallback, false);
    }

    @Test
    public void testTypeSelectorKeyDownEventListenerEnterKey() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doNothing().when((Object)this.view)).hide(true);
        this.view.typeSelectorKeyDownEventListener((Object)keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(true);
        ((KeyboardEvent)Mockito.verify((Object)keyboardEvent)).preventDefault();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testTypeSelectorKeyDownEventListenerEscKey() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor monitor = (ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.mock(ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)monitor).when((Object)this.view)).getMonitor();
        Element menuElement = (Element)Mockito.mock(Element.class);
        ((ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)menuElement).when((Object)monitor)).getMenuElement();
        this.view.typeSelectorKeyDownEventListener((Object)keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).reset();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(false);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testTypeSelectorKeyDownEventListenerWhenIsNotAHandledKey() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isTabKeyPressed(keyboardEvent);
        this.view.typeSelectorKeyDownEventListener((Object)keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide(ArgumentMatchers.anyBoolean());
        ((KeyboardEvent)Mockito.verify((Object)keyboardEvent, (VerificationMode)Mockito.never())).preventDefault();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).reset();
        ((Button)Mockito.verify((Object)this.manageButton, (VerificationMode)Mockito.never())).focus();
        ((Input)Mockito.verify((Object)this.valueEditor, (VerificationMode)Mockito.never())).focus();
    }

    @Test
    public void testTypeSelectorKeyDownEventListenerWhenIsNotAKeyboardEvent() {
        Event event = (Event)Mockito.mock(Event.class);
        this.view.typeSelectorKeyDownEventListener((Object)event);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide(ArgumentMatchers.anyBoolean());
        ((Event)Mockito.verify((Object)event, (VerificationMode)Mockito.never())).preventDefault();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).reset();
        ((Button)Mockito.verify((Object)this.manageButton, (VerificationMode)Mockito.never())).focus();
        ((Input)Mockito.verify((Object)this.valueEditor, (VerificationMode)Mockito.never())).focus();
    }

    @Test
    public void testTypeSelectorKeyDownEventListenerTabKey() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isTabKeyPressed(keyboardEvent);
        this.view.typeSelectorKeyDownEventListener((Object)keyboardEvent);
        ((Input)Mockito.verify((Object)this.valueEditor)).focus();
        ((KeyboardEvent)Mockito.verify((Object)keyboardEvent)).preventDefault();
    }

    @Test
    public void testTypeSelectorKeyDownEventListenerShiftTabKey() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        keyboardEvent.shiftKey = true;
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isTabKeyPressed(keyboardEvent);
        this.view.typeSelectorKeyDownEventListener((Object)keyboardEvent);
        ((Button)Mockito.verify((Object)this.manageButton)).focus();
        ((KeyboardEvent)Mockito.verify((Object)keyboardEvent)).preventDefault();
    }

    @Test
    public void testManagerButtonKeyDownEventListenerEsc() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor monitor = (ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.mock(ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)monitor).when((Object)this.view)).getMonitor();
        Element menuElement = (Element)Mockito.mock(Element.class);
        ((ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)menuElement).when((Object)monitor)).getMenuElement();
        this.view.manageButtonKeyDownEventListener((Object)keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(false);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).reset();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testManagerButtonKeyDownEventWhenIsNotEscapeKey() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        this.view.manageButtonKeyDownEventListener((Object)keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide(false);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).reset();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
    }

    @Test
    public void testManagerButtonKeyDownEventWhenIsNotKeyboardEvent() {
        Event event = (Event)Mockito.mock(Event.class);
        this.view.manageButtonKeyDownEventListener((Object)event);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide(false);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).reset();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
    }

    @Test
    public void testKeyDownEventListenerEsc() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doNothing().when((Object)this.view)).hide(false);
        this.view.manageButtonKeyDownEventListener((Object)keyboardEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(false);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).reset();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testIsTabKeyPressed() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        keyboardEvent.key = "Tab";
        boolean actual = this.view.isTabKeyPressed(keyboardEvent);
        Assert.assertTrue((boolean)actual);
        keyboardEvent.key = "A";
        actual = this.view.isTabKeyPressed(keyboardEvent);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testIsEscapeKeyPressed() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        keyboardEvent.key = "Esc";
        boolean actual = this.view.isEscapeKeyPressed(keyboardEvent);
        Assert.assertTrue((boolean)actual);
        keyboardEvent.key = "A";
        actual = this.view.isEscapeKeyPressed(keyboardEvent);
        Assert.assertFalse((boolean)actual);
        keyboardEvent.key = "Escape";
        actual = this.view.isEscapeKeyPressed(keyboardEvent);
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsEnterKeyPressed() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        keyboardEvent.key = "Enter";
        boolean actual = this.view.isEnterKeyPressed(keyboardEvent);
        Assert.assertTrue((boolean)actual);
        keyboardEvent.key = "A";
        actual = this.view.isEnterKeyPressed(keyboardEvent);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testOnValueEditorKeyDownEnter() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doNothing().when((Object)this.view)).hide(true);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEnter(keyDownEvent);
        this.view.onValueEditorKeyDown(keyDownEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(true);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testOnValueEditorKeyDownEsc() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnter(keyDownEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEsc(keyDownEvent);
        ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor monitor = (ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.mock(ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)monitor).when((Object)this.view)).getMonitor();
        Element menuElement = (Element)Mockito.mock(Element.class);
        ((ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)menuElement).when((Object)monitor)).getMenuElement();
        this.view.onValueEditorKeyDown(keyDownEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).reset();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(false);
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testOnValueEditorKeyDownShiftTab() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnter(keyDownEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEsc(keyDownEvent);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isTab(keyDownEvent);
        Mockito.when((Object)keyDownEvent.isShiftKeyDown()).thenReturn((Object)true);
        this.view.onValueEditorKeyDown(keyDownEvent);
        ((Button)Mockito.verify((Object)this.typeSelectorButton)).focus();
        ((KeyDownEvent)Mockito.verify((Object)keyDownEvent)).preventDefault();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
    }

    @Test
    public void testIsTab() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        Mockito.when((Object)keyDownEvent.getNativeKeyCode()).thenReturn((Object)9);
        boolean actual = this.view.isTab(keyDownEvent);
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsEsc() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        Mockito.when((Object)keyDownEvent.getNativeKeyCode()).thenReturn((Object)27);
        boolean actual = this.view.isEsc(keyDownEvent);
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsEnter() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        Mockito.when((Object)keyDownEvent.getNativeKeyCode()).thenReturn((Object)13);
        boolean actual = this.view.isEnter(keyDownEvent);
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsNotTab() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        Mockito.when((Object)keyDownEvent.getNativeKeyCode()).thenReturn((Object)65);
        boolean actual = this.view.isTab(keyDownEvent);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testIsNotEsc() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        Mockito.when((Object)keyDownEvent.getNativeKeyCode()).thenReturn((Object)65);
        boolean actual = this.view.isEsc(keyDownEvent);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testIsNotEnter() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        Mockito.when((Object)keyDownEvent.getNativeKeyCode()).thenReturn((Object)65);
        boolean actual = this.view.isEnter(keyDownEvent);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testSetDMNModel() {
        this.view.setDMNModel((DMNModelInstrumentedBase)this.decision);
        ((DataTypePickerWidget)Mockito.verify((Object)this.dataTypeEditor)).setDMNModel((DMNModelInstrumentedBase)ArgumentMatchers.eq((Object)this.decision));
    }

    @Test
    public void testInitValue() {
        this.view.initValue(VALUE);
        ((Input)Mockito.verify((Object)this.valueEditor)).setValue((String)ArgumentMatchers.eq((Object)VALUE));
        Assert.assertEquals((Object)VALUE, (Object)this.view.getCurrentValue());
    }

    @Test
    public void testInitSelectedTypeRef() {
        this.view.initSelectedTypeRef(this.typeRef);
        ((DataTypePickerWidget)Mockito.verify((Object)this.dataTypeEditor)).setValue((QName)ArgumentMatchers.eq((Object)this.typeRef), ArgumentMatchers.eq((boolean)false));
        Assert.assertEquals((Object)this.typeRef, (Object)this.view.getCurrentTypeRef());
    }

    @Test
    public void testShow() {
        this.view.show(Optional.empty());
        ((Span)Mockito.verify((Object)this.valueLabel)).setTextContent(VALUE_LABEL);
        ((Popover)Mockito.verify((Object)this.popover)).show();
    }

    @Test
    public void testHideBeforeShown() {
        ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor monitor = (ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.mock(ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)monitor).when((Object)this.view)).getMonitor();
        Element menuElement = (Element)Mockito.mock(Element.class);
        ((ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)menuElement).when((Object)monitor)).getMenuElement();
        this.view.hide();
        ((Popover)Mockito.verify((Object)this.popover, (VerificationMode)Mockito.never())).hide();
        ((Popover)Mockito.verify((Object)this.popover, (VerificationMode)Mockito.never())).destroy();
    }

    @Test
    public void testHideAfterShown() {
        ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor monitor = (ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.mock(ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)monitor).when((Object)this.view)).getMonitor();
        Element menuElement = (Element)Mockito.mock(Element.class);
        ((ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)menuElement).when((Object)monitor)).getMenuElement();
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isVisible();
        this.view.show(Optional.empty());
        this.view.hide();
        ((Input)Mockito.verify((Object)this.valueEditor)).blur();
        ((ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.verify((Object)monitor)).hide();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).isVisible();
    }

    @Test
    public void testHideWhenPopupAlreadyIsHidden() {
        ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor monitor = (ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.mock(ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor.class);
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)monitor).when((Object)this.view)).getMonitor();
        Element menuElement = (Element)Mockito.mock(Element.class);
        ((ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)menuElement).when((Object)monitor)).getMenuElement();
        ((ValueAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isVisible();
        this.view.hide();
        ((Input)Mockito.verify((Object)this.valueEditor, (VerificationMode)Mockito.never())).blur();
        ((ValueAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.never())).hide();
        ((ValueAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).isVisible();
    }

    @Test
    public void testOnValueChange() {
        Mockito.when((Object)this.presenter.normaliseValue((String)Mockito.any())).thenAnswer(i -> i.getArguments()[0]);
        Mockito.when((Object)this.valueEditor.getValue()).thenReturn((Object)VALUE);
        this.view.onValueChange(this.blurEvent);
        ((ValueAndDataTypePopoverView.Presenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setValue((String)ArgumentMatchers.eq((Object)VALUE));
        Assert.assertEquals((Object)VALUE, (Object)this.view.getCurrentValue());
    }

    @Test
    public void testOnValueChangeWithNormalisedValue() {
        String normalisedValue = "normalised";
        Mockito.when((Object)this.presenter.normaliseValue((String)Mockito.any())).thenAnswer(i -> "normalised");
        Mockito.when((Object)this.valueEditor.getValue()).thenReturn((Object)VALUE);
        this.view.onValueChange(this.blurEvent);
        ((ValueAndDataTypePopoverView.Presenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setValue((String)ArgumentMatchers.eq((Object)VALUE));
        ((Input)Mockito.verify((Object)this.valueEditor)).setValue("normalised");
        Assert.assertEquals((Object)"normalised", (Object)this.view.getCurrentValue());
    }

    @Test
    public void testResetValue() {
        this.view.initValue(VALUE);
        String newValue = "new_value";
        Mockito.when((Object)this.presenter.normaliseValue((String)Mockito.any())).thenAnswer(i -> i.getArguments()[0]);
        Mockito.when((Object)this.valueEditor.getValue()).thenReturn((Object)"new_value");
        this.view.onValueChange(this.blurEvent);
        Assert.assertEquals((Object)"new_value", (Object)this.view.getCurrentValue());
        this.view.reset();
        Assert.assertEquals((Object)VALUE, (Object)this.view.getCurrentValue());
    }

    @Test
    public void testResetTypeRef() {
        this.view.initSelectedTypeRef(this.typeRef);
        QName newTypeRef = (QName)Mockito.mock(QName.class);
        ((DataTypePickerWidget)Mockito.verify((Object)this.dataTypeEditor)).addValueChangeHandler((ValueChangeHandler)this.valueChangeHandlerCaptor.capture());
        Mockito.when((Object)this.valueChangeEvent.getValue()).thenReturn((Object)newTypeRef);
        ((ValueChangeHandler)this.valueChangeHandlerCaptor.getValue()).onValueChange(this.valueChangeEvent);
        Assert.assertEquals((Object)newTypeRef, (Object)this.view.getCurrentTypeRef());
        this.view.reset();
        Assert.assertEquals((Object)this.typeRef, (Object)this.view.getCurrentTypeRef());
    }
}

