/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.types.DataObject;
import org.kie.workbench.common.dmn.api.editors.types.DataObjectProperty;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListHighlightHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeStackHash;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDDataTypesHandler;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.kie.workbench.common.widgets.client.kogito.IsKogito;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeListTest {
    @Mock
    private DataTypeList.View view;
    @Mock
    private ManagedInstance<DataTypeListItem> listItems;
    @Mock
    private DataTypeListItem treeGridItem;
    @Mock
    private DataTypeManager dataTypeManager;
    @Mock
    private DataTypeSearchBar searchBar;
    @Mock
    private Consumer<DataTypeListItem> listItemConsumer;
    @Mock
    private DNDListComponent dndListComponent;
    @Mock
    private DNDDataTypesHandler dndDataTypesHandler;
    @Mock
    private DataTypeListHighlightHelper highlightHelper;
    @Mock
    private IsKogito isKogito;
    private DataTypeStore dataTypeStore;
    private DataTypeStackHash dataTypeStackHash;
    @Captor
    private ArgumentCaptor<List<DataTypeListItem>> listItemsCaptor;
    @Captor
    private ArgumentCaptor<List<HTMLElement>> htmlElementsCaptor;
    private DataTypeList dataTypeList;

    @Before
    public void setup() {
        this.dataTypeStore = new DataTypeStore();
        this.dataTypeStackHash = new DataTypeStackHash(this.dataTypeStore);
        this.dataTypeList = (DataTypeList)Mockito.spy((Object)new DataTypeList(this.view, this.listItems, this.dataTypeManager, this.searchBar, this.dndListComponent, this.dataTypeStackHash, this.dndDataTypesHandler, this.highlightHelper, this.isKogito));
        Mockito.when((Object)this.listItems.get()).thenReturn((Object)this.treeGridItem);
    }

    @Test
    public void testSetup() {
        BiConsumer<Element, Element> consumer = (a, b) -> {};
        ((DataTypeList)Mockito.doReturn(consumer).when((Object)this.dataTypeList)).getOnDropDataType();
        this.dataTypeList.setup();
        ((DataTypeList.View)Mockito.verify((Object)this.view)).init((Object)this.dataTypeList);
        ((DataTypeListHighlightHelper)Mockito.verify((Object)this.highlightHelper)).init(this.dataTypeList);
        ((DataTypeList.View)Mockito.verify((Object)this.view)).showImportDataObjectButton();
        ((DNDDataTypesHandler)Mockito.verify((Object)this.dndDataTypesHandler)).init(this.dataTypeList);
        ((DNDListComponent)Mockito.verify((Object)this.dndListComponent)).setOnDropItem(consumer);
    }

    @Test
    public void testSetupViewWhenIsKogito() {
        BiConsumer<Element, Element> consumer = (a, b) -> {};
        ((DataTypeList)Mockito.doReturn(consumer).when((Object)this.dataTypeList)).getOnDropDataType();
        Mockito.when((Object)this.isKogito.get()).thenReturn((Object)true);
        this.dataTypeList.setup();
        ((DataTypeList.View)Mockito.verify((Object)this.view)).init((Object)this.dataTypeList);
        ((DataTypeList.View)Mockito.verify((Object)this.view)).hideImportDataObjectButton();
        ((DNDDataTypesHandler)Mockito.verify((Object)this.dndDataTypesHandler)).init(this.dataTypeList);
        ((DNDListComponent)Mockito.verify((Object)this.dndListComponent)).setOnDropItem(consumer);
    }

    @Test
    public void testGetOnDropDataType() {
        Element e1 = (Element)Mockito.mock(Element.class);
        Element e2 = (Element)Mockito.mock(Element.class);
        this.dataTypeList.getOnDropDataType().accept(e1, e2);
        ((DNDDataTypesHandler)Mockito.verify((Object)this.dndDataTypesHandler)).onDropDataType(e1, e2);
    }

    @Test
    public void testGetElement() {
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)htmlElement);
        Assert.assertEquals((Object)htmlElement, (Object)this.dataTypeList.getElement());
    }

    @Test
    public void testSetupItems() {
        DataType dataType1 = this.makeDataType("item", "iITem", new DataType[0]);
        DataType dataType2 = this.makeDataType("item", "iITem", new DataType[0]);
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataType> dataTypes = Arrays.asList(dataType1, dataType2);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).makeDataTypeListItems(dataTypes);
        this.dataTypeList.setupItems(dataTypes);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.dndListComponent, this.dataTypeList, this.view});
        ((DNDListComponent)inOrder.verify((Object)this.dndListComponent)).clear();
        ((DataTypeList)inOrder.verify((Object)this.dataTypeList)).makeDataTypeListItems(dataTypes);
        ((DNDListComponent)inOrder.verify((Object)this.dndListComponent)).refreshItemsPosition();
        ((DataTypeList.View)inOrder.verify((Object)this.view)).showOrHideNoCustomItemsMessage();
        ((DataTypeList.View)inOrder.verify((Object)this.view)).showReadOnlyMessage(false);
        ((DataTypeList)inOrder.verify((Object)this.dataTypeList)).collapseItemsInTheFirstLevel();
        Assert.assertEquals(listItems, (Object)this.dataTypeList.getItems());
    }

    @Test
    public void testCollapseItemsInTheFirstLevel() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem4 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2, listItem3, listItem4);
        Mockito.when((Object)listItem1.getLevel()).thenReturn((Object)1);
        Mockito.when((Object)listItem2.getLevel()).thenReturn((Object)2);
        Mockito.when((Object)listItem3.getLevel()).thenReturn((Object)1);
        Mockito.when((Object)listItem4.getLevel()).thenReturn((Object)2);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        this.dataTypeList.collapseItemsInTheFirstLevel();
        ((DataTypeListItem)Mockito.verify((Object)listItem1)).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem2, (VerificationMode)Mockito.never())).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem3)).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem4, (VerificationMode)Mockito.never())).collapse();
    }

    @Test
    public void testExpandAllWhenSearchBarIsEnabledEnabled() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2, listItem3);
        Mockito.when((Object)this.searchBar.isEnabled()).thenReturn((Object)true);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        this.dataTypeList.expandAll();
        ((DataTypeListItem)Mockito.verify((Object)listItem1, (VerificationMode)Mockito.never())).expand();
        ((DataTypeListItem)Mockito.verify((Object)listItem2, (VerificationMode)Mockito.never())).expand();
        ((DataTypeListItem)Mockito.verify((Object)listItem3, (VerificationMode)Mockito.never())).expand();
    }

    @Test
    public void testExpandAllWhenSearchBarIsDisabledEnabled() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2, listItem3);
        Mockito.when((Object)this.searchBar.isEnabled()).thenReturn((Object)false);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        this.dataTypeList.expandAll();
        ((DataTypeListItem)Mockito.verify((Object)listItem1)).expand();
        ((DataTypeListItem)Mockito.verify((Object)listItem2)).expand();
        ((DataTypeListItem)Mockito.verify((Object)listItem3)).expand();
    }

    @Test
    public void testCollapseAllWhenSearchBarIsEnabledEnabled() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2, listItem3);
        Mockito.when((Object)this.searchBar.isEnabled()).thenReturn((Object)true);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        this.dataTypeList.collapseAll();
        ((DataTypeListItem)Mockito.verify((Object)listItem1, (VerificationMode)Mockito.never())).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem2, (VerificationMode)Mockito.never())).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem3, (VerificationMode)Mockito.never())).collapse();
    }

    @Test
    public void testCollapseAllWhenSearchBarIsDisabledEnabled() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2, listItem3);
        Mockito.when((Object)this.searchBar.isEnabled()).thenReturn((Object)false);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        this.dataTypeList.collapseAll();
        ((DataTypeListItem)Mockito.verify((Object)listItem1)).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem2)).collapse();
        ((DataTypeListItem)Mockito.verify((Object)listItem3)).collapse();
    }

    @Test
    public void testMakeDataTypeListItemsWithoutSubItems() {
        DataType dataType1 = this.makeDataType("item", "iITem", new DataType[0]);
        DataType dataType2 = this.makeDataType("item", "iITem", new DataType[0]);
        List<DataType> dataTypes = Arrays.asList(dataType1, dataType2);
        this.dataTypeList.makeDataTypeListItems(dataTypes);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems((DataType)ArgumentMatchers.eq((Object)dataType1), ArgumentMatchers.eq((int)1));
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems((DataType)ArgumentMatchers.eq((Object)dataType2), ArgumentMatchers.eq((int)1));
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList, (VerificationMode)Mockito.times((int)2))).makeTreeListItems((DataType)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
    }

    @Test
    public void testMakeDataTypeListItemsWithSubItems() {
        DataType subDataType3 = this.makeDataType("subItem3", "subItemType3", new DataType[0]);
        DataType subDataType1 = this.makeDataType("subItem1", "subItemType1", new DataType[0]);
        DataType subDataType2 = this.makeDataType("subItem2", "subItemType2", subDataType3);
        DataType dataType = this.makeDataType("item", "iITem", subDataType1, subDataType2);
        List<DataType> dataTypes = Collections.singletonList(dataType);
        this.dataTypeList.makeDataTypeListItems(dataTypes);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems((DataType)ArgumentMatchers.eq((Object)dataType), ArgumentMatchers.eq((int)1));
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems((DataType)ArgumentMatchers.eq((Object)subDataType1), ArgumentMatchers.eq((int)2));
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems((DataType)ArgumentMatchers.eq((Object)subDataType2), ArgumentMatchers.eq((int)2));
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems((DataType)ArgumentMatchers.eq((Object)subDataType3), ArgumentMatchers.eq((int)3));
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList, (VerificationMode)Mockito.times((int)4))).makeTreeListItems((DataType)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
    }

    @Test
    public void testMakeTreeListItems() {
        DataType item1 = this.makeDataType("item1", "iITem1", new DataType[0]);
        DataType item2 = this.makeDataType("item2", "iITem2", new DataType[0]);
        DataType item3 = this.makeDataType("item", "iITem", item1, item2);
        List listItems = this.dataTypeList.makeTreeListItems(item3, 1);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems(item3, 1);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems(item1, 2);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).makeTreeListItems(item2, 2);
        Assert.assertEquals((long)3L, (long)listItems.size());
    }

    @Test
    public void testRefreshSubItems() {
        DataTypeListItem listItem0 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        DataTypeManager dataTypeManager1 = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        DataTypeManager dataTypeManager2 = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        DataTypeManager dataTypeManager3 = (DataTypeManager)Mockito.mock(DataTypeManager.class);
        ArrayList items = new ArrayList();
        boolean level = true;
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element3 = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)listItem0.getLevel()).thenReturn((Object)1);
        Mockito.when((Object)listItem0.getDataType()).thenReturn((Object)dataType0);
        Mockito.when((Object)listItem0.getDragAndDropElement()).thenReturn((Object)element0);
        Mockito.when((Object)listItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)listItem1.getDragAndDropElement()).thenReturn((Object)element1);
        Mockito.when((Object)listItem2.getDataType()).thenReturn((Object)dataType2);
        Mockito.when((Object)listItem2.getDragAndDropElement()).thenReturn((Object)element2);
        Mockito.when((Object)listItem3.getDataType()).thenReturn((Object)dataType3);
        Mockito.when((Object)listItem3.getDragAndDropElement()).thenReturn((Object)element3);
        Mockito.when((Object)this.dataTypeManager.from(dataType1)).thenReturn((Object)dataTypeManager1);
        Mockito.when((Object)this.dataTypeManager.from(dataType2)).thenReturn((Object)dataTypeManager2);
        Mockito.when((Object)this.dataTypeManager.from(dataType3)).thenReturn((Object)dataTypeManager3);
        ((DataTypeList)Mockito.doReturn(Collections.singletonList(listItem1)).when((Object)this.dataTypeList)).makeTreeListItems(dataType1, 2);
        ((DataTypeList)Mockito.doReturn(Collections.singletonList(listItem2)).when((Object)this.dataTypeList)).makeTreeListItems(dataType2, 2);
        ((DataTypeList)Mockito.doReturn(Collections.singletonList(listItem3)).when((Object)this.dataTypeList)).makeTreeListItems(dataType3, 2);
        ((DataTypeList)Mockito.doReturn(items).when((Object)this.dataTypeList)).getItems();
        this.dataTypeList.refreshSubItemsFromListItem(listItem0, Arrays.asList(dataType1, dataType2, dataType3));
        ((DataTypeList.View)Mockito.verify((Object)this.view)).cleanSubTypes((DataType)ArgumentMatchers.eq((Object)dataType0));
        ((DataTypeList.View)Mockito.verify((Object)this.view)).addSubItems((DataType)ArgumentMatchers.eq((Object)dataType0), (List)this.listItemsCaptor.capture());
        ((DataTypeManager)Mockito.verify((Object)dataTypeManager1)).withIndexedItemDefinition();
        ((DataTypeManager)Mockito.verify((Object)dataTypeManager2)).withIndexedItemDefinition();
        ((DataTypeManager)Mockito.verify((Object)dataTypeManager3)).withIndexedItemDefinition();
        ((DNDListComponent)Mockito.verify((Object)this.dndListComponent)).setInitialPositionY((HTMLElement)ArgumentMatchers.eq((Object)element0), (List)this.htmlElementsCaptor.capture());
        List capturedElements = (List)this.htmlElementsCaptor.getValue();
        List<HTMLElement> expectedElements = Arrays.asList(element1, element2, element3);
        Assert.assertEquals(expectedElements, (Object)capturedElements);
        List actualItems = (List)this.listItemsCaptor.getValue();
        List<DataTypeListItem> expectedItems = Arrays.asList(listItem1, listItem2, listItem3);
        Assert.assertEquals(expectedItems, (Object)actualItems);
    }

    @Test
    public void testMakeListItem() {
        DataTypeListItem expectedListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doCallRealMethod().when((Object)this.dataTypeList)).makeListItem();
        Mockito.when((Object)this.listItems.get()).thenReturn((Object)expectedListItem);
        DataTypeListItem actualListItem = this.dataTypeList.makeListItem();
        ((DataTypeListItem)Mockito.verify((Object)expectedListItem)).init((DataTypeList)ArgumentMatchers.eq((Object)this.dataTypeList));
        Assert.assertEquals((Object)expectedListItem, (Object)actualListItem);
    }

    @Test
    public void testRemoveItemByDataType() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String uuid = "uuid";
        ((DataTypeList)Mockito.doNothing().when((Object)this.dataTypeList)).removeItem((String)Mockito.any());
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        this.dataTypeList.removeItem(dataType);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).removeItem("uuid");
        ((DataTypeList.View)Mockito.verify((Object)this.view)).removeItem(dataType);
    }

    @Test
    public void testRemoveItemByUUID() {
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem dataTypeListItem0 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem dataTypeListItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ArrayList<DataTypeListItem> items = new ArrayList<DataTypeListItem>(Arrays.asList(dataTypeListItem0, dataTypeListItem1));
        Mockito.when((Object)dataType0.getUUID()).thenReturn((Object)"012");
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"345");
        Mockito.when((Object)dataTypeListItem0.getDataType()).thenReturn((Object)dataType0);
        Mockito.when((Object)dataTypeListItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)this.dataTypeList.getItems()).thenReturn(items);
        this.dataTypeList.removeItem("012");
        List<DataTypeListItem> expected = Collections.singletonList(dataTypeListItem1);
        List actual = this.dataTypeList.getItems();
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testFindItemWhenItemExists() {
        String uuid1 = "uuid1";
        String uuid2 = "uuid2";
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem dataTypeListItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem dataTypeListItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ArrayList<DataTypeListItem> existingItems = new ArrayList<DataTypeListItem>(Arrays.asList(dataTypeListItem1, dataTypeListItem2));
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataType2.getUUID()).thenReturn((Object)"uuid2");
        Mockito.when((Object)dataTypeListItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)dataTypeListItem2.getDataType()).thenReturn((Object)dataType2);
        Mockito.when((Object)this.dataTypeList.getItems()).thenReturn(existingItems);
        Optional item = this.dataTypeList.findItem(dataType1);
        Assert.assertEquals((Object)dataTypeListItem1, item.get());
    }

    @Test
    public void testFindItemWhenItemDoesNotExist() {
        String uuid1 = "uuid1";
        String uuid2 = "uuid2";
        String uuid3 = "uuid3";
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem dataTypeListItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem dataTypeListItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ArrayList<DataTypeListItem> existingItems = new ArrayList<DataTypeListItem>(Arrays.asList(dataTypeListItem1, dataTypeListItem2));
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataType2.getUUID()).thenReturn((Object)"uuid2");
        Mockito.when((Object)dataType3.getUUID()).thenReturn((Object)"uuid3");
        Mockito.when((Object)dataTypeListItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)dataTypeListItem2.getDataType()).thenReturn((Object)dataType2);
        Mockito.when((Object)this.dataTypeList.getItems()).thenReturn(existingItems);
        Optional item = this.dataTypeList.findItem(dataType3);
        Assert.assertFalse((boolean)item.isPresent());
    }

    @Test
    public void testRefreshItemsByUpdatedDataTypes() {
        String uuid1 = "uuid1";
        String uuid2 = "uuid2";
        String uuid3 = "uuid3";
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataType> subDataTypes = Arrays.asList(dataType2, dataType3);
        ArrayList<DataType> existingItems = new ArrayList<DataType>(Arrays.asList(dataType1, dataType2, dataType3));
        ((DataTypeList)Mockito.doReturn(Optional.of(listItem)).when((Object)this.dataTypeList)).findItem(dataType1);
        ((DataTypeList)Mockito.doReturn(Optional.empty()).when((Object)this.dataTypeList)).findItem(dataType2);
        ((DataTypeList)Mockito.doReturn(Optional.empty()).when((Object)this.dataTypeList)).findItem(dataType3);
        ((DataTypeList)Mockito.doNothing().when((Object)this.dataTypeList)).refreshSubItemsFromListItem((DataTypeListItem)ArgumentMatchers.any(), ArgumentMatchers.anyListOf(DataType.class));
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataType2.getUUID()).thenReturn((Object)"uuid2");
        Mockito.when((Object)dataType3.getUUID()).thenReturn((Object)"uuid3");
        Mockito.when((Object)dataType1.getSubDataTypes()).thenReturn(subDataTypes);
        this.dataTypeList.refreshItemsByUpdatedDataTypes(existingItems);
        ((DataTypeListItem)Mockito.verify((Object)listItem)).refresh();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).refreshSubItemsFromListItem(listItem, subDataTypes);
        ((DNDListComponent)Mockito.verify((Object)this.dndListComponent)).consolidateYPosition();
        ((DNDListComponent)Mockito.verify((Object)this.dndListComponent)).refreshItemsPosition();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).refresh();
    }

    @Test
    public void testAddDataType() {
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)this.dataTypeManager.fromNew()).thenReturn((Object)this.dataTypeManager);
        Mockito.when((Object)this.dataTypeManager.get()).thenReturn((Object)dataType);
        ((DataTypeList)Mockito.doReturn((Object)listItem).when((Object)this.dataTypeList)).makeListItem(dataType);
        this.dataTypeList.addDataType();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).reset();
        ((DataType)Mockito.verify((Object)dataType)).create();
        ((DataTypeList.View)Mockito.verify((Object)this.view)).showOrHideNoCustomItemsMessage();
        ((DataTypeListItem)Mockito.verify((Object)listItem)).refresh();
        ((DataTypeListItem)Mockito.verify((Object)listItem)).enableEditMode();
        ((DNDListComponent)Mockito.verify((Object)this.dndListComponent)).refreshItemsCSSAndHTMLPosition();
        ((DataTypeListItem)Mockito.verify((Object)listItem)).enableEditMode();
    }

    @Test
    public void testAddDataTypeWithDefinedDataType() {
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ((DataTypeList)Mockito.doReturn((Object)listItem).when((Object)this.dataTypeList)).makeListItem(dataType);
        this.dataTypeList.addDataType(dataType, false);
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).reset();
        ((DataType)Mockito.verify((Object)dataType)).create();
        ((DataTypeList.View)Mockito.verify((Object)this.view)).showOrHideNoCustomItemsMessage();
        ((DataTypeListItem)Mockito.verify((Object)listItem)).refresh();
        ((DataTypeListItem)Mockito.verify((Object)listItem, (VerificationMode)Mockito.never())).enableEditMode();
        ((DNDListComponent)Mockito.verify((Object)this.dndListComponent)).refreshItemsCSSAndHTMLPosition();
    }

    @Test
    public void testAddDataTypeWithDefinedDataTypeAndEditMode() {
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ((DataTypeList)Mockito.doReturn((Object)listItem).when((Object)this.dataTypeList)).makeListItem(dataType);
        this.dataTypeList.addDataType(dataType, true);
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).reset();
        ((DataType)Mockito.verify((Object)dataType)).create();
        ((DataTypeList.View)Mockito.verify((Object)this.view)).showOrHideNoCustomItemsMessage();
        ((DataTypeListItem)Mockito.verify((Object)listItem)).refresh();
        ((DataTypeListItem)Mockito.verify((Object)listItem)).enableEditMode();
        ((DNDListComponent)Mockito.verify((Object)this.dndListComponent)).refreshItemsCSSAndHTMLPosition();
    }

    @Test
    public void testInsertBelow() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doReturn((Object)listItem).when((Object)this.dataTypeList)).makeListItem(dataType);
        Mockito.when((Object)listItem.getDataType()).thenReturn((Object)dataType);
        this.dataTypeList.insertBelow(dataType, reference);
        ((DataTypeList.View)Mockito.verify((Object)this.view)).insertBelow(listItem, reference);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).refreshItemsByUpdatedDataTypes(Collections.singletonList(dataType));
    }

    @Test
    public void testInsertAbove() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doReturn((Object)listItem).when((Object)this.dataTypeList)).makeListItem(dataType);
        this.dataTypeList.insertAbove(dataType, reference);
        ((DataTypeList.View)Mockito.verify((Object)this.view)).insertAbove(listItem, reference);
        ((DNDListComponent)Mockito.verify((Object)this.dndListComponent)).consolidateYPosition();
        ((DNDListComponent)Mockito.verify((Object)this.dndListComponent)).refreshItemsPosition();
    }

    @Test
    public void testMakeListItemWithDataType() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem expectedListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doReturn((Object)expectedListItem).when((Object)this.dataTypeList)).makeListItem();
        ((DataTypeList)Mockito.doReturn(new ArrayList()).when((Object)this.dataTypeList)).getItems();
        DataTypeListItem actualListItem = this.dataTypeList.makeListItem(dataType);
        List actualItems = this.dataTypeList.getItems();
        List<DataTypeListItem> expectedItems = Collections.singletonList(expectedListItem);
        ((DataTypeListItem)Mockito.verify((Object)expectedListItem)).setupDataType(dataType, 1);
        Assert.assertEquals((Object)expectedListItem, (Object)actualListItem);
        Assert.assertEquals(expectedItems, (Object)actualItems);
    }

    @Test
    public void testShowNoDataTypesFound() {
        this.dataTypeList.showNoDataTypesFound();
        ((DataTypeList.View)Mockito.verify((Object)this.view)).showNoDataTypesFound();
    }

    @Test
    public void testShowListItems() {
        this.dataTypeList.showListItems();
        ((DataTypeList.View)Mockito.verify((Object)this.view)).showOrHideNoCustomItemsMessage();
    }

    @Test
    public void testEnableEditMode() {
        String dataTypeHash = "tCity.name";
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doReturn(Optional.of(listItem)).when((Object)this.dataTypeList)).findItemByDataTypeHash("tCity.name");
        this.dataTypeList.enableEditMode("tCity.name");
        ((DataTypeListItem)Mockito.verify((Object)listItem)).enableEditMode();
    }

    @Test
    public void testInsertNestedField() {
        String dataTypeHash = "tCity.name";
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doReturn(Optional.of(listItem)).when((Object)this.dataTypeList)).findItemByDataTypeHash("tCity.name");
        this.dataTypeList.insertNestedField("tCity.name");
        ((DataTypeListItem)Mockito.verify((Object)listItem)).insertNestedField();
    }

    @Test
    public void testFireListItemUpdateCallbacks() {
        String dataTypeHash = "tCity.name";
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DataTypeList)Mockito.doReturn(Optional.of(listItem)).when((Object)this.dataTypeList)).findItemByDataTypeHash("tCity.name");
        this.dataTypeList.registerDataTypeListItemUpdateCallback(this.listItemConsumer);
        this.dataTypeList.fireOnDataTypeListItemUpdateCallback("tCity.name");
        ((Consumer)Mockito.verify(this.listItemConsumer)).accept(listItem);
    }

    @Test
    public void testFindItemByDataTypeHashWhenListItemIsFound() {
        DataTypeListItem tCity = this.listItem(this.makeDataType("001", "tCity", ""));
        DataTypeListItem tCityId = this.listItem(this.makeDataType("002", "id", "001"));
        DataTypeListItem tCityName = this.listItem(this.makeDataType("003", "name", "001"));
        ((DataTypeList)Mockito.doReturn(Arrays.asList(tCity, tCityId, tCityName)).when((Object)this.dataTypeList)).getItems();
        Optional item = this.dataTypeList.findItemByDataTypeHash("tCity.name");
        Assert.assertTrue((boolean)item.isPresent());
        Assert.assertEquals(item.get(), (Object)tCityName);
    }

    @Test
    public void testFindItemByDataTypeHashWhenListItemIsNotFound() {
        ((DataTypeList)Mockito.doReturn(Collections.emptyList()).when((Object)this.dataTypeList)).getItems();
        Optional item = this.dataTypeList.findItemByDataTypeHash("tCity.name");
        Assert.assertFalse((boolean)item.isPresent());
    }

    @Test
    public void testOnDataTypeEditModeToggleStartEditing() {
        DataTypeListItem currentEditingItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeEditModeToggleEvent event = new DataTypeEditModeToggleEvent(true, currentEditingItem);
        this.dataTypeList.onDataTypeEditModeToggle(event);
        DataTypeListItem actual = this.dataTypeList.getCurrentEditingItem();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).reset();
        Assert.assertEquals((Object)currentEditingItem, (Object)actual);
    }

    @Test
    public void testOnDataTypeEditModeToggleStopEditing() {
        DataTypeListItem currentEditingItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeEditModeToggleEvent event = new DataTypeEditModeToggleEvent(false, currentEditingItem);
        this.dataTypeList.onDataTypeEditModeToggle(event);
        DataTypeListItem actual = this.dataTypeList.getCurrentEditingItem();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).reset();
        Assert.assertEquals(null, (Object)actual);
    }

    @Test
    public void testOnDataTypeEditModeToggleChangedCurrentEditingItem() {
        DataTypeListItem currentEditingItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem previousEditingItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> listItems = Arrays.asList(currentEditingItem, previousEditingItem);
        ((DataTypeList)Mockito.doReturn(listItems).when((Object)this.dataTypeList)).getItems();
        DataTypeEditModeToggleEvent event = new DataTypeEditModeToggleEvent(true, currentEditingItem);
        this.dataTypeList.setCurrentEditingItem(previousEditingItem);
        this.dataTypeList.onDataTypeEditModeToggle(event);
        DataTypeListItem actual = this.dataTypeList.getCurrentEditingItem();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).reset();
        Assert.assertEquals((Object)currentEditingItem, (Object)actual);
        ((DataTypeListItem)Mockito.verify((Object)previousEditingItem)).disableEditMode();
    }

    @Test
    public void testGetListElement() {
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getListItems()).thenReturn((Object)expectedElement);
        HTMLElement actualElement = this.dataTypeList.getListItems();
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testImportDataObjects() {
        DataObject present = (DataObject)Mockito.mock(DataObject.class);
        DataObject notPresent = (DataObject)Mockito.mock(DataObject.class);
        List<DataObject> selectedDataObjects = Arrays.asList(present, notPresent);
        DataType presentDataType = (DataType)Mockito.mock(DataType.class);
        DataType notPresentDataType = (DataType)Mockito.mock(DataType.class);
        String notPresentClass = "not.present";
        String importedPresentClass = "org.something.MyClass";
        DataType existingDataType = (DataType)Mockito.mock(DataType.class);
        ((DataTypeList)Mockito.doReturn((Object)presentDataType).when((Object)this.dataTypeList)).createNewDataType(present);
        ((DataTypeList)Mockito.doReturn((Object)notPresentDataType).when((Object)this.dataTypeList)).createNewDataType(notPresent);
        ((DataTypeList)Mockito.doReturn(Optional.of(existingDataType)).when((Object)this.dataTypeList)).findDataTypeByName("org.something.MyClass");
        ((DataTypeList)Mockito.doReturn(Optional.empty()).when((Object)this.dataTypeList)).findDataTypeByName("not.present");
        ((DataTypeList)Mockito.doNothing().when((Object)this.dataTypeList)).replace(existingDataType, presentDataType);
        ((DataTypeList)Mockito.doNothing().when((Object)this.dataTypeList)).insertProperties(present);
        ((DataTypeList)Mockito.doNothing().when((Object)this.dataTypeList)).insertProperties(notPresent);
        ((DataTypeList)Mockito.doNothing().when((Object)this.dataTypeList)).insert(notPresentDataType);
        ((DataTypeList)Mockito.doNothing().when((Object)this.dataTypeList)).removeFullQualifiedNames(selectedDataObjects);
        Mockito.when((Object)notPresent.getClassType()).thenReturn((Object)"not.present");
        Mockito.when((Object)present.getClassType()).thenReturn((Object)"org.something.MyClass");
        this.dataTypeList.importDataObjects(selectedDataObjects);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).findDataTypeByName("org.something.MyClass");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).replace(existingDataType, presentDataType);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).insertProperties(present);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList, (VerificationMode)Mockito.never())).insert(presentDataType);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).insert(notPresentDataType);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).insertProperties(notPresent);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).removeFullQualifiedNames(selectedDataObjects);
    }

    @Test
    public void testInsertProperties() {
        DataObject dataObject = (DataObject)Mockito.mock(DataObject.class);
        String myImportedClass = "org.MyClass";
        DataType existingDt = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem dtListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        Optional<DataTypeListItem> dtListItemOptional = Optional.of(dtListItem);
        DataObjectProperty property1 = (DataObjectProperty)Mockito.mock(DataObjectProperty.class);
        DataObjectProperty property2 = (DataObjectProperty)Mockito.mock(DataObjectProperty.class);
        List<DataObjectProperty> properties = Arrays.asList(property1, property2);
        DataType property1DataType = (DataType)Mockito.mock(DataType.class);
        DataType property2DataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataObject.getClassType()).thenReturn((Object)"org.MyClass");
        Mockito.when((Object)dataObject.getProperties()).thenReturn(properties);
        ((DataTypeList)Mockito.doReturn(Optional.of(existingDt)).when((Object)this.dataTypeList)).findDataTypeByName("org.MyClass");
        ((DataTypeList)Mockito.doReturn(dtListItemOptional).when((Object)this.dataTypeList)).findItem(existingDt);
        ((DataTypeList)Mockito.doReturn((Object)property1DataType).when((Object)this.dataTypeList)).createNewDataType(property1);
        ((DataTypeList)Mockito.doReturn((Object)property2DataType).when((Object)this.dataTypeList)).createNewDataType(property2);
        this.dataTypeList.insertProperties(dataObject);
        ((DataTypeListItem)Mockito.verify((Object)dtListItem)).insertNestedField(property1DataType);
        ((DataTypeListItem)Mockito.verify((Object)dtListItem)).insertNestedField(property2DataType);
    }

    @Test
    public void testRemoveFullQualifiedNames() {
        String do1Class = "something.class1";
        String do2Class = "something.class2";
        String do3Class = "something.class3";
        String extractedName1 = "class1";
        String extractedName2 = "class2";
        String extractedName3 = "class3";
        String builtName1 = "name1";
        String builtName2 = "name2";
        String builtName3 = "name3";
        DataObject do1 = this.createDataObject("something.class1");
        DataObject do2 = this.createDataObject("something.class2");
        DataObject do3 = this.createDataObject("something.class3");
        HashMap<String, Integer> namesCount = new HashMap<String, Integer>();
        HashMap<String, String> renamed = new HashMap<String, String>();
        namesCount.put("trash", 0);
        renamed.put("trash.from.previous", "previous");
        ((DataTypeList)Mockito.doReturn(namesCount).when((Object)this.dataTypeList)).getImportedNamesOccurrencesCount();
        ((DataTypeList)Mockito.doReturn(renamed).when((Object)this.dataTypeList)).getRenamedImportedDataTypes();
        List<DataObject> imported = Arrays.asList(do1, do2, do3);
        Mockito.when((Object)do1.getClassNameWithoutPackage()).thenReturn((Object)"class1");
        Mockito.when((Object)do2.getClassNameWithoutPackage()).thenReturn((Object)"class2");
        Mockito.when((Object)do3.getClassNameWithoutPackage()).thenReturn((Object)"class3");
        ((DataTypeList)Mockito.doReturn((Object)"name1").when((Object)this.dataTypeList)).buildName("class1", namesCount);
        ((DataTypeList)Mockito.doReturn((Object)"name2").when((Object)this.dataTypeList)).buildName("class2", namesCount);
        ((DataTypeList)Mockito.doReturn((Object)"name3").when((Object)this.dataTypeList)).buildName("class3", namesCount);
        ((DataTypeList)Mockito.doNothing().when((Object)this.dataTypeList)).updatePropertiesReferences(imported, renamed);
        this.dataTypeList.removeFullQualifiedNames(imported);
        ((DataObject)Mockito.verify((Object)do1)).getClassNameWithoutPackage();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).buildName("class1", namesCount);
        Assert.assertTrue((boolean)renamed.containsKey("something.class1"));
        Assert.assertEquals((Object)"name1", renamed.get("something.class1"));
        ((DataObject)Mockito.verify((Object)do1)).setClassType("name1");
        ((DataObject)Mockito.verify((Object)do2)).getClassNameWithoutPackage();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).buildName("class2", namesCount);
        Assert.assertTrue((boolean)renamed.containsKey("something.class2"));
        Assert.assertEquals((Object)"name2", renamed.get("something.class2"));
        ((DataObject)Mockito.verify((Object)do2)).setClassType("name2");
        ((DataObject)Mockito.verify((Object)do3)).getClassNameWithoutPackage();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).buildName("class3", namesCount);
        Assert.assertTrue((boolean)renamed.containsKey("something.class3"));
        Assert.assertEquals((Object)"name3", renamed.get("something.class3"));
        ((DataObject)Mockito.verify((Object)do3)).setClassType("name3");
        Assert.assertEquals((long)3L, (long)renamed.size());
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).updatePropertiesReferences(imported, renamed);
    }

    private DataObject createDataObject(String className) {
        DataObject dataObject = (DataObject)Mockito.mock(DataObject.class);
        Mockito.when((Object)dataObject.getClassType()).thenReturn((Object)className);
        return dataObject;
    }

    @Test
    public void testBuildName() {
        String name = "MyClass";
        String differentName = "SomeOtherClass";
        HashMap namesCount = new HashMap();
        String occurrence0 = this.dataTypeList.buildName("MyClass", namesCount);
        Assert.assertEquals((Object)"MyClass", (Object)occurrence0);
        String occurrence1 = this.dataTypeList.buildName("MyClass", namesCount);
        Assert.assertEquals((Object)"MyClass-1", (Object)occurrence1);
        String occurrence2 = this.dataTypeList.buildName("MyClass", namesCount);
        Assert.assertEquals((Object)"MyClass-2", (Object)occurrence2);
        String differentOccurrence0 = this.dataTypeList.buildName("SomeOtherClass", namesCount);
        Assert.assertEquals((Object)"SomeOtherClass", (Object)differentOccurrence0);
        String differentOccurrence1 = this.dataTypeList.buildName("SomeOtherClass", namesCount);
        Assert.assertEquals((Object)"SomeOtherClass-1", (Object)differentOccurrence1);
    }

    @Test
    public void testUpdatePropertiesReferences() {
        ArrayList<DataObject> imported = new ArrayList<DataObject>();
        HashMap<String, String> renamed = new HashMap<String, String>();
        String propertyType1 = "type";
        String propertyNewType1 = "type-1";
        String uniqueType = "uniqueType";
        renamed.put("type", "type-1");
        DataObjectProperty prop1 = (DataObjectProperty)Mockito.mock(DataObjectProperty.class);
        DataObjectProperty prop2 = (DataObjectProperty)Mockito.mock(DataObjectProperty.class);
        Mockito.when((Object)prop1.getType()).thenReturn((Object)"type");
        Mockito.when((Object)prop2.getType()).thenReturn((Object)"uniqueType");
        ((DataTypeList)Mockito.doReturn((Object)true).when((Object)this.dataTypeList)).isPropertyTypePresent("uniqueType", imported);
        ((DataTypeList)Mockito.doReturn((Object)true).when((Object)this.dataTypeList)).isPropertyTypePresent("type-1", imported);
        DataObject do1 = new DataObject();
        do1.setProperties(Arrays.asList(prop1, prop2));
        imported.add(do1);
        this.dataTypeList.updatePropertiesReferences(imported, renamed);
        ((DataObjectProperty)Mockito.verify((Object)prop1)).setType("type-1");
        ((DataObjectProperty)Mockito.verify((Object)prop2)).setType("uniqueType");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).isPropertyTypePresent("type-1", imported);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).isPropertyTypePresent("uniqueType", imported);
    }

    @Test
    public void testIsPropertyTypePresent() {
        String someBuiltInType = BuiltInType.STRING.getName();
        String anImportedType = "SomeImportedType";
        String unknownType = "UnknownType";
        DataObject dataObject = (DataObject)Mockito.mock(DataObject.class);
        Mockito.when((Object)dataObject.getClassType()).thenReturn((Object)"SomeImportedType");
        List<DataObject> imported = Arrays.asList(dataObject);
        boolean isPresent = this.dataTypeList.isPropertyTypePresent(someBuiltInType, imported);
        Assert.assertTrue((String)"Built-in type is present", (boolean)isPresent);
        isPresent = this.dataTypeList.isPropertyTypePresent("SomeImportedType", imported);
        Assert.assertTrue((String)"Imported type is present", (boolean)isPresent);
        isPresent = this.dataTypeList.isPropertyTypePresent("UnknownType", imported);
        Assert.assertFalse((String)"Type not imported or not built-in is not present", (boolean)isPresent);
    }

    @Test
    public void testInsert() {
        DataType newDataType = (DataType)Mockito.mock(DataType.class);
        ((DataTypeList)Mockito.doNothing().when((Object)this.dataTypeList)).addDataType(newDataType, false);
        this.dataTypeList.insert(newDataType);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).addDataType(newDataType, false);
    }

    @Test
    public void testReplace() {
        DataType newDataType = (DataType)Mockito.mock(DataType.class);
        DataType existing = (DataType)Mockito.mock(DataType.class);
        ((DataTypeList)Mockito.doNothing().when((Object)this.dataTypeList)).insert(newDataType);
        this.dataTypeList.replace(existing, newDataType);
        ((DNDDataTypesHandler)Mockito.verify((Object)this.dndDataTypesHandler)).deleteKeepingReferences(existing);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).insert(newDataType);
    }

    @Test
    public void testCreateNewDataTypeFromProperty() {
        DataObjectProperty dataProperty = (DataObjectProperty)Mockito.mock(DataObjectProperty.class);
        String propertyName = "name";
        String propertyType = "type";
        DataType newType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataProperty.getProperty()).thenReturn((Object)"name");
        Mockito.when((Object)dataProperty.getType()).thenReturn((Object)"type");
        Mockito.when((Object)this.dataTypeManager.fromNew()).thenReturn((Object)this.dataTypeManager);
        Mockito.when((Object)this.dataTypeManager.asList(ArgumentMatchers.anyBoolean())).thenReturn((Object)this.dataTypeManager);
        Mockito.when((Object)this.dataTypeManager.withType("type")).thenReturn((Object)this.dataTypeManager);
        Mockito.when((Object)this.dataTypeManager.get()).thenReturn((Object)newType);
        DataType actual = this.dataTypeList.createNewDataType(dataProperty);
        Assert.assertEquals((Object)newType, (Object)actual);
        ((DataTypeManager)Mockito.verify((Object)this.dataTypeManager)).asList(false);
        ((DataType)Mockito.verify((Object)newType)).setName("name");
    }

    @Test
    public void testCreateNewDataTypeFromPropertyWhenIsList() {
        DataObjectProperty dataProperty = (DataObjectProperty)Mockito.mock(DataObjectProperty.class);
        String propertyName = "name";
        String propertyType = "type";
        DataType newType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataProperty.getProperty()).thenReturn((Object)"name");
        Mockito.when((Object)dataProperty.getType()).thenReturn((Object)"type");
        Mockito.when((Object)dataProperty.isList()).thenReturn((Object)true);
        Mockito.when((Object)this.dataTypeManager.fromNew()).thenReturn((Object)this.dataTypeManager);
        Mockito.when((Object)this.dataTypeManager.asList(ArgumentMatchers.anyBoolean())).thenReturn((Object)this.dataTypeManager);
        Mockito.when((Object)this.dataTypeManager.withType("type")).thenReturn((Object)this.dataTypeManager);
        Mockito.when((Object)this.dataTypeManager.get()).thenReturn((Object)newType);
        DataType actual = this.dataTypeList.createNewDataType(dataProperty);
        Assert.assertEquals((Object)newType, (Object)actual);
        ((DataTypeManager)Mockito.verify((Object)this.dataTypeManager)).asList(true);
        ((DataType)Mockito.verify((Object)newType)).setName("name");
    }

    @Test
    public void testCreateNewDataTypeFromDataObject() {
        DataObject dataObject = (DataObject)Mockito.mock(DataObject.class);
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String structure = "structure";
        String classType = "classType";
        Mockito.when((Object)dataObject.getClassType()).thenReturn((Object)"classType");
        Mockito.when((Object)this.dataTypeManager.structure()).thenReturn((Object)"structure");
        Mockito.when((Object)this.dataTypeManager.fromNew()).thenReturn((Object)this.dataTypeManager);
        Mockito.when((Object)this.dataTypeManager.withType("structure")).thenReturn((Object)this.dataTypeManager);
        Mockito.when((Object)this.dataTypeManager.get()).thenReturn((Object)dataType);
        DataType actual = this.dataTypeList.createNewDataType(dataObject);
        Assert.assertEquals((Object)dataType, (Object)actual);
        ((DataType)Mockito.verify((Object)dataType)).setName("classType");
    }

    @Test
    public void testFindDataTypeByName() {
        String name = "tName";
        Optional<Object> type = Optional.of(Mockito.mock(DataType.class));
        Mockito.when((Object)this.dataTypeManager.getTopLevelDataTypeWithName("tName")).thenReturn(type);
        Optional actual = this.dataTypeList.findDataTypeByName("tName");
        ((DataTypeManager)Mockito.verify((Object)this.dataTypeManager)).getTopLevelDataTypeWithName("tName");
        Assert.assertEquals(type, (Object)actual);
    }

    @Test
    public void testDisableEditModeForChildren() {
        DataTypeListItem dataTypeListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String uuid = "uuid";
        String innerUuid = "inner";
        String deepUuid = "deep";
        DataType notChildDataType = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem notChildItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType childDataType1 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem child1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType childDataType2 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem child2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType innerDataType = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem innerDataTypeListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType deepDataType = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem deepDataTypeListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        Mockito.when((Object)deepDataType.getUUID()).thenReturn((Object)"deep");
        Mockito.when((Object)deepDataType.getParentUUID()).thenReturn((Object)"inner");
        Mockito.when((Object)deepDataTypeListItem.getDataType()).thenReturn((Object)deepDataType);
        Mockito.when((Object)innerDataType.getUUID()).thenReturn((Object)"inner");
        Mockito.when((Object)innerDataType.getParentUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)innerDataTypeListItem.getDataType()).thenReturn((Object)innerDataType);
        Mockito.when((Object)notChildDataType.getParentUUID()).thenReturn((Object)"other_uuid");
        Mockito.when((Object)notChildItem.getDataType()).thenReturn((Object)notChildDataType);
        Mockito.when((Object)child1.getDataType()).thenReturn((Object)childDataType1);
        Mockito.when((Object)childDataType1.getParentUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)child2.getDataType()).thenReturn((Object)childDataType2);
        Mockito.when((Object)childDataType2.getParentUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)dataTypeListItem.getDataType()).thenReturn((Object)dataType);
        List<DataTypeListItem> list = Arrays.asList(child1, notChildItem, child2, innerDataTypeListItem, deepDataTypeListItem);
        ((DataTypeList)Mockito.doReturn(list).when((Object)this.dataTypeList)).getItems();
        this.dataTypeList.disableEditModeForChildren(dataTypeListItem);
        ((DataTypeListItem)Mockito.verify((Object)child1)).disableEditMode();
        ((DataTypeListItem)Mockito.verify((Object)child2)).disableEditMode();
        ((DataTypeListItem)Mockito.verify((Object)innerDataTypeListItem)).disableEditMode();
        ((DataTypeListItem)Mockito.verify((Object)deepDataTypeListItem)).disableEditMode();
        ((DataTypeListItem)Mockito.verify((Object)notChildItem, (VerificationMode)Mockito.never())).disableEditMode();
    }

    @Test
    public void testGetExistingDataTypeNames() {
        String name1 = "name1";
        String name2 = "name2";
        String name3 = "name3";
        DataType dataType1 = this.makeDataType("name1", "whatever", new DataType[0]);
        DataType dataType2 = this.makeDataType("name2", "whatever", new DataType[0]);
        DataType dataType3 = this.makeDataType("name3", "whatever", new DataType[0]);
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> items = Arrays.asList(listItem1, listItem2, listItem3);
        Mockito.when((Object)dataType1.isTopLevel()).thenReturn((Object)true);
        Mockito.when((Object)dataType2.isTopLevel()).thenReturn((Object)false);
        Mockito.when((Object)dataType3.isTopLevel()).thenReturn((Object)true);
        Mockito.when((Object)listItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)listItem2.getDataType()).thenReturn((Object)dataType2);
        Mockito.when((Object)listItem3.getDataType()).thenReturn((Object)dataType3);
        ((DataTypeList)Mockito.doReturn(items).when((Object)this.dataTypeList)).getItems();
        List names = this.dataTypeList.getExistingDataTypesNames();
        Assert.assertEquals((long)2L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("name1"));
        Assert.assertFalse((boolean)names.contains("name2"));
        Assert.assertTrue((boolean)names.contains("name3"));
    }

    @Test
    public void testHighlightLevelWithDataType() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        this.dataTypeList.highlightLevel(dataType);
        ((DataTypeListHighlightHelper)Mockito.verify((Object)this.highlightHelper)).highlightLevel(dataType);
    }

    @Test
    public void testHighlightLevelWithElement() {
        Element element = (Element)Mockito.mock(Element.class);
        this.dataTypeList.highlightLevel(element);
        ((DataTypeListHighlightHelper)Mockito.verify((Object)this.highlightHelper)).highlightLevel(element);
    }

    @Test
    public void testHighlight() {
        Element element = (Element)Mockito.mock(Element.class);
        this.dataTypeList.highlight(element);
        ((DataTypeListHighlightHelper)Mockito.verify((Object)this.highlightHelper)).highlight(element);
    }

    @Test
    public void testCleanLevelHighlightClass() {
        this.dataTypeList.cleanLevelHighlightClass();
        ((DataTypeListHighlightHelper)Mockito.verify((Object)this.highlightHelper)).cleanLevelHighlightClass();
    }

    @Test
    public void testCleanHighlightClass() {
        this.dataTypeList.cleanHighlightClass();
        ((DataTypeListHighlightHelper)Mockito.verify((Object)this.highlightHelper)).cleanHighlightClass();
    }

    private DataTypeListItem listItem(DataType dataType) {
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        Mockito.when((Object)listItem.getDataType()).thenReturn((Object)dataType);
        return listItem;
    }

    private DataType makeDataType(String name, String type, DataType ... subDataTypes) {
        DataType dataType = this.makeDataType("default", name, "");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)type);
        Mockito.when((Object)dataType.getSubDataTypes()).thenReturn(Arrays.asList(subDataTypes));
        return dataType;
    }

    private DataType makeDataType(String uuid, String name, String parentUUID) {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)uuid);
        Mockito.when((Object)dataType.getName()).thenReturn((Object)name);
        Mockito.when((Object)dataType.getParentUUID()).thenReturn((Object)parentUUID);
        this.dataTypeStore.index(dataType.getUUID(), dataType);
        return dataType;
    }
}

