/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeUtils;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeSelect;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeSelectTest {
    private static final String STRUCTURE = "Structure";
    @Mock
    private DataTypeSelect.View view;
    @Mock
    private DataTypeUtils dataTypeUtils;
    @Mock
    private DataTypeManager dataTypeManager;
    @Mock
    private DataTypeListItem listItem;
    private DataTypeSelect dataTypeSelect;

    @Before
    public void setup() {
        this.dataTypeSelect = (DataTypeSelect)Mockito.spy((Object)new DataTypeSelect(this.view, this.dataTypeUtils, this.dataTypeManager));
        Mockito.when((Object)this.dataTypeManager.structure()).thenReturn((Object)STRUCTURE);
    }

    @Test
    public void testInit() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        this.dataTypeSelect.init(this.listItem, dataType);
        Assert.assertEquals((Object)dataType, (Object)this.dataTypeSelect.getDataType());
        ((DataTypeSelect.View)Mockito.verify((Object)this.view)).setDataType(dataType);
    }

    @Test
    public void testSetup() {
        this.dataTypeSelect.setup();
        ((DataTypeSelect.View)Mockito.verify((Object)this.view)).init((Object)this.dataTypeSelect);
    }

    @Test
    public void testGetElement() {
        HTMLElement expected = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expected);
        HTMLElement actual = this.dataTypeSelect.getElement();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testGetDefaultDataTypes() {
        ArrayList<DataType> expectedDataTypes = new ArrayList<DataType>(){
            {
                this.add(Mockito.mock(DataType.class));
            }
        };
        Mockito.when((Object)this.dataTypeUtils.defaultDataTypes()).thenReturn((Object)expectedDataTypes);
        List actualDataTypes = this.dataTypeSelect.getDefaultDataTypes();
        Assertions.assertThat((List)actualDataTypes).hasSameElementsAs((Iterable)expectedDataTypes);
    }

    @Test
    public void testGetCustomDataTypes() {
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        List<DataType> customDataTypes = Arrays.asList(dataType1, dataType2, dataType3);
        Mockito.when((Object)dataType1.getName()).thenReturn((Object)"tUUID");
        Mockito.when((Object)dataType2.getName()).thenReturn((Object)"tPerson");
        Mockito.when((Object)dataType3.getName()).thenReturn((Object)"tCity");
        Mockito.when((Object)this.dataTypeUtils.customDataTypes()).thenReturn(customDataTypes);
        ((DataTypeSelect)Mockito.doReturn((Object)dataType2).when((Object)this.dataTypeSelect)).getDataType();
        List actualDataTypes = this.dataTypeSelect.getCustomDataTypes();
        List<DataType> expectedDataTypes = Arrays.asList(dataType1, dataType3);
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }

    @Test
    public void testEnableEditMode() {
        this.dataTypeSelect.enableEditMode();
        ((DataTypeSelect)Mockito.verify((Object)this.dataTypeSelect)).refresh();
        ((DataTypeSelect.View)Mockito.verify((Object)this.view)).enableEditMode();
    }

    @Test
    public void testDisableEditMode() {
        this.dataTypeSelect.disableEditMode();
        ((DataTypeSelect.View)Mockito.verify((Object)this.view)).disableEditMode();
    }

    @Test
    public void testRefresh() {
        this.dataTypeSelect.refresh();
        ((DataTypeSelect.View)Mockito.verify((Object)this.view)).setupDropdown();
    }

    @Test
    public void testGetValue() {
        String expectedValue = "typeName";
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"typeName");
        String actualValue = this.dataTypeSelect.getValue();
        Assert.assertEquals((Object)"typeName", (Object)actualValue);
    }

    @Test
    public void testClearDataTypesList() {
        DataType parent = (DataType)Mockito.mock(DataType.class);
        ((DataTypeSelect)Mockito.doReturn((Object)parent).when((Object)this.dataTypeSelect)).getDataType();
        Mockito.when((Object)this.dataTypeManager.from(parent)).thenReturn((Object)this.dataTypeManager);
        this.dataTypeSelect.init(this.listItem, parent);
        this.dataTypeSelect.clearDataTypesList();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).cleanSubDataTypes();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).refreshConstraintComponent();
    }

    @Test
    public void testStructure() {
        Assert.assertEquals((Object)STRUCTURE, (Object)this.dataTypeSelect.structure());
    }
}

