/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.common;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.MenuInitializer;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.uberfire.client.views.pfly.selectpicker.JQuery;
import org.uberfire.client.views.pfly.selectpicker.JQueryEvent;

@RunWith(value=LienzoMockitoTestRunner.class)
public class MenuInitializerTest {
    @Mock
    private HTMLDivElement kebabMenu;
    private MenuInitializer initializer;

    @Before
    public void setup() {
        this.initializer = (MenuInitializer)Mockito.spy((Object)new MenuInitializer((Element)this.kebabMenu, ".dropdown"));
    }

    @Test
    public void testInit() {
        JQuery jQuery = (JQuery)PowerMockito.mock(JQuery.class);
        JQuery.CallbackFunction moveDropDownToBody = (JQuery.CallbackFunction)PowerMockito.mock(JQuery.CallbackFunction.class);
        JQuery.CallbackFunction moveDropDownToKebabContainer = (JQuery.CallbackFunction)PowerMockito.mock(JQuery.CallbackFunction.class);
        Element dropdown = (Element)PowerMockito.mock(Element.class);
        ((MenuInitializer)Mockito.doReturn((Object)dropdown).when((Object)this.initializer)).dropdown();
        ((MenuInitializer)Mockito.doReturn((Object)moveDropDownToBody).when((Object)this.initializer)).moveDropDownToBody();
        ((MenuInitializer)Mockito.doReturn((Object)moveDropDownToKebabContainer).when((Object)this.initializer)).moveDropDownToKebabContainer();
        ((MenuInitializer)Mockito.doReturn((Object)jQuery).when((Object)this.initializer)).jQuery(dropdown);
        this.initializer.init();
        ((JQuery)Mockito.verify((Object)jQuery)).on("show.bs.dropdown", moveDropDownToBody);
        ((JQuery)Mockito.verify((Object)jQuery)).on("hidden.bs.dropdown", moveDropDownToKebabContainer);
    }

    @Test
    public void testMoveDropDownToBody() {
        HTMLElement modalInElement = (HTMLElement)PowerMockito.mock(HTMLElement.class);
        HTMLElement target = (HTMLElement)PowerMockito.mock(HTMLElement.class);
        JQuery jQueryModalIn = (JQuery)PowerMockito.mock(JQuery.class);
        JQuery jQueryTarget = (JQuery)PowerMockito.mock(JQuery.class);
        JQuery jQueryCSS = (JQuery)PowerMockito.mock(JQuery.class);
        JQuery jQueryDetach = (JQuery)PowerMockito.mock(JQuery.class);
        JQueryEvent event = (JQueryEvent)PowerMockito.mock(JQueryEvent.class);
        JSONObject jsonObjectProperties = (JSONObject)PowerMockito.mock(JSONObject.class);
        JavaScriptObject javaScriptObjectProperties = (JavaScriptObject)PowerMockito.mock(JavaScriptObject.class);
        event.target = target;
        ((MenuInitializer)Mockito.doReturn((Object)jsonObjectProperties).when((Object)this.initializer)).bodyDropdownProperties(event);
        ((MenuInitializer)Mockito.doReturn((Object)modalInElement).when((Object)this.initializer)).body();
        PowerMockito.when((Object)jsonObjectProperties.getJavaScriptObject()).thenReturn((Object)javaScriptObjectProperties);
        PowerMockito.when((Object)jQueryTarget.css(javaScriptObjectProperties)).thenReturn((Object)jQueryCSS);
        PowerMockito.when((Object)jQueryCSS.detach()).thenReturn((Object)jQueryDetach);
        PowerMockito.when((Object)this.initializer.jQuery((Element)modalInElement)).thenReturn((Object)jQueryModalIn);
        PowerMockito.when((Object)this.initializer.jQuery((Element)target)).thenReturn((Object)jQueryTarget);
        this.initializer.moveDropDownToBody().call(event);
        ((JQuery)Mockito.verify((Object)jQueryModalIn)).append(jQueryDetach);
    }

    @Test
    public void testMoveDropDownToKebabContainer() {
        HTMLElement modalInElement = (HTMLElement)PowerMockito.mock(HTMLElement.class);
        HTMLElement target = (HTMLElement)PowerMockito.mock(HTMLElement.class);
        JQuery jQueryModalIn = (JQuery)PowerMockito.mock(JQuery.class);
        JQuery jQueryTarget = (JQuery)PowerMockito.mock(JQuery.class);
        JQuery jQueryCSS = (JQuery)PowerMockito.mock(JQuery.class);
        JQuery jQueryDetach = (JQuery)PowerMockito.mock(JQuery.class);
        JQueryEvent event = (JQueryEvent)PowerMockito.mock(JQueryEvent.class);
        JSONObject jsonObjectProperties = (JSONObject)PowerMockito.mock(JSONObject.class);
        JavaScriptObject javaScriptObjectProperties = (JavaScriptObject)PowerMockito.mock(JavaScriptObject.class);
        event.target = target;
        ((MenuInitializer)Mockito.doReturn((Object)jsonObjectProperties).when((Object)this.initializer)).emptyProperties();
        ((MenuInitializer)Mockito.doReturn((Object)modalInElement).when((Object)this.initializer)).body();
        PowerMockito.when((Object)jsonObjectProperties.getJavaScriptObject()).thenReturn((Object)javaScriptObjectProperties);
        PowerMockito.when((Object)jQueryTarget.css(javaScriptObjectProperties)).thenReturn((Object)jQueryCSS);
        PowerMockito.when((Object)jQueryCSS.detach()).thenReturn((Object)jQueryDetach);
        PowerMockito.when((Object)this.initializer.jQuery((Element)this.kebabMenu)).thenReturn((Object)jQueryModalIn);
        PowerMockito.when((Object)this.initializer.jQuery((Element)target)).thenReturn((Object)jQueryTarget);
        this.initializer.moveDropDownToKebabContainer().call(event);
        ((JQuery)Mockito.verify((Object)jQueryModalIn)).append(jQueryDetach);
    }

    @Test
    public void testBodyDropdownProperties() {
        JQueryEvent event = (JQueryEvent)PowerMockito.mock(JQueryEvent.class);
        HTMLElement target = (HTMLElement)PowerMockito.mock(HTMLElement.class);
        double left = 1.0;
        double top = 1.0;
        double zIndex = 1051.0;
        JSONObject expectedJSONObject = (JSONObject)PowerMockito.mock(JSONObject.class);
        ((MenuInitializer)Mockito.doReturn((Object)expectedJSONObject).when((Object)this.initializer)).makeJsonObject();
        event.target = target;
        ((MenuInitializer)Mockito.doReturn((Object)1.0).when((Object)this.initializer)).offsetLeft((Element)target);
        ((MenuInitializer)Mockito.doReturn((Object)1.0).when((Object)this.initializer)).offsetTop((Element)target);
        ((MenuInitializer)Mockito.doReturn((Object)1.0).when((Object)this.initializer)).offsetTop((Element)target);
        JSONObject actualJSONObject = this.initializer.bodyDropdownProperties(event);
        ((JSONObject)Mockito.verify((Object)expectedJSONObject)).put("position", (JSONValue)new JSONString("absolute"));
        ((JSONObject)Mockito.verify((Object)expectedJSONObject)).put("left", (JSONValue)new JSONNumber(1.0));
        ((JSONObject)Mockito.verify((Object)expectedJSONObject)).put("top", (JSONValue)new JSONNumber(1.0));
        ((JSONObject)Mockito.verify((Object)expectedJSONObject)).put("z-index", (JSONValue)new JSONNumber(1051.0));
        Assert.assertEquals((Object)expectedJSONObject, (Object)actualJSONObject);
    }

    @Test
    public void testEmptyProperties() {
        JSONObject expectedJSONObject = (JSONObject)PowerMockito.mock(JSONObject.class);
        ((MenuInitializer)Mockito.doReturn((Object)expectedJSONObject).when((Object)this.initializer)).makeJsonObject();
        JSONObject actualJSONObject = this.initializer.emptyProperties();
        ((JSONObject)Mockito.verify((Object)expectedJSONObject)).put("position", (JSONValue)new JSONString(""));
        ((JSONObject)Mockito.verify((Object)expectedJSONObject)).put("left", (JSONValue)new JSONString(""));
        ((JSONObject)Mockito.verify((Object)expectedJSONObject)).put("top", (JSONValue)new JSONString(""));
        ((JSONObject)Mockito.verify((Object)expectedJSONObject)).put("z-index", (JSONValue)new JSONString(""));
        Assert.assertEquals((Object)expectedJSONObject, (Object)actualJSONObject);
    }
}

