/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import java.util.function.BiConsumer;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraint;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraintModal;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeConstraintTest {
    @Mock
    private DataTypeConstraint.View view;
    @Mock
    private ManagedInstance<DataTypeConstraintModal> constraintModalManagedInstance;
    @Mock
    private DataTypeConstraintModal constraintModal;
    private DataTypeConstraint dataTypeConstraint;

    @Before
    public void setup() {
        this.dataTypeConstraint = (DataTypeConstraint)Mockito.spy((Object)new DataTypeConstraint(this.view, this.constraintModalManagedInstance));
        Mockito.when((Object)this.constraintModalManagedInstance.get()).thenReturn((Object)this.constraintModal);
    }

    @Test
    public void testSetup() {
        this.dataTypeConstraint.setup();
        ((DataTypeConstraint.View)Mockito.verify((Object)this.view)).init((Object)this.dataTypeConstraint);
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraint)).disableEditMode();
    }

    @Test
    public void testInit() {
        DataTypeListItem expectedListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType datatype = (DataType)Mockito.mock(DataType.class);
        String expectedConstraint = "constraint";
        ConstraintType expectedType = (ConstraintType)Mockito.mock(ConstraintType.class);
        Mockito.when((Object)expectedListItem.getDataType()).thenReturn((Object)datatype);
        Mockito.when((Object)datatype.getConstraint()).thenReturn((Object)"constraint");
        Mockito.when((Object)datatype.getConstraintType()).thenReturn((Object)expectedType);
        this.dataTypeConstraint.init(expectedListItem);
        DataTypeListItem actualListItem = this.dataTypeConstraint.getListItem();
        String actualConstraint = this.dataTypeConstraint.getValue();
        ConstraintType actualType = this.dataTypeConstraint.getConstraintType();
        Assert.assertEquals((Object)expectedType, (Object)actualType);
        Assert.assertEquals((Object)expectedListItem, (Object)actualListItem);
        Assert.assertEquals((Object)"constraint", (Object)actualConstraint);
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraint)).refreshView();
    }

    @Test
    public void testGetElement() {
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expectedElement);
        HTMLElement actualElement = this.dataTypeConstraint.getElement();
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testEnableEditMode() {
        this.dataTypeConstraint.enableEditMode();
        Assert.assertTrue((boolean)this.dataTypeConstraint.isEditModeEnabled());
        ((DataTypeConstraint.View)Mockito.verify((Object)this.view)).showAnchor();
    }

    @Test
    public void testDisableEditMode() {
        this.dataTypeConstraint.disableEditMode();
        Assert.assertFalse((boolean)this.dataTypeConstraint.isEditModeEnabled());
        ((DataTypeConstraint.View)Mockito.verify((Object)this.view)).hideAnchor();
    }

    @Test
    public void testRefreshViewWhenEditModeIsEnabled() {
        String constraint = "1,2,3";
        ((DataTypeConstraint)Mockito.doReturn((Object)"1,2,3").when((Object)this.dataTypeConstraint)).getValue();
        ((DataTypeConstraint)Mockito.doReturn((Object)true).when((Object)this.dataTypeConstraint)).isEditModeEnabled();
        this.dataTypeConstraint.refreshView();
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraint)).enableEditMode();
    }

    @Test
    public void testRefreshViewWhenEditModeIsNotEnabled() {
        String constraint = "1,2,3";
        ((DataTypeConstraint)Mockito.doReturn((Object)"1,2,3").when((Object)this.dataTypeConstraint)).getValue();
        ((DataTypeConstraint)Mockito.doReturn((Object)false).when((Object)this.dataTypeConstraint)).isEditModeEnabled();
        this.dataTypeConstraint.refreshView();
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraint)).disableEditMode();
    }

    @Test
    public void testOpenModal() {
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        String constraint = "1,2,3";
        String type = "string";
        BiConsumer<String, ConstraintType> onShowConsumer = (s, c) -> {};
        ((DataTypeConstraint)Mockito.doReturn((Object)listItem).when((Object)this.dataTypeConstraint)).getListItem();
        ((DataTypeConstraint)Mockito.doReturn((Object)"1,2,3").when((Object)this.dataTypeConstraint)).getValue();
        ((DataTypeConstraint)Mockito.doReturn(onShowConsumer).when((Object)this.dataTypeConstraint)).getOnShowConsumer();
        Mockito.when((Object)listItem.getType()).thenReturn((Object)"string");
        this.dataTypeConstraint.openModal();
        this.constraintModal.load("string", "1,2,3", ConstraintType.ENUMERATION);
        this.constraintModal.show(onShowConsumer);
    }

    @Test
    public void testGetOnShowConsumer() {
        String expectedConstraint = "1,2,3";
        ConstraintType expectedConstraintType = ConstraintType.ENUMERATION;
        this.dataTypeConstraint.getOnShowConsumer().accept("1,2,3", ConstraintType.ENUMERATION);
        String actualConstraint = this.dataTypeConstraint.getValue();
        ConstraintType actualConstraintType = this.dataTypeConstraint.getConstraintType();
        Assert.assertEquals((Object)"1,2,3", (Object)actualConstraint);
        Assert.assertEquals((Object)expectedConstraintType, (Object)actualConstraintType);
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraint)).refreshView();
    }

    @Test
    public void testDisable() {
        this.dataTypeConstraint.disable();
        String actualConstraint = this.dataTypeConstraint.getValue();
        ConstraintType actualConstraintType = this.dataTypeConstraint.getConstraintType();
        Assert.assertEquals((Object)"", (Object)actualConstraint);
        Assert.assertEquals((Object)ConstraintType.NONE, (Object)actualConstraintType);
        ((DataTypeConstraint.View)Mockito.verify((Object)this.view)).disable();
    }

    @Test
    public void testEnable() {
        this.dataTypeConstraint.enable();
        ((DataTypeConstraint.View)Mockito.verify((Object)this.view)).enable();
    }

    @Test
    public void testGetConstraintModal() {
        Assert.assertNull((Object)this.dataTypeConstraint.getConstraintModal());
        DataTypeConstraintModal firstCallResult = this.dataTypeConstraint.constraintModal();
        DataTypeConstraintModal secondCallResult = this.dataTypeConstraint.constraintModal();
        Assert.assertNotNull((Object)this.dataTypeConstraint.getConstraintModal());
        Assert.assertSame((Object)this.dataTypeConstraint.getConstraintModal(), (Object)firstCallResult);
        Assert.assertSame((Object)this.dataTypeConstraint.getConstraintModal(), (Object)secondCallResult);
    }
}

