/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraint;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraintView;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeConstraintViewTest {
    @Mock
    private HTMLAnchorElement constraintsAnchorContainer;
    @Mock
    private HTMLDivElement constraintsLabelContainer;
    @Mock
    private HTMLElement constraintsAnchorText;
    @Mock
    private HTMLElement constraintsLabelText;
    @Mock
    private HTMLElement constraintsTooltip;
    @Mock
    private TranslationService translationService;
    @Mock
    private DataTypeConstraint presenter;
    private DataTypeConstraintView view;

    @Before
    public void setup() {
        this.view = (DataTypeConstraintView)Mockito.spy((Object)new DataTypeConstraintView(this.constraintsAnchorContainer, this.constraintsLabelContainer, this.constraintsAnchorText, this.constraintsLabelText, this.constraintsTooltip, this.translationService));
        this.view.init(this.presenter);
    }

    @Test
    public void testSetup() {
        String constraintsTooltipText = "ConstraintsTooltip";
        JSONObject properties = (JSONObject)Mockito.mock(JSONObject.class);
        JavaScriptObject propertiesJSONObject = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((DataTypeConstraintView)Mockito.doReturn((Object)properties).when((Object)this.view)).properties();
        Mockito.when((Object)properties.getJavaScriptObject()).thenReturn((Object)propertiesJSONObject);
        Mockito.when((Object)this.translationService.format("DataTypeConstraintView.ConstraintsTooltip", new Object[0])).thenReturn((Object)"ConstraintsTooltip");
        this.view.setup();
        ((HTMLElement)Mockito.verify((Object)this.constraintsTooltip)).setAttribute("title", "ConstraintsTooltip");
        ((DataTypeConstraintView)Mockito.verify((Object)this.view)).setupTooltip(propertiesJSONObject);
    }

    @Test
    public void testOnConstraintsClick() {
        this.view.onConstraintsClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeConstraint)Mockito.verify((Object)this.presenter)).openModal();
    }

    @Test
    public void testShowAnchor() {
        this.constraintsLabelContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.constraintsAnchorContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.constraintsTooltip.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showAnchor();
        ((DOMTokenList)Mockito.verify((Object)this.constraintsLabelContainer.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.constraintsAnchorContainer.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.constraintsTooltip.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testHideAnchorWhenLabelTextIsConstraints() {
        String addConstraints = "Add Constraints";
        Mockito.when((Object)this.translationService.format("DataTypeConstraintView.AddConstraints", new Object[0])).thenReturn((Object)"Add Constraints");
        this.constraintsLabelContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.constraintsAnchorContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.constraintsTooltip.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.constraintsLabelText.textContent = "Add Constraints";
        this.view.hideAnchor();
        ((DOMTokenList)Mockito.verify((Object)this.constraintsLabelContainer.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.constraintsAnchorContainer.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.constraintsTooltip.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testHideAnchorWhenLabelTextIsNotConstraints() {
        String addConstraints = "Add Constraints";
        Mockito.when((Object)this.translationService.format("DataTypeConstraintView.AddConstraints", new Object[0])).thenReturn((Object)"Add Constraints");
        this.constraintsLabelContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.constraintsAnchorContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.constraintsTooltip.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.constraintsLabelText.textContent = "1, 2, 3";
        this.view.hideAnchor();
        ((DOMTokenList)Mockito.verify((Object)this.constraintsLabelContainer.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.constraintsAnchorContainer.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.constraintsTooltip.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testSetTextWhenTextIsNotBlank() {
        String expectedText = "text";
        this.constraintsAnchorText.textContent = "something...";
        this.constraintsLabelText.textContent = "something...";
        this.view.setText("text");
        Assert.assertEquals((Object)"text", (Object)this.constraintsAnchorText.textContent);
        Assert.assertEquals((Object)"text", (Object)this.constraintsLabelText.textContent);
    }

    @Test
    public void testSetTextWhenTextIsBlank() {
        String expectedText = "Add Constraints";
        Mockito.when((Object)this.translationService.format("DataTypeConstraintView.AddConstraints", new Object[0])).thenReturn((Object)"Add Constraints");
        this.constraintsAnchorText.textContent = "something...";
        this.constraintsLabelText.textContent = "something...";
        this.view.setText("");
        Assert.assertEquals((Object)"Add Constraints", (Object)this.constraintsAnchorText.textContent);
        Assert.assertEquals((Object)"Add Constraints", (Object)this.constraintsLabelText.textContent);
    }

    @Test
    public void testProperties() {
        JSONObject jsonObject = (JSONObject)Mockito.mock(JSONObject.class);
        ((DataTypeConstraintView)Mockito.doReturn((Object)jsonObject).when((Object)this.view)).makeJsonObject();
        this.view.properties();
        ((JSONObject)Mockito.verify((Object)jsonObject)).put((String)ArgumentMatchers.eq((Object)"container"), (JSONValue)ArgumentMatchers.eq((Object)new JSONString("body")));
    }

    @Test
    public void testEnable() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeConstraintView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        this.view.enable();
        element.classList.remove(new String[]{"hidden"});
    }

    @Test
    public void testDisable() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeConstraintView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        this.view.disable();
        element.classList.add(new String[]{"hidden"});
    }
}

