/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLInputElement;
import java.util.function.Consumer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.DateSelectorView;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.DateValueFormatter;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DateSelectorViewTest {
    @Mock
    private HTMLInputElement dateInput;
    @Mock
    private DateValueFormatter valueFormatter;
    @Mock
    private JSONObject jsonObject;
    @Mock
    private BlurEvent blurEvent;
    @Mock
    private Object target;
    @Mock
    private Consumer<BlurEvent> consumer;
    private DateSelectorView dateSelectorView;

    @Before
    public void setup() {
        this.dateSelectorView = (DateSelectorView)Mockito.spy((Object)new DateSelectorView(this.dateInput, this.valueFormatter));
    }

    @Test
    public void testOnDateInputBlur() {
        this.dateSelectorView.onValueInputBlur(this.consumer);
        ((DateSelectorView)Mockito.doReturn((Object)this.target).when((Object)this.dateSelectorView)).getEventTarget((BlurEvent)ArgumentMatchers.any());
        this.dateSelectorView.onDateInputBlur(this.blurEvent);
        ((Consumer)Mockito.verify(this.consumer)).accept(this.blurEvent);
    }

    @Test
    public void testOnDateInputBlurTargetNull() {
        this.dateSelectorView.onValueInputBlur(this.consumer);
        ((DateSelectorView)Mockito.doReturn(null).when((Object)this.dateSelectorView)).getEventTarget((BlurEvent)ArgumentMatchers.any());
        this.dateSelectorView.onDateInputBlur(this.blurEvent);
        ((Consumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.never())).accept(this.blurEvent);
    }

    @Test
    public void testProperties() {
        ((DateSelectorView)Mockito.doReturn((Object)this.jsonObject).when((Object)this.dateSelectorView)).makeJsonObject();
        this.dateSelectorView.properties();
        ((DateSelectorView)Mockito.verify((Object)this.dateSelectorView)).makeJsonObject();
        ((JSONObject)Mockito.verify((Object)this.jsonObject)).put("format", (JSONValue)new JSONString("d M yyyy"));
    }
}

