/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.time;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.Node;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.ConstraintPlaceholderHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.DateSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.time.DateTimeSelectorView;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.time.DateTimeValue;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.TimeSelector;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DateTimeSelectorViewTest {
    @Mock
    private HTMLDivElement dateSelectorContainer;
    @Mock
    private HTMLDivElement timeSelectorContainer;
    @Mock
    private DateSelector dateSelector;
    @Mock
    private TimeSelector timeSelector;
    @Mock
    private ConstraintPlaceholderHelper placeholderHelper;
    private DateTimeSelectorView view;

    @Before
    public void setup() {
        this.view = (DateTimeSelectorView)Mockito.spy((Object)new DateTimeSelectorView(this.dateSelectorContainer, this.timeSelectorContainer, this.dateSelector, this.timeSelector, this.placeholderHelper));
    }

    @Test
    public void testInit() {
        Element dateSelectorElement = (Element)Mockito.mock(Element.class);
        Element timeSelectorElement = (Element)Mockito.mock(Element.class);
        String datePlaceHolder = "date placeholder";
        String timePlaceHolder = "time placeholder";
        Mockito.when((Object)this.dateSelector.getElement()).thenReturn((Object)dateSelectorElement);
        Mockito.when((Object)this.timeSelector.getElement()).thenReturn((Object)timeSelectorElement);
        Mockito.when((Object)this.placeholderHelper.getPlaceholderSample(BuiltInType.DATE.toString())).thenReturn((Object)"date placeholder");
        Mockito.when((Object)this.placeholderHelper.getPlaceholderSample(BuiltInType.TIME.toString())).thenReturn((Object)"time placeholder");
        this.view.init();
        ((HTMLDivElement)Mockito.verify((Object)this.dateSelectorContainer)).appendChild((Node)dateSelectorElement);
        ((HTMLDivElement)Mockito.verify((Object)this.timeSelectorContainer)).appendChild((Node)timeSelectorElement);
        ((DateSelector)Mockito.verify((Object)this.dateSelector)).setPlaceholder("date placeholder");
        ((TimeSelector)Mockito.verify((Object)this.timeSelector)).setPlaceholder("time placeholder");
    }

    @Test
    public void testOnBlurCallback() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        Consumer eventConsumer = (Consumer)Mockito.mock(Consumer.class);
        Object target = Mockito.mock(Object.class);
        ((DateTimeSelectorView)Mockito.doReturn((Object)eventConsumer).when((Object)this.view)).getOnValueInputBlur();
        ((DateTimeSelectorView)Mockito.doReturn((Object)target).when((Object)this.view)).getEventTarget(blurEvent);
        Mockito.when((Object)this.dateSelector.isChild(target)).thenReturn((Object)false);
        Mockito.when((Object)this.timeSelector.isChild(target)).thenReturn((Object)false);
        this.view.onBlurCallback(blurEvent);
        ((Consumer)Mockito.verify((Object)eventConsumer)).accept(blurEvent);
    }

    @Test
    public void testOnBlurCallbackWhenTargetIsChildrenOfDate() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        Consumer eventConsumer = (Consumer)Mockito.mock(Consumer.class);
        Object target = Mockito.mock(Object.class);
        ((DateTimeSelectorView)Mockito.doReturn((Object)eventConsumer).when((Object)this.view)).getOnValueInputBlur();
        ((DateTimeSelectorView)Mockito.doReturn((Object)target).when((Object)this.view)).getEventTarget(blurEvent);
        Mockito.when((Object)this.dateSelector.isChild(target)).thenReturn((Object)true);
        Mockito.when((Object)this.timeSelector.isChild(target)).thenReturn((Object)false);
        this.view.onBlurCallback(blurEvent);
        ((Consumer)Mockito.verify((Object)eventConsumer, (VerificationMode)Mockito.never())).accept(blurEvent);
    }

    @Test
    public void testOnBlurCallbackWhenTargetIsChildrenOfTime() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        Consumer eventConsumer = (Consumer)Mockito.mock(Consumer.class);
        Object target = Mockito.mock(Object.class);
        ((DateTimeSelectorView)Mockito.doReturn((Object)eventConsumer).when((Object)this.view)).getOnValueInputBlur();
        ((DateTimeSelectorView)Mockito.doReturn((Object)target).when((Object)this.view)).getEventTarget(blurEvent);
        Mockito.when((Object)this.dateSelector.isChild(target)).thenReturn((Object)false);
        Mockito.when((Object)this.timeSelector.isChild(target)).thenReturn((Object)true);
        this.view.onBlurCallback(blurEvent);
        ((Consumer)Mockito.verify((Object)eventConsumer, (VerificationMode)Mockito.never())).accept(blurEvent);
    }

    @Test
    public void testOnBlurCallbackWhenTargetIsNull() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        Consumer eventConsumer = (Consumer)Mockito.mock(Consumer.class);
        ((DateTimeSelectorView)Mockito.doReturn((Object)eventConsumer).when((Object)this.view)).getOnValueInputBlur();
        ((DateTimeSelectorView)Mockito.doReturn(null).when((Object)this.view)).getEventTarget(blurEvent);
        this.view.onBlurCallback(blurEvent);
        ((Consumer)Mockito.verify((Object)eventConsumer, (VerificationMode)Mockito.never())).accept(ArgumentMatchers.any());
    }

    @Test
    public void testGetValue() {
        String dateValue = "dateValue";
        String timeValue = "timeValue";
        Mockito.when((Object)this.dateSelector.getValue()).thenReturn((Object)"dateValue");
        Mockito.when((Object)this.timeSelector.getValue()).thenReturn((Object)"timeValue");
        DateTimeValue actual = this.view.getValue();
        Assert.assertEquals((Object)"dateValue", (Object)actual.getDate());
        Assert.assertEquals((Object)"timeValue", (Object)actual.getTime());
    }

    @Test
    public void testSetValue() {
        String dateValue = "dateValue";
        String timeValue = "timeValue";
        DateTimeValue dateTimeValue = new DateTimeValue();
        dateTimeValue.setDate("dateValue");
        dateTimeValue.setTime("timeValue");
        this.view.setValue(dateTimeValue);
        ((DateSelector)Mockito.verify((Object)this.dateSelector)).setValue("dateValue");
        ((TimeSelector)Mockito.verify((Object)this.timeSelector)).setValue("timeValue");
    }

    @Test
    public void setSetOnValueChanged() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        this.view.setOnValueChanged(consumer);
        ((DateSelector)Mockito.verify((Object)this.dateSelector)).setOnInputChangeCallback(consumer);
        ((TimeSelector)Mockito.verify((Object)this.timeSelector)).setOnInputChangeCallback(consumer);
    }
}

