/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLElement;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimePickerView;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.views.pfly.widgets.Moment;

@RunWith(value=GwtMockitoTestRunner.class)
public class TimePickerViewTest {
    @Mock
    private HTMLAnchorElement increaseHours;
    @Mock
    private HTMLAnchorElement decreaseHours;
    @Mock
    private HTMLAnchorElement increaseMinutes;
    @Mock
    private HTMLAnchorElement decreaseMinutes;
    @Mock
    private HTMLAnchorElement increaseSeconds;
    @Mock
    private HTMLAnchorElement decreaseSeconds;
    @Mock
    private HTMLElement hours;
    @Mock
    private HTMLElement minutes;
    @Mock
    private HTMLElement seconds;
    @Mock
    private Moment date;
    private TimePickerView view;

    @Before
    public void setup() {
        this.view = (TimePickerView)Mockito.spy((Object)new TimePickerView(this.increaseHours, this.decreaseHours, this.increaseMinutes, this.decreaseMinutes, this.increaseSeconds, this.decreaseSeconds, this.hours, this.minutes, this.seconds));
        ((TimePickerView)Mockito.doReturn((Object)this.date).when((Object)this.view)).getDate();
    }

    @Test
    public void testRefresh() {
        int hours = 14;
        int minutes = 25;
        int seconds = 17;
        Consumer onDateChanged = (Consumer)Mockito.mock(Consumer.class);
        this.view.setOnDateChanged(onDateChanged);
        Mockito.when((Object)this.date.hours()).thenReturn((Object)14);
        Mockito.when((Object)this.date.minutes()).thenReturn((Object)25);
        Mockito.when((Object)this.date.seconds()).thenReturn((Object)17);
        this.view.refresh();
        ((TimePickerView)Mockito.verify((Object)this.view)).setHours(14.0);
        ((TimePickerView)Mockito.verify((Object)this.view)).setMinutes(25.0);
        ((TimePickerView)Mockito.verify((Object)this.view)).setSeconds(17.0);
        ((Consumer)Mockito.verify((Object)onDateChanged)).accept(this.date);
    }

    @Test
    public void testFormatSingleDigit() {
        double input = 4.0;
        this.testFormat(4.0, "04");
    }

    @Test
    public void testFormatTwoDigits() {
        double input = 14.0;
        this.testFormat(14.0, "14");
    }

    @Test
    public void testFormatZero() {
        double input = 0.0;
        this.testFormat(0.0, "00");
    }

    private void testFormat(double input, String expected) {
        String actual = this.view.format(input);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testOnIncreaseHoursClick() {
        Mockito.when((Object)this.date.hours()).thenReturn((Object)1);
        ((TimePickerView)Mockito.doNothing().when((Object)this.view)).refresh();
        this.view.onIncreaseHoursClick(null);
        ((Moment)Mockito.verify((Object)this.date)).hours(2);
    }

    @Test
    public void testOnDecreaseHoursClick() {
        Mockito.when((Object)this.date.hours()).thenReturn((Object)2);
        ((TimePickerView)Mockito.doNothing().when((Object)this.view)).refresh();
        this.view.onDecreaseHoursClick(null);
        ((Moment)Mockito.verify((Object)this.date)).hours(1);
    }

    @Test
    public void testOnIncreaseMinutesClick() {
        Mockito.when((Object)this.date.minutes()).thenReturn((Object)1);
        ((TimePickerView)Mockito.doNothing().when((Object)this.view)).refresh();
        this.view.onIncreaseMinutesClick(null);
        ((Moment)Mockito.verify((Object)this.date)).minutes(2);
    }

    @Test
    public void testOnDecreaseMinutesClick() {
        Mockito.when((Object)this.date.minutes()).thenReturn((Object)2);
        ((TimePickerView)Mockito.doNothing().when((Object)this.view)).refresh();
        this.view.onDecreaseMinutesClick(null);
        ((Moment)Mockito.verify((Object)this.date)).minutes(1);
    }

    @Test
    public void testOnIncreaseSecondsClick() {
        Mockito.when((Object)this.date.seconds()).thenReturn((Object)1);
        ((TimePickerView)Mockito.doNothing().when((Object)this.view)).refresh();
        this.view.onIncreaseSecondsClick(null);
        ((Moment)Mockito.verify((Object)this.date)).seconds(2);
    }

    @Test
    public void testOnDecreaseSecondsClick() {
        Mockito.when((Object)this.date.seconds()).thenReturn((Object)2);
        ((TimePickerView)Mockito.doNothing().when((Object)this.view)).refresh();
        this.view.onDecreaseSecondsClick(null);
        ((Moment)Mockito.verify((Object)this.date)).seconds(1);
    }

    @Test
    public void testUpdateSeconds() {
        Mockito.when((Object)this.date.hours()).thenReturn((Object)23);
        Mockito.when((Object)this.date.minutes()).thenReturn((Object)59);
        Mockito.when((Object)this.date.seconds()).thenReturn((Object)59);
        ((TimePickerView)Mockito.doNothing().when((Object)this.view)).refresh();
        this.view.updateSeconds(0);
        ((Moment)Mockito.verify((Object)this.date)).seconds(0);
        ((Moment)Mockito.verify((Object)this.date)).minutes(59);
        ((Moment)Mockito.verify((Object)this.date)).hours(23);
        ((TimePickerView)Mockito.verify((Object)this.view)).refresh();
    }
}

