/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLElement;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months.YearsMonthsSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months.YearsMonthsValue;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months.YearsMonthsValueConverter;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class YearsMonthsSelectorTest {
    @Mock
    private YearsMonthsSelector.View view;
    @Mock
    private YearsMonthsValueConverter converter;
    @Mock
    private Consumer<Event> onValueChanged;
    @Mock
    private Consumer<BlurEvent> onValueInputBlur;
    private YearsMonthsSelector selector;

    @Before
    public void setup() {
        this.selector = new YearsMonthsSelector(this.view, this.converter);
    }

    @Test
    public void testGetValue() {
        String expected = "duration(\"P2Y1M\")";
        YearsMonthsValue value = (YearsMonthsValue)Mockito.mock(YearsMonthsValue.class);
        Mockito.when((Object)value.getYears()).thenReturn((Object)"2");
        Mockito.when((Object)value.getMonths()).thenReturn((Object)"1");
        Mockito.when((Object)this.converter.toDMNString("2", "1")).thenReturn((Object)"duration(\"P2Y1M\")");
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)value);
        String actual = this.selector.getValue();
        ((YearsMonthsSelector.View)Mockito.verify((Object)this.view)).getValue();
        Assert.assertEquals((Object)"duration(\"P2Y1M\")", (Object)actual);
    }

    @Test
    public void testSetValue() {
        String dmnString = "duration(\"P2Y1M\")";
        YearsMonthsValue value = (YearsMonthsValue)Mockito.mock(YearsMonthsValue.class);
        Mockito.when((Object)value.getYears()).thenReturn((Object)"2");
        Mockito.when((Object)value.getMonths()).thenReturn((Object)"1");
        Mockito.when((Object)this.converter.fromDMNString("duration(\"P2Y1M\")")).thenReturn((Object)value);
        this.selector.setValue("duration(\"P2Y1M\")");
        ((YearsMonthsSelector.View)Mockito.verify((Object)this.view)).setValue(value);
    }

    @Test
    public void testSetPlaceholder() {
        String placeholder = "placeholder";
        this.selector.setPlaceholder("placeholder");
        ((YearsMonthsSelector.View)Mockito.verify((Object)this.view)).setPlaceHolder("placeholder");
    }

    @Test
    public void testGetElement() {
        HTMLElement expected = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expected);
        Element actual = this.selector.getElement();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSetOnInputChangeCallback() {
        this.selector.setOnInputChangeCallback(this.onValueChanged);
        ((YearsMonthsSelector.View)Mockito.verify((Object)this.view)).onValueChanged(this.onValueChanged);
    }

    @Test
    public void testSetOnInputBlurCallback() {
        this.selector.setOnInputBlurCallback(this.onValueInputBlur);
        ((YearsMonthsSelector.View)Mockito.verify((Object)this.view)).onValueInputBlur(this.onValueInputBlur);
    }

    @Test
    public void testSelect() {
        this.selector.select();
        ((YearsMonthsSelector.View)Mockito.verify((Object)this.view)).select();
    }
}

