/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration;

import com.google.gwt.core.client.Scheduler;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.ScrollHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.DataTypeConstraintParserWarningEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.DataTypeConstraintEnumeration;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.item.DataTypeConstraintEnumerationItem;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeConstraintEnumerationTest {
    @Mock
    private DataTypeConstraintEnumeration.View view;
    @Mock
    private DMNClientServicesProxy clientServicesProxy;
    @Mock
    private ScrollHelper scrollHelper;
    @Mock
    private EventSourceMock<DataTypeConstraintParserWarningEvent> parserWarningEvent;
    @Mock
    private ManagedInstance<DataTypeConstraintEnumerationItem> enumerationItemInstances;
    @Captor
    private ArgumentCaptor<Scheduler.ScheduledCommand> scheduledCommandArgumentCaptor;
    private DataTypeConstraintEnumeration constraintEnumeration;

    @Before
    public void setup() {
        this.constraintEnumeration = (DataTypeConstraintEnumeration)Mockito.spy((Object)new DataTypeConstraintEnumeration(this.view, this.clientServicesProxy, this.scrollHelper, this.parserWarningEvent, this.enumerationItemInstances));
        ((DataTypeConstraintEnumeration)Mockito.doNothing().when((Object)this.constraintEnumeration)).scheduleRender((Scheduler.ScheduledCommand)ArgumentMatchers.any(Scheduler.ScheduledCommand.class));
    }

    @Test
    public void testSetup() {
        this.constraintEnumeration.setup();
        ((DataTypeConstraintEnumeration.View)Mockito.verify((Object)this.view)).init((Object)this.constraintEnumeration);
    }

    @Test
    public void testGetValue() {
        DataTypeConstraintEnumerationItem item1 = (DataTypeConstraintEnumerationItem)Mockito.mock(DataTypeConstraintEnumerationItem.class);
        DataTypeConstraintEnumerationItem item2 = (DataTypeConstraintEnumerationItem)Mockito.mock(DataTypeConstraintEnumerationItem.class);
        DataTypeConstraintEnumerationItem item3 = (DataTypeConstraintEnumerationItem)Mockito.mock(DataTypeConstraintEnumerationItem.class);
        Mockito.when((Object)item1.getValue()).thenReturn((Object)"123");
        Mockito.when((Object)item2.getValue()).thenReturn((Object)"456");
        Mockito.when((Object)item3.getValue()).thenReturn((Object)"");
        ((DataTypeConstraintEnumeration)Mockito.doReturn(Arrays.asList(item1, item2)).when((Object)this.constraintEnumeration)).getEnumerationItems();
        String actualValue = this.constraintEnumeration.getValue();
        String expectedValue = "123, 456";
        Assert.assertEquals((Object)"123, 456", (Object)actualValue);
    }

    @Test
    public void testSetValue() {
        String value = "value";
        this.constraintEnumeration.setValue("value");
        ((DMNClientServicesProxy)Mockito.verify((Object)this.clientServicesProxy)).parseFEELList((String)ArgumentMatchers.eq((Object)"value"), (ServiceCallback)ArgumentMatchers.any(ServiceCallback.class));
    }

    @Test
    public void testRefreshView() {
        String value = "1, 2, 3";
        ((DataTypeConstraintEnumeration)Mockito.doNothing().when((Object)this.constraintEnumeration)).setValue((String)Mockito.any());
        ((DataTypeConstraintEnumeration)Mockito.doReturn((Object)"1, 2, 3").when((Object)this.constraintEnumeration)).getValue();
        this.constraintEnumeration.refreshView();
        ((DataTypeConstraintEnumeration)Mockito.verify((Object)this.constraintEnumeration)).setValue("1, 2, 3");
    }

    @Test
    public void testRefreshViewWithOnCompleteCallback() {
        String value = "1, 2, 3";
        Command command = (Command)Mockito.mock(Command.class);
        ((DataTypeConstraintEnumeration)Mockito.doNothing().when((Object)this.constraintEnumeration)).setValue((String)Mockito.any());
        ((DataTypeConstraintEnumeration)Mockito.doReturn((Object)"1, 2, 3").when((Object)this.constraintEnumeration)).getValue();
        this.constraintEnumeration.refreshView(command);
        ((DataTypeConstraintEnumeration)Mockito.verify((Object)this.constraintEnumeration)).registerOnCompleteCallback(command);
        ((DataTypeConstraintEnumeration)Mockito.verify((Object)this.constraintEnumeration)).setValue("1, 2, 3");
    }

    @Test
    public void testExecuteOnCompleteCallback() {
        Command defaultCommand = (Command)Mockito.mock(Command.class);
        Command customCommand = (Command)Mockito.mock(Command.class);
        Mockito.when((Object)this.constraintEnumeration.defaultOnCompleteCallback()).thenReturn((Object)defaultCommand);
        this.constraintEnumeration.registerOnCompleteCallback(customCommand);
        this.constraintEnumeration.executeOnCompleteCallback();
        this.constraintEnumeration.executeOnCompleteCallback();
        this.constraintEnumeration.executeOnCompleteCallback();
        ((Command)Mockito.verify((Object)customCommand)).execute();
        ((Command)Mockito.verify((Object)defaultCommand, (VerificationMode)Mockito.times((int)2))).execute();
    }

    @Test
    public void testScrollToBottom() {
        DataTypeConstraintEnumerationItem item1 = (DataTypeConstraintEnumerationItem)Mockito.mock(DataTypeConstraintEnumerationItem.class);
        DataTypeConstraintEnumerationItem item2 = (DataTypeConstraintEnumerationItem)Mockito.mock(DataTypeConstraintEnumerationItem.class);
        DataTypeConstraintEnumerationItem item3 = (DataTypeConstraintEnumerationItem)Mockito.mock(DataTypeConstraintEnumerationItem.class);
        ((DataTypeConstraintEnumeration)Mockito.doReturn(Arrays.asList(item1, item2, item3)).when((Object)this.constraintEnumeration)).getEnumerationItems();
        ((DataTypeConstraintEnumeration)Mockito.doNothing().when((Object)this.constraintEnumeration)).scrollToPosition(ArgumentMatchers.anyInt());
        Mockito.when((Object)item1.getOrder()).thenReturn((Object)1);
        Mockito.when((Object)item2.getOrder()).thenReturn((Object)2);
        Mockito.when((Object)item3.getOrder()).thenReturn((Object)3);
        this.constraintEnumeration.scrollToBottom();
        ((DataTypeConstraintEnumeration)Mockito.verify((Object)this.constraintEnumeration)).scrollToPosition(3);
    }

    @Test
    public void testScrollToPosition() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement itemElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.constraintEnumeration.getElement()).thenReturn((Object)element);
        Mockito.when((Object)element.querySelector("[data-position=\"2\"")).thenReturn((Object)itemElement);
        this.constraintEnumeration.scrollToPosition(2);
        ((ScrollHelper)Mockito.verify((Object)this.scrollHelper)).scrollTo((Element)itemElement, (Element)element);
    }

    @Test
    public void testGetElement() {
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expectedElement);
        Element actualElement = this.constraintEnumeration.getElement();
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testRender() {
        DataTypeConstraintEnumerationItem item1 = (DataTypeConstraintEnumerationItem)Mockito.mock(DataTypeConstraintEnumerationItem.class);
        DataTypeConstraintEnumerationItem item2 = (DataTypeConstraintEnumerationItem)Mockito.mock(DataTypeConstraintEnumerationItem.class);
        Element element1 = (Element)Mockito.mock(Element.class);
        Element element2 = (Element)Mockito.mock(Element.class);
        InOrder inorder = Mockito.inOrder((Object[])new Object[]{this.view});
        Mockito.when((Object)item1.getOrder()).thenReturn((Object)1);
        Mockito.when((Object)item2.getOrder()).thenReturn((Object)0);
        Mockito.when((Object)item1.getElement()).thenReturn((Object)element1);
        Mockito.when((Object)item2.getElement()).thenReturn((Object)element2);
        ((DataTypeConstraintEnumeration)Mockito.doReturn(Arrays.asList(item1, item2)).when((Object)this.constraintEnumeration)).getEnumerationItems();
        this.constraintEnumeration.render();
        ((DataTypeConstraintEnumeration)Mockito.verify((Object)this.constraintEnumeration)).scheduleRender((Scheduler.ScheduledCommand)this.scheduledCommandArgumentCaptor.capture());
        ((Scheduler.ScheduledCommand)this.scheduledCommandArgumentCaptor.getValue()).execute();
        ((DataTypeConstraintEnumeration.View)Mockito.verify((Object)this.view)).clear();
        ((DataTypeConstraintEnumeration.View)inorder.verify((Object)this.view)).addItem(element2);
        ((DataTypeConstraintEnumeration.View)inorder.verify((Object)this.view)).addItem(element1);
    }

    @Test
    public void testAddEnumerationItem() {
        DataTypeConstraintEnumerationItem item = (DataTypeConstraintEnumerationItem)Mockito.mock(DataTypeConstraintEnumerationItem.class);
        List items = (List)Mockito.spy(new ArrayList());
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeConstraintEnumeration)Mockito.doReturn((Object)items).when((Object)this.constraintEnumeration)).getEnumerationItems();
        ((DataTypeConstraintEnumeration)Mockito.doReturn((Object)item).when((Object)this.constraintEnumeration)).makeEnumerationItem("");
        ((DataTypeConstraintEnumeration)Mockito.doReturn((Object)element).when((Object)this.constraintEnumeration)).getElement();
        ((DataTypeConstraintEnumeration)Mockito.doNothing().when((Object)this.constraintEnumeration)).refreshEnumerationItemsOrder();
        this.constraintEnumeration.addEnumerationItem();
        ((List)Mockito.verify((Object)items)).add(item);
        ((DataTypeConstraintEnumeration)Mockito.verify((Object)this.constraintEnumeration)).refreshEnumerationItemsOrder();
        ((DataTypeConstraintEnumeration)Mockito.verify((Object)this.constraintEnumeration)).render();
        ((DataTypeConstraintEnumeration)Mockito.verify((Object)this.constraintEnumeration)).scrollToBottom();
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)item)).enableEditMode();
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)item)).setOrder(items.size() - 1);
    }

    @Test
    public void testMakeEnumerationItem() {
        String value = "123";
        String constraintValueType = "string";
        DataTypeConstraintEnumerationItem expectedItem = (DataTypeConstraintEnumerationItem)Mockito.mock(DataTypeConstraintEnumerationItem.class);
        Mockito.when((Object)this.enumerationItemInstances.get()).thenReturn((Object)expectedItem);
        ((DataTypeConstraintEnumeration)Mockito.doReturn((Object)"string").when((Object)this.constraintEnumeration)).getConstraintValueType();
        DataTypeConstraintEnumerationItem actualItem = this.constraintEnumeration.makeEnumerationItem("123");
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)expectedItem)).setValue("123");
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)expectedItem)).setConstraintValueType("string");
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)expectedItem)).setDataTypeConstraintEnumeration(this.constraintEnumeration);
        Assert.assertEquals((Object)expectedItem, (Object)actualItem);
    }

    @Test
    public void testGetValueOrdered() {
        DataTypeConstraintEnumerationItem item1 = (DataTypeConstraintEnumerationItem)Mockito.mock(DataTypeConstraintEnumerationItem.class);
        DataTypeConstraintEnumerationItem item2 = (DataTypeConstraintEnumerationItem)Mockito.mock(DataTypeConstraintEnumerationItem.class);
        DataTypeConstraintEnumerationItem item3 = (DataTypeConstraintEnumerationItem)Mockito.mock(DataTypeConstraintEnumerationItem.class);
        Mockito.when((Object)item1.getValue()).thenReturn((Object)"123");
        Mockito.when((Object)item2.getValue()).thenReturn((Object)"456");
        Mockito.when((Object)item3.getValue()).thenReturn((Object)"789");
        Mockito.when((Object)item3.getOrder()).thenReturn((Object)0);
        Mockito.when((Object)item2.getOrder()).thenReturn((Object)1);
        Mockito.when((Object)item1.getOrder()).thenReturn((Object)2);
        this.constraintEnumeration.setEnumerationItems(Arrays.asList(item1, item2, item3));
        String actualValue = this.constraintEnumeration.getValue();
        String expectedValue = "789, 456, 123";
        Assert.assertEquals((Object)"789, 456, 123", (Object)actualValue);
    }
}

