/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import java.util.Optional;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDDataTypesHandler;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDDataTypesHandlerContext;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDDataTypesHandlerShiftStrategy;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DNDDataTypesHandlerTest {
    @Mock
    private DataTypeStore dataTypeStore;
    @Mock
    private DataTypeManager dataTypeManager;
    @Mock
    private ItemDefinitionStore itemDefinitionStore;
    @Mock
    private DataTypeList dataTypeList;
    @Mock
    private DNDListComponent dndListComponent;
    private DNDDataTypesHandler handler;

    @Before
    public void setup() {
        this.handler = (DNDDataTypesHandler)Mockito.spy((Object)new DNDDataTypesHandler(this.dataTypeStore, this.dataTypeManager, this.itemDefinitionStore));
        this.handler.init(this.dataTypeList);
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)this.dndListComponent);
    }

    @Test
    public void testOnDropDataType() {
        Element currentElement = (Element)Mockito.mock(Element.class);
        Element hoverElement = (Element)Mockito.mock(Element.class);
        DataType current = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DNDDataTypesHandlerContext context = (DNDDataTypesHandlerContext)Mockito.mock(DNDDataTypesHandlerContext.class);
        DNDDataTypesHandlerShiftStrategy strategy = DNDDataTypesHandlerShiftStrategy.INSERT_INTO_HOVERED_DATA_TYPE;
        ((DNDDataTypesHandler)Mockito.doNothing().when((Object)this.handler)).logError((String)Mockito.any());
        ((DNDDataTypesHandler)Mockito.doReturn((Object)context).when((Object)this.handler)).makeDndContext(currentElement, hoverElement);
        Mockito.when((Object)context.getCurrentDataType()).thenReturn(Optional.of(current));
        Mockito.when((Object)context.getReference()).thenReturn(Optional.of(reference));
        Mockito.when((Object)context.getStrategy()).thenReturn((Object)strategy);
        this.handler.onDropDataType(currentElement, hoverElement);
        ((DNDDataTypesHandler)Mockito.verify((Object)this.handler)).shiftCurrentByReference(current, reference, strategy);
    }

    @Test
    public void testOnDropDataTypeWhenCurrentIsNotPresent() {
        Element currentElement = (Element)Mockito.mock(Element.class);
        Element hoverElement = (Element)Mockito.mock(Element.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DNDDataTypesHandlerContext context = (DNDDataTypesHandlerContext)Mockito.mock(DNDDataTypesHandlerContext.class);
        ((DNDDataTypesHandler)Mockito.doNothing().when((Object)this.handler)).logError((String)Mockito.any());
        ((DNDDataTypesHandler)Mockito.doReturn((Object)context).when((Object)this.handler)).makeDndContext(currentElement, hoverElement);
        Mockito.when((Object)context.getCurrentDataType()).thenReturn(Optional.empty());
        Mockito.when((Object)context.getReference()).thenReturn(Optional.of(reference));
        this.handler.onDropDataType(currentElement, hoverElement);
        ((DNDDataTypesHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).shiftCurrentByReference((DataType)ArgumentMatchers.any(), (DataType)ArgumentMatchers.any(), (DNDDataTypesHandlerShiftStrategy)ArgumentMatchers.any());
    }

    @Test
    public void testOnDropDataTypeWhenReferenceIsNotPresent() {
        Element currentElement = (Element)Mockito.mock(Element.class);
        Element hoverElement = (Element)Mockito.mock(Element.class);
        DataType current = (DataType)Mockito.mock(DataType.class);
        DNDDataTypesHandlerContext context = (DNDDataTypesHandlerContext)Mockito.mock(DNDDataTypesHandlerContext.class);
        ((DNDDataTypesHandler)Mockito.doNothing().when((Object)this.handler)).logError((String)Mockito.any());
        ((DNDDataTypesHandler)Mockito.doReturn((Object)context).when((Object)this.handler)).makeDndContext(currentElement, hoverElement);
        Mockito.when((Object)context.getCurrentDataType()).thenReturn(Optional.of(current));
        Mockito.when((Object)context.getReference()).thenReturn(Optional.empty());
        this.handler.onDropDataType(currentElement, hoverElement);
        ((DNDDataTypesHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).shiftCurrentByReference((DataType)ArgumentMatchers.any(), (DataType)ArgumentMatchers.any(), (DNDDataTypesHandlerShiftStrategy)ArgumentMatchers.any());
    }

    @Test
    public void testOnDropDataTypeWhenAnErrorIsRaised() {
        Element currentElement = (Element)Mockito.mock(Element.class);
        Element hoverElement = (Element)Mockito.mock(Element.class);
        ((DNDDataTypesHandler)Mockito.doNothing().when((Object)this.handler)).logError((String)Mockito.any());
        ((DNDDataTypesHandler)Mockito.doThrow((Throwable[])new Throwable[]{new UnsupportedOperationException("Error")}).when((Object)this.handler)).makeDndContext((Element)ArgumentMatchers.any(), (Element)ArgumentMatchers.any());
        this.handler.onDropDataType(currentElement, hoverElement);
        ((DNDDataTypesHandler)Mockito.verify((Object)this.handler)).logError("Drag-n-Drop error (Error). Check 'DNDDataTypesHandler'.");
    }

    @Test
    public void testShiftCurrentByReferenceWhenCurrentIsCollapsedAndItIsTopLevelShiftOperation() {
        DataType current = (DataType)Mockito.mock(DataType.class);
        DataType clone = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataType cloneParent1 = (DataType)Mockito.mock(DataType.class);
        DataType cloneParent2 = (DataType)Mockito.mock(DataType.class);
        DNDDataTypesHandlerShiftStrategy strategy = DNDDataTypesHandlerShiftStrategy.INSERT_INTO_HOVERED_DATA_TYPE;
        String referenceHash = "referenceHash";
        String cloneHash = "cloneHash";
        DataTypeListItem oldItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem referenceItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem cloneItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement cloneHTMLElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        String cloneParent1UUID = "cloneParent1UUID";
        String cloneParent2UUID = "cloneParent2UUID";
        DataTypeListItem cloneParent1Item = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem cloneParent2Item = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DNDDataTypesHandler)Mockito.doReturn((Object)clone).when((Object)this.handler)).cloneDataType(current);
        ((DNDDataTypesHandler)Mockito.doReturn((Object)true).when((Object)this.handler)).isTopLevelShiftOperation(current, strategy);
        Mockito.when((Object)this.dataTypeList.calculateHash(reference)).thenReturn((Object)"referenceHash");
        Mockito.when((Object)this.dataTypeList.calculateHash(clone)).thenReturn((Object)"cloneHash");
        Mockito.when((Object)this.dataTypeList.findItem(current)).thenReturn(Optional.of(oldItem));
        Mockito.when((Object)this.dataTypeList.findItemByDataTypeHash("referenceHash")).thenReturn(Optional.of(referenceItem));
        Mockito.when((Object)this.dataTypeList.findItemByDataTypeHash("cloneHash")).thenReturn(Optional.of(cloneItem));
        Mockito.when((Object)cloneItem.getDragAndDropElement()).thenReturn((Object)cloneHTMLElement);
        Mockito.when((Object)oldItem.isCollapsed()).thenReturn((Object)true);
        Mockito.when((Object)cloneItem.getDataType()).thenReturn((Object)clone);
        Mockito.when((Object)clone.getParentUUID()).thenReturn((Object)"cloneParent1UUID");
        Mockito.when((Object)cloneParent1.getParentUUID()).thenReturn((Object)"cloneParent2UUID");
        Mockito.when((Object)cloneParent1.getUUID()).thenReturn((Object)"cloneParent1UUID");
        Mockito.when((Object)cloneParent2.getUUID()).thenReturn((Object)"cloneParent2UUID");
        Mockito.when((Object)this.dataTypeStore.get("cloneParent1UUID")).thenReturn((Object)cloneParent1);
        Mockito.when((Object)this.dataTypeStore.get("cloneParent2UUID")).thenReturn((Object)cloneParent2);
        Mockito.when((Object)this.dataTypeList.findItem(cloneParent1)).thenReturn(Optional.of(cloneParent1Item));
        Mockito.when((Object)this.dataTypeList.findItem(cloneParent2)).thenReturn(Optional.of(cloneParent2Item));
        this.handler.shiftCurrentByReference(current, reference, strategy);
        ((DataTypeListItem)Mockito.verify((Object)cloneItem)).collapse();
        ((DataTypeListItem)Mockito.verify((Object)oldItem)).destroyWithoutDependentTypes();
        ((DataTypeListItem)Mockito.verify((Object)referenceItem)).insertNestedField(clone);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).highlightLevel((Element)cloneHTMLElement);
        ((DataTypeListItem)Mockito.verify((Object)cloneParent1Item)).expand();
        ((DataTypeListItem)Mockito.verify((Object)cloneParent2Item)).expand();
    }

    @Test
    public void testShiftCurrentByReferenceWhenCurrentIsNotCollapsedAndItIsNotTopLevelShiftOperation() {
        DataType current = (DataType)Mockito.mock(DataType.class);
        DataType clone = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataType cloneParent1 = (DataType)Mockito.mock(DataType.class);
        DataType cloneParent2 = (DataType)Mockito.mock(DataType.class);
        DNDDataTypesHandlerShiftStrategy strategy = DNDDataTypesHandlerShiftStrategy.INSERT_INTO_HOVERED_DATA_TYPE;
        String referenceHash = "referenceHash";
        String cloneHash = "cloneHash";
        DataTypeListItem oldItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem referenceItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem cloneItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement cloneHTMLElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        String cloneParent1UUID = "cloneParent1UUID";
        String cloneParent2UUID = "cloneParent2UUID";
        DataTypeListItem cloneParent1Item = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem cloneParent2Item = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        ((DNDDataTypesHandler)Mockito.doReturn((Object)clone).when((Object)this.handler)).cloneDataType(current);
        ((DNDDataTypesHandler)Mockito.doReturn((Object)false).when((Object)this.handler)).isTopLevelShiftOperation(current, strategy);
        Mockito.when((Object)this.dataTypeList.calculateHash(reference)).thenReturn((Object)"referenceHash");
        Mockito.when((Object)this.dataTypeList.calculateHash(clone)).thenReturn((Object)"cloneHash");
        Mockito.when((Object)this.dataTypeList.findItem(current)).thenReturn(Optional.of(oldItem));
        Mockito.when((Object)this.dataTypeList.findItemByDataTypeHash("referenceHash")).thenReturn(Optional.of(referenceItem));
        Mockito.when((Object)this.dataTypeList.findItemByDataTypeHash("cloneHash")).thenReturn(Optional.of(cloneItem));
        Mockito.when((Object)cloneItem.getDragAndDropElement()).thenReturn((Object)cloneHTMLElement);
        Mockito.when((Object)oldItem.isCollapsed()).thenReturn((Object)false);
        Mockito.when((Object)cloneItem.getDataType()).thenReturn((Object)clone);
        Mockito.when((Object)clone.getParentUUID()).thenReturn((Object)"cloneParent1UUID");
        Mockito.when((Object)cloneParent1.getParentUUID()).thenReturn((Object)"cloneParent2UUID");
        Mockito.when((Object)cloneParent1.getUUID()).thenReturn((Object)"cloneParent1UUID");
        Mockito.when((Object)cloneParent2.getUUID()).thenReturn((Object)"cloneParent2UUID");
        Mockito.when((Object)this.dataTypeStore.get("cloneParent1UUID")).thenReturn((Object)cloneParent1);
        Mockito.when((Object)this.dataTypeStore.get("cloneParent2UUID")).thenReturn((Object)cloneParent2);
        Mockito.when((Object)this.dataTypeList.findItem(cloneParent1)).thenReturn(Optional.of(cloneParent1Item));
        Mockito.when((Object)this.dataTypeList.findItem(cloneParent2)).thenReturn(Optional.of(cloneParent2Item));
        this.handler.shiftCurrentByReference(current, reference, strategy);
        ((DataTypeListItem)Mockito.verify((Object)cloneItem)).expand();
        ((DataTypeListItem)Mockito.verify((Object)oldItem)).destroyWithDependentTypes();
        ((DataTypeListItem)Mockito.verify((Object)referenceItem)).insertNestedField(clone);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).highlightLevel((Element)cloneHTMLElement);
        ((DataTypeListItem)Mockito.verify((Object)cloneParent1Item)).expand();
        ((DataTypeListItem)Mockito.verify((Object)cloneParent2Item)).expand();
    }

    @Test
    public void testIsTopLevelShiftOperationWhenDataTypeIsNotTopLevel() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DNDDataTypesHandlerShiftStrategy shiftStrategy = DNDDataTypesHandlerShiftStrategy.INSERT_TOP_LEVEL_DATA_TYPE_AT_THE_TOP;
        Mockito.when((Object)dataType.isTopLevel()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.handler.isTopLevelShiftOperation(dataType, shiftStrategy));
    }

    @Test
    public void testIsTopLevelShiftOperationWhenDataTypeIsTopLevelAndShiftStrategyIsNotTopLevel() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataType.isTopLevel()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.handler.isTopLevelShiftOperation(dataType, DNDDataTypesHandlerShiftStrategy.INSERT_NESTED_DATA_TYPE));
        Assert.assertFalse((boolean)this.handler.isTopLevelShiftOperation(dataType, DNDDataTypesHandlerShiftStrategy.INSERT_SIBLING_DATA_TYPE));
        Assert.assertFalse((boolean)this.handler.isTopLevelShiftOperation(dataType, DNDDataTypesHandlerShiftStrategy.INSERT_INTO_HOVERED_DATA_TYPE));
    }

    @Test
    public void testIsTopLevelShiftOperationWhenDataTypeIsTopLevelAndShiftStrategyIsTopLevel() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataType.isTopLevel()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.handler.isTopLevelShiftOperation(dataType, DNDDataTypesHandlerShiftStrategy.INSERT_TOP_LEVEL_DATA_TYPE_AT_THE_TOP));
        Assert.assertTrue((boolean)this.handler.isTopLevelShiftOperation(dataType, DNDDataTypesHandlerShiftStrategy.INSERT_TOP_LEVEL_DATA_TYPE));
    }

    @Test
    public void testGetReferenceWhenDataTypeListIsNotInitialized() {
        Element currentElement = (Element)Mockito.mock(Element.class);
        Element hoverElement = (Element)Mockito.mock(Element.class);
        Element previousElement = (Element)Mockito.mock(Element.class);
        Optional<Object> previousDataType = Optional.of(Mockito.mock(DataType.class));
        String uuid = "0000-1111-2222-3333";
        Mockito.when((Object)this.dndListComponent.getPreviousElement((Element)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn(Optional.of(previousElement));
        Mockito.when((Object)this.dataTypeStore.get("0000-1111-2222-3333")).thenReturn(previousDataType.get());
        Mockito.when((Object)previousElement.getAttribute("data-row-uuid")).thenReturn((Object)"0000-1111-2222-3333");
        this.handler.init(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.handler.makeDndContext(currentElement, hoverElement).getReference()).isInstanceOf(UnsupportedOperationException.class)).hasMessage("'DNDDataTypesHandler' must be initialized with a 'DataTypeList' instance.");
    }

    @Test
    public void testGetReferenceWhenDNDListComponentIsNotInitialized() {
        Element currentElement = (Element)Mockito.mock(Element.class);
        Element hoverElement = (Element)Mockito.mock(Element.class);
        Element previousElement = (Element)Mockito.mock(Element.class);
        Optional<Object> previousDataType = Optional.of(Mockito.mock(DataType.class));
        String uuid = "0000-1111-2222-3333";
        Mockito.when((Object)this.dndListComponent.getPreviousElement((Element)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn(Optional.of(previousElement));
        Mockito.when((Object)this.dataTypeStore.get("0000-1111-2222-3333")).thenReturn(previousDataType.get());
        Mockito.when((Object)previousElement.getAttribute("data-row-uuid")).thenReturn((Object)"0000-1111-2222-3333");
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.handler.makeDndContext(currentElement, hoverElement).getReference()).isInstanceOf(UnsupportedOperationException.class)).hasMessage("'DNDDataTypesHandler' must be initialized with a 'DNDListComponent' instance.");
    }

    @Test
    public void testDeleteKeepingReferences() {
        DataType existing = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem dtListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        Optional<DataTypeListItem> item = Optional.of(dtListItem);
        Mockito.when((Object)this.dataTypeList.findItem(existing)).thenReturn(item);
        this.handler.deleteKeepingReferences(existing);
        ((DataTypeListItem)Mockito.verify((Object)dtListItem)).destroyWithoutDependentTypes();
    }

    @Test
    public void testDeleteKeepingReferencesItemNotPresent() {
        DataType existing = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem dtListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        Optional item = Optional.empty();
        Mockito.when((Object)this.dataTypeList.findItem(existing)).thenReturn(item);
        this.handler.deleteKeepingReferences(existing);
        ((DataTypeListItem)Mockito.verify((Object)dtListItem, (VerificationMode)Mockito.never())).destroyWithoutDependentTypes();
    }
}

