/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.tooltip;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.CSSStyleDeclaration;
import elemental2.dom.DOMRect;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Event;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLBodyElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLHeadingElement;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.HTMLParagraphElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeKind;
import org.kie.workbench.common.dmn.client.editors.types.listview.tooltip.StructureTypesTooltip;
import org.kie.workbench.common.dmn.client.editors.types.listview.tooltip.StructureTypesTooltipView;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class StructureTypesTooltipViewTest {
    @Mock
    private HTMLDivElement tooltip;
    @Mock
    private HTMLButtonElement close;
    @Mock
    private HTMLHeadingElement dataTypeName;
    @Mock
    private HTMLParagraphElement description;
    @Mock
    private HTMLUListElement dataTypeFields;
    @Mock
    private HTMLLIElement htmlLiElement;
    @Mock
    private HTMLElement htmlSpanElement;
    @Mock
    private HTMLAnchorElement viewDataTypeLink;
    @Mock
    private TranslationService translationService;
    @Mock
    private HTMLBodyElement bodyElement;
    @Mock
    private HTMLElement element;
    @Mock
    private StructureTypesTooltip presenter;
    private StructureTypesTooltipView view;

    @Before
    public void setup() {
        this.view = (StructureTypesTooltipView)Mockito.spy((Object)new StructureTypesTooltipView(this.tooltip, this.close, this.dataTypeName, this.description, this.dataTypeFields, this.htmlLiElement, this.htmlSpanElement, this.viewDataTypeLink, this.translationService));
        this.view.init(this.presenter);
        this.tooltip.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        this.tooltip.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((StructureTypesTooltipView)Mockito.doReturn((Object)this.bodyElement).when((Object)this.view)).getBody();
        ((StructureTypesTooltipView)Mockito.doReturn((Object)this.element).when((Object)this.view)).getElement();
    }

    @Test
    public void testSetup() {
        String expectedDisplay = "none";
        this.tooltip.style.display = "";
        this.view.setup();
        String actualDisplay = this.tooltip.style.display;
        ((HTMLBodyElement)Mockito.verify((Object)this.bodyElement)).appendChild((Node)this.element);
        Assert.assertEquals((Object)"none", (Object)actualDisplay);
    }

    @Test
    public void testOnClose() {
        ((StructureTypesTooltipView)Mockito.doNothing().when((Object)this.view)).hide();
        this.view.onClose((ClickEvent)Mockito.mock(ClickEvent.class));
        ((StructureTypesTooltipView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testOnViewDataTypeLink() {
        ClickEvent clickEvent = (ClickEvent)Mockito.mock(ClickEvent.class);
        ((StructureTypesTooltipView)Mockito.doNothing().when((Object)this.view)).hide();
        this.view.onViewDataTypeLink(clickEvent);
        ((StructureTypesTooltip)Mockito.verify((Object)this.presenter)).goToDataType();
        ((StructureTypesTooltipView)Mockito.verify((Object)this.view)).hide();
        ((ClickEvent)Mockito.verify((Object)clickEvent)).stopPropagation();
        ((ClickEvent)Mockito.verify((Object)clickEvent)).preventDefault();
    }

    @Test
    public void testShow() {
        HTMLElement refElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((StructureTypesTooltipView)Mockito.doNothing().when((Object)this.view)).updateTooltipPosition(refElement);
        ((StructureTypesTooltipView)Mockito.doNothing().when((Object)this.view)).updateTooltipAsVisible();
        ((StructureTypesTooltipView)Mockito.doNothing().when((Object)this.view)).updateContent();
        ((StructureTypesTooltipView)Mockito.doNothing().when((Object)this.view)).updateTooltipClass();
        ((StructureTypesTooltipView)Mockito.doNothing().when((Object)this.view)).setupListeners();
        this.view.show(refElement);
        ((StructureTypesTooltipView)Mockito.verify((Object)this.view)).updateTooltipPosition(refElement);
        ((StructureTypesTooltipView)Mockito.verify((Object)this.view)).updateTooltipAsVisible();
        ((StructureTypesTooltipView)Mockito.verify((Object)this.view)).updateContent();
        ((StructureTypesTooltipView)Mockito.verify((Object)this.view)).updateTooltipClass();
        ((StructureTypesTooltipView)Mockito.verify((Object)this.view)).setupListeners();
    }

    @Test
    public void testHide() {
        ((StructureTypesTooltipView)Mockito.doNothing().when((Object)this.view)).updateTooltipAsHidden();
        ((StructureTypesTooltipView)Mockito.doNothing().when((Object)this.view)).teardownListeners();
        this.view.hide();
        ((StructureTypesTooltipView)Mockito.verify((Object)this.view)).updateTooltipAsHidden();
        ((StructureTypesTooltipView)Mockito.verify((Object)this.view)).teardownListeners();
    }

    @Test
    public void testUpdateContentWhenDataTypeHasZeroFields() {
        ArrayList dataTypes = new ArrayList();
        Node dataTypeFieldsFirstChild = (Node)Mockito.mock(Node.class);
        String typeName = "tPerson";
        String message = "tPerson is a custom, structured data type without fields";
        ((StructureTypesTooltipView)Mockito.doReturn(Optional.of("tPerson is a custom, structured data type without fields")).when((Object)this.view)).getDescriptionText();
        Mockito.when((Object)this.presenter.getTypeName()).thenReturn((Object)"tPerson");
        Mockito.when((Object)this.presenter.getTypeFields()).thenReturn(dataTypes);
        this.dataTypeFields.firstChild = dataTypeFieldsFirstChild;
        ((HTMLUListElement)Mockito.doAnswer(e -> {
            this.dataTypeFields.firstChild = null;
            return null;
        }).when((Object)this.dataTypeFields)).removeChild(dataTypeFieldsFirstChild);
        this.view.updateContent();
        Assert.assertEquals((Object)"tPerson is a custom, structured data type without fields", (Object)this.description.textContent);
        Assert.assertEquals((Object)"tPerson", (Object)this.dataTypeName.textContent);
        ((HTMLUListElement)Mockito.verify((Object)this.dataTypeFields)).removeChild(dataTypeFieldsFirstChild);
        ((HTMLUListElement)Mockito.verify((Object)this.dataTypeFields, (VerificationMode)Mockito.never())).appendChild((Node)ArgumentMatchers.any());
    }

    @Test
    public void testGetDescriptionTextWhenKindIsCustom() {
        String typeName = "tPerson";
        String expectedDescription = "message";
        Mockito.when((Object)this.presenter.getTypeName()).thenReturn((Object)"tPerson");
        Mockito.when((Object)this.presenter.getDataTypeKind()).thenReturn((Object)DataTypeKind.CUSTOM);
        Mockito.when((Object)this.translationService.format("StructureTypesTooltipView.DescriptionCustom", new Object[]{"tPerson"})).thenReturn((Object)"message");
        Optional actualDescription = this.view.getDescriptionText();
        Assert.assertTrue((boolean)actualDescription.isPresent());
        Assert.assertEquals((Object)"message", actualDescription.get());
    }

    @Test
    public void testGetDescriptionTextWhenKindIsStructure() {
        String typeName = "tPerson";
        String expectedDescription = "message";
        List<DataType> typeFields = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        Mockito.when((Object)this.presenter.getTypeName()).thenReturn((Object)"tPerson");
        Mockito.when((Object)this.presenter.getDataTypeKind()).thenReturn((Object)DataTypeKind.STRUCTURE);
        Mockito.when((Object)this.presenter.getTypeFields()).thenReturn(typeFields);
        Mockito.when((Object)this.translationService.format("StructureTypesTooltipView.DescriptionStructured", new Object[]{"tPerson", typeFields.size()})).thenReturn((Object)"message");
        Optional actualDescription = this.view.getDescriptionText();
        Assert.assertTrue((boolean)actualDescription.isPresent());
        Assert.assertEquals((Object)"message", actualDescription.get());
    }

    @Test
    public void testGetDescriptionTextWhenKindIsIncluded() {
        String typeName = "tPerson";
        String expectedDescription = "message";
        Mockito.when((Object)this.presenter.getTypeName()).thenReturn((Object)"tPerson");
        Mockito.when((Object)this.presenter.getDataTypeKind()).thenReturn((Object)DataTypeKind.INCLUDED);
        Mockito.when((Object)this.translationService.format("StructureTypesTooltipView.DescriptionIncluded", new Object[]{"tPerson"})).thenReturn((Object)"message");
        Optional actualDescription = this.view.getDescriptionText();
        Assert.assertTrue((boolean)actualDescription.isPresent());
        Assert.assertEquals((Object)"message", actualDescription.get());
    }

    @Test
    public void testGetDescriptionTextWhenKindIsAnother() {
        String typeName = "tPerson";
        Mockito.when((Object)this.presenter.getTypeName()).thenReturn((Object)"tPerson");
        Mockito.when((Object)this.presenter.getDataTypeKind()).thenReturn((Object)DataTypeKind.BUILT_IN);
        Optional actualDescription = this.view.getDescriptionText();
        Assert.assertFalse((boolean)actualDescription.isPresent());
    }

    @Test
    public void testSetupListeners() {
        HTMLElement listItems = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.presenter.getListItems()).thenReturn((Object)listItems);
        this.view.setupListeners();
        ((HTMLElement)Mockito.verify((Object)listItems)).addEventListener("scroll", this.view.SCROLL_LISTENER);
        ((HTMLBodyElement)Mockito.verify((Object)this.bodyElement)).addEventListener("click", this.view.CLICK_LISTENER);
    }

    @Test
    public void testTeardownListeners() {
        HTMLElement listItems = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.presenter.getListItems()).thenReturn((Object)listItems);
        this.view.teardownListeners();
        ((HTMLElement)Mockito.verify((Object)listItems)).removeEventListener("scroll", this.view.SCROLL_LISTENER);
        ((HTMLBodyElement)Mockito.verify((Object)this.bodyElement)).removeEventListener("click", this.view.CLICK_LISTENER);
    }

    @Test
    public void testIsOutsideWhenItsOutside() {
        Event event = (Event)Mockito.mock(Event.class);
        HTMLElement target = (HTMLElement)Mockito.mock(HTMLElement.class);
        event.target = target;
        Mockito.when((Object)this.element.contains((Node)target)).thenReturn((Object)false);
        ((StructureTypesTooltipView)Mockito.doReturn((Object)true).when((Object)this.view)).isTooltipVisible();
        Assert.assertTrue((boolean)this.view.isOutside(event));
    }

    @Test
    public void testIsOutsideWhenItsNotOutside() {
        Event event = (Event)Mockito.mock(Event.class);
        HTMLElement target = (HTMLElement)Mockito.mock(HTMLElement.class);
        event.target = target;
        Mockito.when((Object)this.element.contains((Node)target)).thenReturn((Object)true);
        ((StructureTypesTooltipView)Mockito.doReturn((Object)true).when((Object)this.view)).isTooltipVisible();
        Assert.assertFalse((boolean)this.view.isOutside(event));
    }

    @Test
    public void testIsOutsideWhenItsOutsideButTooltipIsNotVisible() {
        Event event = (Event)Mockito.mock(Event.class);
        HTMLElement target = (HTMLElement)Mockito.mock(HTMLElement.class);
        event.target = target;
        Mockito.when((Object)this.element.contains((Node)target)).thenReturn((Object)false);
        ((StructureTypesTooltipView)Mockito.doReturn((Object)false).when((Object)this.view)).isTooltipVisible();
        Assert.assertFalse((boolean)this.view.isOutside(event));
    }

    @Test
    public void testIsTooltipVisibleWhenItReturnsTrue() {
        this.tooltip.style.display = "none";
        Assert.assertFalse((boolean)this.view.isTooltipVisible());
    }

    @Test
    public void testIsTooltipVisibleWhenItReturnsFalse() {
        this.tooltip.style.display = "block";
        Assert.assertTrue((boolean)this.view.isTooltipVisible());
    }

    @Test
    public void testUpdateTooltipPosition() {
        HTMLElement refElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        DOMRect domRect = (DOMRect)Mockito.mock(DOMRect.class);
        domRect.x = 2.0;
        domRect.y = 4.0;
        domRect.width = 8.0;
        Mockito.when((Object)refElement.getBoundingClientRect()).thenReturn((Object)domRect);
        this.view.updateTooltipPosition(refElement);
        Assert.assertEquals((Object)"4.0px", (Object)this.tooltip.style.top);
        Assert.assertEquals((Object)"30.0px", (Object)this.tooltip.style.left);
    }

    @Test
    public void testUpdateTooltipClassWhenItsOverflowing() {
        HTMLElement listItems = (HTMLElement)Mockito.mock(HTMLElement.class);
        DOMRect dataTypesListRect = (DOMRect)Mockito.mock(DOMRect.class);
        DOMRect tooltipRect = (DOMRect)Mockito.mock(DOMRect.class);
        Mockito.when((Object)this.presenter.getListItems()).thenReturn((Object)listItems);
        Mockito.when((Object)listItems.getBoundingClientRect()).thenReturn((Object)dataTypesListRect);
        Mockito.when((Object)this.tooltip.getBoundingClientRect()).thenReturn((Object)tooltipRect);
        tooltipRect.y = 150.0;
        tooltipRect.height = 100.0;
        dataTypesListRect.y = 100.0;
        dataTypesListRect.height = 100.0;
        this.view.updateTooltipClass();
        ((DOMTokenList)Mockito.verify((Object)this.tooltip.classList)).toggle("overflow", true);
    }

    @Test
    public void testUpdateTooltipClassWhenItsNotOverflowing() {
        HTMLElement listItems = (HTMLElement)Mockito.mock(HTMLElement.class);
        DOMRect dataTypesListRect = (DOMRect)Mockito.mock(DOMRect.class);
        DOMRect tooltipRect = (DOMRect)Mockito.mock(DOMRect.class);
        Mockito.when((Object)this.presenter.getListItems()).thenReturn((Object)listItems);
        Mockito.when((Object)listItems.getBoundingClientRect()).thenReturn((Object)dataTypesListRect);
        Mockito.when((Object)this.tooltip.getBoundingClientRect()).thenReturn((Object)tooltipRect);
        tooltipRect.y = 50.0;
        tooltipRect.height = 100.0;
        dataTypesListRect.y = 100.0;
        dataTypesListRect.height = 100.0;
        this.view.updateTooltipClass();
        ((DOMTokenList)Mockito.verify((Object)this.tooltip.classList)).toggle("overflow", false);
    }

    @Test
    public void testMakeFieldElement() {
        DataType field = (DataType)Mockito.mock(DataType.class);
        String typeName = "tPerson";
        HTMLLIElement expectedHtmlLiElement = (HTMLLIElement)Mockito.mock(HTMLLIElement.class);
        HTMLLIElement htmlTypeElement = (HTMLLIElement)Mockito.mock(HTMLLIElement.class);
        ((StructureTypesTooltipView)Mockito.doReturn((Object)expectedHtmlLiElement).when((Object)this.view)).makeHTMLLIElement();
        ((StructureTypesTooltipView)Mockito.doReturn((Object)htmlTypeElement).when((Object)this.view)).makeTypeElement(field);
        Mockito.when((Object)field.getName()).thenReturn((Object)"tPerson");
        HTMLLIElement actualHtmlLiElement = this.view.makeFieldElement(field);
        Assert.assertSame((Object)expectedHtmlLiElement, (Object)actualHtmlLiElement);
        Assert.assertEquals((Object)"tPerson", (Object)expectedHtmlLiElement.textContent);
        ((HTMLLIElement)Mockito.verify((Object)expectedHtmlLiElement)).appendChild((Node)htmlTypeElement);
    }

    @Test
    public void testMakeTypeElement() {
        DataType field = (DataType)Mockito.mock(DataType.class);
        String type = "string";
        HTMLElement expectedHtmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((StructureTypesTooltipView)Mockito.doReturn((Object)expectedHtmlElement).when((Object)this.view)).makeHTMLElement();
        Mockito.when((Object)field.getType()).thenReturn((Object)"string");
        HTMLElement actualHtmlElement = this.view.makeTypeElement(field);
        Assert.assertEquals((Object)expectedHtmlElement, (Object)actualHtmlElement);
        Assert.assertEquals((Object)"string", (Object)expectedHtmlElement.textContent);
    }

    @Test
    public void testUpdateTooltipAsVisible() {
        this.view.updateTooltipAsVisible();
        Assert.assertEquals((Object)"block", (Object)this.tooltip.style.display);
    }

    @Test
    public void testUpdateTooltipAsHidden() {
        this.view.updateTooltipAsHidden();
        Assert.assertEquals((Object)"none", (Object)this.tooltip.style.display);
    }
}

