/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.validation;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsInvalidErrorMessage;
import org.kie.workbench.common.dmn.client.editors.types.listview.validation.DataTypeNameFormatValidator;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeNameFormatValidatorTest {
    @Mock
    private DMNClientServicesProxy clientServicesProxy;
    @Mock
    private EventSourceMock<FlashMessage> flashMessageEvent;
    @Mock
    private DataTypeNameIsInvalidErrorMessage nameIsInvalidErrorMessage;
    private DataTypeNameFormatValidator validator;

    @Before
    public void setup() {
        this.validator = (DataTypeNameFormatValidator)Mockito.spy((Object)new DataTypeNameFormatValidator(this.clientServicesProxy, this.flashMessageEvent, this.nameIsInvalidErrorMessage));
    }

    @Test
    public void testIfIsValid() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Command onSuccess = (Command)Mockito.mock(Command.class);
        String dataTypeName = "name";
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"name");
        this.validator.ifIsValid(dataType, onSuccess);
        ((DMNClientServicesProxy)Mockito.verify((Object)this.clientServicesProxy)).isValidVariableName((String)ArgumentMatchers.eq((Object)"name"), (ServiceCallback)ArgumentMatchers.any(ServiceCallback.class));
    }

    @Test
    public void testGetCallbackWhenIsValid() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Command onSuccess = (Command)Mockito.mock(Command.class);
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        Mockito.when((Object)this.nameIsInvalidErrorMessage.getFlashMessage(dataType)).thenReturn((Object)flashMessage);
        this.validator.getCallback(dataType, onSuccess).onSuccess((Object)true);
        ((Command)Mockito.verify((Object)onSuccess)).execute();
        ((EventSourceMock)Mockito.verify(this.flashMessageEvent, (VerificationMode)Mockito.never())).fire((Object)flashMessage);
    }

    @Test
    public void testGetCallbackWhenIsNotValid() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Command onSuccess = (Command)Mockito.mock(Command.class);
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        Mockito.when((Object)this.nameIsInvalidErrorMessage.getFlashMessage(dataType)).thenReturn((Object)flashMessage);
        this.validator.getCallback(dataType, onSuccess).onSuccess((Object)false);
        ((EventSourceMock)Mockito.verify(this.flashMessageEvent)).fire((Object)flashMessage);
        ((Command)Mockito.verify((Object)onSuccess, (VerificationMode)Mockito.never())).execute();
    }
}

