/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionRecordEngine;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.DataTypeDestroyHandler;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeDestroyHandlerTest {
    @Mock
    private DataTypeStore dataTypeStore;
    @Mock
    private DataTypeManager dataTypeManager;
    @Mock
    private ItemDefinitionRecordEngine recordEngine;
    private DataTypeDestroyHandler handler;

    @Before
    public void setup() {
        this.handler = (DataTypeDestroyHandler)Mockito.spy((Object)new DataTypeDestroyHandler(this.dataTypeStore, this.dataTypeManager));
        this.handler.init(this.recordEngine);
    }

    @Test
    public void testDestroy() {
        String uuid = "uuid";
        String parentUUID = "parentUUID";
        String childUUID1 = "childUUID1";
        String childUUID2 = "childUUID2";
        String grandchildUUID1 = "grandchildUUID1";
        String grandchildUUID2 = "grandchildUUID2";
        DataType[] grandchildren = new DataType[]{this.makeDataType("grandchildUUID1", new DataType[0]), this.makeDataType("grandchildUUID2", new DataType[0])};
        DataType[] children = new DataType[]{this.makeDataType("childUUID1", new DataType[0]), this.makeDataType("childUUID2", grandchildren)};
        DataType dataType = this.makeDataType("uuid", children);
        DataType parent = this.makeDataType("parentUUID", dataType);
        ((DataTypeDestroyHandler)Mockito.doReturn((Object)parent).when((Object)this.handler)).parent(dataType);
        this.handler.destroy(dataType);
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore)).unIndex("uuid");
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore)).unIndex("childUUID1");
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore)).unIndex("childUUID2");
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore)).unIndex("grandchildUUID1");
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore)).unIndex("grandchildUUID2");
        Assert.assertEquals(Collections.emptyList(), (Object)parent.getSubDataTypes());
    }

    @Test
    public void testRefreshDependentDataTypes() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        ((DataTypeDestroyHandler)Mockito.doReturn(Arrays.asList(dataType0, dataType1)).when((Object)this.handler)).handleTopLevelDataTypes(dataType);
        ((DataTypeDestroyHandler)Mockito.doReturn(Arrays.asList(dataType2, dataType3)).when((Object)this.handler)).handleNestedDataTypes(dataType);
        List<DataType> expectedDataTypes = Arrays.asList(dataType0, dataType1, dataType2, dataType3);
        List actualDataTypes = this.handler.refreshDependentDataTypes(dataType);
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }

    @Test
    public void testHandleTopLevelDataTypesWhenDataTypeIsNotTopLevel() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataType.isTopLevel()).thenReturn((Object)false);
        List expectedDependentDataTypes = Collections.emptyList();
        List actualDependentDataTypes = this.handler.handleTopLevelDataTypes(dataType);
        ((ItemDefinitionRecordEngine)Mockito.verify((Object)this.recordEngine, (VerificationMode)Mockito.never())).doDestroy((DataType)ArgumentMatchers.any());
        Assert.assertEquals(expectedDependentDataTypes, (Object)actualDependentDataTypes);
    }

    @Test
    public void testHandleTopLevelDataTypesWhenDataTypeIsTopLevel() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataTypeParent0 = (DataType)Mockito.mock(DataType.class);
        DataType dataTypeParent1 = (DataType)Mockito.mock(DataType.class);
        String topLevelName = "name";
        Mockito.when((Object)dataType.isTopLevel()).thenReturn((Object)true);
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"name");
        Mockito.when((Object)dataType0.getType()).thenReturn((Object)"name");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)"name");
        Mockito.when((Object)dataType2.getType()).thenReturn((Object)"name");
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Arrays.asList(dataType0, dataType1, dataType2));
        ((DataTypeDestroyHandler)Mockito.doReturn((Object)dataTypeParent0).when((Object)this.handler)).parent(dataType0);
        ((DataTypeDestroyHandler)Mockito.doReturn((Object)dataTypeParent1).when((Object)this.handler)).parent(dataType1);
        List<DataType> expectedDependentDataTypes = Arrays.asList(dataTypeParent0, dataTypeParent1, dataType2, dataType);
        List actualDependentDataTypes = this.handler.handleTopLevelDataTypes(dataType);
        ((ItemDefinitionRecordEngine)Mockito.verify((Object)this.recordEngine)).doDestroy(dataType0);
        ((ItemDefinitionRecordEngine)Mockito.verify((Object)this.recordEngine)).doDestroy(dataType1);
        ((ItemDefinitionRecordEngine)Mockito.verify((Object)this.recordEngine)).doDestroy(dataType2);
        Assert.assertEquals(expectedDependentDataTypes, (Object)actualDependentDataTypes);
    }

    @Test
    public void testHandleNestedDataTypes() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        DataType dataTypeParent0 = (DataType)Mockito.mock(DataType.class);
        DataType dataTypeParent1 = (DataType)Mockito.mock(DataType.class);
        DataType dataTypeParent2 = (DataType)Mockito.mock(DataType.class);
        DataType dataTypeParent3 = (DataType)Mockito.mock(DataType.class);
        DataType topLevelDataType = (DataType)Mockito.mock(DataType.class);
        String topLevelName = "name";
        String topLevelType = "type";
        Mockito.when((Object)topLevelDataType.getName()).thenReturn((Object)"name");
        Mockito.when((Object)topLevelDataType.getType()).thenReturn((Object)"type");
        Mockito.when((Object)dataType0.getType()).thenReturn((Object)"name");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)"name");
        Mockito.when((Object)dataType2.getType()).thenReturn((Object)"name");
        Mockito.when((Object)dataType3.getType()).thenReturn((Object)"type");
        Mockito.when((Object)dataType3.isTopLevel()).thenReturn((Object)true);
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Arrays.asList(dataType0, dataType1, dataType2, dataType3));
        ((DataTypeDestroyHandler)Mockito.doReturn((Object)dataTypeParent0).when((Object)this.handler)).parent(dataType0);
        ((DataTypeDestroyHandler)Mockito.doReturn((Object)dataTypeParent1).when((Object)this.handler)).parent(dataType1);
        ((DataTypeDestroyHandler)Mockito.doReturn((Object)dataTypeParent2).when((Object)this.handler)).parent(dataType2);
        ((DataTypeDestroyHandler)Mockito.doReturn((Object)dataTypeParent3).when((Object)this.handler)).parent(dataType3);
        ((DataTypeDestroyHandler)Mockito.doReturn(Optional.of(topLevelDataType)).when((Object)this.handler)).getClosestTopLevelDataType(dataType);
        ((DataTypeDestroyHandler)Mockito.doReturn((Object)false).when((Object)this.handler)).isStructure(topLevelDataType);
        List<DataType> expectedDependentDataTypes = Arrays.asList(topLevelDataType, dataType3, dataType0, dataType1, dataType2);
        List actualDependentDataTypes = this.handler.handleNestedDataTypes(dataType);
        Assert.assertEquals(expectedDependentDataTypes, (Object)actualDependentDataTypes);
    }

    private DataType makeDataType(String uuid, DataType ... subDataTypes) {
        DataType dataType = (DataType)Mockito.spy((Object)new DataType(null));
        ((DataType)Mockito.doReturn((Object)uuid).when((Object)dataType)).getUUID();
        dataType.getSubDataTypes().addAll(Arrays.asList(subDataTypes));
        return dataType;
    }
}

