/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.editors.types.persistence.CreationType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.ItemDefinitionCreateHandler;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ItemDefinitionCreateHandlerTest {
    @Mock
    private ItemDefinitionUtils itemDefinitionUtils;
    @Mock
    private ItemDefinitionStore itemDefinitionStore;
    private ItemDefinitionCreateHandler handler;

    @Before
    public void setup() {
        this.handler = (ItemDefinitionCreateHandler)Mockito.spy((Object)new ItemDefinitionCreateHandler(this.itemDefinitionUtils, this.itemDefinitionStore));
    }

    @Test
    public void testAppendItemDefinition() {
        Mockito.when((Object)this.itemDefinitionUtils.all()).thenReturn(new ArrayList());
        ItemDefinition itemDefinition = this.handler.appendItemDefinition();
        Assert.assertTrue((boolean)this.itemDefinitionUtils.all().contains(itemDefinition));
    }

    @Test
    public void testInsertNestedItemDefinitionWhenAbsoluteParentIsPresent() {
        DataType record = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        ItemDefinition relativeParent = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Optional<Object> absoluteParent = Optional.of(Mockito.mock(ItemDefinition.class));
        ArrayList itemDefinitions = new ArrayList();
        String referenceUUID = "referenceUUID";
        Mockito.when((Object)this.itemDefinitionStore.get("referenceUUID")).thenReturn((Object)relativeParent);
        Mockito.when((Object)reference.getUUID()).thenReturn((Object)"referenceUUID");
        Mockito.when((Object)((ItemDefinition)absoluteParent.get()).getItemComponent()).thenReturn(itemDefinitions);
        ((ItemDefinitionCreateHandler)Mockito.doReturn(absoluteParent).when((Object)this.handler)).lookupAbsoluteParent("referenceUUID");
        ItemDefinition nestedItemDefinition = this.handler.insertNested(record, reference);
        Assert.assertEquals((Object)nestedItemDefinition, itemDefinitions.get(0));
    }

    @Test
    public void testInsertNestedItemDefinitionWhenAbsoluteParentIsNotPresent() {
        DataType record = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        ItemDefinition relativeParent = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Optional absoluteParent = Optional.empty();
        ArrayList itemDefinitions = new ArrayList();
        String referenceUUID = "referenceUUID";
        Mockito.when((Object)this.itemDefinitionStore.get("referenceUUID")).thenReturn((Object)relativeParent);
        Mockito.when((Object)reference.getUUID()).thenReturn((Object)"referenceUUID");
        Mockito.when((Object)relativeParent.getItemComponent()).thenReturn(itemDefinitions);
        ((ItemDefinitionCreateHandler)Mockito.doReturn(absoluteParent).when((Object)this.handler)).lookupAbsoluteParent("referenceUUID");
        ItemDefinition nestedItemDefinition = this.handler.insertNested(record, reference);
        ((ItemDefinition)Mockito.verify((Object)relativeParent)).setTypeRef(null);
        Assert.assertEquals((Object)nestedItemDefinition, itemDefinitions.get(0));
    }

    @Test
    public void testInsertItemDefinition() {
        DataType record = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        final ItemDefinition itemDefinitionReference = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        final ItemDefinition item = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ArrayList<ItemDefinition> actualItemDefinitions = new ArrayList<ItemDefinition>(){
            {
                this.add(item);
                this.add(item);
                this.add(itemDefinitionReference);
                this.add(item);
            }
        };
        String uuid = "uuid";
        Mockito.when((Object)reference.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.itemDefinitionStore.get("uuid")).thenReturn((Object)itemDefinitionReference);
        ((ItemDefinitionCreateHandler)Mockito.doReturn((Object)actualItemDefinitions).when((Object)this.handler)).getItemDefinitionSiblings(reference);
        ItemDefinition itemDefinition = this.handler.insertSibling(record, reference, CreationType.BELOW);
        List<ItemDefinition> expectedItemDefinitions = Arrays.asList(item, item, itemDefinitionReference, itemDefinition, item);
        Assert.assertEquals(expectedItemDefinitions, (Object)actualItemDefinitions);
    }

    @Test
    public void testGetItemDefinitionSiblingsWhenParentIsPresent() {
        DataType reference = (DataType)Mockito.mock(DataType.class);
        String parentUUID = "parentUUID";
        Optional<Object> absoluteParent = Optional.of(Mockito.mock(ItemDefinition.class));
        ArrayList expectedItemDefinitions = new ArrayList();
        Mockito.when((Object)reference.getParentUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)((ItemDefinition)absoluteParent.get()).getItemComponent()).thenReturn(expectedItemDefinitions);
        ((ItemDefinitionCreateHandler)Mockito.doReturn(absoluteParent).when((Object)this.handler)).lookupAbsoluteParent("parentUUID");
        List actualItemDefinitions = this.handler.getItemDefinitionSiblings(reference);
        Assert.assertEquals(expectedItemDefinitions, (Object)actualItemDefinitions);
    }

    @Test
    public void testGetItemDefinitionSiblingsWhenParentIsNotPresent() {
        DataType reference = (DataType)Mockito.mock(DataType.class);
        String parentUUID = "parentUUID";
        Optional absoluteParent = Optional.empty();
        ArrayList expectedItemDefinitions = new ArrayList();
        Mockito.when((Object)reference.getParentUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)this.itemDefinitionUtils.all()).thenReturn(expectedItemDefinitions);
        ((ItemDefinitionCreateHandler)Mockito.doReturn(absoluteParent).when((Object)this.handler)).lookupAbsoluteParent("parentUUID");
        List actualItemDefinitions = this.handler.getItemDefinitionSiblings(reference);
        Assert.assertEquals(expectedItemDefinitions, (Object)actualItemDefinitions);
    }

    @Test
    public void testLookupAbsoluteParentWhenParentIsNotPresent() {
        String referenceUUID = "referenceUUID";
        Mockito.when((Object)this.itemDefinitionStore.get("referenceUUID")).thenReturn(null);
        Optional absoluteParent = this.handler.lookupAbsoluteParent("referenceUUID");
        Assert.assertFalse((boolean)absoluteParent.isPresent());
    }

    @Test
    public void testLookupAbsoluteParentWhenParentIsStructure() {
        String referenceUUID = "referenceUUID";
        ItemDefinition parent = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)parent.getTypeRef()).thenReturn(null);
        Mockito.when((Object)this.itemDefinitionStore.get("referenceUUID")).thenReturn((Object)parent);
        Optional actualParent = this.handler.lookupAbsoluteParent("referenceUUID");
        Optional<ItemDefinition> expectedParent = Optional.of(parent);
        Assert.assertEquals(expectedParent, (Object)actualParent);
    }

    @Test
    public void testLookupAbsoluteParentWhenParentIsNotStructure() {
        String type = "type";
        String referenceUUID = "referenceUUID";
        ItemDefinition parent = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Optional<Object> expectedParent = Optional.of(Mockito.mock(ItemDefinition.class));
        QName qName = (QName)Mockito.mock(QName.class);
        Mockito.when((Object)qName.getLocalPart()).thenReturn((Object)"type");
        Mockito.when((Object)parent.getTypeRef()).thenReturn((Object)qName);
        Mockito.when((Object)this.itemDefinitionStore.get("referenceUUID")).thenReturn((Object)parent);
        Mockito.when((Object)this.itemDefinitionUtils.findByName("type")).thenReturn(expectedParent);
        Optional actualParent = this.handler.lookupAbsoluteParent("referenceUUID");
        Assert.assertEquals(expectedParent, (Object)actualParent);
    }
}

