/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.shortcuts;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.EventListener;
import elemental2.dom.EventTarget;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.KeyboardEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeListShortcuts;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeShortcuts;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.selectpicker.JQuery;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeShortcutsTest {
    @Mock
    private DataTypeListShortcuts listShortcuts;
    @Mock
    private KeyboardEvent event;
    private DataTypeShortcuts shortcuts;

    @Before
    public void setup() {
        this.shortcuts = (DataTypeShortcuts)Mockito.spy((Object)new DataTypeShortcuts(this.listShortcuts));
    }

    @Test
    public void testSetup() {
        ((DataTypeShortcuts)Mockito.doNothing().when((Object)this.shortcuts)).addEventListener((String)Mockito.any(), (EventListener)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isLoaded();
        this.shortcuts.setup();
        ((DataTypeShortcuts)Mockito.verify((Object)this.shortcuts)).addEventListener("keydown", this.shortcuts.KEY_DOWN_LISTENER);
        ((DataTypeShortcuts)Mockito.verify((Object)this.shortcuts)).addEventListener("keydown", this.shortcuts.KEY_DOWN_LISTENER);
    }

    @Test
    public void testSetupWhenItIsLoaded() {
        ((DataTypeShortcuts)Mockito.doNothing().when((Object)this.shortcuts)).addEventListener((String)Mockito.any(), (EventListener)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)true).when((Object)this.shortcuts)).isLoaded();
        this.shortcuts.setup();
        ((DataTypeShortcuts)Mockito.verify((Object)this.shortcuts, (VerificationMode)Mockito.never())).addEventListener("keydown", this.shortcuts.KEY_DOWN_LISTENER);
        ((DataTypeShortcuts)Mockito.verify((Object)this.shortcuts, (VerificationMode)Mockito.never())).addEventListener("keydown", this.shortcuts.KEY_DOWN_LISTENER);
    }

    @Test
    public void testTeardown() {
        ((DataTypeShortcuts)Mockito.doNothing().when((Object)this.shortcuts)).removeEventListener((String)Mockito.any(), (EventListener)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)true).when((Object)this.shortcuts)).isLoaded();
        this.shortcuts.teardown();
        ((DataTypeShortcuts)Mockito.verify((Object)this.shortcuts)).removeEventListener("keydown", this.shortcuts.KEY_DOWN_LISTENER);
        ((DataTypeShortcuts)Mockito.verify((Object)this.shortcuts)).removeEventListener("click", this.shortcuts.CLICK_LISTENER);
    }

    @Test
    public void testTeardownWhenItIsNotLoaded() {
        ((DataTypeShortcuts)Mockito.doNothing().when((Object)this.shortcuts)).removeEventListener((String)Mockito.any(), (EventListener)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isLoaded();
        this.shortcuts.teardown();
        ((DataTypeShortcuts)Mockito.verify((Object)this.shortcuts, (VerificationMode)Mockito.never())).removeEventListener("keydown", this.shortcuts.KEY_DOWN_LISTENER);
        ((DataTypeShortcuts)Mockito.verify((Object)this.shortcuts, (VerificationMode)Mockito.never())).removeEventListener("click", this.shortcuts.CLICK_LISTENER);
    }

    @Test
    public void testClickListenerWhenTabContentContainsTarget() {
        JQuery jQuery;
        Event target = (Event)Mockito.mock(Event.class);
        Element targetElement = (Element)Mockito.mock(Element.class);
        Element tabContentElement = (Element)Mockito.mock(Element.class);
        JQuery.$ = jQuery = (JQuery)Mockito.mock(JQuery.class);
        target.target = targetElement;
        ((DataTypeShortcuts)Mockito.doReturn((Object)tabContentElement).when((Object)this.shortcuts)).querySelector(".tab-content");
        Mockito.when((Object)jQuery.contains(tabContentElement, targetElement)).thenReturn((Object)true);
        this.shortcuts.clickListener(target);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).focusIn();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts, (VerificationMode)Mockito.never())).reset();
    }

    @Test
    public void testClickListenerWhenDropdownMenuContainsTarget() {
        JQuery jQuery;
        Event target = (Event)Mockito.mock(Event.class);
        Element targetElement = (Element)Mockito.mock(Element.class);
        Element targetMenu = (Element)Mockito.mock(Element.class);
        JQuery.$ = jQuery = (JQuery)Mockito.mock(JQuery.class);
        target.target = targetElement;
        ((Element)Mockito.doReturn((Object)targetMenu).when((Object)targetElement)).closest(".bs-container.btn-group.bootstrap-select.open");
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).tabContentContainsTarget(target);
        this.shortcuts.clickListener(target);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).focusIn();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts, (VerificationMode)Mockito.never())).reset();
    }

    @Test
    public void testClickListenerWhenConstraintModalFooterContainsTarget() {
        JQuery jQuery;
        Event target = (Event)Mockito.mock(Event.class);
        Element targetElement = (Element)Mockito.mock(Element.class);
        Element targetMenu = (Element)Mockito.mock(Element.class);
        JQuery.$ = jQuery = (JQuery)Mockito.mock(JQuery.class);
        target.target = targetElement;
        ((Element)Mockito.doReturn((Object)targetMenu).when((Object)targetElement)).closest(".constraint-modal-footer");
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).tabContentContainsTarget(target);
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).dropdownMenuContainsTarget(target);
        this.shortcuts.clickListener(target);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).focusIn();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts, (VerificationMode)Mockito.never())).reset();
    }

    @Test
    public void testClickListenerWhenDatatypeElementIsClicked() {
        JQuery jQuery;
        Event target = (Event)Mockito.mock(Event.class);
        Element targetElement = (Element)Mockito.mock(Element.class);
        Element targetMenu = (Element)Mockito.mock(Element.class);
        Element dataTypeRowElement = (Element)Mockito.mock(Element.class);
        JQuery.$ = jQuery = (JQuery)Mockito.mock(JQuery.class);
        target.target = targetElement;
        ((Element)Mockito.doReturn((Object)targetMenu).when((Object)targetElement)).closest(".bs-container.btn-group.bootstrap-select.open");
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).tabContentContainsTarget(target);
        ((Element)Mockito.doReturn((Object)dataTypeRowElement).when((Object)targetElement)).closest(".list-group-item");
        this.shortcuts.clickListener(target);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).focusIn();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).highlight(dataTypeRowElement);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts, (VerificationMode)Mockito.never())).reset();
    }

    @Test
    public void testClickListenerWhenTabContentDoesNotContainTarget() {
        JQuery jQuery;
        Event target = (Event)Mockito.mock(Event.class);
        Element targetElement = (Element)Mockito.mock(Element.class);
        Element tabContentElement = (Element)Mockito.mock(Element.class);
        JQuery.$ = jQuery = (JQuery)Mockito.mock(JQuery.class);
        target.target = targetElement;
        ((DataTypeShortcuts)Mockito.doReturn((Object)tabContentElement).when((Object)this.shortcuts)).querySelector(".tab-content");
        Mockito.when((Object)jQuery.contains(tabContentElement, targetElement)).thenReturn((Object)false);
        this.shortcuts.clickListener(target);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).reset();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts, (VerificationMode)Mockito.never())).focusIn();
    }

    @Test
    public void testClickListenerWhenComponentIsNotEnabled() {
        this.shortcuts.disable();
        this.shortcuts.clickListener((Event)Mockito.mock(Event.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listShortcuts});
    }

    @Test
    public void testKeyDownListenerWhenKeyEscIsPressed() {
        this.event.key = "Esc";
        this.shortcuts.keyDownListener((Event)this.event);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onEscape();
    }

    @Test
    public void testKeyDownListenerWhenKeyEscapeIsPressed() {
        this.event.key = "Escape";
        this.shortcuts.keyDownListener((Event)this.event);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onEscape();
    }

    @Test
    public void testKeyDownListenerWhenKeyBackspaceIsPressed() {
        this.event.key = "Backspace";
        this.event.ctrlKey = true;
        this.shortcuts.keyDownListener((Event)this.event);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onCtrlBackspace();
    }

    @Test
    public void testKeyDownListenerWhenKeyBackspaceIsPressedButAltIsNotPressed() {
        this.event.key = "Backspace";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts, (VerificationMode)Mockito.never())).onCtrlBackspace();
    }

    @Test
    public void testKeyDownListenerWhenKeyTabIsPressed() {
        this.event.key = "Tab";
        ((DataTypeShortcuts)Mockito.doReturn((Object)true).when((Object)this.shortcuts)).isSearchBarTarget((KeyboardEvent)ArgumentMatchers.any());
        this.shortcuts.keyDownListener((Event)this.event);
        ((KeyboardEvent)Mockito.verify((Object)this.event)).preventDefault();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onTab();
    }

    @Test
    public void testKeyDownListenerWhenKeyTabIsPressedButTargetElementIsNotSearchBar() {
        this.event.key = "Tab";
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isSearchBarTarget((KeyboardEvent)ArgumentMatchers.any());
        this.shortcuts.keyDownListener((Event)this.event);
        ((KeyboardEvent)Mockito.verify((Object)this.event, (VerificationMode)Mockito.never())).preventDefault();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts, (VerificationMode)Mockito.never())).onTab();
    }

    @Test
    public void testKeyDownListenerWhenKeySIsPressed() {
        this.event.key = "s";
        this.event.ctrlKey = true;
        this.shortcuts.keyDownListener((Event)this.event);
        ((KeyboardEvent)Mockito.verify((Object)this.event)).preventDefault();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onCtrlS();
    }

    @Test
    public void testKeyDownListenerWhenKeySIsPressedButAltIsNotPressed() {
        this.event.key = "s";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((KeyboardEvent)Mockito.verify((Object)this.event, (VerificationMode)Mockito.never())).preventDefault();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts, (VerificationMode)Mockito.never())).onCtrlS();
    }

    @Test
    public void testKeyDownListenerWhenKeyBIsPressed() {
        this.event.key = "b";
        this.event.ctrlKey = true;
        this.shortcuts.keyDownListener((Event)this.event);
        ((KeyboardEvent)Mockito.verify((Object)this.event)).preventDefault();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onCtrlB();
    }

    @Test
    public void testKeyDownListenerWhenKeyBIsPressedButAltIsNotPressed() {
        this.event.key = "b";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((KeyboardEvent)Mockito.verify((Object)this.event, (VerificationMode)Mockito.never())).preventDefault();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts, (VerificationMode)Mockito.never())).onCtrlB();
    }

    @Test
    public void testKeyDownListenerWhenKeyUIsPressed() {
        this.event.key = "u";
        this.event.ctrlKey = true;
        this.shortcuts.keyDownListener((Event)this.event);
        ((KeyboardEvent)Mockito.verify((Object)this.event)).preventDefault();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onCtrlU();
    }

    @Test
    public void testKeyDownListenerWhenKeyUIsPressedButAltIsNotPressed() {
        this.event.key = "u";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((KeyboardEvent)Mockito.verify((Object)this.event, (VerificationMode)Mockito.never())).preventDefault();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts, (VerificationMode)Mockito.never())).onCtrlU();
    }

    @Test
    public void testKeyDownListenerWhenKeyDIsPressed() {
        this.event.key = "d";
        this.event.ctrlKey = true;
        this.shortcuts.keyDownListener((Event)this.event);
        ((KeyboardEvent)Mockito.verify((Object)this.event)).preventDefault();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onCtrlD();
    }

    @Test
    public void testKeyDownListenerWhenKeyDIsPressedButAltIsNotPressed() {
        this.event.key = "d";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((KeyboardEvent)Mockito.verify((Object)this.event, (VerificationMode)Mockito.never())).preventDefault();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts, (VerificationMode)Mockito.never())).onCtrlD();
    }

    @Test
    public void testKeyDownListenerWhenKeyEIsPressed() {
        this.event.key = "e";
        this.event.ctrlKey = true;
        this.shortcuts.keyDownListener((Event)this.event);
        ((KeyboardEvent)Mockito.verify((Object)this.event)).preventDefault();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onCtrlE();
    }

    @Test
    public void testKeyDownListenerWhenKeyEIsPressedButAltIsNotPressed() {
        this.event.key = "e";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((KeyboardEvent)Mockito.verify((Object)this.event, (VerificationMode)Mockito.never())).preventDefault();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts, (VerificationMode)Mockito.never())).onCtrlE();
    }

    @Test
    public void testKeyDownListenerWhenIsAnInputEventAndSearchBarIsNotTarget() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)true).when((Object)this.shortcuts)).isInputEvent((KeyboardEvent)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isSearchBarTarget((KeyboardEvent)ArgumentMatchers.any());
        this.event.key = "Down";
        this.shortcuts.keyDownListener((Event)this.event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.event});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listShortcuts});
    }

    @Test
    public void testKeyDownListenerWhenKeDownIsPressed() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isInputEvent((KeyboardEvent)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isSearchBarTarget((KeyboardEvent)ArgumentMatchers.any());
        this.event.key = "Down";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onArrowDown();
    }

    @Test
    public void testKeyDownListenerWhenKeyArrowDownIsPressed() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isInputEvent((KeyboardEvent)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isSearchBarTarget((KeyboardEvent)ArgumentMatchers.any());
        this.event.key = "ArrowDown";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onArrowDown();
    }

    @Test
    public void testKeyDownListenerWhenKeyUpIsPressed() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isInputEvent((KeyboardEvent)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isSearchBarTarget((KeyboardEvent)ArgumentMatchers.any());
        this.event.key = "Up";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onArrowUp();
    }

    @Test
    public void testKeyDownListenerWhenKeyArrowUpIsPressed() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isInputEvent((KeyboardEvent)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isSearchBarTarget((KeyboardEvent)ArgumentMatchers.any());
        this.event.key = "ArrowUp";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onArrowUp();
    }

    @Test
    public void testKeyDownListenerWhenKeyLeftIsPressed() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isInputEvent((KeyboardEvent)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isSearchBarTarget((KeyboardEvent)ArgumentMatchers.any());
        this.event.key = "Left";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onArrowLeft();
    }

    @Test
    public void testKeyDownListenerWhenKeyArrowLeftIsPressed() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isInputEvent((KeyboardEvent)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isSearchBarTarget((KeyboardEvent)ArgumentMatchers.any());
        this.event.key = "ArrowLeft";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onArrowLeft();
    }

    @Test
    public void testKeyDownListenerWhenComponentIsNotEnabled() {
        this.shortcuts.disable();
        this.shortcuts.keyDownListener((Event)this.event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listShortcuts});
    }

    @Test
    public void testKeyDownListenerWhenKeyRightIsPressed() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isInputEvent((KeyboardEvent)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isSearchBarTarget((KeyboardEvent)ArgumentMatchers.any());
        this.event.key = "Right";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onArrowRight();
    }

    @Test
    public void testKeyDownListenerWhenKeyArrowRightIsPressed() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isInputEvent((KeyboardEvent)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isSearchBarTarget((KeyboardEvent)ArgumentMatchers.any());
        this.event.key = "ArrowRight";
        this.event.ctrlKey = false;
        this.shortcuts.keyDownListener((Event)this.event);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).onArrowRight();
    }

    @Test
    public void testIsTargetElementAnInputWhenItReturnsTrue() {
        this.event.target = (EventTarget)Mockito.mock(HTMLInputElement.class);
        Assert.assertTrue((boolean)this.shortcuts.isTargetElementAnInput(this.event));
    }

    @Test
    public void testIsTargetElementAnInputWhenItReturnsFalse() {
        this.event.target = (EventTarget)Mockito.mock(HTMLDivElement.class);
        Assert.assertFalse((boolean)this.shortcuts.isTargetElementAnInput(this.event));
    }

    @Test
    public void testIsDropdownOpenedWhenItReturnsTrue() {
        ((DataTypeShortcuts)Mockito.doReturn(null).when((Object)this.shortcuts)).querySelector(".bs-container.btn-group.bootstrap-select.open");
        Assert.assertFalse((boolean)this.shortcuts.isDropdownOpened());
    }

    @Test
    public void testIsDropdownOpenedWhenItReturnsFalse() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)Mockito.mock(Element.class)).when((Object)this.shortcuts)).querySelector(".bs-container.btn-group.bootstrap-select.open");
        Assert.assertTrue((boolean)this.shortcuts.isDropdownOpened());
    }

    @Test
    public void testIsSearchBarTargetWhenItReturnsTrue() {
        HTMLInputElement element = (HTMLInputElement)Mockito.mock(HTMLInputElement.class);
        this.event.target = element;
        Mockito.when((Object)element.getAttribute("data-field")).thenReturn((Object)"search-bar");
        Assert.assertTrue((boolean)this.shortcuts.isTargetElementAnInput(this.event));
    }

    @Test
    public void testIsSearchBarTargetWhenItReturnsFalse() {
        HTMLDivElement element = (HTMLDivElement)Mockito.mock(HTMLDivElement.class);
        this.event.target = element;
        Mockito.when((Object)element.getAttribute("data-field")).thenReturn((Object)"something");
        Assert.assertFalse((boolean)this.shortcuts.isSearchBarTarget(this.event));
    }

    @Test
    public void testIsInputEventWhenTargetElementIsNotAnInputAndDropdownIsNotOpened() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isTargetElementAnInput((KeyboardEvent)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isDropdownOpened();
        Assert.assertFalse((boolean)this.shortcuts.isInputEvent(this.event));
    }

    @Test
    public void testIsInputEventWhenTargetElementIsAnInput() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)true).when((Object)this.shortcuts)).isTargetElementAnInput((KeyboardEvent)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isDropdownOpened();
        Assert.assertTrue((boolean)this.shortcuts.isInputEvent(this.event));
    }

    @Test
    public void testIsInputEventWhenDropdownIsOpened() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)false).when((Object)this.shortcuts)).isTargetElementAnInput((KeyboardEvent)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)true).when((Object)this.shortcuts)).isDropdownOpened();
        Assert.assertTrue((boolean)this.shortcuts.isInputEvent(this.event));
    }

    @Test
    public void testIsInputEventWhenTargetElementIsAnInputAndDropdownIsOpened() {
        ((DataTypeShortcuts)Mockito.doReturn((Object)true).when((Object)this.shortcuts)).isTargetElementAnInput((KeyboardEvent)ArgumentMatchers.any());
        ((DataTypeShortcuts)Mockito.doReturn((Object)true).when((Object)this.shortcuts)).isDropdownOpened();
        Assert.assertTrue((boolean)this.shortcuts.isInputEvent(this.event));
    }

    @Test
    public void testIsNotEnabledWhenItReturnsFalse() {
        this.shortcuts.enable();
        Assert.assertFalse((boolean)this.shortcuts.isNotEnabled());
    }

    @Test
    public void testIsNotEnabledWhenItReturnsTrue() {
        this.shortcuts.disable();
        Assert.assertTrue((boolean)this.shortcuts.isNotEnabled());
    }

    @Test
    public void testReset() {
        this.shortcuts.reset();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).reset();
    }

    @Test
    public void testHighlight() {
        Element element = (Element)Mockito.mock(Element.class);
        this.shortcuts.highlight(element);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.listShortcuts)).highlight(element);
    }
}

