/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.included;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNIncludedNodeFactory;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNMarshallerImportsClientHelper;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNMarshallerImportsContentService;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNMarshallerImportsService;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImport;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.promise.Promises;
import org.uberfire.promise.SyncPromises;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNMarshallerImportsClientHelperTest {
    @Mock
    private Metadata metadataMock;
    @Mock
    private ServiceCallback<List<IncludedModel>> includedModelServiceCallback;
    @Mock
    private ServiceCallback<List<PMMLDocumentMetadata>> pmmlMetadataServiceCallback;
    @Mock
    private DMNMarshallerImportsService dmnImportsService;
    @Mock
    private DMNMarshallerImportsContentService dmnImportsContentService;
    @Mock
    private DMNIncludedNodeFactory includedModelFactory;
    @Captor
    private ArgumentCaptor<List<IncludedModel>> modelsCapture;
    @Captor
    private ArgumentCaptor<List<PMMLDocumentMetadata>> pmmlDocumentMetadataArgumentCaptor;
    private static final String DMN_FILE = "test-dmn.dmn";
    private static final String DMN_PATH = "dmntest/test-dmn.dmn";
    private static final String DMN_CONTENT = "<xml> xml DMN content </xml>";
    private static final String PMML_MODEL_NAME = "model-test";
    private static final String PMML_FILE = "test-pmml.pmml";
    private static final String PMML_PATH = "dmnpmml/test-pmml.pmml";
    private static final String PMML_CONTENT = "<xml> xml PMML content </xml>";
    private static final String TEXT_FILE = "test-file.txt";
    private static final String TEXT_PATH = "invalidfile/test-file.txt";
    private Promises promises;
    private DMNMarshallerImportsClientHelper importsHelper;

    @Before
    public void setup() {
        this.promises = new SyncPromises();
        this.importsHelper = new DMNMarshallerImportsClientHelper(this.dmnImportsService, this.dmnImportsContentService, this.promises, this.includedModelFactory);
    }

    @Test
    public void loadModelsDMNFile() {
        Mockito.when((Object)this.dmnImportsContentService.getModelsURIs()).thenReturn((Object)this.promises.resolve((Object)new String[]{DMN_PATH}));
        Mockito.when((Object)this.dmnImportsContentService.loadFile(DMN_PATH)).thenReturn((Object)this.promises.resolve((Object)DMN_CONTENT));
        this.importsHelper.loadModels(this.includedModelServiceCallback);
        ((DMNMarshallerImportsContentService)Mockito.verify((Object)this.dmnImportsContentService)).loadFile((String)ArgumentMatchers.eq((Object)DMN_PATH));
    }

    @Test
    public void loadModelsPMMLFile() {
        PMMLDocumentMetadata pmmlDocumentMetadata = new PMMLDocumentMetadata(PMML_PATH, PMML_FILE, DMNImportTypes.PMML.getDefaultNamespace(), Collections.emptyList());
        Mockito.when((Object)this.dmnImportsContentService.getModelsURIs()).thenReturn((Object)this.promises.resolve((Object)new String[]{PMML_PATH}));
        Mockito.when((Object)this.dmnImportsContentService.loadFile(PMML_PATH)).thenReturn((Object)this.promises.resolve((Object)PMML_CONTENT));
        Mockito.when((Object)this.dmnImportsContentService.loadFile(PMML_PATH)).thenReturn((Object)this.promises.resolve((Object)PMML_CONTENT));
        ((DMNMarshallerImportsContentService)Mockito.doReturn((Object)this.promises.resolve((Object)pmmlDocumentMetadata)).when((Object)this.dmnImportsContentService)).getPMMLDocumentMetadata(PMML_PATH);
        this.importsHelper.loadModels(this.includedModelServiceCallback);
        ((ServiceCallback)Mockito.verify(this.includedModelServiceCallback)).onSuccess(this.modelsCapture.capture());
        Assert.assertEquals((long)1L, (long)((List)this.modelsCapture.getValue()).size());
        Assert.assertEquals((Object)PMML_FILE, (Object)((IncludedModel)((List)this.modelsCapture.getValue()).get(0)).getPath());
        Assert.assertEquals((Object)PMML_FILE, (Object)((IncludedModel)((List)this.modelsCapture.getValue()).get(0)).getModelName());
        Assert.assertEquals((Object)DMNImportTypes.PMML.getDefaultNamespace(), (Object)((IncludedModel)((List)this.modelsCapture.getValue()).get(0)).getImportType());
        Assert.assertEquals((long)0L, (long)((PMMLIncludedModel)((List)this.modelsCapture.getValue()).get(0)).getModelCount().intValue());
    }

    @Test
    public void loadModelsInvalidFile() {
        Mockito.when((Object)this.dmnImportsContentService.getModelsURIs()).thenReturn((Object)this.promises.resolve((Object)new String[]{TEXT_PATH}));
        this.importsHelper.loadModels(this.includedModelServiceCallback);
        ((DMNMarshallerImportsContentService)Mockito.verify((Object)this.dmnImportsContentService, (VerificationMode)Mockito.never())).loadFile((String)Mockito.any());
        ((DMNMarshallerImportsContentService)Mockito.verify((Object)this.dmnImportsContentService, (VerificationMode)Mockito.never())).getPMMLDocumentMetadata((String)Mockito.any());
        ((DMNMarshallerImportsService)Mockito.verify((Object)this.dmnImportsService, (VerificationMode)Mockito.never())).getWbDefinitions((String)Mockito.any(), (ServiceCallback)ArgumentMatchers.any());
    }

    @Test
    public void getPMMLDocumentsAsyncWhenModelDoesNotHaveImports() {
        Promise returnPromise = this.importsHelper.getPMMLDocumentsAsync(this.metadataMock, Collections.emptyList());
        returnPromise.then(p0 -> {
            Assert.assertEquals((long)0L, (long)p0.size());
            return this.promises.resolve();
        }).catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
    }

    @Test
    public void getPMMLDocumentsAsyncWhenAnyFileCouldBeRead() {
        Mockito.when((Object)this.dmnImportsContentService.getModelsPMMLFilesURIs()).thenReturn((Object)this.promises.resolve((Object)new String[0]));
        Promise returnPromise = this.importsHelper.getPMMLDocumentsAsync(this.metadataMock, Collections.singletonList(Mockito.mock(JSITImport.class)));
        returnPromise.then(p0 -> {
            Assert.assertEquals((long)0L, (long)p0.size());
            return this.promises.resolve();
        }).catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
    }

    @Test
    public void getPMMLDocumentsAsync() {
        PMMLDocumentMetadata pmmlDocumentMetadata = new PMMLDocumentMetadata(PMML_PATH, PMML_FILE, DMNImportTypes.PMML.getDefaultNamespace(), Collections.emptyList());
        Mockito.when((Object)this.dmnImportsContentService.getModelsPMMLFilesURIs()).thenReturn((Object)this.promises.resolve((Object)new String[]{PMML_PATH}));
        Mockito.when((Object)this.dmnImportsContentService.loadFile(PMML_PATH)).thenReturn((Object)this.promises.resolve((Object)PMML_CONTENT));
        ((DMNMarshallerImportsContentService)Mockito.doReturn((Object)this.promises.resolve((Object)pmmlDocumentMetadata)).when((Object)this.dmnImportsContentService)).getPMMLDocumentMetadata(PMML_PATH);
        ArrayList<JSITImport> imports = new ArrayList<JSITImport>();
        JSITImport jsImportMock = (JSITImport)Mockito.mock(JSITImport.class);
        Mockito.when((Object)jsImportMock.getLocationURI()).thenReturn((Object)PMML_FILE);
        imports.add(jsImportMock);
        Promise returnPromise = this.importsHelper.getPMMLDocumentsAsync(this.metadataMock, imports);
        returnPromise.then(def -> {
            Assert.assertEquals((long)1L, (long)def.size());
            Assert.assertEquals((Object)PMML_PATH, (Object)((PMMLDocumentMetadata)def.get(jsImportMock)).getPath());
            Assert.assertEquals((Object)PMML_FILE, (Object)((PMMLDocumentMetadata)def.get(jsImportMock)).getName());
            Assert.assertEquals((Object)DMNImportTypes.PMML.getDefaultNamespace(), (Object)((PMMLDocumentMetadata)def.get(jsImportMock)).getImportType());
            Assert.assertEquals((long)0L, (long)((PMMLDocumentMetadata)def.get(jsImportMock)).getModels().size());
            return this.promises.resolve();
        }).catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
    }

    @Test
    public void getPMMLDocumentsMetadataFromFilesEmptyFiles() {
        this.importsHelper.getPMMLDocumentsMetadataFromFiles(Collections.emptyList(), this.pmmlMetadataServiceCallback);
        this.importsHelper.getPMMLDocumentsMetadataFromFiles(null, this.pmmlMetadataServiceCallback);
        ((ServiceCallback)Mockito.verify(this.pmmlMetadataServiceCallback, (VerificationMode)Mockito.times((int)2))).onSuccess(ArgumentMatchers.eq(Collections.emptyList()));
    }

    @Test
    public void getPMMLDocumentsMetadataFromFiles() {
        PMMLDocumentMetadata documentMetadata = new PMMLDocumentMetadata(PMML_FILE, DMNImportTypes.PMML.getDefaultNamespace(), Collections.emptyList());
        List<PMMLIncludedModel> includedModels = Arrays.asList(new PMMLIncludedModel(PMML_MODEL_NAME, "", PMML_FILE, DMNImportTypes.PMML.getDefaultNamespace(), Integer.valueOf(0)));
        Mockito.when((Object)this.dmnImportsContentService.getModelsPMMLFilesURIs()).thenReturn((Object)this.promises.resolve((Object)new String[]{PMML_PATH}));
        Mockito.when((Object)this.dmnImportsContentService.loadFile(PMML_PATH)).thenReturn((Object)this.promises.resolve((Object)PMML_CONTENT));
        ((DMNMarshallerImportsContentService)Mockito.doReturn((Object)this.promises.resolve((Object)documentMetadata)).when((Object)this.dmnImportsContentService)).getPMMLDocumentMetadata(PMML_PATH);
        this.importsHelper.getPMMLDocumentsMetadataFromFiles(includedModels, this.pmmlMetadataServiceCallback);
        ((ServiceCallback)Mockito.verify(this.pmmlMetadataServiceCallback, (VerificationMode)Mockito.times((int)1))).onSuccess(this.pmmlDocumentMetadataArgumentCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.pmmlDocumentMetadataArgumentCaptor.getValue()).size());
        Assert.assertEquals((Object)PMML_FILE, (Object)((PMMLDocumentMetadata)((List)this.pmmlDocumentMetadataArgumentCaptor.getValue()).get(0)).getPath());
        Assert.assertEquals((Object)PMML_MODEL_NAME, (Object)((PMMLDocumentMetadata)((List)this.pmmlDocumentMetadataArgumentCaptor.getValue()).get(0)).getName());
        Assert.assertEquals((Object)DMNImportTypes.PMML.getDefaultNamespace(), (Object)((PMMLDocumentMetadata)((List)this.pmmlDocumentMetadataArgumentCaptor.getValue()).get(0)).getImportType());
        Assert.assertTrue((boolean)((PMMLDocumentMetadata)((List)this.pmmlDocumentMetadataArgumentCaptor.getValue()).get(0)).getModels().isEmpty());
    }
}

