/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.marshall;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.client.marshaller.marshall.DMNMarshaller;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAuthorityRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITBusinessKnowledgeModel;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecision;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeSource;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDiagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.DiscreteConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNMarshallerTest {
    @Test
    public void testMergeOrAddNodeToDefinitions() {
        JSITDecision existingNode1 = this.makeDecision("id1");
        JSITBusinessKnowledgeModel existingNode2 = this.makeBusinessKnowledgeModel("id2");
        JSITKnowledgeSource existingNode3 = this.makeKnowledgeSource("id3");
        JSITDecision node1 = this.makeDecision("id1");
        JSITBusinessKnowledgeModel node2 = this.makeBusinessKnowledgeModel("id2");
        JSITKnowledgeSource node3 = this.makeKnowledgeSource("id3");
        JSITBusinessKnowledgeModel node4 = this.makeBusinessKnowledgeModel("id4");
        JSITKnowledgeSource node5 = this.makeKnowledgeSource("id5");
        DMNMarshaller dmnMarshaller = (DMNMarshaller)Mockito.spy((Object)new DMNMarshaller());
        JSITDefinitions definitions = (JSITDefinitions)Mockito.spy((Object)new JSITDefinitions());
        ArrayList<JSITDRGElement> definitionsDRGElements = new ArrayList<JSITDRGElement>(Arrays.asList(existingNode1, existingNode2, existingNode3));
        JSITAuthorityRequirement node1AuthorityRequirement = new JSITAuthorityRequirement();
        JSITInformationRequirement node1InformationRequirement = new JSITInformationRequirement();
        JSITKnowledgeRequirement node1KnowledgeRequirement = new JSITKnowledgeRequirement();
        JSITAuthorityRequirement node2AuthorityRequirement = new JSITAuthorityRequirement();
        JSITKnowledgeRequirement node2KnowledgeRequirement = new JSITKnowledgeRequirement();
        JSITAuthorityRequirement node3AuthorityRequirement = new JSITAuthorityRequirement();
        ArrayList node1ExistingAuthorityRequirement = new ArrayList();
        ArrayList node1ExistingInformationRequirement = new ArrayList();
        ArrayList node1ExistingKnowledgeRequirement = new ArrayList();
        ArrayList node2ExistingAuthorityRequirement = new ArrayList();
        ArrayList node2ExistingKnowledgeRequirement = new ArrayList();
        ArrayList node3ExistingAuthorityRequirement = new ArrayList();
        ((DMNMarshaller)Mockito.doReturn((Object)node1).when((Object)dmnMarshaller)).getWrappedJSITDRGElement((JSITDRGElement)ArgumentMatchers.eq((Object)node1), (DMNMarshaller.JSINodeLocalPartName)ArgumentMatchers.any());
        ((DMNMarshaller)Mockito.doReturn((Object)node2).when((Object)dmnMarshaller)).getWrappedJSITDRGElement((JSITDRGElement)ArgumentMatchers.eq((Object)node2), (DMNMarshaller.JSINodeLocalPartName)ArgumentMatchers.any());
        ((DMNMarshaller)Mockito.doReturn((Object)node3).when((Object)dmnMarshaller)).getWrappedJSITDRGElement((JSITDRGElement)ArgumentMatchers.eq((Object)node3), (DMNMarshaller.JSINodeLocalPartName)ArgumentMatchers.any());
        ((DMNMarshaller)Mockito.doReturn((Object)node4).when((Object)dmnMarshaller)).getWrappedJSITDRGElement((JSITDRGElement)ArgumentMatchers.eq((Object)node4), (DMNMarshaller.JSINodeLocalPartName)ArgumentMatchers.any());
        ((DMNMarshaller)Mockito.doReturn((Object)node5).when((Object)dmnMarshaller)).getWrappedJSITDRGElement((JSITDRGElement)ArgumentMatchers.eq((Object)node5), (DMNMarshaller.JSINodeLocalPartName)ArgumentMatchers.any());
        ((DMNMarshaller)Mockito.doReturn((Object)true).when((Object)dmnMarshaller)).instanceOfDecision((JSITDRGElement)ArgumentMatchers.eq((Object)node1));
        ((DMNMarshaller)Mockito.doReturn((Object)true).when((Object)dmnMarshaller)).instanceOfBusinessKnowledgeModel((JSITDRGElement)ArgumentMatchers.eq((Object)node2));
        ((DMNMarshaller)Mockito.doReturn((Object)true).when((Object)dmnMarshaller)).instanceOfKnowledgeSource((JSITDRGElement)ArgumentMatchers.eq((Object)node3));
        ((DMNMarshaller)Mockito.doReturn((Object)true).when((Object)dmnMarshaller)).instanceOfBusinessKnowledgeModel((JSITDRGElement)ArgumentMatchers.eq((Object)node4));
        ((DMNMarshaller)Mockito.doReturn((Object)true).when((Object)dmnMarshaller)).instanceOfKnowledgeSource((JSITDRGElement)ArgumentMatchers.eq((Object)node5));
        ((JSITDefinitions)Mockito.doAnswer(e -> definitionsDRGElements.add((JSITDRGElement)e.getArguments()[0])).when((Object)definitions)).addDrgElement((JSITDRGElement)ArgumentMatchers.any());
        ((JSITDefinitions)Mockito.doReturn(definitionsDRGElements).when((Object)definitions)).getDrgElement();
        ((JSITDecision)Mockito.doReturn(node1ExistingAuthorityRequirement).when((Object)existingNode1)).getAuthorityRequirement();
        ((JSITDecision)Mockito.doReturn(node1ExistingInformationRequirement).when((Object)existingNode1)).getInformationRequirement();
        ((JSITDecision)Mockito.doReturn(node1ExistingKnowledgeRequirement).when((Object)existingNode1)).getKnowledgeRequirement();
        ((JSITBusinessKnowledgeModel)Mockito.doReturn(node2ExistingAuthorityRequirement).when((Object)existingNode2)).getAuthorityRequirement();
        ((JSITBusinessKnowledgeModel)Mockito.doReturn(node2ExistingKnowledgeRequirement).when((Object)existingNode2)).getKnowledgeRequirement();
        ((JSITKnowledgeSource)Mockito.doReturn(node3ExistingAuthorityRequirement).when((Object)existingNode3)).getAuthorityRequirement();
        ((JSITDecision)Mockito.doReturn(new ArrayList<JSITAuthorityRequirement>(Collections.singletonList(node1AuthorityRequirement))).when((Object)node1)).getAuthorityRequirement();
        ((JSITDecision)Mockito.doReturn(new ArrayList<JSITKnowledgeRequirement>(Collections.singletonList(node1KnowledgeRequirement))).when((Object)node1)).getKnowledgeRequirement();
        ((JSITDecision)Mockito.doReturn(new ArrayList<JSITInformationRequirement>(Collections.singletonList(node1InformationRequirement))).when((Object)node1)).getInformationRequirement();
        ((JSITBusinessKnowledgeModel)Mockito.doReturn(new ArrayList<JSITAuthorityRequirement>(Collections.singletonList(node2AuthorityRequirement))).when((Object)node2)).getAuthorityRequirement();
        ((JSITBusinessKnowledgeModel)Mockito.doReturn(new ArrayList<JSITKnowledgeRequirement>(Collections.singletonList(node2KnowledgeRequirement))).when((Object)node2)).getKnowledgeRequirement();
        ((JSITKnowledgeSource)Mockito.doReturn(new ArrayList<JSITAuthorityRequirement>(Collections.singletonList(node3AuthorityRequirement))).when((Object)node3)).getAuthorityRequirement();
        ((JSITDecision)Mockito.doAnswer(e -> this.setList(node1ExistingAuthorityRequirement, e)).when((Object)existingNode1)).setAuthorityRequirement((List)ArgumentMatchers.any());
        ((JSITDecision)Mockito.doAnswer(e -> this.setList(node1ExistingInformationRequirement, e)).when((Object)existingNode1)).setInformationRequirement((List)ArgumentMatchers.any());
        ((JSITDecision)Mockito.doAnswer(e -> this.setList(node1ExistingKnowledgeRequirement, e)).when((Object)existingNode1)).setKnowledgeRequirement((List)ArgumentMatchers.any());
        ((JSITBusinessKnowledgeModel)Mockito.doAnswer(e -> this.setList(node2ExistingAuthorityRequirement, e)).when((Object)existingNode2)).setAuthorityRequirement((List)ArgumentMatchers.any());
        ((JSITBusinessKnowledgeModel)Mockito.doAnswer(e -> this.setList(node2ExistingKnowledgeRequirement, e)).when((Object)existingNode2)).setKnowledgeRequirement((List)ArgumentMatchers.any());
        ((JSITKnowledgeSource)Mockito.doAnswer(e -> this.setList(node3ExistingAuthorityRequirement, e)).when((Object)existingNode3)).setAuthorityRequirement((List)ArgumentMatchers.any());
        ((JSITDecision)Mockito.doAnswer(e -> this.addAll(node1ExistingAuthorityRequirement, e)).when((Object)existingNode1)).addAllAuthorityRequirement((JSITAuthorityRequirement[])ArgumentMatchers.any());
        ((JSITDecision)Mockito.doAnswer(e -> this.addAll(node1ExistingInformationRequirement, e)).when((Object)existingNode1)).addAllInformationRequirement((JSITInformationRequirement[])ArgumentMatchers.any());
        ((JSITDecision)Mockito.doAnswer(e -> this.addAll(node1ExistingKnowledgeRequirement, e)).when((Object)existingNode1)).addAllKnowledgeRequirement((JSITKnowledgeRequirement[])ArgumentMatchers.any());
        ((JSITBusinessKnowledgeModel)Mockito.doAnswer(e -> this.addAll(node2ExistingAuthorityRequirement, e)).when((Object)existingNode2)).addAllAuthorityRequirement((JSITAuthorityRequirement[])ArgumentMatchers.any());
        ((JSITBusinessKnowledgeModel)Mockito.doAnswer(e -> this.addAll(node2ExistingKnowledgeRequirement, e)).when((Object)existingNode2)).addAllKnowledgeRequirement((JSITKnowledgeRequirement[])ArgumentMatchers.any());
        ((JSITKnowledgeSource)Mockito.doAnswer(e -> this.addAll(node3ExistingAuthorityRequirement, e)).when((Object)existingNode3)).addAllAuthorityRequirement((JSITAuthorityRequirement[])ArgumentMatchers.any());
        dmnMarshaller.mergeOrAddNodeToDefinitions((JSITDRGElement)node1, definitions);
        dmnMarshaller.mergeOrAddNodeToDefinitions((JSITDRGElement)node2, definitions);
        dmnMarshaller.mergeOrAddNodeToDefinitions((JSITDRGElement)node3, definitions);
        dmnMarshaller.mergeOrAddNodeToDefinitions((JSITDRGElement)node4, definitions);
        dmnMarshaller.mergeOrAddNodeToDefinitions((JSITDRGElement)node5, definitions);
        dmnMarshaller.mergeOrAddNodeToDefinitions((JSITDRGElement)node1, definitions);
        dmnMarshaller.mergeOrAddNodeToDefinitions((JSITDRGElement)node2, definitions);
        dmnMarshaller.mergeOrAddNodeToDefinitions((JSITDRGElement)node3, definitions);
        dmnMarshaller.mergeOrAddNodeToDefinitions((JSITDRGElement)node4, definitions);
        dmnMarshaller.mergeOrAddNodeToDefinitions((JSITDRGElement)node5, definitions);
        ((JSITDefinitions)Mockito.verify((Object)definitions, (VerificationMode)Mockito.never())).addDrgElement((JSITDRGElement)node1);
        ((JSITDefinitions)Mockito.verify((Object)definitions, (VerificationMode)Mockito.never())).addDrgElement((JSITDRGElement)node2);
        ((JSITDefinitions)Mockito.verify((Object)definitions, (VerificationMode)Mockito.never())).addDrgElement((JSITDRGElement)node3);
        ((JSITDefinitions)Mockito.verify((Object)definitions)).addDrgElement((JSITDRGElement)node4);
        ((JSITDefinitions)Mockito.verify((Object)definitions)).addDrgElement((JSITDRGElement)node5);
        Assert.assertEquals((long)1L, (long)node1ExistingAuthorityRequirement.size());
        Assert.assertEquals((long)1L, (long)node1ExistingInformationRequirement.size());
        Assert.assertEquals((long)1L, (long)node1ExistingKnowledgeRequirement.size());
        Assert.assertEquals((long)1L, (long)node2ExistingAuthorityRequirement.size());
        Assert.assertEquals((long)1L, (long)node2ExistingKnowledgeRequirement.size());
        Assert.assertEquals((long)1L, (long)node3ExistingAuthorityRequirement.size());
        Assert.assertEquals((Object)node1AuthorityRequirement, node1ExistingAuthorityRequirement.get(0));
        Assert.assertEquals((Object)node1InformationRequirement, node1ExistingInformationRequirement.get(0));
        Assert.assertEquals((Object)node1KnowledgeRequirement, node1ExistingKnowledgeRequirement.get(0));
        Assert.assertEquals((Object)node2AuthorityRequirement, node2ExistingAuthorityRequirement.get(0));
        Assert.assertEquals((Object)node2KnowledgeRequirement, node2ExistingKnowledgeRequirement.get(0));
        Assert.assertEquals((Object)node3AuthorityRequirement, node3ExistingAuthorityRequirement.get(0));
    }

    @Test
    public void testGetExistingNode() {
        JSITDecision nodeDRGElement = this.makeDecision("id1");
        JSITDecision definitionsDRGElement1 = this.makeDecision("id1");
        JSITDecision definitionsDRGElement2 = this.makeDecision("id2");
        JSITDecision definitionsDRGElement3 = this.makeDecision("id3");
        DMNMarshaller dmnMarshaller = new DMNMarshaller();
        JSITDefinitions definitions = (JSITDefinitions)Mockito.spy((Object)new JSITDefinitions());
        ArrayList<JSITDecision> definitionsDRGElements = new ArrayList<JSITDecision>(Arrays.asList(definitionsDRGElement1, definitionsDRGElement2, definitionsDRGElement3));
        ((JSITDefinitions)Mockito.doReturn(definitionsDRGElements).when((Object)definitions)).getDrgElement();
        Optional existingNode = dmnMarshaller.getExistingNode(definitions, (JSITDRGElement)nodeDRGElement);
        Assert.assertTrue((boolean)existingNode.isPresent());
        Assert.assertEquals((Object)definitionsDRGElement1, existingNode.get());
    }

    @Test
    public void testWithIncludedModelsWhenNodeParentIsDMNDiagram() {
        DMNMarshaller dmnMarshaller = (DMNMarshaller)Mockito.spy((Object)new DMNMarshaller());
        Node node = (Node)Mockito.mock(Node.class);
        Definition nodeDefinition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Definitions definitionsStunnerPojo = (Definitions)Mockito.mock(Definitions.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        ArrayList<Import> diagramImports = new ArrayList<Import>(Arrays.asList(import1, import2));
        DMNDiagram nodeDiagram = (DMNDiagram)Mockito.mock(DMNDiagram.class);
        Definitions nodeDiagramDefinitions = (Definitions)Mockito.mock(Definitions.class);
        ArrayList nodeDiagramImports = new ArrayList();
        Mockito.when((Object)node.getContent()).thenReturn((Object)nodeDefinition);
        Mockito.when((Object)nodeDefinition.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)definitionsStunnerPojo.getImport()).thenReturn(diagramImports);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)nodeDiagram);
        Mockito.when((Object)nodeDiagram.getDefinitions()).thenReturn((Object)nodeDiagramDefinitions);
        Mockito.when((Object)nodeDiagramDefinitions.getImport()).thenReturn(nodeDiagramImports);
        dmnMarshaller.withIncludedModels(node, definitionsStunnerPojo);
        Assert.assertEquals((long)2L, (long)nodeDiagramImports.size());
        Assert.assertTrue((boolean)nodeDiagramImports.contains(import1));
        Assert.assertTrue((boolean)nodeDiagramImports.contains(import2));
    }

    @Test
    public void testWithIncludedModelsWhenNodeAlreadyHasImports() {
        DMNMarshaller dmnMarshaller = (DMNMarshaller)Mockito.spy((Object)new DMNMarshaller());
        Node node = (Node)Mockito.mock(Node.class);
        Definition nodeDefinition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Definitions definitionsStunnerPojo = (Definitions)Mockito.mock(Definitions.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        ArrayList<Import> diagramImports = new ArrayList<Import>(Arrays.asList(import1, import2));
        DMNDiagram nodeDiagram = (DMNDiagram)Mockito.mock(DMNDiagram.class);
        Definitions nodeDiagramDefinitions = (Definitions)Mockito.mock(Definitions.class);
        ArrayList<Import> nodeDiagramImports = new ArrayList<Import>(Arrays.asList(import1, import2));
        Mockito.when((Object)node.getContent()).thenReturn((Object)nodeDefinition);
        Mockito.when((Object)nodeDefinition.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)definitionsStunnerPojo.getImport()).thenReturn(diagramImports);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)nodeDiagram);
        Mockito.when((Object)nodeDiagram.getDefinitions()).thenReturn((Object)nodeDiagramDefinitions);
        Mockito.when((Object)nodeDiagramDefinitions.getImport()).thenReturn(nodeDiagramImports);
        dmnMarshaller.withIncludedModels(node, definitionsStunnerPojo);
        Assert.assertEquals((long)2L, (long)nodeDiagramImports.size());
        Assert.assertTrue((boolean)nodeDiagramImports.contains(import1));
        Assert.assertTrue((boolean)nodeDiagramImports.contains(import2));
    }

    @Test
    public void testWithIncludedModelsWhenNodeParentIsDefinitions() {
        DMNMarshaller dmnMarshaller = (DMNMarshaller)Mockito.spy((Object)new DMNMarshaller());
        Node node = (Node)Mockito.mock(Node.class);
        Definition nodeDefinition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Definitions definitionsStunnerPojo = (Definitions)Mockito.mock(Definitions.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        ArrayList<Import> diagramImports = new ArrayList<Import>(Arrays.asList(import1, import2));
        Definitions nodeDiagramDefinitions = (Definitions)Mockito.mock(Definitions.class);
        ArrayList nodeDiagramImports = new ArrayList();
        Mockito.when((Object)node.getContent()).thenReturn((Object)nodeDefinition);
        Mockito.when((Object)nodeDefinition.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)definitionsStunnerPojo.getImport()).thenReturn(diagramImports);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)nodeDiagramDefinitions);
        Mockito.when((Object)nodeDiagramDefinitions.getImport()).thenReturn(nodeDiagramImports);
        dmnMarshaller.withIncludedModels(node, definitionsStunnerPojo);
        Assert.assertEquals((long)2L, (long)nodeDiagramImports.size());
        Assert.assertTrue((boolean)nodeDiagramImports.contains(import1));
        Assert.assertTrue((boolean)nodeDiagramImports.contains(import2));
    }

    @Test
    public void testConnect() {
        DMNMarshaller dmnMarshaller = new DMNMarshaller();
        JSIDMNDiagram diagram = (JSIDMNDiagram)Mockito.mock(JSIDMNDiagram.class);
        List dmnDiagramElementIds = (List)Mockito.mock(List.class);
        Definitions definitionsStunnerPojo = (Definitions)Mockito.mock(Definitions.class);
        ArrayList dmnEdges = new ArrayList();
        Node node = (Node)Mockito.mock(Node.class);
        ArrayList<Edge> inEdges = new ArrayList<Edge>();
        Edge edge = (Edge)Mockito.mock(Edge.class);
        Node sourceNode = (Node)Mockito.mock(Node.class);
        View sourceView = (View)Mockito.mock(View.class);
        ViewConnector viewConnector = (ViewConnector)Mockito.mock(ViewConnector.class);
        DiscreteConnection sourceConnection = (DiscreteConnection)Mockito.mock(DiscreteConnection.class);
        DiscreteConnection targetConnection = (DiscreteConnection)Mockito.mock(DiscreteConnection.class);
        View view = (View)Mockito.mock(View.class);
        inEdges.add(edge);
        Mockito.when((Object)edge.getSourceNode()).thenReturn((Object)sourceNode);
        Mockito.when((Object)sourceNode.getContent()).thenReturn((Object)sourceView);
        Mockito.when((Object)node.getInEdges()).thenReturn(inEdges);
        Mockito.when((Object)edge.getContent()).thenReturn((Object)viewConnector);
        Mockito.when((Object)viewConnector.getControlPoints()).thenReturn((Object)new ControlPoint[0]);
        Mockito.when((Object)sourceConnection.isAuto()).thenReturn((Object)true);
        Mockito.when((Object)targetConnection.isAuto()).thenReturn((Object)true);
        Mockito.when((Object)diagram.getName()).thenReturn((Object)"dmnEdge");
        Mockito.when((Object)definitionsStunnerPojo.getDefaultNamespace()).thenReturn((Object)"org.edge");
        Mockito.when((Object)viewConnector.getSourceConnection()).thenReturn(Optional.of(sourceConnection));
        Mockito.when((Object)viewConnector.getTargetConnection()).thenReturn(Optional.of(targetConnection));
        dmnMarshaller.connect(diagram, dmnDiagramElementIds, definitionsStunnerPojo, dmnEdges, node, view);
        Mockito.when((Object)viewConnector.getSourceConnection()).thenReturn(Optional.empty());
        Mockito.when((Object)viewConnector.getTargetConnection()).thenReturn(Optional.empty());
        dmnMarshaller.connect(diagram, dmnDiagramElementIds, definitionsStunnerPojo, dmnEdges, node, view);
        Mockito.when((Object)viewConnector.getSourceConnection()).thenReturn(Optional.of(sourceConnection));
        Mockito.when((Object)viewConnector.getTargetConnection()).thenReturn(Optional.empty());
        dmnMarshaller.connect(diagram, dmnDiagramElementIds, definitionsStunnerPojo, dmnEdges, node, view);
        ((DiscreteConnection)Mockito.verify((Object)sourceConnection)).isAuto();
        ((DiscreteConnection)Mockito.verify((Object)targetConnection)).isAuto();
    }

    private JSITDecision makeDecision(String id) {
        JSITDecision decision = (JSITDecision)Mockito.spy((Object)new JSITDecision());
        ((JSITDecision)Mockito.doReturn((Object)id).when((Object)decision)).getId();
        return decision;
    }

    private JSITBusinessKnowledgeModel makeBusinessKnowledgeModel(String id) {
        JSITBusinessKnowledgeModel businessKnowledgeModel = (JSITBusinessKnowledgeModel)Mockito.spy((Object)new JSITBusinessKnowledgeModel());
        ((JSITBusinessKnowledgeModel)Mockito.doReturn((Object)id).when((Object)businessKnowledgeModel)).getId();
        return businessKnowledgeModel;
    }

    private JSITKnowledgeSource makeKnowledgeSource(String id) {
        JSITKnowledgeSource knowledgeSource = (JSITKnowledgeSource)Mockito.spy((Object)new JSITKnowledgeSource());
        ((JSITKnowledgeSource)Mockito.doReturn((Object)id).when((Object)knowledgeSource)).getId();
        return knowledgeSource;
    }

    private <T> boolean setList(List<T> list, InvocationOnMock e) {
        ArrayList argument = new ArrayList((ArrayList)e.getArguments()[0]);
        list.clear();
        list.addAll(argument);
        return true;
    }

    private <T> boolean addAll(List<T> list, InvocationOnMock e) {
        Object argument = e.getArguments()[0];
        list.add(argument);
        return true;
    }
}

