/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.InformationRequirement;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeConnector;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntry;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIPoint;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElementReference;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNEdge;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class NodeConnectorTest {
    @Mock
    private FactoryManager factoryManager;
    @Mock
    private JSITDMNElement jsiDMNElement;
    @Mock
    private JSITDMNElementReference jsiDMNElementReference;
    @Mock
    private NodeEntry nodeEntry;
    @Mock
    private Node currentNode;
    @Mock
    private Node requiredNode;
    private NodeConnector nodeConnector;
    private String connectorTypeId = BindableAdapterUtils.getDefinitionId(InformationRequirement.class);
    private Map<String, List<NodeEntry>> entriesById = new HashMap<String, List<NodeEntry>>();
    private List<JSIDMNEdge> edges = new ArrayList<JSIDMNEdge>();
    private String diagramId = "diagramId";
    private boolean isDMNDIPresent = false;

    @Before
    public void setup() {
        this.nodeConnector = (NodeConnector)Mockito.spy((Object)new NodeConnector(this.factoryManager));
    }

    @Test
    public void testConnectEdgeToNodesWhenDMNDIIsNotPresent() {
        JSIDMNEdge newEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Mockito.when((Object)this.jsiDMNElementReference.getHref()).thenReturn((Object)"#123");
        Mockito.when((Object)this.jsiDMNElement.getId()).thenReturn((Object)"789");
        Mockito.when((Object)this.nodeEntry.getNode()).thenReturn((Object)this.requiredNode);
        ((NodeConnector)Mockito.doReturn((Object)"456").when((Object)this.nodeConnector)).uuid();
        ((NodeConnector)Mockito.doReturn((Object)newEdge).when((Object)this.nodeConnector)).newEdge();
        ((NodeConnector)Mockito.doNothing().when((Object)this.nodeConnector)).connectWbEdge((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.entriesById.put("123", Collections.singletonList(this.nodeEntry));
        this.isDMNDIPresent = false;
        this.nodeConnector.connectEdgeToNodes(this.connectorTypeId, this.jsiDMNElement, this.jsiDMNElementReference, this.entriesById, this.diagramId, this.edges, this.isDMNDIPresent, this.currentNode);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector)).connectWbEdge((String)ArgumentMatchers.eq((Object)this.connectorTypeId), (String)ArgumentMatchers.eq((Object)this.diagramId), (Node)ArgumentMatchers.eq((Object)this.currentNode), (Node)ArgumentMatchers.eq((Object)this.requiredNode), (JSIDMNEdge)ArgumentMatchers.eq((Object)newEdge), (String)ArgumentMatchers.eq((Object)"456"));
    }

    @Test
    public void testConnectEdgeToNodesWhenDMNDIIsPresent() {
        JSIDMNEdge existingEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Mockito.when((Object)this.jsiDMNElementReference.getHref()).thenReturn((Object)"#123");
        Mockito.when((Object)this.jsiDMNElement.getId()).thenReturn((Object)"789");
        Mockito.when((Object)existingEdge.getDmnElementRef()).thenReturn((Object)new QName("", "789"));
        ((NodeConnector)Mockito.doReturn((Object)this.requiredNode).when((Object)this.nodeConnector)).getNode((JSIDMNEdge)ArgumentMatchers.eq((Object)existingEdge), (List)ArgumentMatchers.any());
        ((NodeConnector)Mockito.doNothing().when((Object)this.nodeConnector)).connectWbEdge((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.entriesById.put("123", Collections.singletonList(this.nodeEntry));
        this.edges.add(existingEdge);
        this.isDMNDIPresent = true;
        this.nodeConnector.connectEdgeToNodes(this.connectorTypeId, this.jsiDMNElement, this.jsiDMNElementReference, this.entriesById, this.diagramId, this.edges, this.isDMNDIPresent, this.currentNode);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector)).connectWbEdge((String)ArgumentMatchers.eq((Object)this.connectorTypeId), (String)ArgumentMatchers.eq((Object)this.diagramId), (Node)ArgumentMatchers.eq((Object)this.currentNode), (Node)ArgumentMatchers.eq((Object)this.requiredNode), (JSIDMNEdge)ArgumentMatchers.eq((Object)existingEdge), (String)ArgumentMatchers.eq((Object)"789"));
    }

    @Test
    public void testConnectEdgeToNodesWhenDMNDIIsPresentButExistingNodeIsNotPresent() {
        Mockito.when((Object)this.jsiDMNElementReference.getHref()).thenReturn((Object)"#123");
        Mockito.when((Object)this.jsiDMNElement.getId()).thenReturn((Object)"789");
        ((NodeConnector)Mockito.doNothing().when((Object)this.nodeConnector)).connectWbEdge((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.entriesById.put("123", Collections.singletonList(this.nodeEntry));
        this.isDMNDIPresent = true;
        this.nodeConnector.connectEdgeToNodes(this.connectorTypeId, this.jsiDMNElement, this.jsiDMNElementReference, this.entriesById, this.diagramId, this.edges, this.isDMNDIPresent, this.currentNode);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector, (VerificationMode)Mockito.never())).connectWbEdge((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testConnectEdgeToNodesWhenNodeEntriesIsEmpty() {
        Mockito.when((Object)this.jsiDMNElementReference.getHref()).thenReturn((Object)"#123");
        this.entriesById.put("123", new ArrayList());
        this.nodeConnector.connectEdgeToNodes(this.connectorTypeId, this.jsiDMNElement, this.jsiDMNElementReference, this.entriesById, this.diagramId, this.edges, this.isDMNDIPresent, this.currentNode);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector, (VerificationMode)Mockito.never())).connectWbEdge((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testConnectEdgeToNodesWhenNodeEntriesIsNull() {
        Mockito.when((Object)this.jsiDMNElementReference.getHref()).thenReturn((Object)"#456");
        this.nodeConnector.connectEdgeToNodes(this.connectorTypeId, this.jsiDMNElement, this.jsiDMNElementReference, this.entriesById, this.diagramId, this.edges, this.isDMNDIPresent, this.currentNode);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector, (VerificationMode)Mockito.never())).connectWbEdge((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testConnectWbEdge() {
        JSIDMNEdge edge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Element element = (Element)Mockito.mock(Element.class);
        String id = "123";
        Edge wbEdge = (Edge)Mockito.mock(Edge.class);
        ViewConnector viewConnector = (ViewConnector)Mockito.mock(ViewConnector.class);
        Mockito.when((Object)this.factoryManager.newElement("diagramId#123", this.connectorTypeId)).thenReturn((Object)element);
        Mockito.when((Object)element.asEdge()).thenReturn((Object)wbEdge);
        Mockito.when((Object)wbEdge.getContent()).thenReturn((Object)viewConnector);
        ((NodeConnector)Mockito.doNothing().when((Object)this.nodeConnector)).connectEdge((Edge)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any());
        ((NodeConnector)Mockito.doNothing().when((Object)this.nodeConnector)).setConnectionMagnets((Edge)ArgumentMatchers.any(), (ViewConnector)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any());
        this.nodeConnector.connectWbEdge(this.connectorTypeId, this.diagramId, this.currentNode, this.requiredNode, edge, "123");
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector)).connectEdge(wbEdge, this.requiredNode, this.currentNode);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector)).setConnectionMagnets(wbEdge, viewConnector, edge);
    }

    @Test
    public void testSetConnectionMagnets() {
        Edge edge = (Edge)Mockito.mock(Edge.class);
        ViewConnector viewConnector = (ViewConnector)Mockito.mock(ViewConnector.class);
        JSIDMNEdge jsidmnEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Node sourceNode = (Node)Mockito.mock(Node.class);
        Node targetNode = (Node)Mockito.mock(Node.class);
        View view = (View)Mockito.mock(View.class);
        Bounds bounds = (Bounds)Mockito.mock(Bounds.class);
        JSIPoint start = (JSIPoint)Mockito.mock(JSIPoint.class);
        JSIPoint waypoint = (JSIPoint)Mockito.mock(JSIPoint.class);
        JSIPoint end = (JSIPoint)Mockito.mock(JSIPoint.class);
        ArrayList<JSIPoint> waypoints = new ArrayList<JSIPoint>();
        waypoints.add(start);
        waypoints.add(waypoint);
        waypoints.add(end);
        NodeConnector nodeConnector = (NodeConnector)Mockito.mock(NodeConnector.class);
        ((NodeConnector)Mockito.doCallRealMethod().when((Object)nodeConnector)).setConnectionMagnets((Edge)ArgumentMatchers.eq((Object)edge), (ViewConnector)ArgumentMatchers.eq((Object)viewConnector), (JSIDMNEdge)ArgumentMatchers.eq((Object)jsidmnEdge));
        Mockito.when((Object)jsidmnEdge.getWaypoint()).thenReturn(waypoints);
        Mockito.when((Object)jsidmnEdge.getId()).thenReturn((Object)"-AUTO-SOURCE-AUTO-TARGET");
        Mockito.when((Object)edge.getSourceNode()).thenReturn((Object)sourceNode);
        Mockito.when((Object)edge.getTargetNode()).thenReturn((Object)targetNode);
        Mockito.when((Object)sourceNode.getContent()).thenReturn((Object)view);
        Mockito.when((Object)targetNode.getContent()).thenReturn((Object)view);
        Mockito.when((Object)view.getBounds()).thenReturn((Object)bounds);
        Mockito.when((Object)bounds.getWidth()).thenReturn((Object)0.0);
        Mockito.when((Object)bounds.getHeight()).thenReturn((Object)0.0);
        Mockito.when((Object)start.getX()).thenReturn((Object)0.0);
        Mockito.when((Object)start.getY()).thenReturn((Object)0.0);
        Mockito.when((Object)waypoint.getX()).thenReturn((Object)1.0);
        Mockito.when((Object)waypoint.getY()).thenReturn((Object)1.0);
        Mockito.when((Object)start.getX()).thenReturn((Object)1.0);
        Mockito.when((Object)start.getY()).thenReturn((Object)1.0);
        nodeConnector.setConnectionMagnets(edge, viewConnector, jsidmnEdge);
        ((NodeConnector)Mockito.verify((Object)nodeConnector)).isSourceAutoConnectionEdge(jsidmnEdge);
        ((NodeConnector)Mockito.verify((Object)nodeConnector)).isTargetAutoConnectionEdge(jsidmnEdge);
        ((ViewConnector)Mockito.verify((Object)viewConnector)).setControlPoints((ControlPoint[])ArgumentMatchers.any());
    }

    @Test
    public void testIsSourceAutoConnectionEdge() {
        String edgeId = "edge-name";
        JSIDMNEdge edge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Mockito.when((Object)edge.getId()).thenReturn((Object)edgeId);
        Assert.assertFalse((boolean)this.nodeConnector.isSourceAutoConnectionEdge(edge));
        Mockito.when((Object)edge.getId()).thenReturn((Object)(edgeId + "-AUTO-SOURCE"));
        Assert.assertTrue((boolean)this.nodeConnector.isSourceAutoConnectionEdge(edge));
    }

    @Test
    public void testIsTargetAutoConnectionEdge() {
        String edgeId = "edge-name";
        JSIDMNEdge edge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Mockito.when((Object)edge.getId()).thenReturn((Object)edgeId);
        Assert.assertFalse((boolean)this.nodeConnector.isTargetAutoConnectionEdge(edge));
        Mockito.when((Object)edge.getId()).thenReturn((Object)(edgeId + "-AUTO-TARGET"));
        Assert.assertTrue((boolean)this.nodeConnector.isTargetAutoConnectionEdge(edge));
    }

    @Test
    public void testIsAutoConnection() {
        String id = "DMNEdge-ID";
        String autoConnectionID = "#AUTO-CONNECTION";
        JSIDMNEdge jsiDMNEdge1 = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Mockito.when((Object)jsiDMNEdge1.getId()).thenReturn((Object)id);
        JSIDMNEdge jsiDMNEdge2 = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Mockito.when((Object)jsiDMNEdge2.getId()).thenReturn((Object)(id + autoConnectionID));
        JSIDMNEdge jsiDMNEdge3 = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Mockito.when((Object)jsiDMNEdge3.getId()).thenReturn(null);
        Assert.assertFalse((boolean)this.nodeConnector.isAutoConnection(jsiDMNEdge1, autoConnectionID));
        Assert.assertTrue((boolean)this.nodeConnector.isAutoConnection(jsiDMNEdge2, autoConnectionID));
        Assert.assertFalse((boolean)this.nodeConnector.isAutoConnection(jsiDMNEdge3, autoConnectionID));
    }
}

