/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.property.dmn;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.property.dmn.DecisionParameterFieldRenderer;
import org.kie.workbench.common.dmn.client.property.dmn.DecisionParametersFieldDefinition;
import org.kie.workbench.common.dmn.client.widgets.decisionservice.parameters.DecisionServiceParametersListWidget;
import org.kie.workbench.common.forms.dynamic.client.rendering.formGroups.FormGroup;
import org.kie.workbench.common.forms.dynamic.client.rendering.formGroups.impl.def.DefaultFormGroup;
import org.kie.workbench.common.forms.dynamic.service.shared.RenderMode;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionParameterFieldRendererTest {
    @Mock
    private DecisionServiceParametersListWidget widget;
    @Mock
    private DefaultFormGroup formGroup;
    private DecisionParameterFieldRenderer renderer;

    @Before
    public void setup() {
        this.renderer = (DecisionParameterFieldRenderer)Mockito.spy((Object)new DecisionParameterFieldRenderer(this.widget));
        ((DecisionParameterFieldRenderer)Mockito.doReturn((Object)this.formGroup).when((Object)this.renderer)).getFormGroupInstance();
    }

    @Test
    public void testGetFormGroup() {
        RenderMode renderMode = RenderMode.EDIT_MODE;
        FormGroup actualGroup = this.renderer.getFormGroup(renderMode);
        ((DefaultFormGroup)Mockito.verify((Object)this.formGroup)).render((Widget)this.widget, this.renderer.getField());
        Assert.assertEquals((Object)this.formGroup, (Object)actualGroup);
    }

    @Test
    public void testSetReadOnly() {
        this.renderer.setReadOnly(true);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).setEnabled(false);
        this.renderer.setReadOnly(false);
        ((DecisionServiceParametersListWidget)Mockito.verify((Object)this.widget)).setEnabled(true);
    }

    @Test
    public void testSGetName() {
        String expected = DecisionParametersFieldDefinition.FIELD_TYPE.getTypeName();
        String actual = this.renderer.getName();
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

