/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.property.dmn;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.NameFieldType;
import org.kie.workbench.common.dmn.client.property.dmn.NameFieldDefinition;
import org.kie.workbench.common.dmn.client.property.dmn.NameFieldRenderer;
import org.kie.workbench.common.forms.dynamic.client.rendering.formGroups.impl.def.DefaultFormGroup;
import org.kie.workbench.common.forms.dynamic.service.shared.FormRenderingContext;
import org.kie.workbench.common.forms.dynamic.service.shared.RenderMode;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class NameFieldRendererTest {
    private static final String NAME = "name";
    @Mock
    private TextBox textBox;
    @Mock
    private FormRenderingContext context;
    @Mock
    private NameFieldDefinition definition;
    @Mock
    private ManagedInstance<DefaultFormGroup> formGroupInstance;
    @Mock
    private DefaultFormGroup formGroup;
    @Mock
    private ChangeEvent event;
    @Captor
    private ArgumentCaptor<ChangeHandler> changeHandlerArgumentCaptor;
    private NameFieldRenderer renderer;

    @Before
    public void setup() {
        NameFieldRenderer wrapped = new NameFieldRenderer(this.textBox){
            {
                this.formGroupsInstance = NameFieldRendererTest.this.formGroupInstance;
            }
        };
        this.renderer = (NameFieldRenderer)Mockito.spy((Object)wrapped);
        Mockito.when((Object)this.formGroupInstance.get()).thenReturn((Object)this.formGroup);
        Mockito.when((Object)this.definition.getFieldType()).thenReturn((Object)new NameFieldType());
    }

    @Test
    public void testChangeHandlerWithWhitespace() {
        Mockito.when((Object)this.textBox.getValue()).thenReturn((Object)"  name  ");
        ((TextBox)Mockito.verify((Object)this.textBox)).addChangeHandler((ChangeHandler)this.changeHandlerArgumentCaptor.capture());
        ChangeHandler changeHandler = (ChangeHandler)this.changeHandlerArgumentCaptor.getValue();
        changeHandler.onChange(this.event);
        ((TextBox)Mockito.verify((Object)this.textBox)).setValue((Object)NAME);
    }

    @Test
    public void testChangeHandlerWithoutWhitespace() {
        Mockito.when((Object)this.textBox.getValue()).thenReturn((Object)NAME);
        ((TextBox)Mockito.verify((Object)this.textBox)).addChangeHandler((ChangeHandler)this.changeHandlerArgumentCaptor.capture());
        ChangeHandler changeHandler = (ChangeHandler)this.changeHandlerArgumentCaptor.getValue();
        changeHandler.onChange(this.event);
        ((TextBox)Mockito.verify((Object)this.textBox, (VerificationMode)Mockito.never())).setValue((Object)NAME);
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)NameFieldDefinition.FIELD_TYPE.getTypeName(), (Object)this.renderer.getName());
    }

    @Test
    public void testGetFormGroupWhenEditMode() {
        this.renderer.init(this.context, (FieldDefinition)this.definition);
        this.assertFormGroup(RenderMode.EDIT_MODE, true);
    }

    @Test
    public void testGetFormGroupWhenReadOnlyMode() {
        Mockito.when((Object)this.definition.getReadOnly()).thenReturn((Object)true);
        this.renderer.init(this.context, (FieldDefinition)this.definition);
        this.assertFormGroup(RenderMode.READ_ONLY_MODE, false);
    }

    @Test
    public void testGetFormGroupWhenPrettyMode() {
        this.renderer.init(this.context, (FieldDefinition)this.definition);
        this.renderer.getFormGroup(RenderMode.PRETTY_MODE);
        ((DefaultFormGroup)Mockito.verify((Object)this.formGroup)).render((Widget)ArgumentMatchers.any(HTML.class), (FieldDefinition)ArgumentMatchers.eq((Object)this.definition));
    }

    private void assertFormGroup(RenderMode mode, boolean enabled) {
        this.renderer.getFormGroup(mode);
        ((TextBox)Mockito.verify((Object)this.textBox)).setEnabled(enabled);
        ((DefaultFormGroup)Mockito.verify((Object)this.formGroup)).render((String)Mockito.any(), (Widget)ArgumentMatchers.eq((Object)this.textBox), (FieldDefinition)ArgumentMatchers.eq((Object)this.definition));
    }

    @Test
    public void testSetReadOnly() {
        this.renderer.setReadOnly(false);
        ((TextBox)Mockito.verify((Object)this.textBox)).setEnabled(true);
        this.renderer.setReadOnly(true);
        ((TextBox)Mockito.verify((Object)this.textBox)).setEnabled(false);
    }

    @Test
    public void testConverterModelType() {
        Assert.assertEquals(Name.class, (Object)this.renderer.getConverter().getModelType());
    }

    @Test
    public void testConverterComponentType() {
        Assert.assertEquals(String.class, (Object)this.renderer.getConverter().getComponentType());
    }

    @Test
    public void testConverterToModelValue() {
        Assert.assertEquals((Object)new Name(NAME), (Object)this.renderer.getConverter().toModelValue((Object)NAME));
    }

    @Test
    public void testConverterToWidgetValue() {
        Assert.assertEquals((Object)NAME, (Object)this.renderer.getConverter().toWidgetValue((Object)new Name(NAME)));
    }
}

