/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.session;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorControl;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayerControl;
import org.kie.workbench.common.dmn.client.widgets.layer.MousePanMediatorControl;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanelControl;
import org.kie.workbench.common.stunner.core.client.ManagedInstanceStub;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.MediatorsControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.MultipleSelection;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ManagedSession;
import org.kie.workbench.common.stunner.core.client.session.impl.SessionLoader;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.preferences.StunnerPreferences;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public abstract class BaseDMNSessionTest<S extends AbstractSession<AbstractCanvas, AbstractCanvasHandler>> {
    @Mock
    protected CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager;
    @Mock
    protected Metadata metadata;
    @Mock
    protected Command callback;
    @Mock
    protected DefinitionUtils definitionUtils;
    @Mock
    protected SessionLoader sessionLoader;
    @Mock
    protected StunnerPreferences stunnerPreferences;
    @Mock
    protected AbstractCanvas canvas;
    @Mock
    protected AbstractCanvasHandler canvasHandler;
    @Mock
    protected MediatorsControl mediatorsControl;
    @Mock
    protected SelectionControl selectionControl;
    @Mock
    protected ExpressionGridCache expressionGridCache;
    @Mock
    protected DMNGridLayerControl gridLayerControl;
    @Mock
    protected DMNGridLayer gridLayer;
    @Mock
    protected DMNGridPanelControl gridPanelControl;
    @Mock
    protected DMNGridPanel gridPanel;
    @Mock
    protected CellEditorControl cellEditorControl;
    @Mock
    protected CellEditorControls cellEditorControls;
    @Mock
    protected MousePanMediatorControl mousePanMediatorControl;
    @Mock
    protected RestrictedMousePanMediator mousePanMediator;
    @Mock
    protected ExpressionEditorControl expressionEditorControl;
    @Mock
    protected ExpressionEditorView.Presenter expressionEditor;
    protected ManagedSession managedSession;
    protected ManagedInstance<AbstractCanvas> canvasInstances;
    protected ManagedInstance<AbstractCanvasHandler> canvasHandlerInstances;
    protected ManagedInstance<CanvasControl<AbstractCanvas>> canvasControlInstances;
    protected ManagedInstance<CanvasControl<AbstractCanvasHandler>> canvasHandlerControlInstances;
    protected S session;
    protected Map<CanvasControl, Class> canvasControlRegistrations;
    protected Map<CanvasControl, Class> canvasHandlerControlRegistrations;

    @Before
    public void setup() {
        this.canvasInstances = new ManagedInstanceStub((Object[])new AbstractCanvas[]{this.canvas});
        this.canvasHandlerInstances = new ManagedInstanceStub((Object[])new AbstractCanvasHandler[]{this.canvasHandler});
        this.canvasControlRegistrations = new HashMap<CanvasControl, Class>();
        this.canvasControlRegistrations.putAll(this.getCanvasControlRegistrations());
        this.canvasControlRegistrations.put((CanvasControl)this.mediatorsControl, MediatorsControl.class);
        this.canvasControlRegistrations.put((CanvasControl)this.expressionGridCache, ExpressionGridCache.class);
        this.canvasControlRegistrations.put((CanvasControl)this.gridLayerControl, DMNGridLayerControl.class);
        this.canvasControlRegistrations.put((CanvasControl)this.gridPanelControl, DMNGridPanelControl.class);
        this.canvasControlRegistrations.put((CanvasControl)this.cellEditorControl, CellEditorControl.class);
        this.canvasControlRegistrations.put((CanvasControl)this.mousePanMediatorControl, MousePanMediatorControl.class);
        this.canvasControlRegistrations.put((CanvasControl)this.expressionEditorControl, ExpressionEditorControl.class);
        Mockito.when((Object)this.gridLayerControl.getGridLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.gridPanelControl.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.cellEditorControl.getCellEditorControls()).thenReturn((Object)this.cellEditorControls);
        Mockito.when((Object)this.mousePanMediatorControl.getMousePanMediator()).thenReturn((Object)this.mousePanMediator);
        Mockito.when((Object)this.expressionEditorControl.getExpressionEditor()).thenReturn((Object)this.expressionEditor);
        CanvasControl[] canvasControls = new CanvasControl[]{};
        this.canvasControlInstances = (ManagedInstance)Mockito.spy((Object)new ManagedInstanceStub((Object[])this.canvasControlRegistrations.keySet().toArray(canvasControls)));
        this.canvasControlRegistrations.entrySet().forEach(e -> Mockito.when((Object)this.canvasControlInstances.select((Class)ArgumentMatchers.eq(e.getValue()), new Annotation[]{(Annotation)Mockito.anyVararg()})).thenReturn((Object)new ManagedInstanceStub((Object[])new CanvasControl[]{(CanvasControl)e.getKey()})));
        this.canvasHandlerControlRegistrations = new HashMap<CanvasControl, Class>();
        this.canvasHandlerControlRegistrations.putAll(this.getCanvasHandlerControlRegistrations());
        this.canvasHandlerControlRegistrations.put((CanvasControl)this.selectionControl, SelectionControl.class);
        CanvasControl[] canvasHandlerControls = new CanvasControl[]{};
        this.canvasHandlerControlInstances = (ManagedInstance)Mockito.spy((Object)new ManagedInstanceStub((Object[])this.canvasHandlerControlRegistrations.keySet().toArray(canvasHandlerControls)));
        this.canvasHandlerControlRegistrations.entrySet().forEach(e -> Mockito.when((Object)this.canvasHandlerControlInstances.select((Class)ArgumentMatchers.eq(e.getValue()), new Annotation[]{(Annotation)Mockito.anyVararg()})).thenReturn((Object)new ManagedInstanceStub((Object[])new CanvasControl[]{(CanvasControl)e.getKey()})));
        this.managedSession = (ManagedSession)Mockito.spy((Object)new ManagedSession(this.definitionUtils, this.sessionLoader, this.canvasInstances, this.canvasHandlerInstances, this.canvasControlInstances, this.canvasHandlerControlInstances));
        this.session = this.getSession();
        ((SessionLoader)Mockito.doAnswer(i -> {
            ParameterizedCommand callback = (ParameterizedCommand)i.getArguments()[1];
            callback.execute((Object)this.stunnerPreferences);
            return null;
        }).when((Object)this.sessionLoader)).load((Metadata)ArgumentMatchers.eq((Object)this.metadata), (ParameterizedCommand)ArgumentMatchers.any(ParameterizedCommand.class), (ParameterizedCommand)ArgumentMatchers.any(ParameterizedCommand.class));
    }

    protected abstract S getSession();

    protected abstract Map<CanvasControl, Class> getCanvasControlRegistrations();

    protected abstract Map<CanvasControl, Class> getCanvasHandlerControlRegistrations();

    @Test
    public void testInit() {
        this.session.init(this.metadata, this.callback);
        this.canvasControlRegistrations.values().forEach(c -> ((ManagedSession)Mockito.verify((Object)this.managedSession)).registerCanvasControl((Class)ArgumentMatchers.eq((Object)c)));
        this.canvasHandlerControlRegistrations.values().forEach(c -> ((ManagedSession)Mockito.verify((Object)this.managedSession)).registerCanvasHandlerControl((Class)ArgumentMatchers.eq((Object)c), (Class)Mockito.any()));
        this.assertInitQualifiers();
        ((ManagedSession)Mockito.verify((Object)this.managedSession)).init((Metadata)ArgumentMatchers.eq((Object)this.metadata), (Command)ArgumentMatchers.eq((Object)this.callback));
    }

    protected void assertInitQualifiers() {
        ((ManagedSession)Mockito.verify((Object)this.managedSession)).registerCanvasHandlerControl((Class)ArgumentMatchers.eq(SelectionControl.class), (Class)ArgumentMatchers.eq(MultipleSelection.class));
    }

    @Test
    public void testDestroy() {
        this.session.init(this.metadata, this.callback);
        this.session.destroy();
        this.canvasControlRegistrations.keySet().forEach(r -> ((CanvasControl)Mockito.verify((Object)r)).destroy());
        this.canvasHandlerControlRegistrations.keySet().forEach(r -> ((CanvasControl)Mockito.verify((Object)r)).destroy());
    }

    @Test
    public void testGetExpressionGridCache() {
        this.session.init(this.metadata, this.callback);
        Assert.assertEquals((Object)this.expressionGridCache, (Object)((DMNSession)this.session).getExpressionGridCache());
    }

    @Test
    public void testGetGridPanel() {
        this.session.init(this.metadata, this.callback);
        Assert.assertEquals((Object)this.gridPanel, (Object)((DMNSession)this.session).getGridPanel());
    }

    @Test
    public void testGetGridLayer() {
        this.session.init(this.metadata, this.callback);
        Assert.assertEquals((Object)this.gridLayer, (Object)((DMNSession)this.session).getGridLayer());
    }

    @Test
    public void testGetCellEditorControls() {
        this.session.init(this.metadata, this.callback);
        Assert.assertEquals((Object)this.cellEditorControls, (Object)((DMNSession)this.session).getCellEditorControls());
    }

    @Test
    public void testGetMousePanMediator() {
        this.session.init(this.metadata, this.callback);
        Assert.assertEquals((Object)this.mousePanMediator, (Object)((DMNSession)this.session).getMousePanMediator());
    }

    @Test
    public void testGetExpressionEditor() {
        this.session.init(this.metadata, this.callback);
        Assert.assertEquals((Object)this.expressionEditor, (Object)((DMNSession)this.session).getExpressionEditor());
    }
}

