/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.codecompletion;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELSuggestions;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.FEELLanguageService;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.Variable;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class MonacoFEELSuggestionsTest {
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private FEELLanguageService feelLanguageService;
    @Captor
    private ArgumentCaptor<List<Variable>> variablesArgumentCaptor;
    private MonacoFEELSuggestions monacoFEELSuggestions;

    @Before
    public void setup() {
        this.monacoFEELSuggestions = (MonacoFEELSuggestions)Mockito.spy((Object)new MonacoFEELSuggestions(this.dmnGraphUtils, this.feelLanguageService));
    }

    @Test
    public void getSuggestions() {
        String expectedNodeName1 = "Decision-1";
        String expectedNodeName2 = "Decision-2";
        String expectedNodeName3 = "Decision-3";
        String expectedNodeName4 = "Decision-4";
        String expectedNodeName5 = "Decision-5";
        String expectedNodeName6 = "Decision-6";
        String expression = "1 +";
        FEELLanguageService.Position position = new FEELLanguageService.Position(1, 1);
        ArrayList expectedCandidates = new ArrayList();
        Stream<Node> nodeStream = Stream.of(this.makeDecisionNode("Decision-1", org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.NUMBER), this.makeDecisionNode("Decision-2", org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.STRING), this.makeDecisionNode("Decision-3", org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.DATE), this.makeDecisionNode("Decision-4", org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.BOOLEAN), this.makeDecisionNode("Decision-5", org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType.CONTEXT), this.makeDecisionNode("Decision-6", null));
        Mockito.when((Object)this.dmnGraphUtils.getNodeStream()).thenReturn(nodeStream);
        Mockito.when((Object)this.feelLanguageService.getCandidates((String)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (FEELLanguageService.Position)ArgumentMatchers.any())).thenReturn(expectedCandidates);
        List actualSuggestions = this.monacoFEELSuggestions.getCandidates("1 +", position);
        ((FEELLanguageService)Mockito.verify((Object)this.feelLanguageService)).getCandidates((String)ArgumentMatchers.eq((Object)"1 +"), (List)this.variablesArgumentCaptor.capture(), (FEELLanguageService.Position)ArgumentMatchers.eq((Object)position));
        List actualVariables = (List)this.variablesArgumentCaptor.getValue();
        Assert.assertSame(expectedCandidates, (Object)actualSuggestions);
        Assert.assertEquals((long)6L, (long)actualVariables.size());
        Assert.assertEquals((Object)"Decision-1", (Object)((Variable)actualVariables.get(0)).getName());
        Assert.assertEquals((Object)"Decision-2", (Object)((Variable)actualVariables.get(1)).getName());
        Assert.assertEquals((Object)"Decision-3", (Object)((Variable)actualVariables.get(2)).getName());
        Assert.assertEquals((Object)"Decision-4", (Object)((Variable)actualVariables.get(3)).getName());
        Assert.assertEquals((Object)"Decision-5", (Object)((Variable)actualVariables.get(4)).getName());
        Assert.assertEquals((Object)"Decision-6", (Object)((Variable)actualVariables.get(5)).getName());
        Assert.assertEquals((Object)BuiltInType.NUMBER, (Object)((Variable)actualVariables.get(0)).getType());
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)((Variable)actualVariables.get(1)).getType());
        Assert.assertEquals((Object)BuiltInType.DATE, (Object)((Variable)actualVariables.get(2)).getType());
        Assert.assertEquals((Object)BuiltInType.BOOLEAN, (Object)((Variable)actualVariables.get(3)).getType());
        Assert.assertEquals((Object)BuiltInType.CONTEXT, (Object)((Variable)actualVariables.get(4)).getType());
        Assert.assertEquals((Object)BuiltInType.UNKNOWN, (Object)((Variable)actualVariables.get(5)).getType());
    }

    private NodeImpl<Definition<Decision>> makeDecisionNode(String name, org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType builtInType) {
        NodeImpl<Definition<Decision>> node = this.makeNodeImpl();
        Definition<Decision> definition = this.makeDefinition();
        Decision decision = (Decision)Mockito.spy((Object)new Decision());
        InformationItemPrimary informationItemPrimary = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        QName qName = builtInType == null ? null : new QName(builtInType);
        Mockito.when((Object)informationItemPrimary.getTypeRef()).thenReturn((Object)qName);
        Mockito.when((Object)node.getContent()).thenReturn(definition);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)decision);
        decision.setName(new Name(name));
        decision.setVariable(informationItemPrimary);
        return node;
    }

    @Test
    public void getSuggestionsWhenFEELLanguageServiceFails() {
        Mockito.when((Object)this.feelLanguageService.getCandidates((String)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (FEELLanguageService.Position)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException()});
        ((MonacoFEELSuggestions)Mockito.doNothing().when((Object)this.monacoFEELSuggestions)).warn((String)ArgumentMatchers.any());
        List candidates = this.monacoFEELSuggestions.getCandidates(null, null);
        ((MonacoFEELSuggestions)Mockito.verify((Object)this.monacoFEELSuggestions)).warn("[FEELLanguageService] Error: Candidates could not be processed.");
        Assert.assertTrue((boolean)candidates.isEmpty());
    }

    private NodeImpl<Definition<Decision>> makeNodeImpl() {
        return (NodeImpl)Mockito.mock(NodeImpl.class);
    }

    private Definition<Decision> makeDefinition() {
        return (Definition)Mockito.mock(Definition.class);
    }
}

