/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.codecompletion;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONBoolean;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.core.JsRegExp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoPropertiesFactory;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoSuggestionsPropertyFactory;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.FEELLanguageService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.views.pfly.monaco.jsinterop.ITextModel;
import org.uberfire.client.views.pfly.monaco.jsinterop.MonacoLanguages;
import org.uberfire.client.views.pfly.monaco.jsinterop.Position;

@RunWith(value=GwtMockitoTestRunner.class)
public class MonacoPropertiesFactoryTest {
    private MonacoPropertiesFactory factory;
    @Mock
    private MonacoSuggestionsPropertyFactory suggestionsPropertyFactory;

    @Before
    public void setup() {
        this.factory = (MonacoPropertiesFactory)Mockito.spy((Object)new MonacoPropertiesFactory());
    }

    @Test
    public void testGetConstructionOptions() {
        JSONObject options = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject scrollbar = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject miniMap = (JSONObject)Mockito.mock(JSONObject.class);
        JSONString language = (JSONString)Mockito.mock(JSONString.class);
        JSONString theme = (JSONString)Mockito.mock(JSONString.class);
        JSONString renderLineHighlight = (JSONString)Mockito.mock(JSONString.class);
        JSONString lineNumbers = (JSONString)Mockito.mock(JSONString.class);
        JSONBoolean overviewRulerBorder = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean scrollBeyondLastLine = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean snippetSuggestions = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean useTabStops = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean contextmenu = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean folding = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean enabled = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean useShadows = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONValue fontSize = (JSONValue)Mockito.mock(JSONValue.class);
        JSONValue lineNumbersMinChars = (JSONValue)Mockito.mock(JSONValue.class);
        JSONValue lineDecorationsWidth = (JSONValue)Mockito.mock(JSONValue.class);
        JSONBoolean automaticLayout = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean renderWhitespace = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONBoolean hideCursorInOverviewRuler = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JavaScriptObject expectedOptions = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)language).when((Object)this.factory)).makeJSONString("feel-language");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)theme).when((Object)this.factory)).makeJSONString("feel-theme");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)renderLineHighlight).when((Object)this.factory)).makeJSONString("none");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)lineNumbers).when((Object)this.factory)).makeJSONString("off");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)fontSize).when((Object)this.factory)).makeJSONNumber(12);
        Mockito.when((Object)options.getJavaScriptObject()).thenReturn((Object)expectedOptions);
        Mockito.when((Object)this.factory.makeJSONObject()).thenReturn((Object)options, (Object[])new JSONObject[]{scrollbar, miniMap});
        Mockito.when((Object)this.factory.makeJSONNumber(1)).thenReturn((Object)lineNumbersMinChars, (Object[])new JSONValue[]{lineDecorationsWidth});
        Mockito.when((Object)this.factory.makeJSONBoolean(false)).thenReturn((Object)overviewRulerBorder, (Object[])new JSONBoolean[]{scrollBeyondLastLine, snippetSuggestions, useTabStops, contextmenu, folding, enabled, useShadows});
        Mockito.when((Object)this.factory.makeJSONBoolean(true)).thenReturn((Object)automaticLayout, (Object[])new JSONBoolean[]{renderWhitespace, hideCursorInOverviewRuler});
        JavaScriptObject actualOptions = this.factory.getConstructionOptions();
        ((JSONObject)Mockito.verify((Object)options)).put("language", (JSONValue)language);
        ((JSONObject)Mockito.verify((Object)options)).put("theme", (JSONValue)theme);
        ((JSONObject)Mockito.verify((Object)options)).put("renderLineHighlight", (JSONValue)renderLineHighlight);
        ((JSONObject)Mockito.verify((Object)options)).put("fontSize", fontSize);
        ((JSONObject)Mockito.verify((Object)options)).put("lineNumbersMinChars", lineNumbersMinChars);
        ((JSONObject)Mockito.verify((Object)options)).put("lineDecorationsWidth", lineDecorationsWidth);
        ((JSONObject)Mockito.verify((Object)options)).put("overviewRulerBorder", (JSONValue)overviewRulerBorder);
        ((JSONObject)Mockito.verify((Object)options)).put("scrollBeyondLastLine", (JSONValue)scrollBeyondLastLine);
        ((JSONObject)Mockito.verify((Object)options)).put("snippetSuggestions", (JSONValue)snippetSuggestions);
        ((JSONObject)Mockito.verify((Object)options)).put("useTabStops", (JSONValue)useTabStops);
        ((JSONObject)Mockito.verify((Object)options)).put("contextmenu", (JSONValue)contextmenu);
        ((JSONObject)Mockito.verify((Object)options)).put("folding", (JSONValue)folding);
        ((JSONObject)Mockito.verify((Object)miniMap)).put("enabled", (JSONValue)enabled);
        ((JSONObject)Mockito.verify((Object)scrollbar)).put("useShadows", (JSONValue)useShadows);
        ((JSONObject)Mockito.verify((Object)options)).put("automaticLayout", (JSONValue)automaticLayout);
        ((JSONObject)Mockito.verify((Object)options)).put("renderWhitespace", (JSONValue)renderWhitespace);
        ((JSONObject)Mockito.verify((Object)options)).put("hideCursorInOverviewRuler", (JSONValue)hideCursorInOverviewRuler);
        Assert.assertEquals((Object)expectedOptions, (Object)actualOptions);
    }

    @Test
    public void testGetThemeData() {
        JSONObject themeDefinition = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject colors = (JSONObject)Mockito.mock(JSONObject.class);
        JSONString colorHEXCode = (JSONString)Mockito.mock(JSONString.class);
        JSONString base = (JSONString)Mockito.mock(JSONString.class);
        JSONBoolean inherit = (JSONBoolean)Mockito.mock(JSONBoolean.class);
        JSONArray rules = (JSONArray)Mockito.mock(JSONArray.class);
        JavaScriptObject expectedEditorThemeData = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)colorHEXCode).when((Object)this.factory)).makeJSONString("#000000");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)base).when((Object)this.factory)).makeJSONString("vs");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)inherit).when((Object)this.factory)).makeJSONBoolean(false);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)rules).when((Object)this.factory)).getRules();
        Mockito.when((Object)themeDefinition.getJavaScriptObject()).thenReturn((Object)expectedEditorThemeData);
        Mockito.when((Object)this.factory.makeJSONObject()).thenReturn((Object)themeDefinition, (Object[])new JSONObject[]{colors});
        JavaScriptObject actualEditorThemeData = this.factory.getThemeData();
        ((JSONObject)Mockito.verify((Object)colors)).put("editorLineNumber.foreground", (JSONValue)colorHEXCode);
        ((JSONObject)Mockito.verify((Object)themeDefinition)).put("base", (JSONValue)base);
        ((JSONObject)Mockito.verify((Object)themeDefinition)).put("inherit", (JSONValue)inherit);
        ((JSONObject)Mockito.verify((Object)themeDefinition)).put("rules", (JSONValue)rules);
        ((JSONObject)Mockito.verify((Object)themeDefinition)).put("colors", (JSONValue)colors);
        Assert.assertEquals((Object)expectedEditorThemeData, (Object)actualEditorThemeData);
    }

    @Test
    public void testGetRules() {
        JSONObject rule1 = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject rule2 = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject rule3 = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject rule4 = (JSONObject)Mockito.mock(JSONObject.class);
        JSONObject rule5 = (JSONObject)Mockito.mock(JSONObject.class);
        JSONString token1 = (JSONString)Mockito.mock(JSONString.class);
        JSONString foreground1 = (JSONString)Mockito.mock(JSONString.class);
        JSONString token2 = (JSONString)Mockito.mock(JSONString.class);
        JSONString foreground2 = (JSONString)Mockito.mock(JSONString.class);
        JSONString token3 = (JSONString)Mockito.mock(JSONString.class);
        JSONString foreground3 = (JSONString)Mockito.mock(JSONString.class);
        JSONString token4 = (JSONString)Mockito.mock(JSONString.class);
        JSONString foreground4 = (JSONString)Mockito.mock(JSONString.class);
        JSONString token5 = (JSONString)Mockito.mock(JSONString.class);
        JSONString foreground5 = (JSONString)Mockito.mock(JSONString.class);
        JSONArray expectedRules = (JSONArray)Mockito.mock(JSONArray.class);
        JSONString bold = (JSONString)Mockito.mock(JSONString.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)token1).when((Object)this.factory)).makeJSONString("feel-keyword");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)token2).when((Object)this.factory)).makeJSONString("feel-numeric");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)token3).when((Object)this.factory)).makeJSONString("feel-boolean");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)token4).when((Object)this.factory)).makeJSONString("feel-string");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)token5).when((Object)this.factory)).makeJSONString("feel-function");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)foreground1).when((Object)this.factory)).makeJSONString("26268C");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)foreground2).when((Object)this.factory)).makeJSONString("3232E7");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)foreground3).when((Object)this.factory)).makeJSONString("26268D");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)foreground4).when((Object)this.factory)).makeJSONString("2A9343");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)foreground5).when((Object)this.factory)).makeJSONString("3232E8");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedRules).when((Object)this.factory)).makeJSONArray();
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)bold).when((Object)this.factory)).makeJSONString("bold");
        Mockito.when((Object)this.factory.makeJSONObject()).thenReturn((Object)rule1, (Object[])new JSONObject[]{rule2, rule3, rule4, rule5});
        JSONArray actualRules = this.factory.getRules();
        ((JSONObject)Mockito.verify((Object)rule1)).put("token", (JSONValue)token1);
        ((JSONObject)Mockito.verify((Object)rule2)).put("token", (JSONValue)token2);
        ((JSONObject)Mockito.verify((Object)rule3)).put("token", (JSONValue)token3);
        ((JSONObject)Mockito.verify((Object)rule4)).put("token", (JSONValue)token4);
        ((JSONObject)Mockito.verify((Object)rule5)).put("token", (JSONValue)token5);
        ((JSONObject)Mockito.verify((Object)rule1)).put("foreground", (JSONValue)foreground1);
        ((JSONObject)Mockito.verify((Object)rule2)).put("foreground", (JSONValue)foreground2);
        ((JSONObject)Mockito.verify((Object)rule3)).put("foreground", (JSONValue)foreground3);
        ((JSONObject)Mockito.verify((Object)rule4)).put("foreground", (JSONValue)foreground4);
        ((JSONObject)Mockito.verify((Object)rule5)).put("foreground", (JSONValue)foreground5);
        ((JSONObject)Mockito.verify((Object)rule1)).put("fontStyle", (JSONValue)bold);
        ((JSONObject)Mockito.verify((Object)rule4)).put("fontStyle", (JSONValue)bold);
        ((JSONObject)Mockito.verify((Object)rule3)).put("fontStyle", (JSONValue)bold);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRules, (JSONValue)rule1);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRules, (JSONValue)rule2);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRules, (JSONValue)rule3);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRules, (JSONValue)rule4);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRules, (JSONValue)rule5);
        Assert.assertEquals((Object)expectedRules, (Object)actualRules);
    }

    @Test
    public void testRow() {
        String pattern = "pattern";
        String name = "name";
        JsRegExp regExp = (JsRegExp)Mockito.mock(JsRegExp.class);
        JSONObject jsonRegExp = (JSONObject)Mockito.mock(JSONObject.class);
        JSONString jsonName = (JSONString)Mockito.mock(JSONString.class);
        JSONArray expectedRow = (JSONArray)Mockito.mock(JSONArray.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)regExp).when((Object)this.factory)).makeRegExp("pattern");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)jsonRegExp).when((Object)this.factory)).makeJSONObject((Object)regExp);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)jsonName).when((Object)this.factory)).makeJSONString("name");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedRow).when((Object)this.factory)).makeJSONArray();
        JSONArray actualRow = this.factory.row("pattern", "name");
        ((JSONArray)Mockito.verify((Object)expectedRow)).set(0, (JSONValue)jsonRegExp);
        ((JSONArray)Mockito.verify((Object)expectedRow)).set(1, (JSONValue)jsonName);
        Assert.assertEquals((Object)expectedRow, (Object)actualRow);
    }

    @Test
    public void testGetLanguage() {
        JSONString languageId = (JSONString)Mockito.mock(JSONString.class);
        JavaScriptObject expectedLanguage = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)languageId).when((Object)this.factory)).makeJSONString("feel-language");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedLanguage).when((Object)this.factory)).makeJavaScriptObject("id", (JSONValue)languageId);
        JavaScriptObject actualLanguage = this.factory.getLanguage();
        Assert.assertEquals((Object)expectedLanguage, (Object)actualLanguage);
    }

    @Test
    public void testGetCompletionItemProvider() {
        MonacoLanguages.ProvideCompletionItemsFunction provideCompletionItemsFunction = (MonacoLanguages.ProvideCompletionItemsFunction)Mockito.mock(MonacoLanguages.ProvideCompletionItemsFunction.class);
        JSONObject functionObject = (JSONObject)Mockito.mock(JSONObject.class);
        JavaScriptObject expectedCompletionItemProvider = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)provideCompletionItemsFunction).when((Object)this.factory)).getProvideCompletionItemsFunction(this.suggestionsPropertyFactory);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)functionObject).when((Object)this.factory)).makeJSONObject((Object)provideCompletionItemsFunction);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedCompletionItemProvider).when((Object)this.factory)).makeJavaScriptObject("provideCompletionItems", (JSONValue)functionObject);
        JavaScriptObject actualCompletionItemProvider = this.factory.getCompletionItemProvider(this.suggestionsPropertyFactory);
        Assert.assertEquals((Object)expectedCompletionItemProvider, (Object)actualCompletionItemProvider);
    }

    @Test
    public void testGetProvideCompletionItemsFunction() {
        JavaScriptObject expectedSuggestions = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        JSONObject expectedJSONObjectSuggestions = (JSONObject)Mockito.mock(JSONObject.class);
        JSONArray suggestions = (JSONArray)Mockito.mock(JSONArray.class);
        ITextModel model = (ITextModel)Mockito.mock(ITextModel.class);
        Position position = (Position)Mockito.mock(Position.class);
        String expression = "expression";
        int line = 2;
        int column = 3;
        FEELLanguageService.Position lspPosition = new FEELLanguageService.Position(2, 2);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedJSONObjectSuggestions).when((Object)this.factory)).makeJSONObject();
        Mockito.when((Object)model.getValue()).thenReturn((Object)"expression");
        Mockito.when((Object)position.getLineNumber()).thenReturn((Object)2);
        Mockito.when((Object)position.getColumn()).thenReturn((Object)3);
        Mockito.when((Object)expectedJSONObjectSuggestions.getJavaScriptObject()).thenReturn((Object)expectedSuggestions);
        Mockito.when((Object)this.suggestionsPropertyFactory.create((String)ArgumentMatchers.any(), (FEELLanguageService.Position)ArgumentMatchers.any())).thenReturn((Object)suggestions);
        JavaScriptObject actualSuggestions = this.factory.getProvideCompletionItemsFunction(this.suggestionsPropertyFactory).call(model, position);
        ((MonacoSuggestionsPropertyFactory)Mockito.verify((Object)this.suggestionsPropertyFactory)).create((String)ArgumentMatchers.eq((Object)"expression"), (FEELLanguageService.Position)ArgumentMatchers.eq((Object)lspPosition));
        ((JSONObject)Mockito.verify((Object)expectedJSONObjectSuggestions)).put("suggestions", (JSONValue)suggestions);
        Assert.assertEquals((Object)expectedSuggestions, (Object)actualSuggestions);
    }

    @Test
    public void testGetLanguageDefinition() {
        JSONValue tokenizer = (JSONValue)Mockito.mock(JSONValue.class);
        JavaScriptObject expectedLanguageDefinition = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedLanguageDefinition).when((Object)this.factory)).makeJavaScriptObject("tokenizer", tokenizer);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)tokenizer).when((Object)this.factory)).getTokenizer();
        JavaScriptObject actualLanguageDefinition = this.factory.getLanguageDefinition();
        Assert.assertEquals((Object)expectedLanguageDefinition, (Object)actualLanguageDefinition);
    }

    @Test
    public void testGetTokenizer() {
        JSONObject expectedTokenizer = (JSONObject)Mockito.mock(JSONObject.class);
        JSONArray root = (JSONArray)Mockito.mock(JSONArray.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedTokenizer).when((Object)this.factory)).makeJSONObject();
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)root).when((Object)this.factory)).getRoot();
        JSONValue actualTokenizer = this.factory.getTokenizer();
        ((JSONObject)Mockito.verify((Object)expectedTokenizer)).put("root", (JSONValue)root);
        Assert.assertEquals((Object)expectedTokenizer, (Object)actualTokenizer);
    }

    @Test
    public void testGetRoot() {
        JSONArray expectedRoot = (JSONArray)Mockito.mock(JSONArray.class);
        JSONArray row1 = (JSONArray)Mockito.mock(JSONArray.class);
        JSONArray row2 = (JSONArray)Mockito.mock(JSONArray.class);
        JSONArray row3 = (JSONArray)Mockito.mock(JSONArray.class);
        JSONArray row4 = (JSONArray)Mockito.mock(JSONArray.class);
        JSONArray row5 = (JSONArray)Mockito.mock(JSONArray.class);
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)expectedRoot).when((Object)this.factory)).makeJSONArray();
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)row1).when((Object)this.factory)).row("(?:(\\btrue\\b)|(\\bfalse\\b))", "feel-boolean");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)row2).when((Object)this.factory)).row("[0-9]+", "feel-numeric");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)row3).when((Object)this.factory)).row("(?:\\\"(?:.*?)\\\")", "feel-string");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)row4).when((Object)this.factory)).row("(?:(?:[a-z ]+\\()|(?:\\()|(?:\\)))", "feel-function");
        ((MonacoPropertiesFactory)Mockito.doReturn((Object)row5).when((Object)this.factory)).row("(?:(\\bfor\\b)|(\\breturn\\b)|(\\bif\\b)|(\\bthen\\b)|(\\belse\\b)|(\\bsome\\b)|(\\bevery\\b)|(\\bsatisfies\\b)|(\\binstance\\b)|(\\bof\\b)|(\\bin\\b)|(\\bfunction\\b)|(\\bexternal\\b)|(\\bor\\b)|(\\band\\b)|(\\bbetween\\b)|(\\bnot\\b)|(\\bnull\\b)|(\\btrue\\b)|(\\bfalse\\b))", "feel-keyword");
        JSONArray actualRoot = this.factory.getRoot();
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRoot, (JSONValue)row1);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRoot, (JSONValue)row2);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRoot, (JSONValue)row3);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRoot, (JSONValue)row4);
        ((MonacoPropertiesFactory)Mockito.verify((Object)this.factory)).push(expectedRoot, (JSONValue)row5);
        Assert.assertEquals((Object)expectedRoot, (Object)actualRoot);
    }
}

