/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.codecompletion.feel;

import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.feel.gwt.functions.api.FunctionOverrideVariation;
import org.kie.dmn.feel.gwt.functions.api.Parameter;
import org.kie.dmn.feel.gwt.functions.client.FEELFunctionProvider;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.Candidate;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.CompletionItemKind;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.FEELLanguageService;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.TypeStackUtils;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.Variable;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class FEELLanguageServiceTest {
    private FEELLanguageService service;
    private List<FunctionOverrideVariation> functionOverrideVariations;
    @Mock
    private FEELFunctionProvider feelFunctionProviderMock;

    @Before
    public void setup() {
        this.service = (FEELLanguageService)Mockito.spy((Object)new FEELLanguageService(new TypeStackUtils()));
        this.functionOverrideVariations = this.getFunctionOverrideVariations();
        GwtMockito.useProviderForType(FEELFunctionProvider.class, aClass -> this.feelFunctionProviderMock);
        ((FEELLanguageService)Mockito.doReturn(this.functionOverrideVariations).when((Object)this.service)).getFunctionOverrideVariations();
        ((FEELFunctionProvider)Mockito.doReturn(this.functionOverrideVariations).when((Object)this.feelFunctionProviderMock)).getDefinitions();
    }

    @Test
    public void testGetCandidatesForNumberScenario() {
        String expression = "2 + |";
        FEELLanguageService.Position position = new FEELLanguageService.Position(1, "2 + |".indexOf("|"));
        String expressionToParse = "2 + |".replace("|", "");
        List<Variable> variables = Arrays.asList(new Variable("Decision-1", (Type)BuiltInType.STRING), new Variable("Decision-2", (Type)BuiltInType.NUMBER), new Variable("Decision-3", (Type)BuiltInType.BOOLEAN), new Variable("Decision-4", (Type)BuiltInType.NUMBER), new Variable("Decision-5", (Type)BuiltInType.DATE));
        List actualCandidates = this.service.getCandidates(expressionToParse, variables, position);
        Assertions.assertThat((List)actualCandidates).containsExactly((Object[])new Candidate[]{new Candidate("Decision-2", "Decision-2", CompletionItemKind.Variable), new Candidate("Decision-4", "Decision-4", CompletionItemKind.Variable), new Candidate("abs(duration)", "abs($1)", CompletionItemKind.Function), new Candidate("abs(number)", "abs($1)", CompletionItemKind.Function), new Candidate("sum(list)", "sum($1)", CompletionItemKind.Function), new Candidate("not", "not", CompletionItemKind.Keyword), new Candidate("for", "for", CompletionItemKind.Keyword), new Candidate("if", "if", CompletionItemKind.Keyword), new Candidate("some", "some", CompletionItemKind.Keyword), new Candidate("every", "every", CompletionItemKind.Keyword), new Candidate("function", "function", CompletionItemKind.Keyword)});
    }

    @Test
    public void testGetCandidatesForStringScenario() {
        String expression = "\"\" + |";
        FEELLanguageService.Position position = new FEELLanguageService.Position(1, "\"\" + |".indexOf("|"));
        String expressionToParse = "\"\" + |".replace("|", "");
        List<Variable> variables = Arrays.asList(new Variable("Decision-1", (Type)BuiltInType.STRING), new Variable("Decision-2", (Type)BuiltInType.NUMBER), new Variable("Decision-3", (Type)BuiltInType.BOOLEAN), new Variable("Decision-4", (Type)BuiltInType.NUMBER), new Variable("Decision-5", (Type)BuiltInType.DATE));
        List actualCandidates = this.service.getCandidates(expressionToParse, variables, position);
        Assertions.assertThat((List)actualCandidates).containsExactly((Object[])new Candidate[]{new Candidate("Decision-1", "Decision-1", CompletionItemKind.Variable), new Candidate("string(number)", "string($1)", CompletionItemKind.Function), new Candidate("not", "not", CompletionItemKind.Keyword), new Candidate("for", "for", CompletionItemKind.Keyword), new Candidate("if", "if", CompletionItemKind.Keyword), new Candidate("some", "some", CompletionItemKind.Keyword), new Candidate("every", "every", CompletionItemKind.Keyword), new Candidate("function", "function", CompletionItemKind.Keyword)});
    }

    @Test
    public void testGetCandidatesForBooleanScenario() {
        String expression = "true and + |";
        FEELLanguageService.Position position = new FEELLanguageService.Position(1, "true and + |".indexOf("|"));
        String expressionToParse = "true and + |".replace("|", "");
        List<Variable> variables = Arrays.asList(new Variable("Decision-1", (Type)BuiltInType.STRING), new Variable("Decision-2", (Type)BuiltInType.NUMBER), new Variable("Decision-3", (Type)BuiltInType.BOOLEAN), new Variable("Decision-4", (Type)BuiltInType.NUMBER), new Variable("Decision-5", (Type)BuiltInType.DATE));
        List actualCandidates = this.service.getCandidates(expressionToParse, variables, position);
        Assertions.assertThat((List)actualCandidates).containsExactly((Object[])new Candidate[]{new Candidate("Decision-3", "Decision-3", CompletionItemKind.Variable), new Candidate("any(list)", "any($1)", CompletionItemKind.Function), new Candidate("not", "not", CompletionItemKind.Keyword), new Candidate("for", "for", CompletionItemKind.Keyword), new Candidate("if", "if", CompletionItemKind.Keyword), new Candidate("some", "some", CompletionItemKind.Keyword), new Candidate("every", "every", CompletionItemKind.Keyword), new Candidate("function", "function", CompletionItemKind.Keyword)});
    }

    @Test
    public void testGetCandidatesForDateScenario() {
        String expression = "now() + |";
        FEELLanguageService.Position position = new FEELLanguageService.Position(1, "now() + |".indexOf("|"));
        String expressionToParse = "now() + |".replace("|", "");
        List<Variable> variables = Arrays.asList(new Variable("Decision-1", (Type)BuiltInType.STRING), new Variable("Decision-2", (Type)BuiltInType.NUMBER), new Variable("Decision-3", (Type)BuiltInType.BOOLEAN), new Variable("Decision-4", (Type)BuiltInType.NUMBER), new Variable("Decision-5", (Type)BuiltInType.DATE));
        List actualCandidates = this.service.getCandidates(expressionToParse, variables, position);
        Assertions.assertThat((List)actualCandidates).containsExactly((Object[])new Candidate[]{new Candidate("Decision-5", "Decision-5", CompletionItemKind.Variable), new Candidate("date(string)", "date($1)", CompletionItemKind.Function), new Candidate("date(number, number, number)", "date($1, $2, $3)", CompletionItemKind.Function), new Candidate("now()", "now()", CompletionItemKind.Function), new Candidate("not", "not", CompletionItemKind.Keyword), new Candidate("for", "for", CompletionItemKind.Keyword), new Candidate("if", "if", CompletionItemKind.Keyword), new Candidate("some", "some", CompletionItemKind.Keyword), new Candidate("every", "every", CompletionItemKind.Keyword), new Candidate("function", "function", CompletionItemKind.Keyword)});
    }

    @Test
    @Ignore(value="DROOLS-6210")
    public void testGetCandidatesForVariableScenario() {
        String expression = "Decision-2 + |";
        FEELLanguageService.Position position = new FEELLanguageService.Position(1, "Decision-2 + |".indexOf("|"));
        String expressionToParse = "Decision-2 + |".replace("|", "");
        List<Variable> variables = Arrays.asList(new Variable("Decision-1", (Type)BuiltInType.STRING), new Variable("Decision-2", (Type)BuiltInType.NUMBER), new Variable("Decision-3", (Type)BuiltInType.BOOLEAN), new Variable("Decision-4", (Type)BuiltInType.NUMBER), new Variable("Decision-5", (Type)BuiltInType.DATE));
        List actualCandidates = this.service.getCandidates(expressionToParse, variables, position);
        Assertions.assertThat((List)actualCandidates).containsExactly((Object[])new Candidate[]{new Candidate("Decision-2", "Decision-2", CompletionItemKind.Variable), new Candidate("Decision-4", "Decision-4", CompletionItemKind.Variable), new Candidate("abs(duration)", "abs($1)", CompletionItemKind.Function), new Candidate("abs(number)", "abs($1)", CompletionItemKind.Function), new Candidate("sum(list)", "sum($1)", CompletionItemKind.Function), new Candidate("not", "not", CompletionItemKind.Keyword), new Candidate("for", "for", CompletionItemKind.Keyword), new Candidate("if", "if", CompletionItemKind.Keyword), new Candidate("some", "some", CompletionItemKind.Keyword), new Candidate("every", "every", CompletionItemKind.Keyword), new Candidate("function", "function", CompletionItemKind.Keyword)});
    }

    @Test
    public void testGetCandidatesWhenTypeDoesNotMatch() {
        String expression = "[1..10] |";
        FEELLanguageService.Position position = new FEELLanguageService.Position(1, "[1..10] |".indexOf("|"));
        String expressionToParse = "[1..10] |".replace("|", "");
        List<Variable> variables = Arrays.asList(new Variable("Decision-1", (Type)BuiltInType.STRING), new Variable("Decision-2", (Type)BuiltInType.NUMBER), new Variable("Decision-3", (Type)BuiltInType.BOOLEAN), new Variable("Decision-4", (Type)BuiltInType.NUMBER), new Variable("Decision-5", (Type)BuiltInType.DATE));
        List actualCandidates = this.service.getCandidates(expressionToParse, variables, position);
        Assertions.assertThat((List)actualCandidates).containsExactly((Object[])new Candidate[]{new Candidate("not", "not", CompletionItemKind.Keyword), new Candidate("for", "for", CompletionItemKind.Keyword), new Candidate("if", "if", CompletionItemKind.Keyword), new Candidate("some", "some", CompletionItemKind.Keyword), new Candidate("every", "every", CompletionItemKind.Keyword), new Candidate("function", "function", CompletionItemKind.Keyword)});
    }

    @Test
    public void testGetTypeSingleLine() {
        this.assertGetType("|(1 + (2 + (\"\" + (4 + 5))))", BuiltInType.UNKNOWN);
        this.assertGetType("(1| + (2 + (\"\" + (4 + 5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 |+ (2 + (\"\" + (4 + 5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 +| (2 + (\"\" + (4 + 5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 + |(2 + (\"\" + (4 + 5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (|2 + (\"\" + (4 + 5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2| + (\"\" + (4 + 5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2 |+ (\"\" + (4 + 5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2 +| (\"\" + (4 + 5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2 + |(\"\" + (4 + 5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2 + (|\"\" + (4 + 5))))", BuiltInType.STRING);
        this.assertGetType("(1 + (2 + (\"\"| + (4 + 5))))", BuiltInType.STRING);
        this.assertGetType("(1 + (2 + (\"\" |+ (4 + 5))))", BuiltInType.STRING);
        this.assertGetType("(1 + (2 + (\"\" +| (4 + 5))))", BuiltInType.STRING);
        this.assertGetType("(1 + (2 + (\"\" + |(4 + 5))))", BuiltInType.STRING);
        this.assertGetType("(1 + (2 + (\"\" + (|4 + 5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2 + (\"\" + (4| + 5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2 + (\"\" + (4 |+ 5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2 + (\"\" + (4 +| 5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2 + (\"\" + (4 + |5))))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2 + (\"\" + (4 + 5|))))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2 + (\"\" + (4 + 5)|)))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2 + (\"\" + (4 + 5))|))", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2 + (\"\" + (4 + 5)))|)", BuiltInType.NUMBER);
        this.assertGetType("(1 + (2 + (\"\" + (4 + 5))))|", BuiltInType.NUMBER);
    }

    @Test
    public void testGetTypeMultiLine() {
        this.assertGetType("(                    \n  1| + (             \n    2 + (            \n      \"\" + (4 + 5) \n    )                \n  )                  \n)                    \n", BuiltInType.NUMBER);
        this.assertGetType("(                    \n  1 + (              \n    2| + (           \n      \"\" + (4 + 5) \n    )                \n  )                  \n)                    \n", BuiltInType.NUMBER);
        this.assertGetType("(                    \n  1 + (              \n    2 + (            \n      \"\"| + (4 + 5)\n    )                \n  )                  \n)                    \n", BuiltInType.STRING);
        this.assertGetType("(                    \n  1 + (              \n    2 + (            \n      \"\" + (4| + 5)\n    )                \n  )                  \n)                    \n", BuiltInType.NUMBER);
        this.assertGetType("date(                \n  2021,              \n     1,              \n     1               \n)                   |\n", BuiltInType.DATE);
    }

    @Test
    public void testLiteralTypes() {
        this.assertGetType("\"\"           |", BuiltInType.STRING);
        this.assertGetType("[1, 2, 3]      |", BuiltInType.LIST);
        this.assertGetType("2              |", BuiltInType.NUMBER);
        this.assertGetType("2 -            |", BuiltInType.NUMBER);
        this.assertGetType("2 *            |", BuiltInType.NUMBER);
        this.assertGetType("2 /            |", BuiltInType.NUMBER);
        this.assertGetType("false          |", BuiltInType.BOOLEAN);
        this.assertGetType("false and      |", BuiltInType.BOOLEAN);
        this.assertGetType("[1..10]        |", BuiltInType.RANGE);
        this.assertGetType("function() { } |", BuiltInType.FUNCTION);
        this.assertGetType("\"\" + 2       |", BuiltInType.UNKNOWN);
    }

    @Test
    public void testAdvancedLiteralTypes() {
        this.assertGetType("date(date and time( \"2012-12-25T11:00:00Z\" )) |", BuiltInType.DATE);
        this.assertGetType("sum([1,2,3])                                    |", BuiltInType.NUMBER);
    }

    private void assertGetType(String expression, BuiltInType expected) {
        String cursor = "|";
        int line = expression.substring(0, expression.indexOf("|")).split("\n").length;
        int column = expression.split("\n")[line - 1].indexOf("|");
        FEELLanguageService.Position position = new FEELLanguageService.Position(line, column);
        String expressionToParse = expression.replace("|", "");
        BaseNode astNode = this.getASTNode(expressionToParse);
        Type actual = this.service.getType(astNode, position);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private BaseNode getASTNode(String expressionToParse) {
        FEEL_1_1Parser parser = this.service.getParser(expressionToParse);
        FEEL_1_1Parser.ExpressionContext parseTree = parser.expression();
        return this.service.getASTNode((ParseTree)parseTree);
    }

    private List<FunctionOverrideVariation> getFunctionOverrideVariations() {
        return Arrays.asList(new FunctionOverrideVariation((Type)BuiltInType.NUMBER, "abs", new Parameter[]{new Parameter("duration", BuiltInType.DURATION)}), new FunctionOverrideVariation((Type)BuiltInType.NUMBER, "abs", new Parameter[]{new Parameter("number", BuiltInType.NUMBER)}), new FunctionOverrideVariation((Type)BuiltInType.BOOLEAN, "any", new Parameter[]{new Parameter("list", BuiltInType.LIST)}), new FunctionOverrideVariation((Type)BuiltInType.DATE, "date", new Parameter[]{new Parameter("from", BuiltInType.STRING)}), new FunctionOverrideVariation((Type)BuiltInType.DATE, "date", new Parameter[]{new Parameter("year", BuiltInType.NUMBER), new Parameter("month", BuiltInType.NUMBER), new Parameter("day", BuiltInType.NUMBER)}), new FunctionOverrideVariation((Type)BuiltInType.DATE, "now", new Parameter[0]), new FunctionOverrideVariation((Type)BuiltInType.NUMBER, "sum", new Parameter[]{new Parameter("list", BuiltInType.LIST)}), new FunctionOverrideVariation((Type)BuiltInType.STRING, "string", new Parameter[]{new Parameter("from", BuiltInType.NUMBER)}));
    }
}

