/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.decisionservice.parameters.parametergroup;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.decisionservice.parameters.parametergroup.ParameterGroup;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ParameterGroupTest {
    @Mock
    private HTMLDivElement groupHeader;
    @Mock
    private HTMLUListElement parameters;
    @Mock
    private ManagedInstance<ParameterGroup.ParameterItem> parameterItems;
    @Mock
    private Elemental2DomUtil util;
    @Mock
    private HTMLDivElement none;
    @Mock
    private DOMTokenList classList;
    private ParameterGroup parameterGroup;

    @Before
    public void setup() {
        this.none.classList = this.classList;
        this.parameterGroup = (ParameterGroup)Mockito.spy((Object)new ParameterGroup(this.groupHeader, this.parameters, this.parameterItems, this.util, this.none));
    }

    @Test
    public void testSetHeader() {
        String headerText = "text";
        this.parameterGroup.setHeader("text");
        Assert.assertEquals((Object)this.groupHeader.textContent, (Object)"text");
    }

    @Test
    public void testAddParameter() {
        String name = "name";
        String type = "type";
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ParameterGroup.ParameterItem parameterItem = (ParameterGroup.ParameterItem)Mockito.mock(ParameterGroup.ParameterItem.class);
        elemental2.dom.HTMLElement element = (elemental2.dom.HTMLElement)Mockito.mock(elemental2.dom.HTMLElement.class);
        ((ParameterGroup)Mockito.doReturn((Object)parameterItem).when((Object)this.parameterGroup)).createParameterItem();
        Mockito.when((Object)parameterItem.getElement()).thenReturn((Object)htmlElement);
        Mockito.when((Object)this.util.asHTMLElement(htmlElement)).thenReturn((Object)element);
        this.parameterGroup.addParameter("name", "type");
        ((Elemental2DomUtil)Mockito.verify((Object)this.util)).asHTMLElement(htmlElement);
        ((HTMLUListElement)Mockito.verify((Object)this.parameters)).appendChild((Node)element);
        ((ParameterGroup)Mockito.verify((Object)this.parameterGroup)).refreshNone();
        Assert.assertFalse((boolean)this.parameterGroup.isEmpty());
    }

    @Test
    public void testRefreshNone() {
        ((ParameterGroup)Mockito.doReturn((Object)true).when((Object)this.parameterGroup)).isEmpty();
        this.parameterGroup.refreshNone();
        ((DOMTokenList)Mockito.verify((Object)this.classList)).remove(new String[]{"hidden"});
        ((ParameterGroup)Mockito.doReturn((Object)false).when((Object)this.parameterGroup)).isEmpty();
        this.parameterGroup.refreshNone();
        ((DOMTokenList)Mockito.verify((Object)this.classList)).add(new String[]{"hidden"});
    }
}

