/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid;

import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.BoundaryTransformMediator;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BoundaryTransformMediatorTest {
    @Mock
    private GridWidget gridWidget;
    private Bounds visibleBounds = new BaseBounds(0.0, 0.0, 1000.0, 1000.0);
    private BoundaryTransformMediator restriction;

    @Before
    public void setup() {
        this.restriction = new BoundaryTransformMediator(this.gridWidget);
    }

    private void setGridWidgetBounds(double x, double y, double width, double height) {
        Mockito.when((Object)this.gridWidget.getX()).thenReturn((Object)x);
        Mockito.when((Object)this.gridWidget.getY()).thenReturn((Object)y);
        Mockito.when((Object)this.gridWidget.getWidth()).thenReturn((Object)width);
        Mockito.when((Object)this.gridWidget.getHeight()).thenReturn((Object)height);
    }

    private void testTransformation(double txActual, double tyActual, double txExpected, double tyExpected) {
        Transform test = new Transform().translate(txActual, tyActual);
        Transform result = this.restriction.adjust(test, this.visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)txExpected, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)tyExpected, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testLeftEdgeWhenGridIsSmallerThanVisibleBounds() {
        this.setGridWidgetBounds(0.0, 0.0, 500.0, 500.0);
        this.testTransformation(1200.0, 0.0, 0.0, 0.0);
    }

    @Test
    public void testRightEdgeWhenGridIsSmallerThanVisibleBounds() {
        this.setGridWidgetBounds(0.0, 0.0, 500.0, 500.0);
        this.testTransformation(-200.0, 0.0, 0.0, 0.0);
    }

    @Test
    public void testTopEdgeWhenGridIsSmallerThanVisibleBounds() {
        this.setGridWidgetBounds(0.0, 0.0, 500.0, 500.0);
        this.testTransformation(0.0, 1200.0, 0.0, 0.0);
    }

    @Test
    public void testBottomEdgeWhenGridIsSmallerThanVisibleBounds() {
        this.setGridWidgetBounds(0.0, 0.0, 500.0, 500.0);
        this.testTransformation(0.0, -200.0, 0.0, 0.0);
    }

    @Test
    public void testLeftEdgeWhenGridIsLargerThanVisibleBounds() {
        this.setGridWidgetBounds(0.0, 0.0, 5000.0, 5000.0);
        this.testTransformation(1200.0, 0.0, 0.0, 0.0);
    }

    @Test
    public void testRightEdgeWhenGridIsLargerThanVisibleBounds() {
        this.setGridWidgetBounds(0.0, 0.0, 5000.0, 5000.0);
        this.testTransformation(-200.0, 0.0, -200.0, 0.0);
    }

    @Test
    public void testTopEdgeWhenGridIsLargerThanVisibleBounds() {
        this.setGridWidgetBounds(0.0, 0.0, 5000.0, 5000.0);
        this.testTransformation(0.0, 1200.0, 0.0, 0.0);
    }

    @Test
    public void testBottomEdgeWhenGridIsLargerThanVisibleBounds() {
        this.setGridWidgetBounds(0.0, 0.0, 5000.0, 5000.0);
        this.testTransformation(0.0, -200.0, 0.0, -200.0);
    }
}

