/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid;

import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCacheImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ExpressionGridCacheImplTest {
    private static final String UUID = "uuid";
    @Mock
    private BaseExpressionGrid editor;
    private ExpressionGridCacheImpl cache;

    @Before
    public void setup() {
        this.cache = new ExpressionGridCacheImpl();
    }

    @Test
    public void testPutExpressionGridWhenNoEditor() {
        this.cache.putExpressionGrid(UUID, Optional.empty());
        Assertions.assertThat((Map)this.cache.getContent()).isEmpty();
    }

    @Test
    public void testPutExpressionGridWhenEditorIsCacheable() {
        Map content = this.cache.getContent();
        Mockito.when((Object)this.editor.isCacheable()).thenReturn((Object)true);
        this.cache.putExpressionGrid(UUID, Optional.of(this.editor));
        Assertions.assertThat((Map)content).isNotEmpty();
        Assertions.assertThat((int)content.size()).isEqualTo(1);
        Assertions.assertThat((boolean)content.containsKey(UUID)).isTrue();
        Assertions.assertThat((Optional)((Optional)content.get(UUID))).isEqualTo(Optional.of(this.editor));
    }

    @Test
    public void testPutExpressionGridWhenEditorIsNotCacheable() {
        Mockito.when((Object)this.editor.isCacheable()).thenReturn((Object)false);
        this.cache.putExpressionGrid(UUID, Optional.of(this.editor));
        Assertions.assertThat((Map)this.cache.getContent()).isEmpty();
    }

    @Test
    public void testGetExpressionWhenIsPresent() {
        Mockito.when((Object)this.editor.isCacheable()).thenReturn((Object)true);
        this.cache.putExpressionGrid(UUID, Optional.of(this.editor));
        Optional content = this.cache.getExpressionGrid(UUID);
        Assertions.assertThat((Optional)content).isPresent();
        Assertions.assertThat(content.get()).isEqualTo((Object)this.editor);
    }

    @Test
    public void testGetExpressionWhenNotPresent() {
        Assertions.assertThat((Optional)this.cache.getExpressionGrid("")).isNotPresent();
    }

    @Test
    public void testRemoveExpressionGrid() {
        Map content = this.cache.getContent();
        Mockito.when((Object)this.editor.isCacheable()).thenReturn((Object)true);
        this.cache.putExpressionGrid(UUID, Optional.of(this.editor));
        this.cache.removeExpressionGrid("");
        Assertions.assertThat((Map)content).isNotEmpty();
        Assertions.assertThat((int)content.size()).isEqualTo(1);
        Assertions.assertThat((boolean)content.containsKey(UUID)).isTrue();
        Assertions.assertThat((Optional)((Optional)content.get(UUID))).isEqualTo(Optional.of(this.editor));
        this.cache.removeExpressionGrid(UUID);
        Assertions.assertThat((Map)content).isEmpty();
    }

    @Test
    public void testDoInit() {
        Mockito.when((Object)this.editor.isCacheable()).thenReturn((Object)true);
        this.cache.putExpressionGrid(UUID, Optional.of(this.editor));
        Assertions.assertThat((Map)this.cache.getContent()).isNotEmpty();
        this.cache.doInit();
        Assertions.assertThat((Map)this.cache.getContent()).isEmpty();
    }

    @Test
    public void testDoDestroy() {
        Mockito.when((Object)this.editor.isCacheable()).thenReturn((Object)true);
        this.cache.putExpressionGrid(UUID, Optional.of(this.editor));
        Assertions.assertThat((Map)this.cache.getContent()).isNotEmpty();
        this.cache.doDestroy();
        Assertions.assertThat((Map)this.cache.getContent()).isEmpty();
    }
}

