/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwtmockito.GwtMock;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.ValueAndDataTypeHeaderMetaData;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl.BaseGridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public abstract class BaseNameAndDataTypeColumnRendererTest<R extends BaseGridColumnRenderer, C> {
    protected static final String TITLE = "title";
    protected static final String PLACE_HOLDER = "placeHolder";
    protected static final QName TYPE_REF = new QName();
    protected static final double BLOCK_WIDTH = 100.0;
    protected static final double ROW_HEIGHT = 32.0;
    @Mock
    protected LiteralExpressionColumn uiColumn;
    @Mock
    protected GridData uiModel;
    @Mock
    protected GridRenderer gridRenderer;
    @Mock
    protected GridRendererTheme gridRendererTheme;
    @Mock
    protected Text text1;
    @Mock
    protected Text text2;
    @Mock
    protected Transform transform;
    @GwtMock
    protected Group headerGroup;
    protected GridBodyCellRenderContext bodyContext;
    protected GridHeaderColumnRenderContext headerContext;
    protected List<GridColumn.HeaderMetaData> headerMetaData;
    protected GridCell<C> cell;
    protected R renderer;

    @Before
    public void setup() {
        this.renderer = this.getColumnRenderer();
        this.headerContext = new GridHeaderColumnRenderContext(0.0, Collections.singletonList(this.uiColumn), Collections.singletonList(this.uiColumn), 0, this.uiModel, this.gridRenderer);
        this.bodyContext = new GridBodyCellRenderContext(0.0, 0.0, 100.0, 32.0, 0.0, 0.0, 0, 0, false, this.transform, this.gridRenderer);
        Mockito.when((Object)this.gridRenderer.getTheme()).thenReturn((Object)this.gridRendererTheme);
        Mockito.when((Object)this.gridRendererTheme.getHeaderText()).thenReturn((Object)this.text1, (Object[])new Text[]{this.text2});
        Mockito.when((Object)this.gridRendererTheme.getBodyText()).thenReturn((Object)this.text1);
        Mockito.when((Object)this.gridRendererTheme.getPlaceholderText()).thenReturn((Object)this.text1);
        Mockito.when((Object)this.text1.asNode()).thenReturn(Mockito.mock(Node.class));
        Mockito.when((Object)this.text2.asNode()).thenReturn(Mockito.mock(Node.class));
    }

    protected abstract R getColumnRenderer();

    @Test
    public void testRenderHeaderContentWithNormalColumnHeaderMetaData() {
        GridColumn.HeaderMetaData metaData = (GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class);
        this.headerMetaData = Collections.singletonList(metaData);
        Mockito.when((Object)metaData.getTitle()).thenReturn((Object)TITLE);
        this.renderer.renderHeaderContent(this.headerMetaData, this.headerContext, 0, 100.0, 32.0);
        ((Text)Mockito.verify((Object)this.text1)).setText((String)ArgumentMatchers.eq((Object)TITLE));
        ((Text)Mockito.verify((Object)this.text1)).setX(50.0);
        ((Text)Mockito.verify((Object)this.text1)).setY(16.0);
        ((Group)Mockito.verify((Object)this.headerGroup)).add((IPrimitive)this.text1);
        ((Group)Mockito.verify((Object)this.headerGroup, (VerificationMode)Mockito.never())).add((IPrimitive)this.text2);
    }

    @Test
    public void testRenderHeaderContentWithNameAndDataTypeHeaderMetaData() {
        ValueAndDataTypeHeaderMetaData metaData = (ValueAndDataTypeHeaderMetaData)Mockito.mock(ValueAndDataTypeHeaderMetaData.class);
        Mockito.when((Object)metaData.render((GridHeaderColumnRenderContext)ArgumentMatchers.any(GridHeaderColumnRenderContext.class), ArgumentMatchers.anyDouble(), ArgumentMatchers.anyDouble())).thenCallRealMethod();
        this.headerMetaData = Collections.singletonList(metaData);
        Mockito.when((Object)metaData.getTitle()).thenReturn((Object)TITLE);
        Mockito.when((Object)metaData.getTypeRef()).thenReturn((Object)TYPE_REF);
        this.renderer.renderHeaderContent(this.headerMetaData, this.headerContext, 0, 100.0, 32.0);
        ((Text)Mockito.verify((Object)this.text1)).setText((String)ArgumentMatchers.eq((Object)TITLE));
        ((Text)Mockito.verify((Object)this.text1)).setX(50.0);
        ((Text)Mockito.verify((Object)this.text1)).setY(8.0);
        ((Text)Mockito.verify((Object)this.text2)).setText((String)ArgumentMatchers.eq((Object)("(" + TYPE_REF + ")")));
        ((Text)Mockito.verify((Object)this.text2)).setX(50.0);
        ((Text)Mockito.verify((Object)this.text2)).setY(24.0);
        ((Text)Mockito.verify((Object)this.text2)).setFontStyle("italic");
        ((Text)Mockito.verify((Object)this.text2)).setFontSize(8.0);
        ((Group)Mockito.verify((Object)this.headerGroup)).add((IPrimitive)this.text1);
        ((Group)Mockito.verify((Object)this.headerGroup)).add((IPrimitive)this.text2);
    }

    @Test
    public void testRenderHeaderContentWithNameAndDataTypeHeaderMetaDataWithPlaceHolder() {
        ValueAndDataTypeHeaderMetaData metaData = (ValueAndDataTypeHeaderMetaData)Mockito.mock(ValueAndDataTypeHeaderMetaData.class);
        Mockito.when((Object)metaData.renderPlaceHolder((GridHeaderColumnRenderContext)ArgumentMatchers.any(GridHeaderColumnRenderContext.class), ArgumentMatchers.anyDouble(), ArgumentMatchers.anyDouble())).thenCallRealMethod();
        Mockito.when((Object)metaData.getPlaceHolder()).thenReturn(Optional.of(PLACE_HOLDER));
        this.headerMetaData = Collections.singletonList(metaData);
        this.renderer.renderHeaderContent(this.headerMetaData, this.headerContext, 0, 100.0, 32.0);
        ((Text)Mockito.verify((Object)this.text1)).setText((String)ArgumentMatchers.eq((Object)PLACE_HOLDER));
        ((Text)Mockito.verify((Object)this.text1)).setX(50.0);
        ((Text)Mockito.verify((Object)this.text1)).setY(16.0);
        ((Group)Mockito.verify((Object)this.headerGroup)).add((IPrimitive)this.text1);
    }

    @Test
    public void testRenderNullCell() {
        Assertions.assertThat((Object)this.renderer.renderCell(null, this.bodyContext)).isNull();
    }

    @Test
    public void testRenderNullCellValue() {
        this.cell = new BaseGridCell(null);
        Assertions.assertThat((Object)this.renderer.renderCell(this.cell, this.bodyContext)).isNull();
    }
}

