/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.list;

import com.google.gwt.core.client.Scheduler;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.KeyboardEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.errai.common.client.dom.DOMTokenList;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.CanBeClosedByKeyboard;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorDividerItemView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorHeaderItemView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorTextItemView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorViewImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class ListSelectorViewImplTest {
    @Mock
    private UnorderedList itemsContainer;
    @Mock
    private ManagedInstance<ListSelectorTextItemView> listSelectorTextItemViews;
    @Mock
    private ManagedInstance<ListSelectorDividerItemView> listSelectorDividerItemViews;
    @Mock
    private ManagedInstance<ListSelectorHeaderItemView> listSelectorHeaderItemViews;
    @Mock
    private ListSelectorView.Presenter presenter;
    @Mock
    private ListSelectorTextItemView textItemView;
    @Mock
    private HTMLElement textElement;
    @Mock
    private HasListSelectorControl.ListSelectorTextItem textItem;
    @Mock
    private ListSelectorDividerItemView dividerItemView;
    @Mock
    private HTMLElement dividerElement;
    @Mock
    private HasListSelectorControl.ListSelectorDividerItem dividerItem;
    @Mock
    private ListSelectorHeaderItemView headerItemView;
    @Mock
    private HTMLElement headerElement;
    @Mock
    private HTMLElement viewElement;
    @Mock
    private DOMTokenList viewElementCSSClasses;
    @Mock
    private Consumer<CanBeClosedByKeyboard> canBeClosedByKeyboardConsumer;
    @Mock
    private HasListSelectorControl.ListSelectorHeaderItem headerItem;
    private ListSelectorViewImpl view;

    @Before
    public void setUp() {
        this.view = (ListSelectorViewImpl)Mockito.spy((Object)new ListSelectorViewImpl(this.itemsContainer, this.listSelectorTextItemViews, this.listSelectorDividerItemViews, this.listSelectorHeaderItemViews));
        ((ManagedInstance)Mockito.doReturn((Object)this.textItemView).when(this.listSelectorTextItemViews)).get();
        ((ListSelectorTextItemView)Mockito.doReturn((Object)this.textElement).when((Object)this.textItemView)).getElement();
        ((ManagedInstance)Mockito.doReturn((Object)this.dividerItemView).when(this.listSelectorDividerItemViews)).get();
        ((ListSelectorDividerItemView)Mockito.doReturn((Object)this.dividerElement).when((Object)this.dividerItemView)).getElement();
        ((ManagedInstance)Mockito.doReturn((Object)this.headerItemView).when(this.listSelectorHeaderItemViews)).get();
        ((ListSelectorHeaderItemView)Mockito.doReturn((Object)this.headerElement).when((Object)this.headerItemView)).getElement();
        ((ListSelectorViewImpl)Mockito.doReturn((Object)this.viewElement).when((Object)this.view)).getElement();
        this.view.init(this.presenter);
        Mockito.when((Object)this.viewElement.getClassList()).thenReturn((Object)this.viewElementCSSClasses);
        ((ListSelectorViewImpl)Mockito.doAnswer(i -> {
            ((Scheduler.ScheduledCommand)i.getArguments()[0]).execute();
            return null;
        }).when((Object)this.view)).schedule((Scheduler.ScheduledCommand)ArgumentMatchers.any(Scheduler.ScheduledCommand.class));
    }

    @Test
    public void testSetItems() {
        boolean textItemEnabled = true;
        String textItemText = "Insert rule above";
        ((HasListSelectorControl.ListSelectorTextItem)Mockito.doReturn((Object)true).when((Object)this.textItem)).isEnabled();
        ((HasListSelectorControl.ListSelectorTextItem)Mockito.doReturn((Object)"Insert rule above").when((Object)this.textItem)).getText();
        String headerItemText = "Header";
        ((HasListSelectorControl.ListSelectorHeaderItem)Mockito.doReturn((Object)"Header").when((Object)this.headerItem)).getText();
        this.view.setItems(Arrays.asList(this.textItem, this.dividerItem, this.headerItem));
        ((UnorderedList)Mockito.verify((Object)this.itemsContainer)).appendChild((Node)this.textElement);
        ((UnorderedList)Mockito.verify((Object)this.itemsContainer)).appendChild((Node)this.dividerElement);
        ((UnorderedList)Mockito.verify((Object)this.itemsContainer)).appendChild((Node)this.headerElement);
        ((ListSelectorTextItemView)Mockito.verify((Object)this.textItemView)).setEnabled(ArgumentMatchers.eq((boolean)true));
        ((ListSelectorTextItemView)Mockito.verify((Object)this.textItemView)).setText((String)ArgumentMatchers.eq((Object)"Insert rule above"));
        ((ListSelectorHeaderItemView)Mockito.verify((Object)this.headerItemView)).setText((String)ArgumentMatchers.eq((Object)"Header"));
        ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(Command.class);
        ((ListSelectorTextItemView)Mockito.verify((Object)this.textItemView)).addClickHandler((Command)commandCaptor.capture());
        ((Command)commandCaptor.getValue()).execute();
        ((ListSelectorView.Presenter)Mockito.verify((Object)this.presenter)).onItemSelected((HasListSelectorControl.ListSelectorItem)ArgumentMatchers.eq((Object)this.textItem));
        Mockito.reset((Object[])new ListSelectorView.Presenter[]{this.presenter});
        ((HasListSelectorControl.ListSelectorTextItem)Mockito.doReturn((Object)false).when((Object)this.textItem)).isEnabled();
        ((Command)commandCaptor.getValue()).execute();
        ((ListSelectorView.Presenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).onItemSelected((HasListSelectorControl.ListSelectorItem)ArgumentMatchers.any(HasListSelectorControl.ListSelectorTextItem.class));
    }

    @Test
    public void testSetItemsUnknownImplementation() {
        this.view.setItems(Collections.singletonList(Mockito.mock(HasListSelectorControl.ListSelectorItem.class)));
        ((UnorderedList)Mockito.verify((Object)this.itemsContainer, (VerificationMode)Mockito.never())).appendChild((Node)ArgumentMatchers.any());
    }

    @Test
    public void testShow() {
        this.view.show(Optional.empty());
        ((DOMTokenList)Mockito.verify((Object)this.viewElementCSSClasses)).add("open");
        ((HTMLElement)Mockito.verify((Object)this.viewElement)).focus();
    }

    @Test
    public void testHide() {
        this.view.hide();
        ((DOMTokenList)Mockito.verify((Object)this.viewElementCSSClasses)).remove("open");
    }

    @Test
    public void testRegisterOnCloseHandler() {
        EventListener onKeyDown = e -> {};
        ((ListSelectorViewImpl)Mockito.doReturn((Object)onKeyDown).when((Object)this.view)).onKeyDown();
        this.view.registerOnCloseHandler();
        ((HTMLElement)Mockito.verify((Object)this.viewElement)).addEventListener("keydown", onKeyDown, false);
    }

    @Test
    public void testOnKeyDownWhenEscapeIsPressedOnIEOrEdge() {
        Event event = (Event)Mockito.mock(Event.class);
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((ListSelectorViewImpl)Mockito.doReturn((Object)keyboardEvent).when((Object)this.view)).asElemental2Event(event);
        keyboardEvent.key = "Esc";
        this.view.onKeyDown().call(event);
        ((ListSelectorViewImpl)Mockito.verify((Object)this.view)).hide();
        ((ListSelectorViewImpl)Mockito.verify((Object)this.view)).returnFocusToPanel();
    }

    @Test
    public void testOnKeyDownWhenEscapeIsPressedOnOtherBrowser() {
        Event event = (Event)Mockito.mock(Event.class);
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((ListSelectorViewImpl)Mockito.doReturn((Object)keyboardEvent).when((Object)this.view)).asElemental2Event(event);
        keyboardEvent.key = "Escape";
        this.view.onKeyDown().call(event);
        ((ListSelectorViewImpl)Mockito.verify((Object)this.view)).hide();
        ((ListSelectorViewImpl)Mockito.verify((Object)this.view)).returnFocusToPanel();
    }

    @Test
    public void testOnKeyDownWhenEscapeIsNotPressed() {
        Event event = (Event)Mockito.mock(Event.class);
        ((ListSelectorViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEscape(event);
        this.view.onKeyDown().call(event);
        ((ListSelectorViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
        ((ListSelectorViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).returnFocusToPanel();
    }

    @Test
    public void testReturnFocusToPanel() {
        this.view.setOnClosedByKeyboardCallback(this.canBeClosedByKeyboardConsumer);
        this.view.returnFocusToPanel();
        ((Consumer)Mockito.verify(this.canBeClosedByKeyboardConsumer)).accept(this.view);
    }
}

