/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.handlers;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.handlers.DelegatingGridWidgetEditCellMouseEventHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellEditAction;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DelegatingGridWidgetEditCellMouseEventHandlerTest {
    private static final int PARENT_ROW_INDEX = 0;
    private static final int PARENT_COLUMN_INDEX = 1;
    @Mock
    private GridCellTuple parent;
    @Mock
    private GridWidget parentGridWidget;
    @Mock
    private GridData parentGridData;
    @Mock
    private LiteralExpressionGrid gridWidget;
    @Mock
    private GridData gridData;
    @Mock
    private GridCell gridCell;
    @Mock
    private Point2D relativeLocation;
    @Mock
    private NodeMouseClickEvent event;
    @Mock
    private GridData.SelectedCell selectedCell;
    private Optional<Integer> uiHeaderRowIndex;
    private Optional<Integer> uiHeaderColumnIndex;
    private Optional<Integer> uiRowIndex;
    private Optional<Integer> uiColumnIndex;
    private DelegatingGridWidgetEditCellMouseEventHandler handler;

    private void setupGrid(Supplier<GridCellTuple> parentSupplier, Supplier<Integer> nestingSupplier) {
        this.handler = (DelegatingGridWidgetEditCellMouseEventHandler)Mockito.spy((Object)new DelegatingGridWidgetEditCellMouseEventHandler(parentSupplier, nestingSupplier));
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.gridData);
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)this.parentGridWidget);
        Mockito.when((Object)this.parent.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.parent.getColumnIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.parentGridWidget.getModel()).thenReturn((Object)this.parentGridData);
    }

    @Test
    public void testOnNodeMouseEventWhenOnlyVisualChangeAllowed() {
        Mockito.when((Object)this.gridWidget.isOnlyVisualChangeAllowed()).thenReturn((Object)true);
        this.setupGrid(() -> null, () -> 0);
        Assertions.assertThat((boolean)this.handler.onNodeMouseEvent((GridWidget)this.gridWidget, this.relativeLocation, this.uiHeaderRowIndex, this.uiHeaderColumnIndex, this.uiRowIndex, this.uiColumnIndex, (AbstractNodeMouseEvent)this.event)).isFalse();
        ((LiteralExpressionGrid)Mockito.verify((Object)this.gridWidget, (VerificationMode)Mockito.never())).startEditingCell((Point2D)Mockito.any());
    }

    @Test
    public void testOnNodeMouseEventWhenNotNested() {
        Mockito.when((Object)this.gridData.getSelectedCells()).thenReturn(Collections.emptyList());
        this.setupGrid(() -> null, () -> 0);
        this.uiHeaderRowIndex = Optional.of(0);
        this.uiHeaderColumnIndex = Optional.of(1);
        this.uiRowIndex = Optional.of(2);
        this.uiColumnIndex = Optional.of(3);
        this.handler.onNodeMouseEvent((GridWidget)this.gridWidget, this.relativeLocation, this.uiHeaderRowIndex, this.uiHeaderColumnIndex, this.uiRowIndex, this.uiColumnIndex, (AbstractNodeMouseEvent)this.event);
        ((DelegatingGridWidgetEditCellMouseEventHandler)Mockito.verify((Object)this.handler)).doSuperOnNodeMouseEvent((GridWidget)ArgumentMatchers.eq((Object)this.gridWidget), (Point2D)ArgumentMatchers.eq((Object)this.relativeLocation), (Optional)ArgumentMatchers.eq(this.uiHeaderRowIndex), (Optional)ArgumentMatchers.eq(this.uiHeaderColumnIndex), (Optional)ArgumentMatchers.eq(this.uiRowIndex), (Optional)ArgumentMatchers.eq(this.uiColumnIndex), (AbstractNodeMouseEvent)ArgumentMatchers.eq((Object)this.event));
    }

    @Test
    public void testOnNodeMouseEventWhenNestedOnHeader() {
        Mockito.when((Object)this.parentGridData.getSelectedCells()).thenReturn(Collections.emptyList());
        this.setupGrid(() -> this.parent, () -> 1);
        this.uiHeaderRowIndex = Optional.of(0);
        this.uiHeaderColumnIndex = Optional.of(1);
        this.uiRowIndex = Optional.empty();
        this.uiColumnIndex = Optional.empty();
        Assertions.assertThat((boolean)this.handler.onNodeMouseEvent((GridWidget)this.gridWidget, this.relativeLocation, this.uiHeaderRowIndex, this.uiHeaderColumnIndex, this.uiRowIndex, this.uiColumnIndex, (AbstractNodeMouseEvent)this.event)).isFalse();
    }

    @Test
    public void testOnNodeMouseEventWhenNestedOnBodyWithoutCellSelection() {
        Mockito.when((Object)this.event.isShiftKeyDown()).thenReturn((Object)false);
        Mockito.when((Object)this.event.isControlKeyDown()).thenReturn((Object)true);
        Mockito.when((Object)this.parentGridData.getSelectedCells()).thenReturn(Collections.emptyList());
        this.setupGrid(() -> this.parent, () -> 1);
        this.uiHeaderRowIndex = Optional.empty();
        this.uiHeaderColumnIndex = Optional.empty();
        this.uiRowIndex = Optional.of(0);
        this.uiColumnIndex = Optional.of(1);
        Assertions.assertThat((boolean)this.handler.onNodeMouseEvent((GridWidget)this.gridWidget, this.relativeLocation, this.uiHeaderRowIndex, this.uiHeaderColumnIndex, this.uiRowIndex, this.uiColumnIndex, (AbstractNodeMouseEvent)this.event)).isFalse();
    }

    @Test
    public void testOnNodeMouseEventWhenNestedOnBodyWithCellSelection() {
        Mockito.when((Object)this.event.isShiftKeyDown()).thenReturn((Object)false);
        Mockito.when((Object)this.event.isControlKeyDown()).thenReturn((Object)true);
        Mockito.when((Object)this.parentGridData.getSelectedCells()).thenReturn(Collections.singletonList(this.selectedCell));
        Mockito.when((Object)this.gridData.getCell(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)1))).thenReturn((Object)this.gridCell);
        Mockito.when((Object)this.gridWidget.startEditingCell((Point2D)Mockito.any())).thenReturn((Object)true);
        this.setupGrid(() -> this.parent, () -> 1);
        this.uiHeaderRowIndex = Optional.empty();
        this.uiHeaderColumnIndex = Optional.empty();
        this.uiRowIndex = Optional.of(0);
        this.uiColumnIndex = Optional.of(1);
        ((DelegatingGridWidgetEditCellMouseEventHandler)Mockito.doReturn((Object)true).when((Object)this.handler)).isEventHandled((GridCellEditAction)Mockito.any(), (AbstractNodeMouseEvent)Mockito.any());
        Assertions.assertThat((boolean)this.handler.onNodeMouseEvent((GridWidget)this.gridWidget, this.relativeLocation, this.uiHeaderRowIndex, this.uiHeaderColumnIndex, this.uiRowIndex, this.uiColumnIndex, (AbstractNodeMouseEvent)this.event)).isTrue();
        ((LiteralExpressionGrid)Mockito.verify((Object)this.gridWidget)).startEditingCell((Point2D)ArgumentMatchers.eq((Object)this.relativeLocation));
    }
}

