/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.keyboard;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperation;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseDynamicReadOnlyKeyboardOperationTest<O extends KeyboardOperation> {
    @Mock
    protected GridLayer gridLayer;
    @Mock
    protected BaseExpressionGrid gridWidget;
    @Mock
    protected GridData uiModel;
    private O operation;

    @Before
    public void setup() {
        this.operation = this.getOperation();
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.uiModel);
        Mockito.when((Object)this.uiModel.getSelectedCells()).thenReturn(Collections.singletonList(Mockito.mock(GridData.SelectedCell.class)));
    }

    protected abstract O getOperation();

    @Test
    public void testIsExecutable() {
        Mockito.when((Object)this.gridWidget.isOnlyVisualChangeAllowed()).thenReturn((Object)false);
        Assertions.assertThat((boolean)this.operation.isExecutable((GridWidget)this.gridWidget)).isTrue();
    }

    @Test
    public void testIsExecutableWhenOnlyVisualChangeAllowed() {
        Mockito.when((Object)this.gridWidget.isOnlyVisualChangeAllowed()).thenReturn((Object)true);
        Assertions.assertThat((boolean)this.operation.isExecutable((GridWidget)this.gridWidget)).isFalse();
    }
}

