/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.layer;

import com.ait.lienzo.client.core.Context2D;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IDrawable;
import com.ait.lienzo.client.core.shape.IPathClipper;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwtmockito.GwtMockito;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainerGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.dnd.DMNGridWidgetDnDMouseUpHandler;
import org.kie.workbench.common.dmn.client.widgets.dnd.DelegatingGridWidgetDndMouseMoveHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DMNGridLayerTest {
    private static final double CONTAINER_WIDTH = 1000.0;
    private static final double CONTAINER_HEIGHT = 500.0;
    private static final double CONTAINER_X = 25.0;
    private static final double CONTAINER_Y = 50.0;
    private static final double PARENT_X = 0.0;
    private static final double PARENT_Y = 0.0;
    private static final double VIEWPORT_TRANSLATE_X = 15.0;
    private static final double VIEWPORT_TRANSLATE_Y = 35.0;
    @Mock
    private Context2D context2D;
    @Mock
    private ExpressionContainerGrid container;
    @Mock
    private BaseExpressionGrid expressionGrid;
    @Mock
    private Viewport viewport;
    @Mock
    private Transform transform;
    @Mock
    private Group ghostGroup;
    @Mock
    private Rectangle ghostRectangle;
    @Captor
    private ArgumentCaptor<GridLayerRedrawManager.PrioritizedCommand> drawCommand;
    private DMNGridLayer gridLayer;

    @Before
    public void setup() {
        this.gridLayer = (DMNGridLayer)Mockito.spy((Object)((Object)new TestDMNGridLayer(this.context2D)));
        ((DMNGridLayer)Mockito.doReturn((Object)this.viewport).when((Object)this.gridLayer)).getViewport();
        Mockito.when((Object)this.viewport.getTransform()).thenReturn((Object)this.transform);
        Mockito.when((Object)this.container.getWidth()).thenReturn((Object)1000.0);
        Mockito.when((Object)this.container.getHeight()).thenReturn((Object)500.0);
        Mockito.when((Object)this.container.getX()).thenReturn((Object)25.0);
        Mockito.when((Object)this.container.getY()).thenReturn((Object)50.0);
        Mockito.when((Object)this.container.getComputedLocation()).thenReturn((Object)new Point2D(0.0, 0.0));
        Mockito.when((Object)this.expressionGrid.getComputedLocation()).thenReturn((Object)new Point2D(0.0, 0.0));
        Mockito.when((Object)this.transform.getTranslateX()).thenReturn((Object)15.0);
        Mockito.when((Object)this.transform.getTranslateY()).thenReturn((Object)35.0);
    }

    @Test
    public void checkGridWidgetDnDMouseMoveHandler() {
        Assert.assertTrue((boolean)(this.gridLayer.getGridWidgetDnDMouseMoveHandler() instanceof DelegatingGridWidgetDndMouseMoveHandler));
    }

    @Test
    public void checkGridWidgetDnDMouseUpHandler() {
        Assert.assertTrue((boolean)(this.gridLayer.getGridWidgetDnDMouseUpHandler() instanceof DMNGridWidgetDnDMouseUpHandler));
    }

    @Test
    public void testDrawDelegatesToBatch() {
        this.gridLayer.draw();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testBatchDelegatesToDoBatch() {
        Mockito.when((Object)this.gridLayer.doBatch()).thenCallRealMethod();
        this.gridLayer.batch();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.drawCommand.capture());
        ((GridLayerRedrawManager.PrioritizedCommand)this.drawCommand.getValue()).execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).doBatch();
    }

    @Test
    public void testNoGhostAddedWhenNoContainerFound() {
        this.gridLayer.doBatch();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).addGhost((ExpressionContainerGrid)Mockito.any(), (GridWidget)Mockito.any());
    }

    @Test
    public void testNoGhostAddedWhenContainerFoundButNoExpressionGridFound() {
        ((DMNGridLayer)Mockito.doReturn(Collections.singleton(this.container)).when((Object)this.gridLayer)).getGridWidgets();
        this.gridLayer.doBatch();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).addGhost((ExpressionContainerGrid)Mockito.any(), (GridWidget)Mockito.any());
    }

    @Test
    public void testGhostAddedWhenContainerFoundAndExpressionGridFound() {
        ((DMNGridLayer)Mockito.doReturn(new HashSet<BaseGrid>(Arrays.asList(this.container, this.expressionGrid))).when((Object)this.gridLayer)).getGridWidgets();
        this.gridLayer.select((GridWidget)this.expressionGrid);
        this.gridLayer.doBatch();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).addGhost((ExpressionContainerGrid)ArgumentMatchers.eq((Object)this.container), (GridWidget)ArgumentMatchers.eq((Object)this.expressionGrid));
    }

    @Test
    public void testGhostRendering() {
        GwtMockito.useProviderForType(Group.class, clazz -> this.ghostGroup);
        ((DMNGridLayer)Mockito.doReturn(new HashSet<BaseGrid>(Arrays.asList(this.container, this.expressionGrid))).when((Object)this.gridLayer)).getGridWidgets();
        ((DMNGridLayer)Mockito.doReturn((Object)this.ghostRectangle).when((Object)this.gridLayer)).getGhostRectangle();
        this.gridLayer.select((GridWidget)this.expressionGrid);
        this.gridLayer.doBatch();
        this.assertGhostRendering();
    }

    @Test
    public void testGhostRenderingLiteralExpression() {
        LiteralExpressionGrid literalExpressionGrid = (LiteralExpressionGrid)Mockito.mock(LiteralExpressionGrid.class);
        GridCellTuple parentGridCellTuple = new GridCellTuple(0, 0, (GridWidget)this.container);
        GwtMockito.useProviderForType(Group.class, clazz -> this.ghostGroup);
        ((DMNGridLayer)Mockito.doReturn(new HashSet<BaseGrid>(Arrays.asList(this.container, literalExpressionGrid))).when((Object)this.gridLayer)).getGridWidgets();
        ((DMNGridLayer)Mockito.doReturn((Object)this.ghostRectangle).when((Object)this.gridLayer)).getGhostRectangle();
        ((LiteralExpressionGrid)Mockito.doReturn((Object)parentGridCellTuple).when((Object)literalExpressionGrid)).getParentInformation();
        this.gridLayer.select((GridWidget)literalExpressionGrid);
        this.gridLayer.doBatch();
        this.assertGhostRendering();
    }

    @Test
    public void testGhostRenderingUndefinedExpression() {
        UndefinedExpressionGrid undefinedExpressionGrid = (UndefinedExpressionGrid)Mockito.mock(UndefinedExpressionGrid.class);
        GridCellTuple parentGridCellTuple = new GridCellTuple(0, 0, (GridWidget)this.container);
        GwtMockito.useProviderForType(Group.class, clazz -> this.ghostGroup);
        ((DMNGridLayer)Mockito.doReturn(new HashSet<BaseGrid>(Arrays.asList(this.container, undefinedExpressionGrid))).when((Object)this.gridLayer)).getGridWidgets();
        ((DMNGridLayer)Mockito.doReturn((Object)this.ghostRectangle).when((Object)this.gridLayer)).getGhostRectangle();
        ((UndefinedExpressionGrid)Mockito.doReturn((Object)parentGridCellTuple).when((Object)undefinedExpressionGrid)).getParentInformation();
        this.gridLayer.select((GridWidget)undefinedExpressionGrid);
        this.gridLayer.doBatch();
        this.assertGhostRendering();
    }

    private void assertGhostRendering() {
        ((Rectangle)Mockito.verify((Object)this.ghostRectangle)).setWidth(ArgumentMatchers.eq((double)1001.0));
        ((Rectangle)Mockito.verify((Object)this.ghostRectangle)).setHeight(ArgumentMatchers.eq((double)501.0));
        ((Rectangle)Mockito.verify((Object)this.ghostRectangle)).setFillColor((IColor)ColorName.WHITE);
        ((Rectangle)Mockito.verify((Object)this.ghostRectangle)).setAlpha(0.5);
        ((Rectangle)Mockito.verify((Object)this.ghostRectangle)).setListening(false);
        ((Group)Mockito.verify((Object)this.ghostGroup)).setX(40.0);
        ((Group)Mockito.verify((Object)this.ghostGroup)).setY(85.0);
        ((Group)Mockito.verify((Object)this.ghostGroup)).setPathClipper((IPathClipper)Mockito.any());
        ((Group)Mockito.verify((Object)this.ghostGroup)).add((IPrimitive)this.ghostRectangle);
        ((Group)Mockito.verify((Object)this.ghostGroup)).drawWithTransforms((Context2D)ArgumentMatchers.eq((Object)this.context2D), Mockito.anyDouble(), (BoundingBox)Mockito.any());
    }

    @Test
    public void testSelectGridWidget() {
        Mockito.when((Object)this.expressionGrid.getModel()).thenReturn((Object)new BaseGridData(false));
        Mockito.when((Object)this.expressionGrid.asNode()).thenReturn(Mockito.mock(Node.class));
        Assertions.assertThat((boolean)this.gridLayer.getSelectedGridWidget().isPresent()).isFalse();
        this.gridLayer.add((IPrimitive)this.expressionGrid);
        this.gridLayer.select((GridWidget)this.expressionGrid);
        Assertions.assertThat((boolean)this.gridLayer.getSelectedGridWidget().isPresent()).isTrue();
        Assertions.assertThat(this.gridLayer.getSelectedGridWidget().get()).isEqualTo((Object)this.expressionGrid);
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid)).select();
    }

    @Test
    public void testSelectNestedGridWidget() {
        GridWidget gridWidget = (GridWidget)Mockito.mock(GridWidget.class);
        BaseGridData gridData = new BaseGridData(false);
        gridData.appendRow((GridRow)new BaseGridRow());
        gridData.appendColumn((GridColumn)Mockito.mock(GridColumn.class));
        gridData.setCellValue(0, 0, (GridCellValue)new ExpressionCellValue(Optional.of(this.expressionGrid)));
        this.gridLayer.register(gridWidget);
        this.gridLayer.register((GridWidget)this.expressionGrid);
        Assertions.assertThat((boolean)this.gridLayer.getSelectedGridWidget().isPresent()).isFalse();
        Mockito.when((Object)gridWidget.getModel()).thenReturn((Object)gridData);
        Mockito.when((Object)this.expressionGrid.getModel()).thenReturn((Object)new BaseGridData(false));
        this.gridLayer.select((GridWidget)this.expressionGrid);
        Assertions.assertThat((boolean)this.gridLayer.getSelectedGridWidget().isPresent()).isTrue();
        Assertions.assertThat(this.gridLayer.getSelectedGridWidget().get()).isEqualTo((Object)this.expressionGrid);
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid)).select();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        Mockito.reset((Object[])new IDrawable[]{this.gridLayer, gridWidget, this.expressionGrid});
        Mockito.when((Object)gridWidget.getModel()).thenReturn((Object)gridData);
        Mockito.when((Object)this.expressionGrid.getModel()).thenReturn((Object)new BaseGridData(false));
        Mockito.when((Object)this.expressionGrid.isSelected()).thenReturn((Object)true);
        this.gridLayer.select(gridWidget);
        Assertions.assertThat((boolean)this.gridLayer.getSelectedGridWidget().isPresent()).isTrue();
        Assertions.assertThat(this.gridLayer.getSelectedGridWidget().get()).isEqualTo((Object)gridWidget);
        ((GridWidget)Mockito.verify((Object)gridWidget)).select();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid)).deselect();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        Mockito.reset((Object[])new IDrawable[]{this.gridLayer, gridWidget, this.expressionGrid});
        Mockito.when((Object)gridWidget.getModel()).thenReturn((Object)gridData);
        Mockito.when((Object)gridWidget.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.expressionGrid.getModel()).thenReturn((Object)new BaseGridData(false));
        Mockito.when((Object)this.expressionGrid.isSelected()).thenReturn((Object)false);
        this.gridLayer.select(gridWidget);
        ((GridWidget)Mockito.verify((Object)gridWidget, (VerificationMode)Mockito.never())).select();
        ((BaseExpressionGrid)Mockito.verify((Object)this.expressionGrid, (VerificationMode)Mockito.never())).deselect();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).batch();
    }

    @Test
    public void testDeregister() {
        GridWidget gridWidget = (GridWidget)Mockito.mock(GridWidget.class);
        this.gridLayer.select(gridWidget);
        this.gridLayer.deregister((GridWidget)this.expressionGrid);
        Assertions.assertThat((boolean)this.gridLayer.getSelectedGridWidget().isPresent()).isTrue();
        Assertions.assertThat(this.gridLayer.getSelectedGridWidget().get()).isEqualTo((Object)gridWidget);
        this.gridLayer.deregister(gridWidget);
        Assertions.assertThat((boolean)this.gridLayer.getSelectedGridWidget().isPresent()).isFalse();
    }

    @Test
    public void testRemove() {
        GridWidget gridWidget = (GridWidget)Mockito.mock(GridWidget.class);
        Mockito.when((Object)gridWidget.getModel()).thenReturn((Object)new BaseGridData(false));
        Mockito.when((Object)this.expressionGrid.getModel()).thenReturn((Object)new BaseGridData(false));
        Mockito.when((Object)gridWidget.asNode()).thenReturn(Mockito.mock(Node.class));
        Mockito.when((Object)this.expressionGrid.asNode()).thenReturn(Mockito.mock(Node.class));
        this.gridLayer.add((IPrimitive)gridWidget);
        this.gridLayer.add((IPrimitive)this.expressionGrid);
        this.gridLayer.select((GridWidget)this.expressionGrid);
        this.gridLayer.remove((IPrimitive)gridWidget);
        Assertions.assertThat((boolean)this.gridLayer.getSelectedGridWidget().isPresent()).isTrue();
        Assertions.assertThat(this.gridLayer.getSelectedGridWidget().get()).isEqualTo((Object)this.expressionGrid);
        this.gridLayer.remove((IPrimitive)this.expressionGrid);
        Assertions.assertThat((boolean)this.gridLayer.getSelectedGridWidget().isPresent()).isFalse();
    }

    @Test
    public void testRemoveAll() {
        GridWidget gridWidget = (GridWidget)Mockito.mock(GridWidget.class);
        Mockito.when((Object)gridWidget.getModel()).thenReturn((Object)new BaseGridData(false));
        Mockito.when((Object)this.expressionGrid.getModel()).thenReturn((Object)new BaseGridData(false));
        Mockito.when((Object)gridWidget.asNode()).thenReturn(Mockito.mock(Node.class));
        Mockito.when((Object)this.expressionGrid.asNode()).thenReturn(Mockito.mock(Node.class));
        this.gridLayer.add((IPrimitive)gridWidget);
        this.gridLayer.add((IPrimitive)this.expressionGrid);
        this.gridLayer.select((GridWidget)this.expressionGrid);
        this.gridLayer.removeAll();
        Assertions.assertThat((boolean)this.gridLayer.getSelectedGridWidget().isPresent()).isFalse();
    }

    private static class TestDMNGridLayer
    extends DMNGridLayer {
        private Context2D context2D;

        private TestDMNGridLayer(Context2D context2D) {
            this.context2D = context2D;
        }

        public Context2D getContext() {
            return this.context2D;
        }
    }
}

