/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.panel;

import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanelContainer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNGridPanelContainerTest {
    private static final int WIDTH = 100;
    private static final int HEIGHT = 200;
    @Mock
    private Element containerElement;
    @Mock
    private Element containerParentElement;
    private DMNGridPanelContainer container;

    @Before
    public void setup() {
        this.container = (DMNGridPanelContainer)Mockito.spy((Object)new DMNGridPanelContainer());
        Mockito.when((Object)this.container.getElement()).thenReturn((Object)this.containerElement);
        Mockito.when((Object)this.containerElement.getParentElement()).thenReturn((Object)this.containerParentElement);
        Mockito.when((Object)this.containerParentElement.getOffsetWidth()).thenReturn((Object)100);
        Mockito.when((Object)this.containerParentElement.getOffsetHeight()).thenReturn((Object)200);
    }

    @Test
    public void testSetWidgetNotResizableAndResize() {
        Widget widget = (Widget)Mockito.mock(Widget.class);
        this.container.setWidget(widget);
        this.verifyNotResizableInteractions((IsWidget)widget);
    }

    @Test
    public void testSetIsWidgetNotResizableAndResize() {
        IsWidget widget = (IsWidget)Mockito.mock(IsWidget.class);
        this.container.setWidget(widget);
        this.verifyNotResizableInteractions(widget);
    }

    @Test
    public void testSetWidgetIsResizableAndResize() {
        ResizeComposite widget = (ResizeComposite)Mockito.mock(ResizeComposite.class);
        this.container.setWidget((Widget)widget);
        this.verifyResizableInteractions((RequiresResize)widget);
    }

    @Test
    public void testSetWidgetIsResizableAndResizeWithZeroWidth() {
        Mockito.when((Object)this.containerParentElement.getOffsetWidth()).thenReturn((Object)0);
        ResizeComposite widget = (ResizeComposite)Mockito.mock(ResizeComposite.class);
        this.container.setWidget((Widget)widget);
        this.verifyResizableInteractionsWithZeroDimension((RequiresResize)widget);
    }

    @Test
    public void testSetWidgetIsResizableAndResizeWithZeroHeight() {
        Mockito.when((Object)this.containerParentElement.getOffsetHeight()).thenReturn((Object)0);
        ResizeComposite widget = (ResizeComposite)Mockito.mock(ResizeComposite.class);
        this.container.setWidget((Widget)widget);
        this.verifyResizableInteractionsWithZeroDimension((RequiresResize)widget);
    }

    private void verifyNotResizableInteractions(IsWidget widget) {
        this.container.onResize();
        ((DMNGridPanelContainer)Mockito.verify((Object)this.container)).setPixelSize(100, 200);
        Mockito.verifyZeroInteractions((Object[])new Object[]{widget});
    }

    private void verifyResizableInteractions(RequiresResize widget) {
        this.container.onResize();
        ((DMNGridPanelContainer)Mockito.verify((Object)this.container)).setPixelSize(100, 200);
        ((RequiresResize)Mockito.verify((Object)widget)).onResize();
    }

    private void verifyResizableInteractionsWithZeroDimension(RequiresResize widget) {
        this.container.onResize();
        ((DMNGridPanelContainer)Mockito.verify((Object)this.container, (VerificationMode)Mockito.never())).setPixelSize(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((RequiresResize)Mockito.verify((Object)widget)).onResize();
    }
}

