/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.panel;

import com.ait.lienzo.client.core.Context2D;
import com.ait.lienzo.client.core.INativeContext2D;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DMNGridPanelTest {
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private DivElement gridLayerDivElement;
    @Mock
    private Style gridLayerDivElementStyle;
    @Mock
    private CanvasElement gridLayerCanvasElement;
    @Mock
    private Node gridLayerNode;
    @Mock
    private Context2D context2D;
    @Mock
    private INativeContext2D nativeContext2D;
    @Mock
    private RestrictedMousePanMediator mousePanMediator;
    @Mock
    private ContextMenuHandler contextMenuHandler;
    @Mock
    private TransformMediator transformMediator;
    @Mock
    private Transform transform;
    @Mock
    private Transform newTransform;
    @Mock
    private Viewport viewport;
    private DMNGridPanel gridPanel;

    @Before
    public void setup() {
        Mockito.when((Object)this.gridLayer.getElement()).thenReturn((Object)this.gridLayerDivElement);
        Mockito.when((Object)this.gridLayerDivElement.getStyle()).thenReturn((Object)this.gridLayerDivElementStyle);
        Mockito.when((Object)this.gridLayer.getCanvasElement()).thenReturn((Object)this.gridLayerCanvasElement);
        Mockito.when((Object)this.gridLayer.getContext()).thenReturn((Object)this.context2D);
        Mockito.when((Object)this.gridLayer.asNode()).thenReturn((Object)this.gridLayerNode);
        Mockito.when((Object)this.context2D.getNativeContext()).thenReturn((Object)this.nativeContext2D);
        this.gridPanel = (DMNGridPanel)Mockito.spy((Object)new DMNGridPanel(this.gridLayer, this.mousePanMediator, this.contextMenuHandler));
        ((DMNGridPanel)Mockito.doAnswer(o -> {
            ((Scheduler.ScheduledCommand)o.getArguments()[0]).execute();
            return null;
        }).when((Object)this.gridPanel)).doResize((Scheduler.ScheduledCommand)Mockito.any());
        ((DMNGridPanel)Mockito.doNothing().when((Object)this.gridPanel)).updatePanelSize();
        ((DMNGridPanel)Mockito.doNothing().when((Object)this.gridPanel)).refreshScrollPosition();
        Mockito.when((Object)this.gridLayer.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.viewport.getTransform()).thenReturn((Object)this.transform);
        Mockito.when((Object)this.mousePanMediator.getTransformMediator()).thenReturn((Object)this.transformMediator);
        Mockito.when((Object)this.transformMediator.adjust((Transform)ArgumentMatchers.eq((Object)this.transform), (Bounds)Mockito.any())).thenReturn((Object)this.newTransform);
    }

    @Test
    public void testDefaultGridLayer() {
        Assertions.assertThat((Object)this.gridPanel.getDefaultGridLayer()).isEqualTo((Object)this.gridLayer);
    }

    @Test
    public void testOnResize() {
        this.gridPanel.onResize();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((Viewport)Mockito.verify((Object)this.viewport)).setTransform((Transform)ArgumentMatchers.eq((Object)this.newTransform));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)2))).batch();
    }
}

