/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.toolbox;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNCommonActionsToolboxFactory;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNEditBusinessKnowledgeModelToolboxAction;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNEditDecisionToolboxAction;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.Toolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.DeleteNodeAction;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundsImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNCommonActionsToolboxFactoryTest {
    private static final String E_UUID = "e1";
    @Mock
    private ActionsToolboxFactory commonActionsToolboxFactory;
    @Mock
    private DeleteNodeAction deleteNodeAction;
    @Mock
    private DMNEditDecisionToolboxAction editDecisionToolboxAction;
    @Mock
    private DMNEditBusinessKnowledgeModelToolboxAction editBusinessKnowledgeModelToolboxAction;
    @Mock
    private ActionsToolboxView view;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Node element;
    private DMNCommonActionsToolboxFactory tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.element.getUUID()).thenReturn((Object)E_UUID);
        Mockito.when((Object)this.element.asNode()).thenReturn((Object)this.element);
        Mockito.when((Object)this.commonActionsToolboxFactory.getActions((AbstractCanvasHandler)Matchers.eq((Object)this.canvasHandler), (Element)Mockito.any(Element.class))).thenReturn(Collections.singleton(this.deleteNodeAction));
        this.tested = new DMNCommonActionsToolboxFactory(this.commonActionsToolboxFactory, () -> this.editDecisionToolboxAction, () -> this.editBusinessKnowledgeModelToolboxAction, () -> this.view);
    }

    @Test
    public void testBuildToolboxForNoDecisionType() {
        Optional _toolbox = this.tested.build(this.canvasHandler, (Element)this.element);
        Assert.assertTrue((boolean)_toolbox.isPresent());
        Toolbox toolbox = (Toolbox)_toolbox.get();
        Assert.assertTrue((boolean)(toolbox instanceof ActionsToolbox));
        ActionsToolbox actionsToolbox = (ActionsToolbox)toolbox;
        Assert.assertEquals((Object)E_UUID, (Object)actionsToolbox.getElementUUID());
        Assert.assertEquals((long)1L, (long)actionsToolbox.size());
        Assert.assertEquals((Object)this.deleteNodeAction, actionsToolbox.iterator().next());
        ((ActionsToolboxView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((ActionsToolbox)Matchers.eq((Object)actionsToolbox));
        ((ActionsToolboxView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addButton((Glyph)Mockito.any(Glyph.class), Mockito.anyString(), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testBuildToolboxForDecisionType() {
        NodeImpl decisionNode = new NodeImpl("decisionNode1");
        Decision decision = new Decision();
        BoundsImpl bounds = new BoundsImpl(new BoundImpl(Double.valueOf(0.0), Double.valueOf(0.0)), new BoundImpl(Double.valueOf(100.0), Double.valueOf(150.0)));
        ViewImpl nodeContent = new ViewImpl((Object)decision, (Bounds)bounds);
        decisionNode.setContent((Object)nodeContent);
        Optional _toolbox = this.tested.build(this.canvasHandler, (Element)decisionNode);
        Assert.assertTrue((boolean)_toolbox.isPresent());
        Toolbox toolbox = (Toolbox)_toolbox.get();
        Assert.assertTrue((boolean)(toolbox instanceof ActionsToolbox));
        ActionsToolbox actionsToolbox = (ActionsToolbox)toolbox;
        Assert.assertEquals((Object)"decisionNode1", (Object)actionsToolbox.getElementUUID());
        Assert.assertEquals((long)2L, (long)actionsToolbox.size());
        Iterator actionsIt = actionsToolbox.iterator();
        Assert.assertEquals((Object)this.deleteNodeAction, actionsIt.next());
        Assert.assertEquals((Object)this.editDecisionToolboxAction, actionsIt.next());
        Assert.assertFalse((boolean)actionsIt.hasNext());
        ((ActionsToolboxView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((ActionsToolbox)Matchers.eq((Object)actionsToolbox));
        ((ActionsToolboxView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addButton((Glyph)Mockito.any(Glyph.class), Mockito.anyString(), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testBuildToolboxForBusinessKnowledgeModelType() {
        NodeImpl bkmNode = new NodeImpl("bkmNode1");
        BusinessKnowledgeModel bkm = new BusinessKnowledgeModel();
        BoundsImpl bounds = new BoundsImpl(new BoundImpl(Double.valueOf(0.0), Double.valueOf(0.0)), new BoundImpl(Double.valueOf(100.0), Double.valueOf(150.0)));
        ViewImpl nodeContent = new ViewImpl((Object)bkm, (Bounds)bounds);
        bkmNode.setContent((Object)nodeContent);
        Optional _toolbox = this.tested.build(this.canvasHandler, (Element)bkmNode);
        Assert.assertTrue((boolean)_toolbox.isPresent());
        Toolbox toolbox = (Toolbox)_toolbox.get();
        Assert.assertTrue((boolean)(toolbox instanceof ActionsToolbox));
        ActionsToolbox actionsToolbox = (ActionsToolbox)toolbox;
        Assert.assertEquals((Object)"bkmNode1", (Object)actionsToolbox.getElementUUID());
        Assert.assertEquals((long)2L, (long)actionsToolbox.size());
        Iterator actionsIt = actionsToolbox.iterator();
        Assert.assertEquals((Object)this.deleteNodeAction, actionsIt.next());
        Assert.assertEquals((Object)this.editBusinessKnowledgeModelToolboxAction, actionsIt.next());
        Assert.assertFalse((boolean)actionsIt.hasNext());
        ((ActionsToolboxView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((ActionsToolbox)Matchers.eq((Object)actionsToolbox));
        ((ActionsToolboxView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addButton((Glyph)Mockito.any(Glyph.class), Mockito.anyString(), (Consumer)Mockito.any(Consumer.class));
    }
}

