/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.toolbox;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNEditDecisionToolboxAction;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundsImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNEditDecisionToolboxActionTest {
    private static final String E_UUID = "e1";
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Index<?, ?> graphIndex;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private ClientSession session;
    @Mock
    private ClientTranslationService translationService;
    @Mock
    private EventSourceMock<EditExpressionEvent> editExpressionEvent;
    private DMNEditDecisionToolboxAction tested;
    private Decision decision;
    private Node<View<Decision>, Edge> decisionNode;

    @Before
    public void setup() throws Exception {
        this.decisionNode = new NodeImpl(E_UUID);
        this.decision = new Decision();
        BoundsImpl bounds = new BoundsImpl(new BoundImpl(Double.valueOf(0.0), Double.valueOf(0.0)), new BoundImpl(Double.valueOf(100.0), Double.valueOf(150.0)));
        ViewImpl nodeContent = new ViewImpl((Object)this.decision, (Bounds)bounds);
        this.decisionNode.setContent((Object)nodeContent);
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn(this.graphIndex);
        Mockito.when((Object)this.graphIndex.get((String)Matchers.eq((Object)E_UUID))).thenReturn(this.decisionNode);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        this.tested = new DMNEditDecisionToolboxAction(this.sessionManager, this.translationService, this.editExpressionEvent);
    }

    @Test
    public void testTitle() {
        this.tested.getTitle(this.canvasHandler, E_UUID);
        ((ClientTranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.times((int)1))).getKeyValue((String)Matchers.eq((Object)"org.kie.workbench.common.stunner.core.edit"));
    }

    @Test
    public void testAction() {
        MouseClickEvent event = (MouseClickEvent)Mockito.mock(MouseClickEvent.class);
        ToolboxAction cascade = this.tested.onMouseClick(this.canvasHandler, E_UUID, event);
        Assert.assertEquals((Object)this.tested, (Object)cascade);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EditExpressionEvent.class);
        ((EventSourceMock)Mockito.verify(this.editExpressionEvent, (VerificationMode)Mockito.times((int)1))).fire(eventCaptor.capture());
        EditExpressionEvent editExprEvent = (EditExpressionEvent)eventCaptor.getValue();
        Assert.assertEquals((Object)this.decision, (Object)editExprEvent.getHasExpression());
        Assert.assertEquals((Object)this.decision, editExprEvent.getHasName().get());
        Assert.assertEquals((Object)this.session, (Object)editExprEvent.getSession());
    }
}

