/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.toolbox;

import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNFlowActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateConnectorAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateNodeAction;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.lookup.util.CommonLookups;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNFlowActionsToolboxFactoryTest {
    private static final String DS_ID = "defSetId1";
    private static final String EDGE_ID = "edgeDefId1";
    private static final String NODE_ID = "nodeDefId1";
    private static final String E_UUID = "e1";
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private DefinitionManager definitionManager;
    @Mock
    private AdapterManager adapters;
    @Mock
    private DefinitionAdapter definitionAdapter;
    @Mock
    private CommonLookups commonLookups;
    @Mock
    private CreateConnectorAction createConnectorAction;
    @Mock
    private CreateNodeAction createNodeAction;
    @Mock
    private ActionsToolboxView view;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Metadata metadata;
    @Mock
    private Graph graph;
    @Mock
    private Object allowedNodeDefinition;
    @Mock
    private Node<View<Object>, Edge> element;
    private DMNFlowActionsToolboxFactory tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.definitionUtils.getDefinitionManager()).thenReturn((Object)this.definitionManager);
        Mockito.when((Object)this.definitionManager.adapters()).thenReturn((Object)this.adapters);
        Mockito.when((Object)this.adapters.forDefinition()).thenReturn((Object)this.definitionAdapter);
        Mockito.when((Object)this.definitionAdapter.getId(Matchers.eq((Object)this.allowedNodeDefinition))).thenReturn((Object)NODE_ID);
        Mockito.when((Object)this.createConnectorAction.setEdgeId(Mockito.anyString())).thenReturn((Object)this.createConnectorAction);
        Mockito.when((Object)this.createNodeAction.setEdgeId(Mockito.anyString())).thenReturn((Object)this.createNodeAction);
        Mockito.when((Object)this.createNodeAction.setNodeId(Mockito.anyString())).thenReturn((Object)this.createNodeAction);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.metadata.getDefinitionSetId()).thenReturn((Object)DS_ID);
        Mockito.when((Object)this.element.getUUID()).thenReturn((Object)E_UUID);
        Mockito.when((Object)this.element.asNode()).thenReturn(this.element);
        Mockito.when((Object)this.commonLookups.getAllowedConnectors((String)Matchers.eq((Object)DS_ID), (Node)Matchers.eq(this.element), Mockito.anyInt(), Mockito.anyInt())).thenReturn(Collections.singleton(EDGE_ID));
        Mockito.when((Object)this.definitionUtils.getDefaultConnectorId((String)Matchers.eq((Object)DS_ID))).thenReturn((Object)EDGE_ID);
        Mockito.when((Object)this.commonLookups.getAllowedTargetDefinitions((String)Matchers.eq((Object)DS_ID), (Graph)Matchers.eq((Object)this.graph), (Node)Matchers.eq(this.element), (String)Matchers.eq((Object)EDGE_ID), Mockito.anyInt(), Mockito.anyInt())).thenReturn(Collections.singleton(this.allowedNodeDefinition));
        this.tested = new DMNFlowActionsToolboxFactory(this.definitionUtils, this.commonLookups, () -> this.createConnectorAction, () -> this.createNodeAction, () -> this.view);
    }

    @Test
    public void testBuildToolbox() {
        Optional toolbox = this.tested.build(this.canvasHandler, this.element);
        Assert.assertTrue((boolean)toolbox.isPresent());
        Assert.assertTrue((boolean)(toolbox.get() instanceof ActionsToolbox));
        ActionsToolbox actionsToolbox = (ActionsToolbox)toolbox.get();
        Assert.assertEquals((Object)E_UUID, (Object)actionsToolbox.getElementUUID());
        Assert.assertEquals((long)2L, (long)actionsToolbox.size());
        Iterator actionIt = actionsToolbox.iterator();
        Assert.assertEquals((Object)this.createConnectorAction, actionIt.next());
        Assert.assertEquals((Object)this.createNodeAction, actionIt.next());
        ((CreateConnectorAction)Mockito.verify((Object)this.createConnectorAction, (VerificationMode)Mockito.times((int)1))).setEdgeId((String)Matchers.eq((Object)EDGE_ID));
        ((CreateNodeAction)Mockito.verify((Object)this.createNodeAction, (VerificationMode)Mockito.times((int)1))).setEdgeId((String)Matchers.eq((Object)EDGE_ID));
        ((CreateNodeAction)Mockito.verify((Object)this.createNodeAction, (VerificationMode)Mockito.times((int)1))).setNodeId((String)Matchers.eq((Object)NODE_ID));
        ((ActionsToolboxView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((ActionsToolbox)Matchers.eq((Object)actionsToolbox));
        ((ActionsToolboxView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addButton((Glyph)Mockito.any(Glyph.class), Mockito.anyString(), (Consumer)Mockito.any(Consumer.class));
    }
}

