/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.context;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.expressions.types.context.AddContextEntryCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.NameColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class AddContextEntryCommandTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private NameColumn uiNameColumn;
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private ExpressionEditorDefinitions expressionEditorDefinitions;
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private Context context;
    private ContextEntry defaultResultContextEntry;
    private ContextEntry contextEntry;
    private GridData uiModel;
    private DMNGridRow uiModelRow;
    private DMNGridRow uiDefaultResultModelRow;
    private ContextUIModelMapper uiModelMapper;
    private AddContextEntryCommand command;

    @Before
    public void setup() {
        this.context = new Context();
        this.contextEntry = new ContextEntry(){
            {
                this.setVariable(new InformationItem(){
                    {
                        this.setName(new Name("variable"));
                    }
                });
            }
        };
        this.defaultResultContextEntry = new ContextEntry();
        this.context.getContextEntry().add(this.defaultResultContextEntry);
        this.uiModel = new BaseGridData();
        this.uiModelRow = new DMNGridRow();
        this.uiDefaultResultModelRow = new DMNGridRow();
        this.uiModel.appendRow((GridRow)this.uiDefaultResultModelRow);
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiNameColumn);
        this.uiModel.appendColumn((GridColumn)this.uiExpressionEditorColumn);
        this.uiModelMapper = new ContextUIModelMapper(() -> this.uiModel, () -> Optional.of(this.context), () -> this.expressionEditorDefinitions);
        this.command = new AddContextEntryCommand(this.context, this.contextEntry, this.uiModel, this.uiModelRow, this.uiModelMapper, this.canvasOperation);
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((NameColumn)Mockito.doReturn((Object)1).when((Object)this.uiNameColumn)).getIndex();
        ((ExpressionEditorColumn)Mockito.doReturn((Object)2).when((Object)this.uiExpressionEditorColumn)).getIndex();
        ((ExpressionEditorDefinitions)Mockito.doReturn(Optional.empty()).when((Object)this.expressionEditorDefinitions)).getExpressionEditorDefinition((Optional)Matchers.any(Optional.class));
    }

    @Test
    public void testGraphCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecute() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)2L, (long)this.context.getContextEntry().size());
        Assert.assertEquals((Object)this.contextEntry, this.context.getContextEntry().get(0));
        Assert.assertEquals((Object)this.defaultResultContextEntry, this.context.getContextEntry().get(1));
    }

    @Test
    public void testGraphCommandExecuteMultipleEntriesPresent() {
        ContextEntry firstEntry = new ContextEntry(){
            {
                this.setVariable(new InformationItem(){
                    {
                        this.setName(new Name("old one"));
                    }
                });
            }
        };
        this.context.getContextEntry().add(0, firstEntry);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)3L, (long)this.context.getContextEntry().size());
        Assert.assertEquals((Object)firstEntry, this.context.getContextEntry().get(0));
        Assert.assertEquals((Object)this.contextEntry, this.context.getContextEntry().get(1));
        Assert.assertEquals((Object)this.defaultResultContextEntry, this.context.getContextEntry().get(2));
    }

    @Test
    public void testGraphCommandUndo() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.context.getContextEntry().size());
        Assert.assertEquals((Object)this.defaultResultContextEntry, this.context.getContextEntry().get(0));
    }

    @Test
    public void testGraphCommandUndoMultipleEntriesPresent() {
        ContextEntry firstEntry = new ContextEntry(){
            {
                this.setVariable(new InformationItem(){
                    {
                        this.setName(new Name("old one"));
                    }
                });
            }
        };
        this.context.getContextEntry().add(0, firstEntry);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)2L, (long)this.context.getContextEntry().size());
        Assert.assertEquals((Object)firstEntry, this.context.getContextEntry().get(0));
        Assert.assertEquals((Object)this.defaultResultContextEntry, this.context.getContextEntry().get(1));
    }

    @Test
    public void testCanvasCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecute() {
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)this.uiModelRow, this.uiModel.getRows().get(0));
        Assert.assertEquals((Object)this.uiDefaultResultModelRow, this.uiModel.getRows().get(1));
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiNameColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(2));
        Assert.assertEquals((long)2L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"variable", (Object)this.uiModel.getCell(0, 1).getValue().getValue());
        Assert.assertNull((Object)this.uiModel.getCell(1, 0));
        Assert.assertNull((Object)this.uiModel.getCell(1, 1));
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteMultipleEntries() {
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command firstEntryCanvasCommand = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)firstEntryCanvasCommand.execute((Object)this.handler));
        ContextEntry secondRowEntry = new ContextEntry(){
            {
                this.setVariable(new InformationItem(){
                    {
                        this.setName(new Name("last entry"));
                    }
                });
            }
        };
        DMNGridRow uiSecondModelRow = new DMNGridRow();
        this.command = new AddContextEntryCommand(this.context, secondRowEntry, this.uiModel, uiSecondModelRow, this.uiModelMapper, this.canvasOperation);
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command secondEntryCanvasCommand = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)secondEntryCanvasCommand.execute((Object)this.handler));
        Assert.assertEquals((long)3L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)this.uiModelRow, this.uiModel.getRows().get(0));
        Assert.assertEquals((Object)uiSecondModelRow, this.uiModel.getRows().get(1));
        Assert.assertEquals((Object)this.uiDefaultResultModelRow, this.uiModel.getRows().get(2));
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiNameColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(2));
        Assert.assertEquals((long)2L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"variable", (Object)this.uiModel.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)2, (Object)this.uiModel.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)"last entry", (Object)this.uiModel.getCell(1, 1).getValue().getValue());
        Assert.assertNull((Object)this.uiModel.getCell(2, 0));
        Assert.assertNull((Object)this.uiModel.getCell(2, 1));
        ((Command)Mockito.verify((Object)this.canvasOperation, (VerificationMode)Mockito.times((int)2))).execute();
    }

    @Test
    public void testCanvasCommandUndo() {
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Command[]{this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiNameColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(2));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertNull((Object)this.uiModel.getCell(0, 0));
        Assert.assertNull((Object)this.uiModel.getCell(0, 1));
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }
}

