/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.context;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.expressions.types.context.MoveRowsCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.NameColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class MoveRowsCommandTest {
    protected static final String II1 = "ii1";
    protected static final String II2 = "ii2";
    protected static final String II3 = "ii3";
    @Mock
    protected DMNGridLayer gridLayer;
    @Mock
    protected RowNumberColumn uiRowNumberColumn;
    @Mock
    protected NameColumn uiNameColumn;
    @Mock
    protected ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    protected Command canvasOperation;
    @Mock
    protected AbstractCanvasHandler handler;
    @Mock
    protected GraphCommandExecutionContext gce;
    @Mock
    protected RuleManager ruleManager;
    protected Context context;
    protected DMNGridData uiModel;
    protected MoveRowsCommand command;

    @Before
    public void setup() {
        this.context = new Context();
        this.uiModel = new DMNGridData(this.gridLayer);
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((NameColumn)Mockito.doReturn((Object)1).when((Object)this.uiNameColumn)).getIndex();
        ((ExpressionEditorColumn)Mockito.doReturn((Object)2).when((Object)this.uiExpressionEditorColumn)).getIndex();
        this.addContextEntry(II1);
        this.addContextEntry(II2);
        this.addUiModelColumn((GridColumn<?>)this.uiRowNumberColumn);
        this.addUiModelColumn((GridColumn<?>)this.uiNameColumn);
        this.addUiModelColumn((GridColumn<?>)this.uiExpressionEditorColumn);
        this.addUiModelRow(0);
        this.addUiModelRow(1);
    }

    protected void addContextEntry(final String variable) {
        this.context.getContextEntry().add(new ContextEntry(){
            {
                this.setVariable(new InformationItem(){
                    {
                        this.setName(new Name(variable));
                    }
                });
                this.setExpression((Expression)new LiteralExpression(){
                    {
                        this.setText(MoveRowsCommandTest.this.makeLiteralExpression(variable, MoveRowsCommandTest.this.context.getContextEntry().size()));
                    }
                });
            }
        });
    }

    protected String makeLiteralExpression(String base, int index) {
        return base + "e" + index;
    }

    protected void addUiModelColumn(GridColumn<?> uiColumn) {
        this.uiModel.appendColumn(uiColumn);
    }

    protected void addUiModelRow(int rowIndex) {
        DMNGridRow uiRow = new DMNGridRow();
        this.uiModel.appendRow((GridRow)uiRow);
        this.uiModel.setCell(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)(rowIndex + 1)));
        this.uiModel.setCell(rowIndex, 1, (GridCellValue)new BaseGridCellValue((Object)("name" + rowIndex)));
        this.uiModel.setCell(rowIndex, 2, (GridCellValue)new BaseGridCellValue((Object)("editor" + rowIndex)));
    }

    private void setupCommand(int index, GridRow uiModelRow) {
        this.command = new MoveRowsCommand(this.context, this.uiModel, index, Collections.singletonList(uiModelRow), this.canvasOperation);
    }

    @Test
    public void testGraphCommandAllow() {
        this.setupCommand(0, this.uiModel.getRow(0));
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecuteMoveUp() {
        this.setupCommand(0, this.uiModel.getRow(1));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.newGraphCommand(this.handler).execute((Object)this.gce));
        this.assertContextEntryDefinitions(new int[]{1, 0});
    }

    @Test
    public void testGraphCommandExecuteMoveUpThreeRows() {
        this.addContextEntry(II3);
        this.addUiModelRow(2);
        this.setupCommand(0, this.uiModel.getRow(2));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.newGraphCommand(this.handler).execute((Object)this.gce));
        this.assertContextEntryDefinitions(new int[]{1, 2, 0});
    }

    @Test
    public void testGraphCommandExecuteMoveDown() {
        this.setupCommand(1, this.uiModel.getRow(0));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.newGraphCommand(this.handler).execute((Object)this.gce));
        this.assertContextEntryDefinitions(new int[]{1, 0});
    }

    @Test
    public void testGraphCommandExecuteMoveDownThreeRows() {
        this.addContextEntry(II3);
        this.addUiModelRow(2);
        this.setupCommand(2, this.uiModel.getRow(0));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.newGraphCommand(this.handler).execute((Object)this.gce));
        this.assertContextEntryDefinitions(new int[]{2, 0, 1});
    }

    @Test
    public void testGraphCommandUndoMoveUp() {
        this.setupCommand(0, this.uiModel.getRow(1));
        org.kie.workbench.common.stunner.core.command.Command gc = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.execute((Object)this.gce));
        this.command.newCanvasCommand(this.handler).execute((Object)this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.undo((Object)this.gce));
        this.assertContextEntryDefinitions(new int[]{0, 1});
    }

    @Test
    public void testGraphCommandUndoMoveDown() {
        this.setupCommand(1, this.uiModel.getRow(0));
        org.kie.workbench.common.stunner.core.command.Command gc = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.execute((Object)this.gce));
        this.command.newCanvasCommand(this.handler).execute((Object)this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)gc.undo((Object)this.gce));
        this.assertContextEntryDefinitions(new int[]{0, 1});
    }

    private void assertContextEntryDefinitions(int[] iiRowIndexes) {
        String[] rowValueBases = new String[]{II1, II2, II3};
        int iiRowIndexIterator = 0;
        for (int iiRowIndex : iiRowIndexes) {
            Assert.assertEquals((Object)rowValueBases[iiRowIndexIterator], (Object)((ContextEntry)this.context.getContextEntry().get(iiRowIndex)).getVariable().getName().getValue());
            Assert.assertEquals((Object)this.makeLiteralExpression(rowValueBases[iiRowIndexIterator], iiRowIndexIterator), (Object)((LiteralExpression)((ContextEntry)this.context.getContextEntry().get(iiRowIndex)).getExpression()).getText());
            ++iiRowIndexIterator;
        }
    }

    @Test
    public void testCanvasCommandAllow() {
        this.setupCommand(0, this.uiModel.getRow(0));
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecuteMoveUp() {
        this.setupCommand(0, this.uiModel.getRow(1));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.newCanvasCommand(this.handler).execute((Object)this.handler));
        this.assertUiModelDefinition(new int[]{1, 0});
    }

    @Test
    public void testCanvasCommandExecuteMoveUpThreeRows() {
        this.addContextEntry(II3);
        this.addUiModelRow(2);
        this.setupCommand(0, this.uiModel.getRow(2));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.newCanvasCommand(this.handler).execute((Object)this.handler));
        this.assertUiModelDefinition(new int[]{2, 0, 1});
    }

    @Test
    public void testCanvasCommandExecuteMoveDown() {
        this.setupCommand(1, this.uiModel.getRow(0));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.newCanvasCommand(this.handler).execute((Object)this.handler));
        this.assertUiModelDefinition(new int[]{1, 0});
    }

    @Test
    public void testCanvasCommandExecuteMoveDownThreeRows() {
        this.addContextEntry(II3);
        this.addUiModelRow(2);
        this.setupCommand(2, this.uiModel.getRow(0));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.newCanvasCommand(this.handler).execute((Object)this.handler));
        this.assertUiModelDefinition(new int[]{1, 2, 0});
    }

    @Test
    public void testCanvasCommandUndoMoveUp() {
        this.setupCommand(0, this.uiModel.getRow(1));
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        this.assertUiModelDefinition(new int[]{0, 1});
    }

    @Test
    public void testCanvasCommandUndoMoveDown() {
        this.setupCommand(1, this.uiModel.getRow(0));
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        this.assertUiModelDefinition(new int[]{0, 1});
    }

    private void assertUiModelDefinition(int[] rowIndexes) {
        int rowIndexesIterator = 0;
        for (int rowIndex : rowIndexes) {
            if (rowIndex != rowIndexes[rowIndexes.length - 1]) {
                Assert.assertEquals((Object)(rowIndexesIterator + 1), (Object)this.uiModel.getCell(rowIndexesIterator, 0).getValue().getValue());
            }
            Assert.assertEquals((Object)("name" + rowIndexes[rowIndexesIterator]), (Object)this.uiModel.getCell(rowIndexesIterator, 1).getValue().getValue());
            Assert.assertEquals((Object)("editor" + rowIndexes[rowIndexesIterator]), (Object)this.uiModel.getCell(rowIndexesIterator, 2).getValue().getValue());
            ++rowIndexesIterator;
        }
    }
}

