/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.AddInputClauseCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.InputClauseColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class AddInputClauseCommandTest {
    @Mock
    private DMNGridLayer selectionManager;
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private InputClauseColumn uiInputClauseColumn;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    private DecisionTable dtable;
    private InputClause inputClause;
    private GridData uiModel;
    private DecisionTableUIModelMapper uiModelMapper;
    private AddInputClauseCommand command;
    @Mock
    private Command canvasOperation;

    @Before
    public void setUp() throws Exception {
        this.dtable = new DecisionTable();
        this.uiModel = new DMNGridData(this.selectionManager);
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.inputClause = new InputClause();
        this.uiModelMapper = new DecisionTableUIModelMapper(() -> this.uiModel, () -> Optional.of(this.dtable));
        this.command = new AddInputClauseCommand(this.dtable, this.inputClause, this.uiModel, this.uiInputClauseColumn, this.uiModelMapper, this.canvasOperation);
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((InputClauseColumn)Mockito.doReturn((Object)1).when((Object)this.uiInputClauseColumn)).getIndex();
    }

    @Test
    public void testGraphCommandAllow() throws Exception {
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandExecute() throws Exception {
        this.dtable.getRule().add(new DecisionRule());
        this.dtable.getRule().add(new DecisionRule());
        Assert.assertEquals((long)0L, (long)this.dtable.getInput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)1L, (long)this.dtable.getInput().size());
        Assert.assertEquals((long)1L, (long)((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().size());
        Assert.assertEquals((Object)"unary test", (Object)((UnaryTests)((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().get(0)).getText());
        Assert.assertEquals((long)1L, (long)((DecisionRule)this.dtable.getRule().get(1)).getInputEntry().size());
        Assert.assertEquals((Object)"unary test", (Object)((UnaryTests)((DecisionRule)this.dtable.getRule().get(1)).getInputEntry().get(0)).getText());
    }

    @Test
    public void testGraphCommandExecuteExistingNotAffected() throws Exception {
        String ruleOneOldInput = "old rule 1";
        String ruleTwoOldInput = "old rule 2";
        this.dtable.getInput().add(new InputClause());
        this.addRuleWithInputClauseValues("old rule 1");
        this.addRuleWithInputClauseValues("old rule 2");
        Assert.assertEquals((long)1L, (long)this.dtable.getInput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)2L, (long)this.dtable.getInput().size());
        Assert.assertEquals((long)2L, (long)((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().size());
        Assert.assertEquals((Object)"old rule 1", (Object)((UnaryTests)((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().get(0)).getText());
        Assert.assertEquals((Object)"unary test", (Object)((UnaryTests)((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().get(1)).getText());
        Assert.assertEquals((long)2L, (long)((DecisionRule)this.dtable.getRule().get(1)).getInputEntry().size());
        Assert.assertEquals((Object)"old rule 2", (Object)((UnaryTests)((DecisionRule)this.dtable.getRule().get(1)).getInputEntry().get(0)).getText());
        Assert.assertEquals((Object)"unary test", (Object)((UnaryTests)((DecisionRule)this.dtable.getRule().get(1)).getInputEntry().get(1)).getText());
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testGraphCommandUndoNoInputClauseColumns() throws Exception {
        this.dtable.getRule().add(new DecisionRule());
        Assert.assertEquals((long)0L, (long)this.dtable.getInput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandUndoJustLastInputClauseColumn() throws Exception {
        String ruleOneOldInput = "old rule 1";
        String ruleTwoOldInput = "old rule 2";
        this.dtable.getInput().add(new InputClause());
        this.addRuleWithInputClauseValues("old rule 1");
        this.addRuleWithInputClauseValues("old rule 2");
        Assert.assertEquals((long)1L, (long)this.dtable.getInput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)1L, (long)this.dtable.getInput().size());
        Assert.assertEquals((long)1L, (long)((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().size());
        Assert.assertEquals((Object)"old rule 1", (Object)((UnaryTests)((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().get(0)).getText());
        Assert.assertEquals((long)1L, (long)((DecisionRule)this.dtable.getRule().get(1)).getInputEntry().size());
        Assert.assertEquals((Object)"old rule 2", (Object)((UnaryTests)((DecisionRule)this.dtable.getRule().get(1)).getInputEntry().get(0)).getText());
    }

    @Test
    public void testCanvasCommandAllow() throws Exception {
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasCommand.allow((Object)this.canvasHandler));
    }

    @Test
    public void testCanvasCommandAddRuleAndThenUndo() throws Exception {
        String ruleOneInputValue = "one";
        String ruleTwoInputValue = "two";
        this.addRuleWithInputClauseValues("one");
        this.addRuleWithInputClauseValues("two");
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        graphCommand.execute((Object)this.graphCommandExecutionContext);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        org.kie.workbench.common.stunner.core.command.Command canvasAddInputClauseCommand = this.command.newCanvasCommand(this.canvasHandler);
        canvasAddInputClauseCommand.execute((Object)this.canvasHandler);
        Assert.assertEquals((Object)"one", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(1)).getValue().getValue());
        Assert.assertEquals((Object)"two", (Object)((GridCell)this.uiModel.getRow(1).getCells().get(1)).getValue().getValue());
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasAddInputClauseCommand.undo((Object)this.canvasHandler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        ((Command)Mockito.verify((Object)this.canvasOperation, (VerificationMode)Mockito.times((int)2))).execute();
    }

    @Test
    public void testCanvasCommandUndoWhenNothingBefore() throws Exception {
        org.kie.workbench.common.stunner.core.command.Command canvasAddInputClauseCommand = this.command.newCanvasCommand(this.canvasHandler);
        canvasAddInputClauseCommand.undo((Object)this.canvasHandler);
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    private void addRuleWithInputClauseValues(final String ... inputClauseValues) {
        this.dtable.getRule().add(new DecisionRule(){
            {
                Stream.of(inputClauseValues).forEach(iClause -> this.getInputEntry().add(new UnaryTests((String)iClause){
                    final /* synthetic */ String val$iClause;
                    {
                        this.val$iClause = string;
                        this.setText(this.val$iClause);
                    }
                }));
            }
        });
    }
}

