/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.function;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.SetKindCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class SetKindCommandTest {
    @Mock
    private GridColumn mockColumn;
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    @Mock
    private BaseExpressionGrid originalEditor;
    private LiteralExpression originalExpression = new LiteralExpression();
    private FunctionDefinition.Kind originalKind = FunctionDefinition.Kind.FEEL;
    @Mock
    private BaseExpressionGrid newEditor;
    private LiteralExpression newExpression = new LiteralExpression();
    private FunctionDefinition.Kind newKind = FunctionDefinition.Kind.JAVA;
    private FunctionDefinition function;
    private GridData uiModel;
    private SetKindCommand command;

    @Before
    public void setup() {
        this.function = new FunctionDefinition();
        this.function.getAdditionalAttributes().put(FunctionDefinition.KIND_QNAME, this.originalKind.code());
        this.function.setExpression((Expression)this.originalExpression);
        this.uiModel = new BaseGridData();
        this.uiModel.appendColumn(this.mockColumn);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.setCell(0, 0, (GridCellValue)new ExpressionCellValue(Optional.of(this.originalEditor)));
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
    }

    private void setupCommand() {
        GridCellValueTuple gcv = new GridCellValueTuple(0, 0, this.uiModel, (GridCellValue)new ExpressionCellValue(Optional.of(this.newEditor)));
        this.command = new SetKindCommand(gcv, this.function, this.newKind, Optional.of(this.newExpression), this.canvasOperation);
    }

    @Test
    public void testGraphCommandAllow() {
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecute() {
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)this.newKind.code(), this.function.getAdditionalAttributes().get(FunctionDefinition.KIND_QNAME));
        Assert.assertEquals((Object)this.newExpression, (Object)this.function.getExpression());
    }

    @Test
    public void testGraphCommandUndo() {
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((Object)this.originalKind.code(), this.function.getAdditionalAttributes().get(FunctionDefinition.KIND_QNAME));
        Assert.assertEquals((Object)this.originalExpression, (Object)this.function.getExpression());
    }

    @Test
    public void testGraphCommandUndoWithNullOriginalExpression() {
        this.function.setExpression(null);
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((Object)this.originalKind.code(), this.function.getAdditionalAttributes().get(FunctionDefinition.KIND_QNAME));
        Assert.assertNull((Object)this.function.getExpression());
    }

    @Test
    public void testCanvasCommandAllow() {
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecute() {
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.handler));
        Assert.assertEquals((Object)this.newEditor, ((Optional)((ExpressionCellValue)this.uiModel.getCell(0, 0).getValue()).getValue()).get());
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndo() {
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.handler));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.handler));
        Assert.assertEquals((Object)this.originalEditor, ((Optional)((ExpressionCellValue)this.uiModel.getCell(0, 0).getValue()).getValue()).get());
        ((Command)Mockito.verify((Object)this.canvasOperation, (VerificationMode)Mockito.times((int)2))).execute();
    }
}

