/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.relation;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.List;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.AddRelationColumnCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class AddRelationColumnCommandTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private RelationColumn uiModelColumn;
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private Relation relation;
    private InformationItem informationItem;
    private GridData uiModel;
    private RelationUIModelMapper uiModelMapper;
    private AddRelationColumnCommand command;

    @Before
    public void setup() {
        this.relation = new Relation();
        this.informationItem = new InformationItem();
        this.uiModel = new BaseGridData();
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModelMapper = new RelationUIModelMapper(() -> this.uiModel, () -> Optional.of(this.relation));
        this.command = new AddRelationColumnCommand(this.relation, this.informationItem, this.uiModel, this.uiModelColumn, this.uiModelMapper, this.canvasOperation);
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((RelationColumn)Mockito.doReturn((Object)1).when((Object)this.uiModelColumn)).getIndex();
    }

    @Test
    public void testGraphCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecuteWithRows() {
        this.relation.getRow().add(new List());
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.relation.getColumn().size());
        Assert.assertEquals((Object)this.informationItem, this.relation.getColumn().get(0));
        Assert.assertEquals((long)1L, (long)this.relation.getRow().size());
        Assert.assertEquals((long)1L, (long)((List)this.relation.getRow().get(0)).getExpression().size());
        Assert.assertTrue((boolean)(((List)this.relation.getRow().get(0)).getExpression().get(0) instanceof LiteralExpression));
    }

    @Test
    public void testGraphCommandExecuteWithNoRows() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.relation.getColumn().size());
        Assert.assertEquals((Object)this.informationItem, this.relation.getColumn().get(0));
        Assert.assertEquals((long)0L, (long)this.relation.getRow().size());
    }

    @Test
    public void testGraphCommandUndoWithRows() {
        this.relation.getRow().add(new List());
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)1L, (long)this.relation.getRow().size());
    }

    @Test
    public void testGraphCommandUndoWithNoRows() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)0L, (long)this.relation.getRow().size());
    }

    @Test
    public void testCanvasCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecuteWithRows() {
        this.relation.getRow().add(new List());
        this.uiModel.appendRow((GridRow)new DMNGridRow());
        this.uiModelMapper.fromDMNModel(0, 0);
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((long)2L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"", (Object)this.uiModel.getCell(0, 1).getValue().getValue());
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteWithNoRows() {
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithRows() {
        this.relation.getRow().add(new List());
        this.uiModel.appendRow((GridRow)new DMNGridRow());
        this.uiModelMapper.fromDMNModel(0, 0);
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Command[]{this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((long)1L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithNoRows() {
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Command[]{this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }
}

