/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.general;

import com.google.gwt.user.client.ui.IsWidget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.client.commands.general.BaseNavigateCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionViewer;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.AbstractSessionPresenter;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.workbench.widgets.listbar.ResizeFlowPanel;

public abstract class BaseNavigationCommandTest {
    @Mock
    protected ExpressionEditorView.Presenter editor;
    @Mock
    protected ResizeFlowPanel editorContainerForErrai1090;
    @Mock
    protected AbstractSessionPresenter sessionPresenter;
    @Mock
    protected SessionPresenter.View sessionPresenterView;
    @Mock
    protected SessionViewer sessionView;
    @Mock
    protected IsWidget view;
    @Mock
    protected SessionManager sessionManager;
    @Mock
    protected SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    protected AbstractClientSession session;
    @Mock
    protected HasName hasName;
    @Mock
    protected HasExpression hasExpression;
    @Mock
    protected GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    protected AbstractCanvasHandler canvasHandler;
    @Mock
    protected AbstractCanvas canvas;
    @Mock
    protected Layer layer;
    protected BaseNavigateCommand command;

    @Before
    public void setup() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.canvas.getLayer()).thenReturn((Object)this.layer);
        Mockito.when((Object)this.sessionPresenter.getView()).thenReturn((Object)this.sessionPresenterView);
        Mockito.when((Object)this.sessionPresenter.getDisplayer()).thenReturn((Object)this.sessionView);
        Mockito.when((Object)this.sessionView.getView()).thenReturn((Object)this.view);
        this.command = (BaseNavigateCommand)Mockito.spy((Object)this.getCommand());
        ((BaseNavigateCommand)Mockito.doNothing().when((Object)this.command)).hidePaletteWidget(((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((BaseNavigateCommand)Mockito.doReturn((Object)this.editorContainerForErrai1090).when((Object)this.command)).wrapElementForErrai1090();
    }

    protected abstract BaseNavigateCommand getCommand();

    @Test
    public void verifyGraphCommandIsNoOperation() {
        Assert.assertEquals((Object)BaseNavigateCommand.NOP_GRAPH_COMMAND, (Object)this.command.getGraphCommand(this.canvasHandler));
    }

    @Test
    public void allowCanvasCommand() {
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).allow((Object)this.canvasHandler));
    }

    public abstract void executeCanvasCommand();

    public abstract void undoCanvasCommand();
}

