/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.general;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteCellValueCommand;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@RunWith(value=MockitoJUnitRunner.class)
public class DeleteCellValueCommandTest {
    private static final int ROW_INDEX = 0;
    private static final int COLUMN_INDEX = 1;
    private static final String CELL_VALUE = "value";
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private GridData gridModel;
    @Mock
    private GridCell gridCell;
    @Mock
    private GridCellValue gridCellValue;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    private BaseUIModelMapper<?> uiModelMapper;
    @Captor
    private ArgumentCaptor<Supplier<Optional<GridCellValue<?>>>> gridCellValueSupplierCaptor;
    @Captor
    private ArgumentCaptor<GridCellValue<?>> gridCellValueCaptor;
    private DeleteCellValueCommand command;

    @Before
    public void setup() {
        Mockito.when((Object)this.gridModel.getCell(0, 1)).thenReturn((Object)this.gridCell);
        Mockito.when((Object)this.gridCell.getValue()).thenReturn((Object)this.gridCellValue);
        Mockito.when((Object)this.gridCellValue.getValue()).thenReturn((Object)CELL_VALUE);
        this.command = new DeleteCellValueCommand(new GridCellTuple(0, 1, this.gridModel), () -> this.uiModelMapper, () -> ((DMNGridLayer)this.gridLayer).batch());
    }

    @Test
    public void checkGraphCommand() {
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).allow((Object)this.graphCommandExecutionContext));
        ((BaseUIModelMapper)Mockito.verify(this.uiModelMapper, (VerificationMode)Mockito.never())).toDMNModel(Mockito.anyInt(), Mockito.anyInt(), (Supplier)Mockito.any(Supplier.class));
    }

    @Test
    public void executeGraphCommand() {
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).execute((Object)this.graphCommandExecutionContext));
        ((BaseUIModelMapper)Mockito.verify(this.uiModelMapper)).toDMNModel(Mockito.eq((int)0), Mockito.eq((int)1), (Supplier)this.gridCellValueSupplierCaptor.capture());
        Supplier gridCellValueSupplier = (Supplier)this.gridCellValueSupplierCaptor.getValue();
        Assert.assertNotNull((Object)gridCellValueSupplier);
        Optional oGridCellValue = (Optional)gridCellValueSupplier.get();
        Assert.assertFalse((boolean)oGridCellValue.isPresent());
    }

    @Test
    public void undoGraphCommand() {
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).undo((Object)this.graphCommandExecutionContext));
        ((BaseUIModelMapper)Mockito.verify(this.uiModelMapper)).toDMNModel(Mockito.eq((int)0), Mockito.eq((int)1), (Supplier)this.gridCellValueSupplierCaptor.capture());
        Supplier gridCellValueSupplier = (Supplier)this.gridCellValueSupplierCaptor.getValue();
        Assert.assertNotNull((Object)gridCellValueSupplier);
        Optional oGridCellValue = (Optional)gridCellValueSupplier.get();
        Assert.assertTrue((boolean)oGridCellValue.isPresent());
        Assert.assertEquals((Object)this.gridCellValue, oGridCellValue.get());
        Assert.assertEquals((Object)CELL_VALUE, (Object)((GridCellValue)oGridCellValue.get()).getValue());
    }

    @Test
    public void allowCanvasCommand() {
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).allow((Object)this.canvasHandler));
        ((GridData)Mockito.verify((Object)this.gridModel, (VerificationMode)Mockito.never())).deleteCell(Mockito.anyInt(), Mockito.anyInt());
    }

    @Test
    public void executeCanvasCommand() {
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler));
        ((GridData)Mockito.verify((Object)this.gridModel)).deleteCell(Mockito.eq((int)0), Mockito.eq((int)1));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void undoCanvasCommand() {
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).undo((Object)this.canvasHandler));
        ((GridData)Mockito.verify((Object)this.gridModel)).setCell(Mockito.eq((int)0), Mockito.eq((int)1), (GridCellValue)this.gridCellValueCaptor.capture());
        Assert.assertEquals((Object)this.gridCellValue, (Object)this.gridCellValueCaptor.getValue());
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void checkCommandDefinition() {
        Assert.assertTrue((boolean)(this.command instanceof VetoExecutionCommand));
        Assert.assertTrue((boolean)(this.command instanceof VetoUndoCommand));
    }
}

